package com.ejianc.business.analysis.mapper;

import com.ejianc.business.analysis.vo.AuthenticRightVO;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.analysis.bean.AuthenticRightEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 项目确权情况分析
 * 
 * @author generator
 * 
 */
@Mapper
public interface AuthenticRightMapper extends BaseCrudMapper<AuthenticRightEntity> {
    //批量查询项目信息
    List<AuthenticRightVO> getProjects(@Param("endDate") String endDate);

    //工程计量台账本年开累
    List<AuthenticRightVO> getEngineermeasurementNear(@Param("beginDate") String beginDate, @Param("endDate") String endDate);

    //项目月度成本分析报告本年开累
    List<AuthenticRightVO> getCostanalysisNear(@Param("beginDate") String beginDate, @Param("endDate") String endDate);

    //工程计量台账开累
    List<AuthenticRightVO> getEngineermeasurement(@Param("endDate") String endDate);

    //项目月度成本分析报告开累
    List<AuthenticRightVO> getCostanalysis(@Param("endDate") String endDate);

    //工程计量台账本年开累
    List<AuthenticRightVO> getEngineermeasurementCreateTime(@Param("endDate") String endDate);

    //项目月度成本分析报告本年开累
    List<AuthenticRightVO> getCostanalysisCreateTime(@Param("endDate") String endDate);

    //查询列表
    List<AuthenticRightVO> queryList(Map<String, Object> paramMapper);

    //删除当前月份数据
    void deleteByReportingMonth(@Param(value = "reportingMonth")String reportingMonth);

}
