package com.ejianc.business.analysis.service.impl;

import com.ejianc.business.analysis.bean.AuthenticRightEntity;
import com.ejianc.business.analysis.mapper.AuthenticRightMapper;
import com.ejianc.business.analysis.service.IAuthenticRightService;
import com.ejianc.business.analysis.vo.AuthenticRightVO;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 项目确权情况分析
 * 
 * @author generator
 * 
 */
@Service("authenticRightService")
public class AuthenticRightServiceImpl extends BaseServiceImpl<AuthenticRightMapper, AuthenticRightEntity> implements IAuthenticRightService{

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private AuthenticRightMapper mapper;

    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public void execute(String day,String date) {
        //开始日期 方便统计本年数据
        String beginDate = null;
        //结束日期:执行日期减一天
        String endDate = null;
        //如果配置了手动生成日期，则不执行用户设置日期
        if(StringUtils.isNotEmpty(date)){
            Date executeDate = null;
            Date stateDate = null;
            try {
                //格式化本年一月一日
                stateDate = DateUtils.parseDate(date,"yyyy-MM-dd");
                //方便手动调用接口日期
                executeDate = DateUtils.parseDate(date,"yyyy-MM-dd");
            } catch (ParseException e) {
                e.printStackTrace();
            }
            //格式化本年一月一日
            beginDate = DateFormatUtils.format(stateDate, "yyyy-01-01");
            //结束日期:执行日期减一个月
            endDate = DateFormatUtils.format(DateUtils.addMonths(executeDate, -1), "yyyy-MM-dd");
        }else{
            //如果当前日期不等于设置天数，不执行
            if (!day.equals(DateFormatUtils.format(new Date(), "d"))) {
                throw new BusinessException("当前日期，不匹配设置日期");
            }else{
                beginDate = DateFormatUtils.format(new Date(), "yyyy-01-01");
                //结束日期:执行日期减一个月之前得所有数据
                endDate = DateFormatUtils.format(DateUtils.addMonths(new Date(), -1), "yyyy-MM-dd");
            }
        }
        //查询项目信息数据
        List<AuthenticRightVO> authenticRightVOList = queryProjects(endDate);

        //补全二级组织信息
        for(AuthenticRightVO authenticRightVO :authenticRightVOList){
            Date createDate = null;
            try {
                //方便手动调用接口日期
                createDate = DateUtils.parseDate(endDate,"yyyy-MM-dd");
            } catch (ParseException e) {
                e.printStackTrace();
            }
            authenticRightVO.setCreateTime(new Date());
            authenticRightVO.setReportingMonth(createDate);//取当前生成月份日期

            CommonResponse<OrgVO> orgVo = iOrgApi.detailById(authenticRightVO.getProjectDepartmentId());//此处是项目部id 1286211352287834113
            // CommonResponse<OrgVO> orgVo = iOrgApi.detailById(Long.parseLong("1286211352287834113"));//此处是项目部id
            if (orgVo.isSuccess() && null != orgVo.getData()) {
                String innerCode = orgVo.getData().getInnerCode();
                String[] strs = innerCode.split("\\|");
                CommonResponse<OrgVO> orgVos = iOrgApi.detailById(Long.parseLong(strs[1]));
                if (orgVos.isSuccess() && null != orgVos.getData()) {
                    //二级组织信息
                    authenticRightVO.setTwoOrgId(orgVos.getData().getId());
                    authenticRightVO.setTwoOrgName(orgVos.getData().getShortName());
                    authenticRightVO.setTwoOrgCode(orgVos.getData().getCode());
                }
            }
        }

        //----------------------------------------------------年累数据-----------------------------------------------

        //查询项目月度成本分析年累
        List<AuthenticRightVO> costanalysisListNear = getCostanalysisNear(beginDate,endDate);

        //项目月度成本分析年累赋值
        if(CollectionUtils.isNotEmpty(costanalysisListNear)){
            Map<Long,AuthenticRightVO> maps = costanalysisListNear.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
            AuthenticRightVO cvo;
            Long k;
            for (AuthenticRightVO vo : authenticRightVOList) {
                k = vo.getProjectId();
                if (!maps.containsKey(k)){
                    continue;
                }
                cvo = maps.get(k);
                vo.setRealProductYear(cvo.getRealProductYear());
                vo.setActualCostYear(cvo.getActualCostYear());
            }
        }else{
            //如果项目月度成本分析年累为空默认为0
            for(AuthenticRightVO authenticRightVO :authenticRightVOList){
                authenticRightVO.setRealProductYear(new BigDecimal(0));
                authenticRightVO.setActualCostYear(new BigDecimal(0));
            }
        }

        //工程计量台账年累
        List<AuthenticRightVO> costanalysisNearList = getEngineermeasurementNear(beginDate,endDate);

        //工程计量台账赋值
        if(CollectionUtils.isNotEmpty(costanalysisNearList)){
            Map<Long,AuthenticRightVO> maps = costanalysisNearList.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
            AuthenticRightVO cvo;
            Long k;
            for (AuthenticRightVO vo : authenticRightVOList) {
                k = vo.getProjectId();
                if (!maps.containsKey(k)){
                    continue;
                }
                cvo = maps.get(k);
                vo.setNotarizeProductYear(cvo.getNotarizeProductYear());
            }
        }else{
            //如果工程计量台账为空默认为0
            for(AuthenticRightVO authenticRightVO :authenticRightVOList){
                authenticRightVO.setNotarizeProductYear(new BigDecimal(0));
            }
        }

        //----------------------------------------------------开累数据-----------------------------------------------


        //查询项目月度成本分析开累
        List<AuthenticRightVO> costanalysisList = getCostanalysis(endDate);
        //项目月度成本分析开累赋值
        if(CollectionUtils.isNotEmpty(costanalysisList)){
            Map<Long,AuthenticRightVO> maps = costanalysisList.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
            AuthenticRightVO cvo;
            Long k;
            for (AuthenticRightVO vo : authenticRightVOList) {
                k = vo.getProjectId();
                if (!maps.containsKey(k)){
                    continue;
                }
                cvo = maps.get(k);
                vo.setRealProductTotal(cvo.getRealProductTotal());
                vo.setActualCostTotal(cvo.getActualCostTotal());
            }
        }else{
            //如果项目月度成本分析开累为空默认为0
            for(AuthenticRightVO authenticRightVO :authenticRightVOList){
                authenticRightVO.setRealProductTotal(new BigDecimal(0));
                authenticRightVO.setActualCostTotal(new BigDecimal(0));
            }
        }

        //工程计量台账开累
        List<AuthenticRightVO> engineermeasurementList = getEngineermeasurement(endDate);

        //工程计量台账开赋值
        if(CollectionUtils.isNotEmpty(engineermeasurementList)){
            Map<Long,AuthenticRightVO> maps = engineermeasurementList.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
            AuthenticRightVO cvo;
            Long k;
            for (AuthenticRightVO vo : authenticRightVOList) {
                k = vo.getProjectId();
                if (!maps.containsKey(k)){
                    continue;
                }
                cvo = maps.get(k);
                vo.setNotarizeProductTotal(cvo.getNotarizeProductTotal());
            }
        }else{
            //如果工程计量台账开为空默认为0
            for(AuthenticRightVO authenticRightVO :authenticRightVOList){
                authenticRightVO.setNotarizeProductTotal(new BigDecimal(0));
            }
        }

        //--------------------------------------日期赋值-------------------------------------------


        //查询项目月度成本日期赋值
        List<AuthenticRightVO> costanalysisCreateTimeList = getCostanalysisCreateTime(endDate);

        if(CollectionUtils.isNotEmpty(costanalysisCreateTimeList)){
            Map<Long,AuthenticRightVO> maps = costanalysisCreateTimeList.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
            AuthenticRightVO cvo;
            Long k;
            for (AuthenticRightVO vo : authenticRightVOList) {
                k = vo.getProjectId();
                if (!maps.containsKey(k)){
                    continue;
                }
                cvo = maps.get(k);
                vo.setCostAnalyseCreateTime(cvo.getCostAnalyseCreateTime());
            }
        }

        //工程计量台账日期赋值
        List<AuthenticRightVO> engineermeasurementCreateTime = getEngineermeasurementCreateTime(endDate);


        if(CollectionUtils.isNotEmpty(engineermeasurementCreateTime)){
            Map<Long,AuthenticRightVO> maps = engineermeasurementCreateTime.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
            AuthenticRightVO cvo;
            Long k;
            for (AuthenticRightVO vo : authenticRightVOList) {
                k = vo.getProjectId();
                if (!maps.containsKey(k)){
                    continue;
                }
                cvo = maps.get(k);
                vo.setProjectUnitCreateTime(cvo.getProjectUnitCreateTime());
            }
        }

        //计算逻辑
        for(AuthenticRightVO authenticRightVO :authenticRightVOList){
            //年确认率
            authenticRightVO.setNotarizeRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(authenticRightVO.getNotarizeProductYear() == null ? new BigDecimal("0") : authenticRightVO.getNotarizeProductYear(), authenticRightVO.getActualCostYear() == null ? new BigDecimal("0") :authenticRightVO.getActualCostYear()),new BigDecimal("100")));
            //开累确认率
            authenticRightVO.setNotarizeRateTotal(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(authenticRightVO.getNotarizeProductTotal() == null ? new BigDecimal("0") : authenticRightVO.getNotarizeProductTotal(), authenticRightVO.getActualCostTotal() == null ? new BigDecimal("0") :authenticRightVO.getActualCostTotal()),new BigDecimal("100")));

            //年确权率
            authenticRightVO.setAuthenticRightRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(authenticRightVO.getNotarizeProductYear() == null ? new BigDecimal("0") : authenticRightVO.getNotarizeProductYear(), authenticRightVO.getRealProductYear() == null ? new BigDecimal("0") :authenticRightVO.getRealProductYear()),new BigDecimal("100")));
            //开累确权率
            authenticRightVO.setAuthenticRightRateTotal(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(authenticRightVO.getNotarizeProductTotal() == null ? new BigDecimal("0") : authenticRightVO.getNotarizeProductTotal(), authenticRightVO.getRealProductTotal() == null ? new BigDecimal("0") :authenticRightVO.getRealProductTotal()),new BigDecimal("100")));
        }


        logger.info("-----------------------------------------项目确权情况分析生成数据,截止日期:"+endDate+" :"+ com.alibaba.fastjson.JSONObject.toJSONString(authenticRightVOList));
        if(CollectionUtils.isNotEmpty(authenticRightVOList)){
            //保存之前先根据日期删除当前月份数据
            deleteByReportingMonth(endDate);
            saveOrUpdateBatch(BeanMapper.mapList(authenticRightVOList, AuthenticRightEntity.class));
        }
    }

    @Override
    public List<AuthenticRightVO> queryProjects(String endDate) {
        return mapper.getProjects(endDate);
    }

    @Override
    public List<AuthenticRightVO> getEngineermeasurementNear(String beginDate, String endDate) {
        return mapper.getEngineermeasurementNear(beginDate,endDate);
    }

    @Override
    public List<AuthenticRightVO> getCostanalysisNear(String beginDate, String endDate) {
        return mapper.getCostanalysisNear(beginDate,endDate);
    }

    @Override
    public List<AuthenticRightVO> getEngineermeasurement(String endDate) {
        return mapper.getEngineermeasurement(endDate);
    }

    @Override
    public List<AuthenticRightVO> getCostanalysis(String endDate) {
        return mapper.getCostanalysis(endDate);
    }

    @Override
    public List<AuthenticRightVO> getEngineermeasurementCreateTime(String endDate) {
        return mapper.getEngineermeasurementCreateTime(endDate);
    }

    @Override
    public List<AuthenticRightVO> getCostanalysisCreateTime(String endDate) {
        return mapper.getCostanalysisCreateTime(endDate);
    }

    @Override
    public List<AuthenticRightVO> queryList(Map<String, Object> paramMapper) {
        return mapper.queryList(paramMapper);
    }

    @Override
    public void deleteByReportingMonth(String reportingMonth) {
        mapper.deleteByReportingMonth(reportingMonth);
    }


    @Override
    public List<AuthenticRightVO> processingList(List<AuthenticRightVO> authenticRightVOList) {
        List<AuthenticRightVO> authenticRightVOS = new ArrayList<>(); //数据集合
        List<AuthenticRightVO> authenticRightVOS1 = new ArrayList<>(); //小计集合
        AuthenticRightVO authenticRightTotalVO = new AuthenticRightVO(); //合计行
        //未开工
        BigDecimal notarizeProductYear1 = new BigDecimal("0"); //业主确认产值（本年） 小计
        BigDecimal realProductYear1 = new BigDecimal("0"); // 实际完成产值（本年） 小计
        BigDecimal actualCostYear1 = new BigDecimal("0"); //实际成本（本年） 小计
        BigDecimal notarizeProductTotal1 = new BigDecimal("0"); //业主确认产值（开累） 小计
        BigDecimal realProductTotal1 = new BigDecimal("0"); // 实际完成产值（开累） 小计
        BigDecimal actualCostTotal1 = new BigDecimal("0"); //实际成本（开累） 小计
        BigDecimal notarizeRate1 = new BigDecimal("0"); // 年确认率 小计

        BigDecimal authenticRightRate1 = new BigDecimal("0"); //年确权率 小计
        BigDecimal notarizeRateTotal1 = new BigDecimal("0"); //开累确认率
        BigDecimal authenticRightRateTotal1 = new BigDecimal("0"); //开累确权率 小计
        List<AuthenticRightVO> authenticRightVOList1 = new ArrayList<>();//数据集合
        AuthenticRightVO authenticRightVO1 = new AuthenticRightVO();//小计行

        //在建
        BigDecimal notarizeProductYear2 = new BigDecimal("0"); //业主确认产值（本年） 小计
        BigDecimal realProductYear2 = new BigDecimal("0"); // 实际完成产值（本年） 小计
        BigDecimal actualCostYear2 = new BigDecimal("0"); //实际成本（本年） 小计
        BigDecimal notarizeProductTotal2 = new BigDecimal("0"); //业主确认产值（开累） 小计
        BigDecimal realProductTotal2 = new BigDecimal("0"); // 实际完成产值（开累） 小计
        BigDecimal actualCostTotal2 = new BigDecimal("0"); //实际成本（开累） 小计
        BigDecimal notarizeRate2 = new BigDecimal("0"); // 年确认率 小计
        BigDecimal authenticRightRate2 = new BigDecimal("0"); //年确权率 小计
        BigDecimal notarizeRateTotal2 = new BigDecimal("0"); //开累确认率
        BigDecimal authenticRightRateTotal2 = new BigDecimal("0"); //开累确权率 小计
        List<AuthenticRightVO> authenticRightVOList2 = new ArrayList<>();//数据集合
        AuthenticRightVO authenticRightVO2 = new AuthenticRightVO();//小计行


        //停缓建
        BigDecimal notarizeProductYear3 = new BigDecimal("0"); //业主确认产值（本年） 小计
        BigDecimal realProductYear3 = new BigDecimal("0"); // 实际完成产值（本年） 小计
        BigDecimal actualCostYear3 = new BigDecimal("0"); //实际成本（本年） 小计
        BigDecimal notarizeProductTotal3 = new BigDecimal("0"); //业主确认产值（开累） 小计
        BigDecimal realProductTotal3 = new BigDecimal("0"); // 实际完成产值（开累） 小计
        BigDecimal actualCostTotal3 = new BigDecimal("0"); //实际成本（开累） 小计
        BigDecimal notarizeRate3 = new BigDecimal("0"); // 年确认率 小计
        BigDecimal authenticRightRate3 = new BigDecimal("0"); //年确权率 小计
        BigDecimal notarizeRateTotal3 = new BigDecimal("0"); //开累确认率
        BigDecimal authenticRightRateTotal3 = new BigDecimal("0"); //开累确权率 小计
        List<AuthenticRightVO> authenticRightVOList3 = new ArrayList<>();//数据集合
        AuthenticRightVO authenticRightVO3 = new AuthenticRightVO();//小计行


        //竣工未结算
        BigDecimal notarizeProductYear4 = new BigDecimal("0"); //业主确认产值（本年） 小计
        BigDecimal realProductYear4 = new BigDecimal("0"); // 实际完成产值（本年） 小计
        BigDecimal actualCostYear4 = new BigDecimal("0"); //实际成本（本年） 小计
        BigDecimal notarizeProductTotal4 = new BigDecimal("0"); //业主确认产值（开累） 小计
        BigDecimal realProductTotal4 = new BigDecimal("0"); // 实际完成产值（开累） 小计
        BigDecimal actualCostTotal4 = new BigDecimal("0"); //实际成本（开累） 小计
        BigDecimal notarizeRate4 = new BigDecimal("0"); // 年确认率 小计
        BigDecimal authenticRightRate4 = new BigDecimal("0"); //年确权率 小计
        BigDecimal notarizeRateTotal4 = new BigDecimal("0"); //开累确认率
        BigDecimal authenticRightRateTotal4 = new BigDecimal("0"); //开累确权率 小计
        List<AuthenticRightVO> authenticRightVOList4 = new ArrayList<>();//数据集合
        AuthenticRightVO authenticRightVO4 = new AuthenticRightVO();//小计行


        //竣工已结算
        BigDecimal notarizeProductYear5 = new BigDecimal("0"); //业主确认产值（本年） 小计
        BigDecimal realProductYear5 = new BigDecimal("0"); // 实际完成产值（本年） 小计
        BigDecimal actualCostYear5 = new BigDecimal("0"); //实际成本（本年） 小计
        BigDecimal notarizeProductTotal5 = new BigDecimal("0"); //业主确认产值（开累） 小计
        BigDecimal realProductTotal5 = new BigDecimal("0"); // 实际完成产值（开累） 小计
        BigDecimal actualCostTotal5 = new BigDecimal("0"); //实际成本（开累） 小计
        BigDecimal notarizeRate5 = new BigDecimal("0"); // 年确认率 小计
        BigDecimal authenticRightRate5 = new BigDecimal("0"); //年确权率 小计
        BigDecimal notarizeRateTotal5 = new BigDecimal("0"); //开累确认率
        BigDecimal authenticRightRateTotal5 = new BigDecimal("0"); //开累确权率 小计
        List<AuthenticRightVO> authenticRightVOList5 = new ArrayList<>();//数据集合
        AuthenticRightVO authenticRightVO5 = new AuthenticRightVO();//小计行


        //完工
        BigDecimal notarizeProductYear6 = new BigDecimal("0"); //业主确认产值（本年） 小计
        BigDecimal realProductYear6 = new BigDecimal("0"); // 实际完成产值（本年） 小计
        BigDecimal actualCostYear6 = new BigDecimal("0"); //实际成本（本年） 小计
        BigDecimal notarizeProductTotal6 = new BigDecimal("0"); //业主确认产值（开累） 小计
        BigDecimal realProductTotal6 = new BigDecimal("0"); // 实际完成产值（开累） 小计
        BigDecimal actualCostTotal6 = new BigDecimal("0"); //实际成本（开累） 小计

        BigDecimal notarizeRate6 = new BigDecimal("0"); // 年确认率 小计
        BigDecimal authenticRightRate6 = new BigDecimal("0"); //年确权率 小计
        BigDecimal notarizeRateTotal6 = new BigDecimal("0"); //开累确认率
        BigDecimal authenticRightRateTotal6 = new BigDecimal("0"); //开累确权率 小计
        List<AuthenticRightVO> authenticRightVOList6 = new ArrayList<>();//数据集合
        AuthenticRightVO authenticRightVO6 = new AuthenticRightVO();//小计行


        //合计
        BigDecimal notarizeProductYearTotoal = new BigDecimal("0"); //业主确认产值（本年） 小计
        BigDecimal realProductYearTotal = new BigDecimal("0"); // 实际完成产值（本年） 小计
        BigDecimal actualCostYearTotal = new BigDecimal("0"); //实际成本（本年） 小计
        BigDecimal notarizeProductTotalTotal = new BigDecimal("0"); //业主确认产值（开累） 小计
        BigDecimal realProductTotalTotal = new BigDecimal("0"); // 实际完成产值（开累） 小计
        BigDecimal actualCostTotalTotal = new BigDecimal("0"); //实际成本（开累） 小计
        BigDecimal notarizeRateTotal = new BigDecimal("0"); // 年确认率 小计
        BigDecimal authenticRightRateTotal = new BigDecimal("0"); //年确权率 小计
        BigDecimal notarizeRateTotalTotal = new BigDecimal("0"); //开累确认率
        BigDecimal authenticRightRateTotalTotal = new BigDecimal("0"); //开累确权率 小计
        AuthenticRightVO authenticRightVOTotal = new AuthenticRightVO();//合计行


        /*for(AuthenticRightVO authenticRightVO : authenticRightVOList){
            if(authenticRightVO.getProjectStatus() != null && authenticRightVO.getProjectStatus() == 1){
                notarizeProductYear1 = ComputeUtil.safeAdd(notarizeProductYear1,authenticRightVO.getNotarizeProductYear() == null ? new BigDecimal("0"):authenticRightVO.getNotarizeProductYear());
                realProductYear1 = ComputeUtil.safeAdd(realProductYear1,authenticRightVO.getRealProductYear()  == null ? new BigDecimal("0") : authenticRightVO.getRealProductYear());
                actualCostYear1 = ComputeUtil.safeAdd(actualCostYear1,authenticRightVO.getActualCostYear() == null ? new BigDecimal("0") :authenticRightVO.getActualCostYear());
                notarizeProductTotal1 = ComputeUtil.safeAdd(notarizeProductTotal1,authenticRightVO.getNotarizeProductTotal() == null ? new BigDecimal("0"):authenticRightVO.getNotarizeProductTotal());
                realProductTotal1 = ComputeUtil.safeAdd(realProductTotal1,authenticRightVO.getRealProductTotal()  == null ? new BigDecimal("0") : authenticRightVO.getRealProductTotal());
                actualCostTotal1 = ComputeUtil.safeAdd(actualCostTotal1,authenticRightVO.getActualCostTotal() == null ? new BigDecimal("0") :authenticRightVO.getActualCostTotal());
                notarizeRate1 = ComputeUtil.safeAdd(notarizeRate1,authenticRightVO.getNotarizeRate() == null ? new BigDecimal("0") :authenticRightVO.getNotarizeRate());
                authenticRightRate1 = ComputeUtil.safeAdd(authenticRightRate1,authenticRightVO.getAuthenticRightRate() == null ? new BigDecimal("0") :authenticRightVO.getAuthenticRightRate());
                notarizeRateTotal1 = ComputeUtil.safeAdd(notarizeRateTotal1,authenticRightVO.getNotarizeRateTotal() == null ? new BigDecimal("0") :authenticRightVO.getNotarizeRateTotal());
                authenticRightRateTotal1 = ComputeUtil.safeAdd(authenticRightRateTotal1,authenticRightVO.getAuthenticRightRateTotal() == null ? new BigDecimal("0") :authenticRightVO.getAuthenticRightRateTotal());
                authenticRightVOList1.add(authenticRightVO);
            }
            if(authenticRightVO.getProjectStatus() != null && authenticRightVO.getProjectStatus() == 2){
                notarizeProductYear2 = ComputeUtil.safeAdd(notarizeProductYear2,authenticRightVO.getNotarizeProductYear() == null ? new BigDecimal("0"):authenticRightVO.getNotarizeProductYear());
                realProductYear2 = ComputeUtil.safeAdd(realProductYear2,authenticRightVO.getRealProductYear()  == null ? new BigDecimal("0") : authenticRightVO.getRealProductYear());
                actualCostYear2 = ComputeUtil.safeAdd(actualCostYear2,authenticRightVO.getActualCostYear() == null ? new BigDecimal("0") :authenticRightVO.getActualCostYear());
                notarizeProductTotal2 = ComputeUtil.safeAdd(notarizeProductTotal2,authenticRightVO.getNotarizeProductTotal() == null ? new BigDecimal("0"):authenticRightVO.getNotarizeProductTotal());
                realProductTotal2 = ComputeUtil.safeAdd(realProductTotal2,authenticRightVO.getRealProductTotal()  == null ? new BigDecimal("0") : authenticRightVO.getRealProductTotal());
                actualCostTotal2 = ComputeUtil.safeAdd(actualCostTotal2,authenticRightVO.getActualCostTotal() == null ? new BigDecimal("0") :authenticRightVO.getActualCostTotal());
                notarizeRate2 = ComputeUtil.safeAdd(notarizeRate2,authenticRightVO.getNotarizeRate() == null ? new BigDecimal("0") :authenticRightVO.getNotarizeRate());
                authenticRightRate2 = ComputeUtil.safeAdd(authenticRightRate2,authenticRightVO.getAuthenticRightRate() == null ? new BigDecimal("0") :authenticRightVO.getAuthenticRightRate());
                notarizeRateTotal2 = ComputeUtil.safeAdd(notarizeRateTotal2,authenticRightVO.getNotarizeRateTotal() == null ? new BigDecimal("0") :authenticRightVO.getNotarizeRateTotal());
                authenticRightRateTotal2 = ComputeUtil.safeAdd(authenticRightRateTotal2,authenticRightVO.getAuthenticRightRateTotal() == null ? new BigDecimal("0") :authenticRightVO.getAuthenticRightRateTotal());
                authenticRightVOList2.add(authenticRightVO);
            }
            if(authenticRightVO.getProjectStatus() != null && authenticRightVO.getProjectStatus() == 3){
                notarizeProductYear3 = ComputeUtil.safeAdd(notarizeProductYear3,authenticRightVO.getNotarizeProductYear() == null ? new BigDecimal("0"):authenticRightVO.getNotarizeProductYear());
                realProductYear3 = ComputeUtil.safeAdd(realProductYear3,authenticRightVO.getRealProductYear()  == null ? new BigDecimal("0") : authenticRightVO.getRealProductYear());
                actualCostYear3 = ComputeUtil.safeAdd(actualCostYear3,authenticRightVO.getActualCostYear() == null ? new BigDecimal("0") :authenticRightVO.getActualCostYear());
                notarizeProductTotal3 = ComputeUtil.safeAdd(notarizeProductTotal3,authenticRightVO.getNotarizeProductTotal() == null ? new BigDecimal("0"):authenticRightVO.getNotarizeProductTotal());
                realProductTotal3 = ComputeUtil.safeAdd(realProductTotal3,authenticRightVO.getRealProductTotal()  == null ? new BigDecimal("0") : authenticRightVO.getRealProductTotal());
                actualCostTotal3 = ComputeUtil.safeAdd(actualCostTotal3,authenticRightVO.getActualCostTotal() == null ? new BigDecimal("0") :authenticRightVO.getActualCostTotal());
                notarizeRate3 = ComputeUtil.safeAdd(notarizeRate3,authenticRightVO.getNotarizeRate() == null ? new BigDecimal("0") :authenticRightVO.getNotarizeRate());
                authenticRightRate3 = ComputeUtil.safeAdd(authenticRightRate3,authenticRightVO.getAuthenticRightRate() == null ? new BigDecimal("0") :authenticRightVO.getAuthenticRightRate());
                notarizeRateTotal3 = ComputeUtil.safeAdd(notarizeRateTotal3,authenticRightVO.getNotarizeRateTotal() == null ? new BigDecimal("0") :authenticRightVO.getNotarizeRateTotal());
                authenticRightRateTotal3 = ComputeUtil.safeAdd(authenticRightRateTotal3,authenticRightVO.getAuthenticRightRateTotal() == null ? new BigDecimal("0") :authenticRightVO.getAuthenticRightRateTotal());
                authenticRightVOList3.add(authenticRightVO);
            }
            if(authenticRightVO.getProjectStatus() != null && authenticRightVO.getProjectStatus() == 4){
                notarizeProductYear4 = ComputeUtil.safeAdd(notarizeProductYear4,authenticRightVO.getNotarizeProductYear() == null ? new BigDecimal("0"):authenticRightVO.getNotarizeProductYear());
                realProductYear4 = ComputeUtil.safeAdd(realProductYear4,authenticRightVO.getRealProductYear()  == null ? new BigDecimal("0") : authenticRightVO.getRealProductYear());
                actualCostYear4 = ComputeUtil.safeAdd(actualCostYear4,authenticRightVO.getActualCostYear() == null ? new BigDecimal("0") :authenticRightVO.getActualCostYear());
                notarizeProductTotal4 = ComputeUtil.safeAdd(notarizeProductTotal4,authenticRightVO.getNotarizeProductTotal() == null ? new BigDecimal("0"):authenticRightVO.getNotarizeProductTotal());
                realProductTotal4 = ComputeUtil.safeAdd(realProductTotal4,authenticRightVO.getRealProductTotal()  == null ? new BigDecimal("0") : authenticRightVO.getRealProductTotal());
                actualCostTotal4 = ComputeUtil.safeAdd(actualCostTotal4,authenticRightVO.getActualCostTotal() == null ? new BigDecimal("0") :authenticRightVO.getActualCostTotal());
                notarizeRate4 = ComputeUtil.safeAdd(notarizeRate4,authenticRightVO.getNotarizeRate() == null ? new BigDecimal("0") :authenticRightVO.getNotarizeRate());
                authenticRightRate4 = ComputeUtil.safeAdd(authenticRightRate4,authenticRightVO.getAuthenticRightRate() == null ? new BigDecimal("0") :authenticRightVO.getAuthenticRightRate());
                notarizeRateTotal4 = ComputeUtil.safeAdd(notarizeRateTotal4,authenticRightVO.getNotarizeRateTotal() == null ? new BigDecimal("0") :authenticRightVO.getNotarizeRateTotal());
                authenticRightRateTotal4 = ComputeUtil.safeAdd(authenticRightRateTotal4,authenticRightVO.getAuthenticRightRateTotal() == null ? new BigDecimal("0") :authenticRightVO.getAuthenticRightRateTotal());
                authenticRightVOList4.add(authenticRightVO);
            }
            if(authenticRightVO.getProjectStatus() != null && authenticRightVO.getProjectStatus() == 5){
                notarizeProductYear5 = ComputeUtil.safeAdd(notarizeProductYear5,authenticRightVO.getNotarizeProductYear() == null ? new BigDecimal("0"):authenticRightVO.getNotarizeProductYear());
                realProductYear5 = ComputeUtil.safeAdd(realProductYear5,authenticRightVO.getRealProductYear()  == null ? new BigDecimal("0") : authenticRightVO.getRealProductYear());
                actualCostYear5 = ComputeUtil.safeAdd(actualCostYear5,authenticRightVO.getActualCostYear() == null ? new BigDecimal("0") :authenticRightVO.getActualCostYear());
                notarizeProductTotal5 = ComputeUtil.safeAdd(notarizeProductTotal5,authenticRightVO.getNotarizeProductTotal() == null ? new BigDecimal("0"):authenticRightVO.getNotarizeProductTotal());
                realProductTotal5 = ComputeUtil.safeAdd(realProductTotal5,authenticRightVO.getRealProductTotal()  == null ? new BigDecimal("0") : authenticRightVO.getRealProductTotal());
                actualCostTotal5 = ComputeUtil.safeAdd(actualCostTotal5,authenticRightVO.getActualCostTotal() == null ? new BigDecimal("0") :authenticRightVO.getActualCostTotal());
                notarizeRate5 = ComputeUtil.safeAdd(notarizeRate5,authenticRightVO.getNotarizeRate() == null ? new BigDecimal("0") :authenticRightVO.getNotarizeRate());
                authenticRightRate5 = ComputeUtil.safeAdd(authenticRightRate5,authenticRightVO.getAuthenticRightRate() == null ? new BigDecimal("0") :authenticRightVO.getAuthenticRightRate());
                notarizeRateTotal5 = ComputeUtil.safeAdd(notarizeRateTotal5,authenticRightVO.getNotarizeRateTotal() == null ? new BigDecimal("0") :authenticRightVO.getNotarizeRateTotal());
                authenticRightRateTotal5 = ComputeUtil.safeAdd(authenticRightRateTotal5,authenticRightVO.getAuthenticRightRateTotal() == null ? new BigDecimal("0") :authenticRightVO.getAuthenticRightRateTotal());
                authenticRightVOList5.add(authenticRightVO);
            }
            if(authenticRightVO.getProjectStatus() != null && authenticRightVO.getProjectStatus() == 6){
                notarizeProductYear6 = ComputeUtil.safeAdd(notarizeProductYear6,authenticRightVO.getNotarizeProductYear() == null ? new BigDecimal("0"):authenticRightVO.getNotarizeProductYear());
                realProductYear6 = ComputeUtil.safeAdd(realProductYear6,authenticRightVO.getRealProductYear()  == null ? new BigDecimal("0") : authenticRightVO.getRealProductYear());
                actualCostYear6 = ComputeUtil.safeAdd(actualCostYear6,authenticRightVO.getActualCostYear() == null ? new BigDecimal("0") :authenticRightVO.getActualCostYear());
                notarizeProductTotal6 = ComputeUtil.safeAdd(notarizeProductTotal6,authenticRightVO.getNotarizeProductTotal() == null ? new BigDecimal("0"):authenticRightVO.getNotarizeProductTotal());
                realProductTotal6 = ComputeUtil.safeAdd(realProductTotal6,authenticRightVO.getRealProductTotal()  == null ? new BigDecimal("0") : authenticRightVO.getRealProductTotal());
                actualCostTotal6 = ComputeUtil.safeAdd(actualCostTotal6,authenticRightVO.getActualCostTotal() == null ? new BigDecimal("0") :authenticRightVO.getActualCostTotal());
                notarizeRate6 = ComputeUtil.safeAdd(notarizeRate6,authenticRightVO.getNotarizeRate() == null ? new BigDecimal("0") :authenticRightVO.getNotarizeRate());
                authenticRightRate6 = ComputeUtil.safeAdd(authenticRightRate6,authenticRightVO.getAuthenticRightRate() == null ? new BigDecimal("0") :authenticRightVO.getAuthenticRightRate());
                notarizeRateTotal6 = ComputeUtil.safeAdd(notarizeRateTotal6,authenticRightVO.getNotarizeRateTotal() == null ? new BigDecimal("0") :authenticRightVO.getNotarizeRateTotal());
                authenticRightRateTotal6 = ComputeUtil.safeAdd(authenticRightRateTotal6,authenticRightVO.getAuthenticRightRateTotal() == null ? new BigDecimal("0") :authenticRightVO.getAuthenticRightRateTotal());
                authenticRightVOList6.add(authenticRightVO);
            }
        }
*/

        for(AuthenticRightVO authenticRightVO : authenticRightVOList){
            if(authenticRightVO.getProjectStatus() != null && authenticRightVO.getProjectStatus() == 1){
                authenticRightVOList1.add(authenticRightVO);
            }
            if(authenticRightVO.getProjectStatus() != null && authenticRightVO.getProjectStatus() == 2){
                authenticRightVOList2.add(authenticRightVO);
            }
            if(authenticRightVO.getProjectStatus() != null && authenticRightVO.getProjectStatus() == 3){
                authenticRightVOList3.add(authenticRightVO);
            }
            if(authenticRightVO.getProjectStatus() != null && authenticRightVO.getProjectStatus() == 4){
                authenticRightVOList4.add(authenticRightVO);
            }
            if(authenticRightVO.getProjectStatus() != null && authenticRightVO.getProjectStatus() == 5){
                authenticRightVOList5.add(authenticRightVO);
            }
            if(authenticRightVO.getProjectStatus() != null && authenticRightVO.getProjectStatus() == 6){
                authenticRightVOList6.add(authenticRightVO);
            }
        }

        if(CollectionUtils.isNotEmpty(authenticRightVOList1)){
            authenticRightVOS.addAll(countList(authenticRightVOList1));
        }
        if(CollectionUtils.isNotEmpty(authenticRightVOList2)){
            authenticRightVOS.addAll(countList(authenticRightVOList2));
        }
        if(CollectionUtils.isNotEmpty(authenticRightVOList3)){
            authenticRightVOS.addAll(countList(authenticRightVOList3));
        }
        if(CollectionUtils.isNotEmpty(authenticRightVOList4)){
            authenticRightVOS.addAll(countList(authenticRightVOList4));
        }
        if(CollectionUtils.isNotEmpty(authenticRightVOList5)){
            authenticRightVOS.addAll(countList(authenticRightVOList5));
        }
        if(CollectionUtils.isNotEmpty(authenticRightVOList6)){
            authenticRightVOS.addAll(countList(authenticRightVOList6));
        }
        if(CollectionUtils.isNotEmpty(authenticRightVOS)){
            //如果等于小计加进去 方便计算合计
            for(AuthenticRightVO authenticRightVO : authenticRightVOS){
                if("小计".equals(authenticRightVO.getNumber())){
                    authenticRightVOS1.add(authenticRightVO);
                }
            }
        }

        if(CollectionUtils.isNotEmpty(authenticRightVOS1)){
            authenticRightTotalVO = countTotalList(authenticRightVOS1);
        }
        if(authenticRightTotalVO != null ){
            authenticRightVOS.add(authenticRightTotalVO);
        }


/*        //万元显示
        for(AuthenticRightVO authenticRightVO : profitIncomeVOS){
            authenticRightVO.setRealProduct(ComputeUtil.safeDiv(authenticRightVO.getRealProduct(),new BigDecimal(10000)));
            authenticRightVO.setNotarizeProduct(ComputeUtil.safeDiv(authenticRightVO.getNotarizeProduct(),new BigDecimal(10000)));
            authenticRightVO.setUnliquidated(ComputeUtil.safeDiv(authenticRightVO.getUnliquidated(),new BigDecimal(10000)));
        }*/


     /*   for (int i = 0; i < profitIncomeVOS.size(); i++) {
            if(!("小计").equals(profitIncomeVOS.get(i).getNumber()) && !("合计").equals(profitIncomeVOS.get(i).getNumber())){
                if(profitIncomeVOS.get(i).getProjectStatus() == 1){
                    profitIncomeVOS.get(i).setProjectStatusName("未开工");
                }
                if(profitIncomeVOS.get(i).getProjectStatus() == 2){
                    profitIncomeVOS.get(i).setProjectStatusName("在建");
                }
                if(profitIncomeVOS.get(i).getProjectStatus() == 3){
                    profitIncomeVOS.get(i).setProjectStatusName("停缓建");
                }
                if(profitIncomeVOS.get(i).getProjectStatus() == 4){
                    profitIncomeVOS.get(i).setProjectStatusName("竣工未结算");
                }
                if(profitIncomeVOS.get(i).getProjectStatus() == 5){
                    profitIncomeVOS.get(i).setProjectStatusName("竣工已结算");
                }
                if(profitIncomeVOS.get(i).getProjectStatus() == 6){
                    profitIncomeVOS.get(i).setProjectStatusName("完工");
                }
            }
        }*/
        return authenticRightVOS;
    }

    public static List<AuthenticRightVO> countList(List<AuthenticRightVO> authenticRightVOList) {
        if(CollectionUtils.isNotEmpty(authenticRightVOList)){
            BigDecimal notarizeProductYear = new BigDecimal("0");
            BigDecimal realProductYear = new BigDecimal("0");
            BigDecimal actualCostYear = new BigDecimal("0");
            BigDecimal notarizeProductTotal = new BigDecimal("0");
            BigDecimal realProductTotal = new BigDecimal("0");
            BigDecimal actualCostTotal = new BigDecimal("0");
            BigDecimal notarizeRate = new BigDecimal("0");
            BigDecimal authenticRightRate = new BigDecimal("0");
            BigDecimal notarizeRateTotal = new BigDecimal("0");
            BigDecimal authenticRightRateTotal = new BigDecimal("0");

            List<AuthenticRightVO> authenticRightVOS = new ArrayList<>();//数据集合
            AuthenticRightVO authenticRightVO1 = new AuthenticRightVO();//小计行
            //传list计算小计
            for(AuthenticRightVO authenticRightVO : authenticRightVOList){
                notarizeProductYear = ComputeUtil.safeAdd(notarizeProductYear,authenticRightVO.getNotarizeProductYear() == null ? new BigDecimal("0"):authenticRightVO.getNotarizeProductYear());
                realProductYear = ComputeUtil.safeAdd(realProductYear,authenticRightVO.getRealProductYear()  == null ? new BigDecimal("0") : authenticRightVO.getRealProductYear());
                actualCostYear = ComputeUtil.safeAdd(actualCostYear,authenticRightVO.getActualCostYear() == null ? new BigDecimal("0") :authenticRightVO.getActualCostYear());
                notarizeProductTotal = ComputeUtil.safeAdd(notarizeProductTotal,authenticRightVO.getNotarizeProductTotal() == null ? new BigDecimal("0"):authenticRightVO.getNotarizeProductTotal());
                realProductTotal = ComputeUtil.safeAdd(realProductTotal,authenticRightVO.getRealProductTotal()  == null ? new BigDecimal("0") : authenticRightVO.getRealProductTotal());
                actualCostTotal = ComputeUtil.safeAdd(actualCostTotal,authenticRightVO.getActualCostTotal() == null ? new BigDecimal("0") :authenticRightVO.getActualCostTotal());
                notarizeRate = ComputeUtil.safeAdd(notarizeRate,authenticRightVO.getNotarizeRate() == null ? new BigDecimal("0") :authenticRightVO.getNotarizeRate());
                authenticRightRate = ComputeUtil.safeAdd(authenticRightRate,authenticRightVO.getAuthenticRightRate() == null ? new BigDecimal("0") :authenticRightVO.getAuthenticRightRate());
                notarizeRateTotal = ComputeUtil.safeAdd(notarizeRateTotal,authenticRightVO.getNotarizeRateTotal() == null ? new BigDecimal("0") :authenticRightVO.getNotarizeRateTotal());
                authenticRightRateTotal = ComputeUtil.safeAdd(authenticRightRateTotal,authenticRightVO.getAuthenticRightRateTotal() == null ? new BigDecimal("0") :authenticRightVO.getAuthenticRightRateTotal());
                authenticRightVOS.add(authenticRightVO);
            }
            //序号赋值
            for (int i = 0; i < authenticRightVOS.size(); i++) {
                authenticRightVOS.get(i).setNumber(""+(i+1)+"");
            }

            for (int i = 0; i < authenticRightVOS.size(); i++) {

                    if(authenticRightVOS.get(i).getProjectStatus() == 1){
                        authenticRightVOS.get(i).setProjectStatusName("未开工");
                    }
                    if(authenticRightVOS.get(i).getProjectStatus() == 2){
                        authenticRightVOS.get(i).setProjectStatusName("在建");
                    }
                    if(authenticRightVOS.get(i).getProjectStatus() == 3){
                        authenticRightVOS.get(i).setProjectStatusName("停缓建");
                    }
                    if(authenticRightVOS.get(i).getProjectStatus() == 4){
                        authenticRightVOS.get(i).setProjectStatusName("竣工未结算");
                    }
                    if(authenticRightVOS.get(i).getProjectStatus() == 5){
                        authenticRightVOS.get(i).setProjectStatusName("竣工已结算");
                    }
                    if(authenticRightVOS.get(i).getProjectStatus() == 6){
                        authenticRightVOS.get(i).setProjectStatusName("完工");
                    }

            }
            authenticRightVO1.setNumber("小计");
            authenticRightVO1.setId(IdWorker.getId());
            authenticRightVO1.setNotarizeProductYear(notarizeProductYear);
            authenticRightVO1.setRealProductYear(realProductYear);
            authenticRightVO1.setActualCostYear(notarizeProductYear);
            authenticRightVO1.setNotarizeProductTotal(notarizeProductTotal);
            authenticRightVO1.setRealProductTotal(realProductTotal);
            authenticRightVO1.setActualCostTotal(actualCostTotal);
            authenticRightVO1.setNotarizeRate(notarizeRate);
            authenticRightVO1.setAuthenticRightRate(authenticRightRate);
            authenticRightVO1.setNotarizeRateTotal(notarizeRateTotal);
            authenticRightVO1.setAuthenticRightRateTotal(authenticRightRateTotal);
            authenticRightVOS.add(authenticRightVO1);

           /* private BigDecimal notarizeProductYear; // 业主确认产值（本年）
            private BigDecimal realProductYear; // 实际完成产值（本年）
            private BigDecimal actualCostYear; // 实际成本（本年）
            private BigDecimal notarizeProductTotal; // 业主确认产值（开累）
            private BigDecimal realProductTotal; // 实际完成产值（开累）
            private BigDecimal actualCostTotal; // 实际成本（开累）*/

            //万元显示
            for(AuthenticRightVO authenticRightVO : authenticRightVOS){
                authenticRightVO.setNotarizeProductYear(ComputeUtil.safeDiv(authenticRightVO.getNotarizeProductYear(),new BigDecimal(10000)));
                authenticRightVO.setRealProductYear(ComputeUtil.safeDiv(authenticRightVO.getRealProductYear(),new BigDecimal(10000)));
                authenticRightVO.setActualCostYear(ComputeUtil.safeDiv(authenticRightVO.getActualCostYear(),new BigDecimal(10000)));
                authenticRightVO.setNotarizeProductTotal(ComputeUtil.safeDiv(authenticRightVO.getNotarizeProductTotal(),new BigDecimal(10000)));
                authenticRightVO.setRealProductTotal(ComputeUtil.safeDiv(authenticRightVO.getRealProductTotal(),new BigDecimal(10000)));
                authenticRightVO.setActualCostTotal(ComputeUtil.safeDiv(authenticRightVO.getActualCostTotal(),new BigDecimal(10000)));
            }
            return authenticRightVOS;
        }else{
            return null;
        }


    }

    //传小计所有行 返回合计行
    public static AuthenticRightVO countTotalList(List<AuthenticRightVO> authenticRightVOList) {
        if(CollectionUtils.isNotEmpty(authenticRightVOList)){
            BigDecimal notarizeProductYear = new BigDecimal("0");
            BigDecimal realProductYear = new BigDecimal("0");
            BigDecimal actualCostYear = new BigDecimal("0");
            BigDecimal notarizeProductTotal = new BigDecimal("0");
            BigDecimal realProductTotal = new BigDecimal("0");
            BigDecimal actualCostTotal = new BigDecimal("0");
            BigDecimal notarizeRate = new BigDecimal("0");
            BigDecimal authenticRightRate = new BigDecimal("0");
            BigDecimal notarizeRateTotal = new BigDecimal("0");
            BigDecimal authenticRightRateTotal = new BigDecimal("0");

            List<AuthenticRightVO> authenticRightVOS = new ArrayList<>();//数据集合
            AuthenticRightVO authenticRightVO1 = new AuthenticRightVO();//小计行
            //传list计算小计

            for(AuthenticRightVO authenticRightVO : authenticRightVOList){
                if("小计".equals(authenticRightVO.getNumber())){
                    notarizeProductYear = ComputeUtil.safeAdd(notarizeProductYear,authenticRightVO.getNotarizeProductYear() == null ? new BigDecimal("0"):authenticRightVO.getNotarizeProductYear());
                    realProductYear = ComputeUtil.safeAdd(realProductYear,authenticRightVO.getRealProductYear()  == null ? new BigDecimal("0") : authenticRightVO.getRealProductYear());
                    actualCostYear = ComputeUtil.safeAdd(actualCostYear,authenticRightVO.getActualCostYear() == null ? new BigDecimal("0") :authenticRightVO.getActualCostYear());
                    notarizeProductTotal = ComputeUtil.safeAdd(notarizeProductTotal,authenticRightVO.getNotarizeProductTotal() == null ? new BigDecimal("0"):authenticRightVO.getNotarizeProductTotal());
                    realProductTotal = ComputeUtil.safeAdd(realProductTotal,authenticRightVO.getRealProductTotal()  == null ? new BigDecimal("0") : authenticRightVO.getRealProductTotal());
                    actualCostTotal = ComputeUtil.safeAdd(actualCostTotal,authenticRightVO.getActualCostTotal() == null ? new BigDecimal("0") :authenticRightVO.getActualCostTotal());
                    notarizeRate = ComputeUtil.safeAdd(notarizeRate,authenticRightVO.getNotarizeRate() == null ? new BigDecimal("0") :authenticRightVO.getNotarizeRate());
                    authenticRightRate = ComputeUtil.safeAdd(authenticRightRate,authenticRightVO.getAuthenticRightRate() == null ? new BigDecimal("0") :authenticRightVO.getAuthenticRightRate());
                    notarizeRateTotal = ComputeUtil.safeAdd(notarizeRateTotal,authenticRightVO.getNotarizeRateTotal() == null ? new BigDecimal("0") :authenticRightVO.getNotarizeRateTotal());
                    authenticRightRateTotal = ComputeUtil.safeAdd(authenticRightRateTotal,authenticRightVO.getAuthenticRightRateTotal() == null ? new BigDecimal("0") :authenticRightVO.getAuthenticRightRateTotal());
                }

            }
            authenticRightVO1.setNumber("合计");
            authenticRightVO1.setId(IdWorker.getId());
            authenticRightVO1.setNotarizeProductYear(notarizeProductYear);
            authenticRightVO1.setRealProductYear(realProductYear);
            authenticRightVO1.setActualCostYear(notarizeProductYear);
            authenticRightVO1.setNotarizeProductTotal(notarizeProductTotal);
            authenticRightVO1.setRealProductTotal(realProductTotal);
            authenticRightVO1.setActualCostTotal(actualCostTotal);
            authenticRightVO1.setNotarizeRate(notarizeRate);
            authenticRightVO1.setAuthenticRightRate(authenticRightRate);
            authenticRightVO1.setNotarizeRateTotal(notarizeRateTotal);
            authenticRightVO1.setAuthenticRightRateTotal(authenticRightRateTotal);


            return authenticRightVO1;
        }else{
            return null;
        }


    }

    public static BigDecimal getBigDecimalSum(BigDecimal i, BigDecimal... arg) {
        BigDecimal sum = i;
        for (BigDecimal b : arg) {
            sum = sum.add(b);
        }
        return sum;
    }
}
