package com.ejianc.business.analysis.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 项目工程造价指标分析
 * 
 * @author generator
 * 
 */
public class ProjectIndexVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    private String number; // 序号
    private Long analysisId; // 查询工程造价指标分析主键id
    private Long orgId; // 所属组织id
    private String orgCode; // 所属组织编码
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private Long twoOrgId; // 二级组织id
    private String twoOrgCode; // 二级组织编码
    private String twoOrgName; // 二级组织名称
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Integer projectStatus; // 项目状态
    private String reportingMonth; // 报表日期
    private String buildingFunction; // 建筑功能
    private String buildPlace; // 建设地点
    private String structMethod; // 结构类型
    private String earthquakeFortification; // 抗震设防
    private BigDecimal eaveHeight; // 檐高
    private BigDecimal prefabricationRate; // 预制率
    private BigDecimal assemblySrate; // 装配率
    private BigDecimal totalCost; // 总造价(元)
    private Date startDate; // 开工日期
    private Date completionDate; // 竣工日期
    private BigDecimal artificial; //人工（工日）
    private BigDecimal steelBar; // 钢筋
    private BigDecimal concrete; // 混凝土
    private BigDecimal cement; // 水泥
    private BigDecimal sand; // 砂
    private BigDecimal crushedStone; // 碎石
    private BigDecimal block; // 砌块
    private BigDecimal precastReinforcement; // 预制构件钢筋
    private BigDecimal precastConcrete; // 预制构件混凝土
    private BigDecimal architectureCost; // 建筑工程 造价（元）
    private BigDecimal architectureCostPercentage; // 建筑工程 占总造价百分比（%）
    private BigDecimal architectureCostCentiare; // 建筑工程 平方米造价（元/㎡）
    private BigDecimal decorationCost; // 装饰工程 造价（元）
    private BigDecimal decorationCostPercentage; // 装饰工程 占总造价百分比（%）
    private BigDecimal decorationCostCentiare; // 装饰工程 平方米造价（元/㎡）
    private BigDecimal installationCost; // 安装工程 造价（元）
    private BigDecimal installationCostPercentage; // 安装工程 占总造价百分比（%）
    private BigDecimal installationCostCentiare; // 安装工程 平方米造价（元/㎡）
    private BigDecimal elseEngineeringCost; // 其他工程 造价（元）
    private BigDecimal elseEngineeringCostPercentage; // 其他工程 占总造价百分比（%）
    private BigDecimal elseEngineeringCostCentiare; // 其他工程 平方米造价（元/㎡）
    private BigDecimal earthCost; // 土石方 造价（元）
    private BigDecimal earthCostPercentage; // 土石方 占总造价百分比（%）
    private BigDecimal earthCostCentiare; // 土石方 平方米造价（元/㎡）
    private BigDecimal basicsCost; //基础钢筋混凝土结构 造价（元）
    private BigDecimal basicsCostPercentage; //基础钢筋混凝土结构 占总造价百分比（%）
    private BigDecimal basicsCostCentiare; //基础钢筋混凝土结构 平方米造价（元/㎡）
    private BigDecimal subjectCost; //主体钢筋混凝土结构 造价（元）
    private BigDecimal subjectCostPercentage; //主体钢筋混凝土结构 占总造价百分比（%）
    private BigDecimal subjectCostCentiare; //主体钢筋混凝土结构 平方米造价（元/㎡）
    private BigDecimal masonryCost; // 砌筑 造价（元）
    private BigDecimal masonryCostPercentage; // 砌筑 占总造价百分比（%）
    private BigDecimal masonryCostCentiare; // 砌筑 平方米造价（元/㎡）
    private BigDecimal waterproofCost; // 防水保温 造价（元）
    private BigDecimal waterproofCostPercentage; // 防水保温 占总造价百分比（%）
    private BigDecimal waterproofCostCentiare; // 防水保温 平方米造价（元/㎡）
    private BigDecimal prefabricatedCost; // 装配式构件 造价（元）
    private BigDecimal prefabricatedCostPercentage; // 装配式构件 占总造价百分比（%）
    private BigDecimal prefabricatedCostCentiare; // 装配式构件 平方米造价（元/㎡）
    private BigDecimal elseArchitectureCost; // 建筑工程其他 造价（元）
    private BigDecimal elseArchitectureCostPercentage; // 建筑工程其他 占总造价百分比（%）
    private BigDecimal elseArchitectureCostCentiare; // 建筑工程其他 平方米造价（元/㎡）
    private BigDecimal flooringCost; // 楼地面 造价（元）
    private BigDecimal flooringCostPercentage; // 楼地面 占总造价百分比（%）
    private BigDecimal flooringCostCentiare; // 楼地面 平方米造价（元/㎡）
    private BigDecimal wallCost; // 墙柱面 造价（元）
    private BigDecimal wallCostPercentage; // 墙柱面 占总造价百分比（%）
    private BigDecimal wallCostCentiare; // 墙柱面 平方米造价（元/㎡）
    private BigDecimal ceilingCost; // 天 棚 造价（元）
    private BigDecimal ceilingCostPercentage; // 天 棚 占总造价百分比（%）
    private BigDecimal ceilingCostCentiare; // 天 棚 平方米造价（元/㎡）
    private BigDecimal doorsCost; // 门窗 造价（元）
    private BigDecimal doorsCostPercentage; // 门窗 占总造价百分比（%）
    private BigDecimal doorsCostCentiare; // 门窗 平方米造价（元/㎡）
    private BigDecimal oilPaintCost; // 油漆、裱糊 造价（元）
    private BigDecimal oilPaintCostPercentage; // 油漆、裱糊 占总造价百分比（%）
    private BigDecimal oilPaintCostCentiare; // 油漆、裱糊 平方米造价（元/㎡）
    private BigDecimal decorationElseCost; // 装饰工程其他 造价（元）
    private BigDecimal decorationElseCostPercentage; // 装饰工程其他 占总造价百分比（%）
    private BigDecimal decorationElseCostCentiare; // 装饰工程其他 平方米造价（元/㎡）
    private BigDecimal electricCost; // 电器工程 造价（元）
    private BigDecimal electricCostPercentage; // 电器工程 占总造价百分比（%）
    private BigDecimal electricCostCentiare; // 电器工程 平方米造价（元/㎡）
    private BigDecimal drainCost; // 给排水工程 造价（元）
    private BigDecimal drainCostPercentage; // 给排水工程 占总造价百分比（%）
    private BigDecimal drainCostCentiare; // 给排水工程 平方米造价（元/㎡）
    private BigDecimal heatingCost; // 采暖工程 造价（元）
    private BigDecimal heatingCostPercentage; // 采暖工程占总造价百分比（%）
    private BigDecimal heatingCostCentiare; // 采暖工程 平方米造价（元/㎡）
    private BigDecimal ventilateCost; // 通风工程 造价（元）
    private BigDecimal ventilateCostPercentage; // 通风工程 占总造价百分比（%）
    private BigDecimal ventilateCostCentiare; // 通风工程 平方米造价（元/㎡）
    private BigDecimal conditionerPaintCost; // 空调工程 造价（元）
    private BigDecimal conditionerPaintCostPercentage; // 空调工程 占总造价百分比（%）
    private BigDecimal conditionerPaintCostCentiare; // 空调工程 平方米造价（元/㎡）
    private BigDecimal installElseCost; // 安装工程其他 造价（元）
    private BigDecimal installElseCostPercentage; // 安装工程其他 占总造价百分比（%）
    private BigDecimal installElseCostCentiare; // 安装工程其他 平方米造价（元/㎡）
    private BigDecimal safetyCost; // 安全、文明施工费 造价（元）
    private BigDecimal safetyCostPercentage; // 安全、文明施工费 占总造价百分比（%）
    private BigDecimal safetyCostCentiare; // 安全、文明施工费 平方米造价（元/㎡）
    private BigDecimal templateCost; // 模板及支架 造价（元）
    private BigDecimal templateCostPercentage; // 模板及支架 占总造价百分比（%）
    private BigDecimal templateCostCentiare; // 模板及支架 平方米造价（元/㎡）
    private BigDecimal stagingCost; // 脚手架 造价（元）
    private BigDecimal stagingCostPercentage; // 脚手架 占总造价百分比（%）
    private BigDecimal stagingCostCentiare; // 脚手架 平方米造价（元/㎡）
    private BigDecimal carriageCost; // 垂直运输机械 造价（元）
    private BigDecimal carriageCostPercentage; // 垂直运输机械 占总造价百分比（%）
    private BigDecimal carriageCostCentiare; // 垂直运输机械 平方米造价（元/㎡）
    private BigDecimal temporaryCost; // 临设费用 造价（元）
    private BigDecimal temporaryCostPercentage; // 临设费用占总造价百分比（%）
    private BigDecimal temporaryCostCentiare; // 临设费用 平方米造价（元/㎡）
    private BigDecimal drainWaterCost; // 施工排水 造价（元）
    private BigDecimal drainWaterCostPercentage; // 施工排水 占总造价百分比（%）
    private BigDecimal drainWaterCostCentiare; // 施工排水 平方米造价（元/㎡）
    private BigDecimal rainCost; // 施工降水 造价（元）
    private BigDecimal rainCostPercentage; // 施工降水 占总造价百分比（%）
    private BigDecimal rainCostCentiare; // 施工降水 平方米造价（元/㎡）
    private BigDecimal measureElseCost; // 措施费其他 造价（元）
    private BigDecimal measureElseCostPercentage; // 措施费其他 占总造价百分比（%）
    private BigDecimal measureElseCostCentiare; // 措施费其他 平方米造价（元/㎡）
    private String remark; // 备注
    private Integer projectStatusOrder; // 项目状态排序
    private Integer orgStatusOrder; // 二级组织排序
    private String projectStatusName;
    private Date projectCreateTime;
    private BigDecimal builtArea;//建筑面积
    private BigDecimal perCost;//每平米造价（万元）

    public BigDecimal getPerCost() {
        return perCost;
    }

    public void setPerCost(BigDecimal perCost) {
        this.perCost = perCost;
    }

    public BigDecimal getBuiltArea() {
        return builtArea;
    }

    public void setBuiltArea(BigDecimal builtArea) {
        this.builtArea = builtArea;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Date getProjectCreateTime() {
        return projectCreateTime;
    }

    public void setProjectCreateTime(Date projectCreateTime) {
        this.projectCreateTime = projectCreateTime;
    }

    public String getProjectStatusName() {
        return projectStatusName;
    }

    public void setProjectStatusName(String projectStatusName) {
        this.projectStatusName = projectStatusName;
    }

    public Integer getOrgStatusOrder() {
        return orgStatusOrder;
    }

    public void setOrgStatusOrder(Integer orgStatusOrder) {
        this.orgStatusOrder = orgStatusOrder;
    }

    public Integer getProjectStatusOrder() {
        return projectStatusOrder;
    }

    public void setProjectStatusOrder(Integer projectStatusOrder) {
        this.projectStatusOrder = projectStatusOrder;
    }

    public Long getAnalysisId() {
        return analysisId;
    }

    public void setAnalysisId(Long analysisId) {
        this.analysisId = analysisId;
    }

    public BigDecimal getTotalCost() {
        return totalCost;
    }

    public void setTotalCost(BigDecimal totalCost) {
        this.totalCost = totalCost;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getTwoOrgId() {
        return twoOrgId;
    }

    public void setTwoOrgId(Long twoOrgId) {
        this.twoOrgId = twoOrgId;
    }
    public String getTwoOrgCode() {
        return twoOrgCode;
    }

    public void setTwoOrgCode(String twoOrgCode) {
        this.twoOrgCode = twoOrgCode;
    }
    public String getTwoOrgName() {
        return twoOrgName;
    }

    public void setTwoOrgName(String twoOrgName) {
        this.twoOrgName = twoOrgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Integer getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(Integer projectStatus) {
        this.projectStatus = projectStatus;
    }
    public String getReportingMonth() {
        return reportingMonth;
    }

    public void setReportingMonth(String reportingMonth) {
        this.reportingMonth = reportingMonth;
    }
    public String getBuildingFunction() {
        return buildingFunction;
    }

    public void setBuildingFunction(String buildingFunction) {
        this.buildingFunction = buildingFunction;
    }
    public String getBuildPlace() {
        return buildPlace;
    }

    public void setBuildPlace(String buildPlace) {
        this.buildPlace = buildPlace;
    }
    public String getStructMethod() {
        return structMethod;
    }

    public void setStructMethod(String structMethod) {
        this.structMethod = structMethod;
    }
    public String getEarthquakeFortification() {
        return earthquakeFortification;
    }

    public void setEarthquakeFortification(String earthquakeFortification) {
        this.earthquakeFortification = earthquakeFortification;
    }
    public BigDecimal getEaveHeight() {
        return eaveHeight;
    }

    public void setEaveHeight(BigDecimal eaveHeight) {
        this.eaveHeight = eaveHeight;
    }
    public BigDecimal getPrefabricationRate() {
        return prefabricationRate;
    }

    public void setPrefabricationRate(BigDecimal prefabricationRate) {
        this.prefabricationRate = prefabricationRate;
    }
    public BigDecimal getAssemblySrate() {
        return assemblySrate;
    }

    public void setAssemblySrate(BigDecimal assemblySrate) {
        this.assemblySrate = assemblySrate;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getCompletionDate() {
        return completionDate;
    }

    public void setCompletionDate(Date completionDate) {
        this.completionDate = completionDate;
    }
    public BigDecimal getArtificial() {
        return artificial;
    }

    public void setArtificial(BigDecimal artificial) {
        this.artificial = artificial;
    }
    public BigDecimal getSteelBar() {
        return steelBar;
    }

    public void setSteelBar(BigDecimal steelBar) {
        this.steelBar = steelBar;
    }
    public BigDecimal getConcrete() {
        return concrete;
    }

    public void setConcrete(BigDecimal concrete) {
        this.concrete = concrete;
    }
    public BigDecimal getCement() {
        return cement;
    }

    public void setCement(BigDecimal cement) {
        this.cement = cement;
    }
    public BigDecimal getSand() {
        return sand;
    }

    public void setSand(BigDecimal sand) {
        this.sand = sand;
    }
    public BigDecimal getCrushedStone() {
        return crushedStone;
    }

    public void setCrushedStone(BigDecimal crushedStone) {
        this.crushedStone = crushedStone;
    }
    public BigDecimal getBlock() {
        return block;
    }

    public void setBlock(BigDecimal block) {
        this.block = block;
    }
    public BigDecimal getPrecastReinforcement() {
        return precastReinforcement;
    }

    public void setPrecastReinforcement(BigDecimal precastReinforcement) {
        this.precastReinforcement = precastReinforcement;
    }
    public BigDecimal getPrecastConcrete() {
        return precastConcrete;
    }

    public void setPrecastConcrete(BigDecimal precastConcrete) {
        this.precastConcrete = precastConcrete;
    }
    public BigDecimal getArchitectureCost() {
        return architectureCost;
    }

    public void setArchitectureCost(BigDecimal architectureCost) {
        this.architectureCost = architectureCost;
    }
    public BigDecimal getArchitectureCostPercentage() {
        return architectureCostPercentage;
    }

    public void setArchitectureCostPercentage(BigDecimal architectureCostPercentage) {
        this.architectureCostPercentage = architectureCostPercentage;
    }
    public BigDecimal getArchitectureCostCentiare() {
        return architectureCostCentiare;
    }

    public void setArchitectureCostCentiare(BigDecimal architectureCostCentiare) {
        this.architectureCostCentiare = architectureCostCentiare;
    }
    public BigDecimal getDecorationCost() {
        return decorationCost;
    }

    public void setDecorationCost(BigDecimal decorationCost) {
        this.decorationCost = decorationCost;
    }
    public BigDecimal getDecorationCostPercentage() {
        return decorationCostPercentage;
    }

    public void setDecorationCostPercentage(BigDecimal decorationCostPercentage) {
        this.decorationCostPercentage = decorationCostPercentage;
    }
    public BigDecimal getDecorationCostCentiare() {
        return decorationCostCentiare;
    }

    public void setDecorationCostCentiare(BigDecimal decorationCostCentiare) {
        this.decorationCostCentiare = decorationCostCentiare;
    }
    public BigDecimal getInstallationCost() {
        return installationCost;
    }

    public void setInstallationCost(BigDecimal installationCost) {
        this.installationCost = installationCost;
    }
    public BigDecimal getInstallationCostPercentage() {
        return installationCostPercentage;
    }

    public void setInstallationCostPercentage(BigDecimal installationCostPercentage) {
        this.installationCostPercentage = installationCostPercentage;
    }
    public BigDecimal getInstallationCostCentiare() {
        return installationCostCentiare;
    }

    public void setInstallationCostCentiare(BigDecimal installationCostCentiare) {
        this.installationCostCentiare = installationCostCentiare;
    }
    public BigDecimal getElseEngineeringCost() {
        return elseEngineeringCost;
    }

    public void setElseEngineeringCost(BigDecimal elseEngineeringCost) {
        this.elseEngineeringCost = elseEngineeringCost;
    }
    public BigDecimal getElseEngineeringCostPercentage() {
        return elseEngineeringCostPercentage;
    }

    public void setElseEngineeringCostPercentage(BigDecimal elseEngineeringCostPercentage) {
        this.elseEngineeringCostPercentage = elseEngineeringCostPercentage;
    }
    public BigDecimal getElseEngineeringCostCentiare() {
        return elseEngineeringCostCentiare;
    }

    public void setElseEngineeringCostCentiare(BigDecimal elseEngineeringCostCentiare) {
        this.elseEngineeringCostCentiare = elseEngineeringCostCentiare;
    }
    public BigDecimal getEarthCost() {
        return earthCost;
    }

    public void setEarthCost(BigDecimal earthCost) {
        this.earthCost = earthCost;
    }
    public BigDecimal getEarthCostPercentage() {
        return earthCostPercentage;
    }

    public void setEarthCostPercentage(BigDecimal earthCostPercentage) {
        this.earthCostPercentage = earthCostPercentage;
    }
    public BigDecimal getEarthCostCentiare() {
        return earthCostCentiare;
    }

    public void setEarthCostCentiare(BigDecimal earthCostCentiare) {
        this.earthCostCentiare = earthCostCentiare;
    }
    public BigDecimal getBasicsCost() {
        return basicsCost;
    }

    public void setBasicsCost(BigDecimal basicsCost) {
        this.basicsCost = basicsCost;
    }
    public BigDecimal getBasicsCostPercentage() {
        return basicsCostPercentage;
    }

    public void setBasicsCostPercentage(BigDecimal basicsCostPercentage) {
        this.basicsCostPercentage = basicsCostPercentage;
    }
    public BigDecimal getBasicsCostCentiare() {
        return basicsCostCentiare;
    }

    public void setBasicsCostCentiare(BigDecimal basicsCostCentiare) {
        this.basicsCostCentiare = basicsCostCentiare;
    }
    public BigDecimal getSubjectCost() {
        return subjectCost;
    }

    public void setSubjectCost(BigDecimal subjectCost) {
        this.subjectCost = subjectCost;
    }
    public BigDecimal getSubjectCostPercentage() {
        return subjectCostPercentage;
    }

    public void setSubjectCostPercentage(BigDecimal subjectCostPercentage) {
        this.subjectCostPercentage = subjectCostPercentage;
    }
    public BigDecimal getSubjectCostCentiare() {
        return subjectCostCentiare;
    }

    public void setSubjectCostCentiare(BigDecimal subjectCostCentiare) {
        this.subjectCostCentiare = subjectCostCentiare;
    }
    public BigDecimal getMasonryCost() {
        return masonryCost;
    }

    public void setMasonryCost(BigDecimal masonryCost) {
        this.masonryCost = masonryCost;
    }
    public BigDecimal getMasonryCostPercentage() {
        return masonryCostPercentage;
    }

    public void setMasonryCostPercentage(BigDecimal masonryCostPercentage) {
        this.masonryCostPercentage = masonryCostPercentage;
    }
    public BigDecimal getMasonryCostCentiare() {
        return masonryCostCentiare;
    }

    public void setMasonryCostCentiare(BigDecimal masonryCostCentiare) {
        this.masonryCostCentiare = masonryCostCentiare;
    }
    public BigDecimal getWaterproofCost() {
        return waterproofCost;
    }

    public void setWaterproofCost(BigDecimal waterproofCost) {
        this.waterproofCost = waterproofCost;
    }
    public BigDecimal getWaterproofCostPercentage() {
        return waterproofCostPercentage;
    }

    public void setWaterproofCostPercentage(BigDecimal waterproofCostPercentage) {
        this.waterproofCostPercentage = waterproofCostPercentage;
    }
    public BigDecimal getWaterproofCostCentiare() {
        return waterproofCostCentiare;
    }

    public void setWaterproofCostCentiare(BigDecimal waterproofCostCentiare) {
        this.waterproofCostCentiare = waterproofCostCentiare;
    }
    public BigDecimal getPrefabricatedCost() {
        return prefabricatedCost;
    }

    public void setPrefabricatedCost(BigDecimal prefabricatedCost) {
        this.prefabricatedCost = prefabricatedCost;
    }
    public BigDecimal getPrefabricatedCostPercentage() {
        return prefabricatedCostPercentage;
    }

    public void setPrefabricatedCostPercentage(BigDecimal prefabricatedCostPercentage) {
        this.prefabricatedCostPercentage = prefabricatedCostPercentage;
    }
    public BigDecimal getPrefabricatedCostCentiare() {
        return prefabricatedCostCentiare;
    }

    public void setPrefabricatedCostCentiare(BigDecimal prefabricatedCostCentiare) {
        this.prefabricatedCostCentiare = prefabricatedCostCentiare;
    }
    public BigDecimal getElseArchitectureCost() {
        return elseArchitectureCost;
    }

    public void setElseArchitectureCost(BigDecimal elseArchitectureCost) {
        this.elseArchitectureCost = elseArchitectureCost;
    }
    public BigDecimal getElseArchitectureCostPercentage() {
        return elseArchitectureCostPercentage;
    }

    public void setElseArchitectureCostPercentage(BigDecimal elseArchitectureCostPercentage) {
        this.elseArchitectureCostPercentage = elseArchitectureCostPercentage;
    }
    public BigDecimal getElseArchitectureCostCentiare() {
        return elseArchitectureCostCentiare;
    }

    public void setElseArchitectureCostCentiare(BigDecimal elseArchitectureCostCentiare) {
        this.elseArchitectureCostCentiare = elseArchitectureCostCentiare;
    }
    public BigDecimal getFlooringCost() {
        return flooringCost;
    }

    public void setFlooringCost(BigDecimal flooringCost) {
        this.flooringCost = flooringCost;
    }
    public BigDecimal getFlooringCostPercentage() {
        return flooringCostPercentage;
    }

    public void setFlooringCostPercentage(BigDecimal flooringCostPercentage) {
        this.flooringCostPercentage = flooringCostPercentage;
    }
    public BigDecimal getFlooringCostCentiare() {
        return flooringCostCentiare;
    }

    public void setFlooringCostCentiare(BigDecimal flooringCostCentiare) {
        this.flooringCostCentiare = flooringCostCentiare;
    }
    public BigDecimal getWallCost() {
        return wallCost;
    }

    public void setWallCost(BigDecimal wallCost) {
        this.wallCost = wallCost;
    }
    public BigDecimal getWallCostPercentage() {
        return wallCostPercentage;
    }

    public void setWallCostPercentage(BigDecimal wallCostPercentage) {
        this.wallCostPercentage = wallCostPercentage;
    }
    public BigDecimal getWallCostCentiare() {
        return wallCostCentiare;
    }

    public void setWallCostCentiare(BigDecimal wallCostCentiare) {
        this.wallCostCentiare = wallCostCentiare;
    }
    public BigDecimal getCeilingCost() {
        return ceilingCost;
    }

    public void setCeilingCost(BigDecimal ceilingCost) {
        this.ceilingCost = ceilingCost;
    }
    public BigDecimal getCeilingCostPercentage() {
        return ceilingCostPercentage;
    }

    public void setCeilingCostPercentage(BigDecimal ceilingCostPercentage) {
        this.ceilingCostPercentage = ceilingCostPercentage;
    }
    public BigDecimal getCeilingCostCentiare() {
        return ceilingCostCentiare;
    }

    public void setCeilingCostCentiare(BigDecimal ceilingCostCentiare) {
        this.ceilingCostCentiare = ceilingCostCentiare;
    }
    public BigDecimal getDoorsCost() {
        return doorsCost;
    }

    public void setDoorsCost(BigDecimal doorsCost) {
        this.doorsCost = doorsCost;
    }
    public BigDecimal getDoorsCostPercentage() {
        return doorsCostPercentage;
    }

    public void setDoorsCostPercentage(BigDecimal doorsCostPercentage) {
        this.doorsCostPercentage = doorsCostPercentage;
    }
    public BigDecimal getDoorsCostCentiare() {
        return doorsCostCentiare;
    }

    public void setDoorsCostCentiare(BigDecimal doorsCostCentiare) {
        this.doorsCostCentiare = doorsCostCentiare;
    }
    public BigDecimal getOilPaintCost() {
        return oilPaintCost;
    }

    public void setOilPaintCost(BigDecimal oilPaintCost) {
        this.oilPaintCost = oilPaintCost;
    }
    public BigDecimal getOilPaintCostPercentage() {
        return oilPaintCostPercentage;
    }

    public void setOilPaintCostPercentage(BigDecimal oilPaintCostPercentage) {
        this.oilPaintCostPercentage = oilPaintCostPercentage;
    }
    public BigDecimal getOilPaintCostCentiare() {
        return oilPaintCostCentiare;
    }

    public void setOilPaintCostCentiare(BigDecimal oilPaintCostCentiare) {
        this.oilPaintCostCentiare = oilPaintCostCentiare;
    }
    public BigDecimal getDecorationElseCost() {
        return decorationElseCost;
    }

    public void setDecorationElseCost(BigDecimal decorationElseCost) {
        this.decorationElseCost = decorationElseCost;
    }
    public BigDecimal getDecorationElseCostPercentage() {
        return decorationElseCostPercentage;
    }

    public void setDecorationElseCostPercentage(BigDecimal decorationElseCostPercentage) {
        this.decorationElseCostPercentage = decorationElseCostPercentage;
    }
    public BigDecimal getDecorationElseCostCentiare() {
        return decorationElseCostCentiare;
    }

    public void setDecorationElseCostCentiare(BigDecimal decorationElseCostCentiare) {
        this.decorationElseCostCentiare = decorationElseCostCentiare;
    }
    public BigDecimal getElectricCost() {
        return electricCost;
    }

    public void setElectricCost(BigDecimal electricCost) {
        this.electricCost = electricCost;
    }
    public BigDecimal getElectricCostPercentage() {
        return electricCostPercentage;
    }

    public void setElectricCostPercentage(BigDecimal electricCostPercentage) {
        this.electricCostPercentage = electricCostPercentage;
    }
    public BigDecimal getElectricCostCentiare() {
        return electricCostCentiare;
    }

    public void setElectricCostCentiare(BigDecimal electricCostCentiare) {
        this.electricCostCentiare = electricCostCentiare;
    }
    public BigDecimal getDrainCost() {
        return drainCost;
    }

    public void setDrainCost(BigDecimal drainCost) {
        this.drainCost = drainCost;
    }
    public BigDecimal getDrainCostPercentage() {
        return drainCostPercentage;
    }

    public void setDrainCostPercentage(BigDecimal drainCostPercentage) {
        this.drainCostPercentage = drainCostPercentage;
    }
    public BigDecimal getDrainCostCentiare() {
        return drainCostCentiare;
    }

    public void setDrainCostCentiare(BigDecimal drainCostCentiare) {
        this.drainCostCentiare = drainCostCentiare;
    }
    public BigDecimal getHeatingCost() {
        return heatingCost;
    }

    public void setHeatingCost(BigDecimal heatingCost) {
        this.heatingCost = heatingCost;
    }
    public BigDecimal getHeatingCostPercentage() {
        return heatingCostPercentage;
    }

    public void setHeatingCostPercentage(BigDecimal heatingCostPercentage) {
        this.heatingCostPercentage = heatingCostPercentage;
    }
    public BigDecimal getHeatingCostCentiare() {
        return heatingCostCentiare;
    }

    public void setHeatingCostCentiare(BigDecimal heatingCostCentiare) {
        this.heatingCostCentiare = heatingCostCentiare;
    }
    public BigDecimal getVentilateCost() {
        return ventilateCost;
    }

    public void setVentilateCost(BigDecimal ventilateCost) {
        this.ventilateCost = ventilateCost;
    }
    public BigDecimal getVentilateCostPercentage() {
        return ventilateCostPercentage;
    }

    public void setVentilateCostPercentage(BigDecimal ventilateCostPercentage) {
        this.ventilateCostPercentage = ventilateCostPercentage;
    }
    public BigDecimal getVentilateCostCentiare() {
        return ventilateCostCentiare;
    }

    public void setVentilateCostCentiare(BigDecimal ventilateCostCentiare) {
        this.ventilateCostCentiare = ventilateCostCentiare;
    }
    public BigDecimal getConditionerPaintCost() {
        return conditionerPaintCost;
    }

    public void setConditionerPaintCost(BigDecimal conditionerPaintCost) {
        this.conditionerPaintCost = conditionerPaintCost;
    }
    public BigDecimal getConditionerPaintCostPercentage() {
        return conditionerPaintCostPercentage;
    }

    public void setConditionerPaintCostPercentage(BigDecimal conditionerPaintCostPercentage) {
        this.conditionerPaintCostPercentage = conditionerPaintCostPercentage;
    }
    public BigDecimal getConditionerPaintCostCentiare() {
        return conditionerPaintCostCentiare;
    }

    public void setConditionerPaintCostCentiare(BigDecimal conditionerPaintCostCentiare) {
        this.conditionerPaintCostCentiare = conditionerPaintCostCentiare;
    }
    public BigDecimal getInstallElseCost() {
        return installElseCost;
    }

    public void setInstallElseCost(BigDecimal installElseCost) {
        this.installElseCost = installElseCost;
    }
    public BigDecimal getInstallElseCostPercentage() {
        return installElseCostPercentage;
    }

    public void setInstallElseCostPercentage(BigDecimal installElseCostPercentage) {
        this.installElseCostPercentage = installElseCostPercentage;
    }
    public BigDecimal getInstallElseCostCentiare() {
        return installElseCostCentiare;
    }

    public void setInstallElseCostCentiare(BigDecimal installElseCostCentiare) {
        this.installElseCostCentiare = installElseCostCentiare;
    }
    public BigDecimal getSafetyCost() {
        return safetyCost;
    }

    public void setSafetyCost(BigDecimal safetyCost) {
        this.safetyCost = safetyCost;
    }
    public BigDecimal getSafetyCostPercentage() {
        return safetyCostPercentage;
    }

    public void setSafetyCostPercentage(BigDecimal safetyCostPercentage) {
        this.safetyCostPercentage = safetyCostPercentage;
    }
    public BigDecimal getSafetyCostCentiare() {
        return safetyCostCentiare;
    }

    public void setSafetyCostCentiare(BigDecimal safetyCostCentiare) {
        this.safetyCostCentiare = safetyCostCentiare;
    }
    public BigDecimal getTemplateCost() {
        return templateCost;
    }

    public void setTemplateCost(BigDecimal templateCost) {
        this.templateCost = templateCost;
    }
    public BigDecimal getTemplateCostPercentage() {
        return templateCostPercentage;
    }

    public void setTemplateCostPercentage(BigDecimal templateCostPercentage) {
        this.templateCostPercentage = templateCostPercentage;
    }
    public BigDecimal getTemplateCostCentiare() {
        return templateCostCentiare;
    }

    public void setTemplateCostCentiare(BigDecimal templateCostCentiare) {
        this.templateCostCentiare = templateCostCentiare;
    }
    public BigDecimal getStagingCost() {
        return stagingCost;
    }

    public void setStagingCost(BigDecimal stagingCost) {
        this.stagingCost = stagingCost;
    }
    public BigDecimal getStagingCostPercentage() {
        return stagingCostPercentage;
    }

    public void setStagingCostPercentage(BigDecimal stagingCostPercentage) {
        this.stagingCostPercentage = stagingCostPercentage;
    }
    public BigDecimal getStagingCostCentiare() {
        return stagingCostCentiare;
    }

    public void setStagingCostCentiare(BigDecimal stagingCostCentiare) {
        this.stagingCostCentiare = stagingCostCentiare;
    }
    public BigDecimal getCarriageCost() {
        return carriageCost;
    }

    public void setCarriageCost(BigDecimal carriageCost) {
        this.carriageCost = carriageCost;
    }
    public BigDecimal getCarriageCostPercentage() {
        return carriageCostPercentage;
    }

    public void setCarriageCostPercentage(BigDecimal carriageCostPercentage) {
        this.carriageCostPercentage = carriageCostPercentage;
    }
    public BigDecimal getCarriageCostCentiare() {
        return carriageCostCentiare;
    }

    public void setCarriageCostCentiare(BigDecimal carriageCostCentiare) {
        this.carriageCostCentiare = carriageCostCentiare;
    }
    public BigDecimal getTemporaryCost() {
        return temporaryCost;
    }

    public void setTemporaryCost(BigDecimal temporaryCost) {
        this.temporaryCost = temporaryCost;
    }
    public BigDecimal getTemporaryCostPercentage() {
        return temporaryCostPercentage;
    }

    public void setTemporaryCostPercentage(BigDecimal temporaryCostPercentage) {
        this.temporaryCostPercentage = temporaryCostPercentage;
    }
    public BigDecimal getTemporaryCostCentiare() {
        return temporaryCostCentiare;
    }

    public void setTemporaryCostCentiare(BigDecimal temporaryCostCentiare) {
        this.temporaryCostCentiare = temporaryCostCentiare;
    }
    public BigDecimal getDrainWaterCost() {
        return drainWaterCost;
    }

    public void setDrainWaterCost(BigDecimal drainWaterCost) {
        this.drainWaterCost = drainWaterCost;
    }
    public BigDecimal getDrainWaterCostPercentage() {
        return drainWaterCostPercentage;
    }

    public void setDrainWaterCostPercentage(BigDecimal drainWaterCostPercentage) {
        this.drainWaterCostPercentage = drainWaterCostPercentage;
    }
    public BigDecimal getDrainWaterCostCentiare() {
        return drainWaterCostCentiare;
    }

    public void setDrainWaterCostCentiare(BigDecimal drainWaterCostCentiare) {
        this.drainWaterCostCentiare = drainWaterCostCentiare;
    }
    public BigDecimal getRainCost() {
        return rainCost;
    }

    public void setRainCost(BigDecimal rainCost) {
        this.rainCost = rainCost;
    }
    public BigDecimal getRainCostPercentage() {
        return rainCostPercentage;
    }

    public void setRainCostPercentage(BigDecimal rainCostPercentage) {
        this.rainCostPercentage = rainCostPercentage;
    }
    public BigDecimal getRainCostCentiare() {
        return rainCostCentiare;
    }

    public void setRainCostCentiare(BigDecimal rainCostCentiare) {
        this.rainCostCentiare = rainCostCentiare;
    }
    public BigDecimal getMeasureElseCost() {
        return measureElseCost;
    }

    public void setMeasureElseCost(BigDecimal measureElseCost) {
        this.measureElseCost = measureElseCost;
    }
    public BigDecimal getMeasureElseCostPercentage() {
        return measureElseCostPercentage;
    }

    public void setMeasureElseCostPercentage(BigDecimal measureElseCostPercentage) {
        this.measureElseCostPercentage = measureElseCostPercentage;
    }
    public BigDecimal getMeasureElseCostCentiare() {
        return measureElseCostCentiare;
    }

    public void setMeasureElseCostCentiare(BigDecimal measureElseCostCentiare) {
        this.measureElseCostCentiare = measureElseCostCentiare;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    
}
