package com.ejianc.business.analysis.mapper;

import com.ejianc.business.analysis.bean.ProjectPaymentEntity;
import com.ejianc.business.analysis.vo.ProjectPaymentVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 工程确权收付款情况
 * 
 * @author generator
 * 
 */
@Mapper
public interface ProjectPaymentMapper extends BaseCrudMapper<ProjectPaymentEntity> {
    //查询工程计量台账本年累计值
    List<ProjectPaymentVO> quertEngineermeasurement(@Param("startDate")String startDate, @Param("endDate")String endDate, @Param("projectIdList") List<Long> projectIdList);

    //查询工程计量台账开累
    List<ProjectPaymentVO> quertEngineermeasurementTotal(@Param("endDate")String endDate, @Param("projectIdList") List<Long> projectIdList);

    //查询实际成本本年累计值
    List<ProjectPaymentVO> quertCostanalysis(@Param("startDate")String startDate, @Param("endDate")String endDate, @Param("projectIdList") List<Long> projectIdList);

    //查询实际成本开累
    List<ProjectPaymentVO> quertCostanalysisTotal(@Param("endDate")String endDate, @Param("projectIdList") List<Long> projectIdList);

    //查询付款登记
    List<ProjectPaymentVO> quertPaymentTotal(@Param("endDate")String endDate, @Param("projectIdList") List<Long> projectIdList);

    //查询实际成本id
    List<ProjectPaymentVO> quertAnalysis(@Param("endDate")String endDate, @Param("projectIdList") List<Long> projectIdList);

    List<ProjectPaymentVO> quertCosthuizong(@Param("idList") List<Long> idList);


}
