package com.ejianc.business.analysis.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 项目财务两金分析
 * 
 * @author generator
 * 
 */
 @TableName("ejc_analysis_gold")
public class GoldEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_code")
    private String orgCode; // 所属组织编码
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="two_org_id")
    private Long twoOrgId; // 二级组织id
    @TableField(value="two_org_code")
    private String twoOrgCode; // 二级组织编码
    @TableField(value="two_org_name")
    private String twoOrgName; // 二级组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_status")
    private Integer projectStatus; // 项目状态
    @TableField(value="reporting_month")
    private String reportingMonth; // 报表日期
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="code")
    private String code; // 费用编码
    @TableField(value="project_create_time")
    private Date projectCreateTime; // 项目创建日期
    @TableField(value="cost_analysis_create_time")
    private Date costAnalysisCreateTime; // 月度分析报告创建时间
    @TableField(value="org_status_order")
    private Integer orgStatusOrder; // 二级组织排序
    @TableField(value="cash_flow")
    private BigDecimal cashFlow; // 净现金流量
    @TableField(value="completed_balance")
    private BigDecimal completedBalance; // 已完工未结算
    @TableField(value="stock_up")
    private BigDecimal stockUp; // 存货
    @TableField(value="account_receive")
    private BigDecimal accountReceive; // 应收账款
    @TableField(value="accounts_receive")
    private BigDecimal accountsReceive; // 应收未收账款
    @TableField(value="accounts_payable")
    private BigDecimal accountsPayable; // 应付账款
    @TableField(value="open_dollars")
    private BigDecimal openDollars; // 开累百元收入
    @TableField(value="open_dept")
    private BigDecimal openDept; // 开累带息负债
    @TableField(value="contractual")
    private BigDecimal contractual; // 合同负债
    @TableField(value="short_name")
    private String shortName;//组织简称
    public String getShortName() {
        return shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }
    
    

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getTwoOrgId() {
        return twoOrgId;
    }

    public void setTwoOrgId(Long twoOrgId) {
        this.twoOrgId = twoOrgId;
    }
    public String getTwoOrgCode() {
        return twoOrgCode;
    }

    public void setTwoOrgCode(String twoOrgCode) {
        this.twoOrgCode = twoOrgCode;
    }
    public String getTwoOrgName() {
        return twoOrgName;
    }

    public void setTwoOrgName(String twoOrgName) {
        this.twoOrgName = twoOrgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Integer getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(Integer projectStatus) {
        this.projectStatus = projectStatus;
    }
    public String getReportingMonth() {
        return reportingMonth;
    }

    public void setReportingMonth(String reportingMonth) {
        this.reportingMonth = reportingMonth;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Date getProjectCreateTime() {
        return projectCreateTime;
    }

    public void setProjectCreateTime(Date projectCreateTime) {
        this.projectCreateTime = projectCreateTime;
    }
    public Date getCostAnalysisCreateTime() {
        return costAnalysisCreateTime;
    }

    public void setCostAnalysisCreateTime(Date costAnalysisCreateTime) {
        this.costAnalysisCreateTime = costAnalysisCreateTime;
    }
    public Integer getOrgStatusOrder() {
        return orgStatusOrder;
    }

    public void setOrgStatusOrder(Integer orgStatusOrder) {
        this.orgStatusOrder = orgStatusOrder;
    }
    public BigDecimal getCashFlow() {
        return cashFlow;
    }

    public void setCashFlow(BigDecimal cashFlow) {
        this.cashFlow = cashFlow;
    }
    public BigDecimal getCompletedBalance() {
        return completedBalance;
    }

    public void setCompletedBalance(BigDecimal completedBalance) {
        this.completedBalance = completedBalance;
    }
    public BigDecimal getStockUp() {
        return stockUp;
    }

    public void setStockUp(BigDecimal stockUp) {
        this.stockUp = stockUp;
    }
    public BigDecimal getAccountReceive() {
        return accountReceive;
    }

    public void setAccountReceive(BigDecimal accountReceive) {
        this.accountReceive = accountReceive;
    }
    public BigDecimal getAccountsReceive() {
        return accountsReceive;
    }

    public void setAccountsReceive(BigDecimal accountsReceive) {
        this.accountsReceive = accountsReceive;
    }
    public BigDecimal getAccountsPayable() {
        return accountsPayable;
    }

    public void setAccountsPayable(BigDecimal accountsPayable) {
        this.accountsPayable = accountsPayable;
    }
    public BigDecimal getOpenDollars() {
        return openDollars;
    }

    public void setOpenDollars(BigDecimal openDollars) {
        this.openDollars = openDollars;
    }
    public BigDecimal getOpenDept() {
        return openDept;
    }

    public void setOpenDept(BigDecimal openDept) {
        this.openDept = openDept;
    }
    public BigDecimal getContractual() {
        return contractual;
    }

    public void setContractual(BigDecimal contractual) {
        this.contractual = contractual;
    }
    
}
