package com.ejianc.business.analysis.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.analysis.bean.ProfitIncomeEntity;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
 * 收入分析
 * 
 * @author generator
 * 
 */
@Mapper
public interface ProfitIncomeMapper extends BaseCrudMapper<ProfitIncomeEntity> {
    //查询项目信息
    List<ProfitIncomeVO> getProject(@Param("endDate") String endDate);

    //查询项目月度成本分析
    List<ProfitIncomeVO> getCostanalysis(@Param("endDate") String endDate);

    //查询工程计量台账
    List<ProfitIncomeVO> getEngineermeasurement(@Param("endDate") String endDate);

    //批量查询项目信息 type 1--施工类, 2--不过滤施工类
    List<ProfitIncomeVO> getProjects(@Param("idList") List<Long> idList,Integer type);
    //批量查询施工类合同
    List<ProfitIncomeVO> getProjectByType(@Param("idList") List<Long> idList,@Param("projectType") String projectType);

    //查询列表
    List<ProfitIncomeVO> queryList(Map<String, Object> paramMapper);

    //删除当前月份数据
    void deleteByReportingMonth(@Param(value = "reportingMonth")String reportingMonth);

}
