package com.ejianc.business.analysis.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.FeeVO;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.business.analysis.vo.ProjectPaymentVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.number.MathUtil;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.analysis.mapper.FeeMapper;
import com.ejianc.business.analysis.bean.FeeEntity;
import com.ejianc.business.analysis.service.IFeeService;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 现场管理费
 * 
 * @author generator
 * 
 */
@Service("feeService")
public class FeeServiceImpl extends BaseServiceImpl<FeeMapper, FeeEntity> implements IFeeService{
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;
    @Autowired
    private FeeMapper feeMapper;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IFeeService feeService;

    @Autowired
    private IDefdocApi defdocApi;


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        //获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        logger.info("reportingMonth"+reportingMonth+"inAdvanceFlag"+inAdvanceFlag+"day"+day+"projectIdList"+JSONArray.toJSONString(projectIdList));
        //先删后增
        LambdaQueryWrapper<FeeEntity> lambdaFee = Wrappers.<FeeEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaFee.in(FeeEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(FeeEntity::getReportingMonth, reportingMonth);
        feeService.remove(lambdaFee);

        //查询项目信息数据
        List<ProfitIncomeVO> profitIncomeVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(projectIdList,1);
        }else{
            //等于1代表预生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(null,1);
        }

        //过滤掉公司费用类公共项目
        CommonResponse<List<DefdocDetailVO>> plProject = defdocApi.getDefDocByDefCode("pl_project");
        if (!plProject.isSuccess()){
            throw new BusinessException("根据档案编码查询档案项失败!");
        }
        List<DefdocDetailVO> defdocDetailVOList = plProject.getData();

        Map<String, List<DefdocDetailVO>> nameMap = new HashMap<>();

        if (CollectionUtils.isNotEmpty(defdocDetailVOList)){
            nameMap =defdocDetailVOList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getName()
                    ));
        }

//过滤掉过滤掉公司费用类公共项目
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)){
            Map<String, List<DefdocDetailVO>> finalNameMap = nameMap;
            profitIncomeVOList = profitIncomeVOList.stream().filter(s-> !finalNameMap.containsKey(s.getProjectName())).collect(Collectors.toList());
        }





        //获取间接费明细数据
        //获取当年月初的年月
        String yearMonth = CommonUtils.getSysYearAndFirstMonth();
        //获取去本年值--管理费
        List<FeeVO> bqData = feeMapper.getBqData(yearMonth, reportingMonth, projectIdList);
        logger.info("bqData"+"yearMonth"+yearMonth+"reportingMonth"+reportingMonth+"projectIdList"+JSONArray.toJSONString(projectIdList));

        //获取去本年值--实际完成产值
        List<FeeVO> bqIncomeData = feeMapper.getBqIncomeData(yearMonth, reportingMonth, projectIdList);
        //获取累计值--管理费
        List<FeeVO> ljData = feeMapper.getLjData(reportingMonth, projectIdList);
        //获取累计值--产值收入
        List<FeeVO> ljIncomeData = feeMapper.getLjIncomeData(reportingMonth, projectIdList);
        Map<Long, List<FeeVO>> mapBq = new HashMap<>();
        Map<Long, List<FeeVO>> mapBqIncome = new HashMap<>();
        Map<Long, List<FeeVO>> mapLj = new HashMap<>();
        Map<Long, List<FeeVO>> mapLjIncome = new HashMap<>();
        if (CollectionUtils.isNotEmpty(bqData)){
            mapBq = bqData.stream().collect(
            Collectors.groupingBy(
                    s -> s.getProjectId()
            ));
        }
        if (CollectionUtils.isNotEmpty(bqIncomeData)){
            mapBqIncome = bqIncomeData.stream().collect(
            Collectors.groupingBy(
                    s -> s.getProjectId()
            ));
        }
        if (CollectionUtils.isNotEmpty(ljData)){
            mapLj = ljData.stream().collect(
            Collectors.groupingBy(
                    s -> s.getProjectId()
            ));
        }
        if (CollectionUtils.isNotEmpty(ljIncomeData)){
            mapLjIncome = ljIncomeData.stream().collect(
            Collectors.groupingBy(
                    s -> s.getProjectId()
            ));
        }


        if (CollectionUtils.isNotEmpty(profitIncomeVOList)){
            //赋值组织简称
//            List<Long> orgIds = profitIncomeVOList.stream().map(ProfitIncomeVO::getOrgId).collect(Collectors.toList());
//            CommonResponse<List<OrgVO>> orgListData = orgApi.findAllByIds(orgIds);
//            Map<Long, OrgVO> orgListMap = new HashMap<>();
//            if (orgListData.isSuccess() && null != orgListData.getData()) {
//                List<OrgVO> orgList = orgListData.getData();
//                if(CollectionUtils.isNotEmpty(orgList)){
//                    orgListMap = orgList.stream()
//                            .collect(Collectors.toMap(x->x.getId(), Function.identity(),(k1, k2) ->k2));
//                }
//            }
//            for (ProfitIncomeVO profitIncomeVO : profitIncomeVOList){
//                if (orgListMap.containsKey(profitIncomeVO.getOrgId())){
//                    OrgVO orgVO = orgListMap.get(profitIncomeVO.getOrgId());
//                    profitIncomeVO.setShortName(orgVO.getShortName());
//                }
//            }

            List<FeeVO> feeVOList = BeanMapper.mapList(profitIncomeVOList, FeeVO.class);
            for (FeeVO feeVO : feeVOList){
                feeVO.setReportingMonth(reportingMonth);//取当前生成月份日期
                feeVO.setCreateTime(new Date());
                //设置本年值--管理费
                if (mapBq.containsKey(feeVO.getProjectId())){
                    List<FeeVO> feeVOS = mapBq.get(feeVO.getProjectId());
                    FeeVO feeVOBq = feeVOS.stream().findFirst().get();
                    feeVO.setYearFee(CommonUtils.parseNullValue(feeVOBq.getYearFee()));
                }else{
                    feeVO.setYearFee(BigDecimal.ZERO);
                }
                //设置本年值--产值收入
                if (mapBqIncome.containsKey(feeVO.getProjectId())){
                    List<FeeVO> feeVOS = mapBqIncome.get(feeVO.getProjectId());
                    FeeVO feeVOBq = feeVOS.stream().findFirst().get();
                    feeVO.setYearProduction(CommonUtils.parseNullValue(feeVOBq.getYearProduction()));
                }else{
                    feeVO.setYearProduction(BigDecimal.ZERO);
                }
                //设置累计值--管理费
                if (mapLj.containsKey(feeVO.getProjectId())){
                    List<FeeVO> feeVOS = mapLj.get(feeVO.getProjectId());
                    //排序获取最近的月份数据
                    List<FeeVO> collectCompare = feeVOS.stream().sorted(Comparator.comparing(FeeVO::getReportingMonth).reversed())
                            .collect(Collectors.toList());
                    FeeVO feeVOLj = collectCompare.stream().findFirst().get();
                    feeVO.setSumFee(CommonUtils.parseNullValue(feeVOLj.getSumFee()));
                }else{
                    feeVO.setSumFee(BigDecimal.ZERO);
                }
                //设置累计值--产值收入
                if (mapLjIncome.containsKey(feeVO.getProjectId())){
                    List<FeeVO> feeVOS = mapLjIncome.get(feeVO.getProjectId());
                    //排序获取最近的月份数据
                    List<FeeVO> collectCompare = feeVOS.stream().sorted(Comparator.comparing(FeeVO::getReportingMonth).reversed())
                            .collect(Collectors.toList());
                    FeeVO feeVOLj = collectCompare.stream().findFirst().get();
                    feeVO.setSumProduction(CommonUtils.parseNullValue(feeVOLj.getSumProduction()));
                }else{
                    feeVO.setSumProduction(BigDecimal.ZERO);
                }
                //补全二级组织信息
                CommonResponse<OrgVO> orgVo = orgApi.detailById(feeVO.getProjectDepartmentId());//此处是项目部id 1286211352287834113
                if (orgVo.isSuccess() && null != orgVo.getData()) {
                    String innerCode = orgVo.getData().getInnerCode();
                    String[] strs = innerCode.split("\\|");
                    CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                    if (orgVos.isSuccess() && null != orgVos.getData()) {
                        //二级组织信息
                        feeVO.setTwoOrgId(orgVos.getData().getId());
                        feeVO.setTwoOrgName(orgVos.getData().getShortName());
                        feeVO.setTwoOrgCode(orgVos.getData().getCode());
                        feeVO.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());
                    }
                }
            }

            List<FeeEntity> feeEntityList = BeanMapper.mapList(feeVOList, FeeEntity.class);
            feeService.saveBatch(feeEntityList);
        }

    }

    @Override
    public List<FeeVO> dealData(List<FeeVO> feeVOS) {

        //转万元
        for(FeeVO feeVO : feeVOS){
            feeVO.setYearProduction(CommonUtils.parseYuanToWan(feeVO.getYearProduction()));
            feeVO.setYearFee(CommonUtils.parseYuanToWan(feeVO.getYearFee()));
            feeVO.setSumProduction(CommonUtils.parseYuanToWan(feeVO.getSumProduction()));
            feeVO.setSumFee(CommonUtils.parseYuanToWan(feeVO.getSumFee()));
        }

        //处理第一行合计值
        FeeVO feeVO = new FeeVO();
        ArrayList<FeeVO> feeNewList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(feeVOS)){
            getSumData(feeVOS, feeVO);
            feeVO.setNumber("合计");
            feeVO.setId(IdWorker.getId());
            feeNewList.add(feeVO);
        }

        //计算排序字段
        for(FeeVO feeVOrder :feeVOS){
            feeVOrder.setProjectStatusOrder(CommonUtils.getProjectOrderNum(feeVOrder.getProjectStatus()));
        }

        //计算项目状态合计
        feeVOS = feeVOS.stream().sorted(Comparator.comparing(FeeVO::getProjectStatusOrder))
                .collect(Collectors.toList());
        Map<Integer, List<FeeVO>> mapProjectStatusOrder = feeVOS.stream().collect(
                Collectors.groupingBy(
                        s -> s.getProjectStatusOrder()
                ));

        mapProjectStatusOrder.forEach((projectStatusKey,projectStatusList)->{
            FeeVO projectStatusSumfeeVO = new FeeVO();
            projectStatusSumfeeVO.setNumber("项目状态合计");
            projectStatusSumfeeVO.setId(IdWorker.getId());
            projectStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusNameProject(projectStatusKey));
            getSumData(projectStatusList, projectStatusSumfeeVO);
            feeNewList.add(projectStatusSumfeeVO);

            //计算组织状态合计
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(FeeVO::getOrgStatusOrder))
                    .collect(Collectors.toList());
            Map<Integer, List<FeeVO>> mapOrgStatusOrder = projectStatusList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getOrgStatusOrder()
                    ));
            mapOrgStatusOrder.forEach((orgStatusKey,orgStatusList)->{
                FeeVO orgStatusSumfeeVO = new FeeVO();
                orgStatusSumfeeVO.setNumber("单位小计");
                orgStatusSumfeeVO.setId(IdWorker.getId());
                orgStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(orgStatusList.stream().findFirst().get().getProjectStatus()));
                orgStatusSumfeeVO.setTwoOrgName(orgStatusList.stream().findFirst().get().getTwoOrgName());
                getSumData(orgStatusList, orgStatusSumfeeVO);
                feeNewList.add(orgStatusSumfeeVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(FeeVO::getProjectCreateTime))
                        .collect(Collectors.toList());
                for (FeeVO feeVONum : orgStatusList){
                    feeVONum.setNumber(number +"");
                    number = number + 1;
                    feeVONum.setProjectStatusName(CommonUtils.getProjectStatusName(feeVONum.getProjectStatus()));
//                    //转万元赋值
//                    feeVONum.setYearProduction(CommonUtils.parseYuanToWan(feeVONum.getYearProduction()));
//                    feeVONum.setYearFee(CommonUtils.parseYuanToWan(feeVONum.getYearFee()));
//                    feeVONum.setSumProduction(CommonUtils.parseYuanToWan(feeVONum.getSumProduction()));
//                    feeVONum.setSumFee(CommonUtils.parseYuanToWan(feeVONum.getSumFee()));
                    //计算占比
                    feeVONum.setYearRate(CommonUtils.calculateRate(feeVONum.getYearFee(),feeVONum.getYearProduction()));
                    feeVONum.setSumRate(CommonUtils.calculateRate(feeVONum.getSumFee(),feeVONum.getSumProduction()));
                }
                feeNewList.addAll(orgStatusList);
            });

        });
        return feeNewList;
    }

    private void getSumData(List<FeeVO> feeVOS, FeeVO feeVO) {


        BigDecimal yearProduction = feeVOS.stream().map(FeeVO::getYearProduction)
        .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal yearFee = feeVOS.stream().map(FeeVO::getYearFee)
        .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumProduction = feeVOS.stream().map(FeeVO::getSumProduction)
        .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumFee = feeVOS.stream().map(FeeVO::getSumFee)
        .reduce(BigDecimal.ZERO, BigDecimal::add);
        //转万元赋值
        feeVO.setYearProduction(yearProduction);
        feeVO.setYearFee(yearFee);
        feeVO.setSumProduction(sumProduction);
        feeVO.setSumFee(sumFee);
        //计算占比
        feeVO.setYearRate(CommonUtils.calculateRate(feeVO.getYearFee(),feeVO.getYearProduction()));
        feeVO.setSumRate(CommonUtils.calculateRate(feeVO.getSumFee(),feeVO.getSumProduction()));

    }

}
