package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.FeeEntity;
import com.ejianc.business.analysis.mapper.FeeMapper;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.service.IFeeService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.*;
import com.ejianc.business.analysis.vo.SettleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.shiro.authc.Account;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.analysis.mapper.SettleMapper;
import com.ejianc.business.analysis.bean.SettleEntity;
import com.ejianc.business.analysis.service.ISettleService;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 分供方结算情况汇总表
 * 
 * @author generator
 * 
 */
@Service("settleService")
public class SettleServiceImpl extends BaseServiceImpl<SettleMapper, SettleEntity> implements ISettleService{
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;
    @Autowired
    private SettleMapper settleMapper;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ISettleService settleService;
    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        //获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);

        //先删后增
        LambdaQueryWrapper<SettleEntity> lambdaFee = Wrappers.<SettleEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaFee.in(SettleEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(SettleEntity::getReportingMonth, reportingMonth);
        settleService.remove(lambdaFee);

        //查询项目信息数据
        List<ProfitIncomeVO> profitIncomeVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(projectIdList,1);
        }else{
            //等于1代表预生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(null,1);
        }

        //获取项目下所有的合同信息
        List<SettleVO> listContract = settleMapper.getContractNum(projectIdList);
        Map<Long,BigDecimal>listContractMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(listContract)){
            listContractMap = listContract.stream().collect(Collectors.toMap(SettleVO::getProjectId, SettleVO::getContractNum));
        }

        //合同状态取平台中心【分供方合同履约状态管理】=已竣已结合同个数/（已竣已结+已竣未结）个数
        List<SettleVO> listContractType = settleMapper.getContractTypeNum(projectIdList);
        Map<String,BigDecimal>listContractTypetMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(listContract)){
            listContractTypetMap = listContractType.stream().collect(Collectors.toMap(s->s.getProjectId() + "-" + s.getContractStatusName(), SettleVO::getContractNum));
        }

        //获取结算数据
        List<SettleVO> listSettle = settleMapper.getSettleMny(projectIdList);
        Map<Long,BigDecimal> listSettlMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(listContract)){
            listSettlMap = listSettle.stream().collect(Collectors.toMap(s->s.getProjectId(), SettleVO::getSettleMny));
        }

        //获取已确认变洽签、索赔金额
        List<SettleVO> listSp = settleMapper.getSpMny(projectIdList);
        Map<Long,BigDecimal> listSpMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(listContract)){
            listSpMap = listSp.stream().collect(Collectors.toMap(s->s.getProjectId(), SettleVO::getSettleMny));
        }

        //获取应付和已付金额,应付未付金额
        List<SettleVO> listPayMny = settleMapper.getPayMny(projectIdList);
        Map<Long,List<SettleVO>> listPayMnyMap = new HashMap<>();
        Map<String,List<SettleVO>> listPayMnyPeriodMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(listContract)){
            listPayMnyMap = listPayMny.stream().collect(Collectors.groupingBy(s->s.getProjectId()));
            listPayMnyPeriodMap = listPayMny.stream().collect(Collectors.groupingBy(s->s.getProjectId() + "-" + s.getReportingMonth()));
        }

        //获取劳务分包和专业分包的结算金额
        List<SettleVO> listContractTypeMny = settleMapper.getContractTypeMny(projectIdList);
        Map<String,BigDecimal> listContractTypeMnyMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(listContract)){
            listContractTypeMnyMap = listContractTypeMny.stream().collect(Collectors.toMap(s->s.getProjectId() + "-" + s.getContractStatusName(), SettleVO::getSettleMny));
        }
        //获取劳务分包和专业分包的付款金额
        List<SettleVO> listContractPayMny = settleMapper.getContractPayMny(projectIdList);
//        Map<String,BigDecimal> listContractPayMnyMap = new HashMap<>();
//        Map<String,BigDecimal> listContractPayMnyMap = new HashMap<>();
        Map<String,List<SettleVO>> listContractPayMnyPeriodMap = new HashMap<>();
        Map<Long,List<SettleVO>> listContractPayMnyMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(listContract)){
//            listContractPayMnyMap = listContractPayMny.stream().collect(Collectors.toMap(s->s.getProjectId() + "-" +s.getContractStatusName(), SettleVO::getSettleMny));
            listContractPayMnyMap = listContractPayMny.stream().collect(Collectors.groupingBy(s->s.getProjectId()));
        }


        ///补全二级组织信息
        Map<Long, SettleVO> twoOrgMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            List<SettleVO> feeVOList = BeanMapper.mapList(profitIncomeVOList, SettleVO.class);
            for (SettleVO feeVO : feeVOList){
                feeVO.setReportingMonth(reportingMonth);//取当前生成月份日期
                feeVO.setCreateTime(new Date());
                //设置分供合同数量
                if (listContractMap.containsKey(feeVO.getProjectId())){
                    BigDecimal contractNum = listContractMap.get(feeVO.getProjectId());
                    feeVO.setContractNum(CommonUtils.parseNullValue(contractNum));
                }else{
                    feeVO.setContractNum(BigDecimal.ZERO);
                }

                //设置结算完成率
                String keyYjyj = feeVO.getProjectId() + "-" + "已竣已结";
                String keyYjwj = feeVO.getProjectId() + "-" + "已竣未结";
                if (listContractTypetMap.containsKey(keyYjyj)){
                    BigDecimal yjyjNum = listContractTypetMap.get(keyYjyj);
                    BigDecimal yjwjNum = listContractTypetMap.get(keyYjwj);
//                    feeVO.setSettleRate(CommonUtils.calculateRate(yjyjNum,yjyjNum.add(yjwjNum)));
                    feeVO.setYjyjNum(CommonUtils.parseNullValue(yjyjNum));
                    feeVO.setYjwjNum(CommonUtils.parseNullValue(yjwjNum));
                }else{
                    feeVO.setYjyjNum(BigDecimal.ZERO);
                    feeVO.setYjwjNum(BigDecimal.ZERO);
                }

                //已办理结算金额
                if (listSettlMap.containsKey(feeVO.getProjectId())){
                    BigDecimal settleMny = listSettlMap.get(feeVO.getProjectId());
                    feeVO.setSettleMny(CommonUtils.parseNullValue(settleMny));
                }else{
                    feeVO.setSettleMny(BigDecimal.ZERO);
                }

                //已确认变洽签,索赔金额
                if (listSpMap.containsKey(feeVO.getProjectId())){
                    BigDecimal settleMny = listSpMap.get(feeVO.getProjectId());
                    feeVO.setClaimMny(CommonUtils.parseNullValue(settleMny));
                }else{
                    feeVO.setClaimMny(BigDecimal.ZERO);
                }

                //应付和未付金额
                if (listPayMnyMap.containsKey(feeVO.getProjectId())) {
                    List<SettleVO> settleVOList = listPayMnyMap.get(feeVO.getProjectId());
                    List<SettleVO> collectCompare = settleVOList.stream().sorted(Comparator.comparing(SettleVO::getReportingMonth).reversed())
                            .collect(Collectors.toList());
                    SettleVO periodVO = collectCompare.stream().findFirst().get();
                    feeVO.setYfMny(CommonUtils.parseNullValue(periodVO.getYfMny()));
                    feeVO.setPayMny(CommonUtils.parseNullValue(periodVO.getPayMny()));
                    feeVO.setYfwfMny(CommonUtils.parseNullValue(periodVO.getYfwfMny()));
                }else{
                    feeVO.setYfMny(BigDecimal.ZERO);
                    feeVO.setPayMny(BigDecimal.ZERO);
                    feeVO.setYfwfMny(BigDecimal.ZERO);
                }

                //已结算劳务分包金额
                if (listContractTypeMnyMap.containsKey(feeVO.getProjectId() + "-" + "劳务分包")) {
                    BigDecimal lwSettleMny = listContractTypeMnyMap.get(feeVO.getProjectId() + "-" + "劳务分包");
                    feeVO.setLwSettleMny(CommonUtils.parseNullValue(lwSettleMny));
                }else{
                    feeVO.setLwSettleMny(BigDecimal.ZERO);
                }

                //已结算专业分包金额
                if (listContractTypeMnyMap.containsKey(feeVO.getProjectId() + "-" + "专业分包")) {
                    BigDecimal lwSettleMny = listContractTypeMnyMap.get(feeVO.getProjectId() + "-" + "专业分包");
                    feeVO.setZySettleMny(CommonUtils.parseNullValue(lwSettleMny));
                }else{
                    feeVO.setZySettleMny(BigDecimal.ZERO);
                }

                //已付款劳务分包金额和专业分包金额
                if (listContractPayMnyMap.containsKey(feeVO.getProjectId())) {
                    List<SettleVO> settleVOList = listContractPayMnyMap.get(feeVO.getProjectId());
                    listContractPayMnyPeriodMap = settleVOList.stream().collect(Collectors.groupingBy(s->s.getProjectId() + "-" + s.getContractStatusName()));
                    String keyLw = feeVO.getProjectId() + "-" + "劳务分包";
                    if (listContractPayMnyPeriodMap.containsKey(keyLw)){
                        List<SettleVO> settleVOS = listContractPayMnyPeriodMap.get(keyLw);
                        List<SettleVO> collectCompare = settleVOS.stream().sorted(Comparator.comparing(SettleVO::getReportingMonth).reversed())
                                .collect(Collectors.toList());
                        SettleVO periodVO = collectCompare.stream().findFirst().get();
                        feeVO.setLwPayMny(CommonUtils.parseNullValue(periodVO.getLwSettleMny()));
//                        feeVO.setZyPayMny(CommonUtils.parseNullValue(periodVO.getLwPayMny()));
                    }else{
                        feeVO.setLwPayMny(BigDecimal.ZERO);
                    }
                    //专业
                    String keyZy = feeVO.getProjectId() + "-" + "专业分包";
                    if (listContractPayMnyPeriodMap.containsKey(keyZy)){
                        List<SettleVO> settleVOS = listContractPayMnyPeriodMap.get(keyZy);
                        List<SettleVO> collectCompare = settleVOS.stream().sorted(Comparator.comparing(SettleVO::getReportingMonth).reversed())
                                .collect(Collectors.toList());
                        SettleVO periodVO = collectCompare.stream().findFirst().get();
                        feeVO.setZyPayMny(CommonUtils.parseNullValue(periodVO.getLwSettleMny()));
//                        feeVO.setZyPayMny(CommonUtils.parseNullValue(periodVO.getLwPayMny()));
                    }else{
                        feeVO.setZyPayMny(BigDecimal.ZERO);
                    }

//                    List<SettleVO> collectCompare = settleVOList.stream().sorted(Comparator.comparing(SettleVO::getReportingMonth).reversed())
//                            .collect(Collectors.toList());
//                    SettleVO periodVO = collectCompare.stream().findFirst().get();
//                    feeVO.setLwPayMny(CommonUtils.parseNullValue(periodVO.getLwPayMny()));
//                    feeVO.setZyPayMny(CommonUtils.parseNullValue(periodVO.getLwPayMny()));
                }

                //补零
                feeVO.setContractNum(CommonUtils.parseNullValue(feeVO.getContractNum()));
                feeVO.setYjyjNum(CommonUtils.parseNullValue(feeVO.getYjyjNum()));
                feeVO.setYjwjNum(CommonUtils.parseNullValue(feeVO.getYjwjNum()));
                feeVO.setSettleMny(CommonUtils.parseNullValue(feeVO.getSettleMny()));
                feeVO.setClaimMny(CommonUtils.parseNullValue(feeVO.getClaimMny()));
                feeVO.setYfMny(CommonUtils.parseNullValue(feeVO.getYfMny()));
                feeVO.setPayMny(CommonUtils.parseNullValue(feeVO.getPayMny()));
                feeVO.setYfwfMny(CommonUtils.parseNullValue(feeVO.getYfwfMny()));
                feeVO.setLwSettleMny(CommonUtils.parseNullValue(feeVO.getLwSettleMny()));
                feeVO.setZySettleMny(CommonUtils.parseNullValue(feeVO.getZySettleMny()));
                feeVO.setLwPayMny(CommonUtils.parseNullValue(feeVO.getLwPayMny()));
                feeVO.setZyPayMny(CommonUtils.parseNullValue(feeVO.getZyPayMny()));
                feeVO.setYjyjNum(CommonUtils.parseNullValue(feeVO.getYjyjNum()));
                feeVO.setYjwjNum(CommonUtils.parseNullValue(feeVO.getYjwjNum()));

                //补全二级组织信息
                CommonResponse<OrgVO> orgVo = orgApi.detailById(feeVO.getProjectDepartmentId());//此处是项目部id 1286211352287834113
                if (orgVo.isSuccess() && null != orgVo.getData()) {
                    String innerCode = orgVo.getData().getInnerCode();
                    String[] strs = innerCode.split("\\|");
                    CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                    if (orgVos.isSuccess() && null != orgVos.getData()) {
                        //二级组织信息
                        feeVO.setTwoOrgId(orgVos.getData().getId());
                        feeVO.setTwoOrgName(orgVos.getData().getShortName());
                        feeVO.setTwoOrgCode(orgVos.getData().getCode());
                        feeVO.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());
                    }
                }
            }
            List<SettleEntity> feeEntityList = BeanMapper.mapList(feeVOList, SettleEntity.class);
            settleService.saveBatch(feeEntityList);
        }



    }

    @Override
    public List<SettleVO> dealData(List<SettleVO> feeVOS) {
        for(SettleVO feeVONum : feeVOS){
            feeVONum.setSettleMny(CommonUtils.parseYuanToWan(feeVONum.getSettleMny()));
            feeVONum.setClaimMny(CommonUtils.parseYuanToWan(feeVONum.getClaimMny()));
            feeVONum.setYfMny(CommonUtils.parseYuanToWan(feeVONum.getYfMny()));
            feeVONum.setPayMny(CommonUtils.parseYuanToWan(feeVONum.getPayMny()));
            feeVONum.setYfwfMny(CommonUtils.parseYuanToWan(feeVONum.getYfwfMny()));
            feeVONum.setLwSettleMny(CommonUtils.parseYuanToWan(feeVONum.getLwSettleMny()));
            feeVONum.setLwPayMny(CommonUtils.parseYuanToWan(feeVONum.getLwPayMny()));
            feeVONum.setZySettleMny(CommonUtils.parseYuanToWan(feeVONum.getZySettleMny()));
            feeVONum.setZyPayMny(CommonUtils.parseYuanToWan(feeVONum.getZyPayMny()));
        }
        //处理第一行合计值
        SettleVO feeVO = new SettleVO();
        ArrayList<SettleVO> feeNewList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(feeVOS)){
            getSumData(feeVOS, feeVO);
            feeVO.setNumber("合计");
            feeVO.setId(IdWorker.getId());
            feeNewList.add(feeVO);
        }

        //计算排序字段
        for(SettleVO feeVOrder :feeVOS){
            feeVOrder.setProjectStatusOrder(CommonUtils.getProjectOrderNum(feeVOrder.getProjectStatus()));
        }

        //计算项目状态合计
        feeVOS = feeVOS.stream().sorted(Comparator.comparing(SettleVO::getProjectStatusOrder))
                .collect(Collectors.toList());
        Map<Integer, List<SettleVO>> mapProjectStatusOrder = feeVOS.stream().collect(
                Collectors.groupingBy(
                        s -> s.getProjectStatusOrder()
                ));
        mapProjectStatusOrder.forEach((projectStatusKey,projectStatusList)->{
            SettleVO projectStatusSumfeeVO = new SettleVO();
            projectStatusSumfeeVO.setNumber("项目状态合计");
            projectStatusSumfeeVO.setId(IdWorker.getId());
            projectStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusNameProject(projectStatusKey));
            getSumData(projectStatusList, projectStatusSumfeeVO);
            feeNewList.add(projectStatusSumfeeVO);

            //计算组织状态合计
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(SettleVO::getOrgStatusOrder))
                    .collect(Collectors.toList());
            Map<Integer, List<SettleVO>> mapOrgStatusOrder = projectStatusList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getOrgStatusOrder()
                    ));
            mapOrgStatusOrder.forEach((orgStatusKey,orgStatusList)->{
                SettleVO orgStatusSumfeeVO = new SettleVO();
                orgStatusSumfeeVO.setNumber("单位小计");
                orgStatusSumfeeVO.setId(IdWorker.getId());
                orgStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(orgStatusList.stream().findFirst().get().getProjectStatus()));
                orgStatusSumfeeVO.setTwoOrgName(orgStatusList.stream().findFirst().get().getTwoOrgName());
                getSumData(orgStatusList, orgStatusSumfeeVO);
                feeNewList.add(orgStatusSumfeeVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(SettleVO::getProjectCreateTime))
                        .collect(Collectors.toList());
                for (SettleVO feeVONum : orgStatusList){
                    feeVONum.setNumber(number +"");
                    number = number + 1;
                    feeVONum.setProjectStatusName(CommonUtils.getProjectStatusName(feeVONum.getProjectStatus()));

                    //转万元赋值
                    feeVONum.setContractNum(CommonUtils.parseNullValue(feeVONum.getContractNum()));

//                    feeVONum.setSettleMny(CommonUtils.parseYuanToWan(feeVONum.getSettleMny()));
//                    feeVONum.setClaimMny(CommonUtils.parseYuanToWan(feeVONum.getClaimMny()));
//                    feeVONum.setYfMny(CommonUtils.parseYuanToWan(feeVONum.getYfMny()));
//                    feeVONum.setPayMny(CommonUtils.parseYuanToWan(feeVONum.getPayMny()));
//                    feeVONum.setYfwfMny(CommonUtils.parseYuanToWan(feeVONum.getYfwfMny()));
//                    feeVONum.setLwSettleMny(CommonUtils.parseYuanToWan(feeVONum.getLwSettleMny()));
//                    feeVONum.setLwPayMny(CommonUtils.parseYuanToWan(feeVONum.getLwPayMny()));

                    feeVONum.setLwRate(CommonUtils.calculateRate(feeVONum.getLwPayMny(),feeVONum.getLwSettleMny()));
                    feeVONum.setZyRate(CommonUtils.calculateRate(feeVONum.getZyPayMny(),feeVONum.getZySettleMny()));
                    feeVONum.setSettleRate(CommonUtils.calculateRate(feeVONum.getYjyjNum(),feeVONum.getYjyjNum().add(feeVONum.getYjwjNum())));
                    feeVONum.setClaimRate(CommonUtils.calculateRate(feeVONum.getClaimMny(),feeVONum.getZySettleMny().add(feeVONum.getLwSettleMny())));

                }
                feeNewList.addAll(orgStatusList);
            });

        });
        
        return feeNewList;
    }

    private void getSumData(List<SettleVO> feeVOS, SettleVO feeVO) {
        BigDecimal contractNum = feeVOS.stream().map(SettleVO::getContractNum)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal yjyjNum = feeVOS.stream().map(SettleVO::getYjyjNum)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal yjwjNum = feeVOS.stream().map(SettleVO::getYjwjNum)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal settleMny = feeVOS.stream().map(SettleVO::getSettleMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal claimMny = feeVOS.stream().map(SettleVO::getClaimMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal yfMny = feeVOS.stream().map(SettleVO::getYfMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal payMny = feeVOS.stream().map(SettleVO::getPayMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal yfwfMny = feeVOS.stream().map(SettleVO::getYfwfMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal lwSettleMny = feeVOS.stream().map(SettleVO::getLwSettleMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal lwPayMny = feeVOS.stream().map(SettleVO::getLwPayMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal zySettleMny = feeVOS.stream().map(SettleVO::getZySettleMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal zyPayMny = feeVOS.stream().map(SettleVO::getZyPayMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        //转万元赋值
        feeVO.setContractNum(CommonUtils.parseNullValue(contractNum));

        feeVO.setSettleMny(settleMny);
        feeVO.setClaimMny(claimMny);
        feeVO.setYfMny(yfMny);
        feeVO.setPayMny(payMny);
        feeVO.setYfwfMny(yfwfMny);
        feeVO.setLwSettleMny(lwSettleMny);
        feeVO.setLwPayMny(lwPayMny);
        feeVO.setZySettleMny(zySettleMny);
        feeVO.setZyPayMny(zyPayMny);

        feeVO.setLwRate(CommonUtils.calculateRate(lwPayMny,lwSettleMny));
        feeVO.setZyRate(CommonUtils.calculateRate(zyPayMny,zySettleMny));
        feeVO.setSettleRate(CommonUtils.calculateRate(yjyjNum,yjyjNum.add(yjwjNum)));
        feeVO.setClaimRate(CommonUtils.calculateRate(feeVO.getClaimMny(),feeVO.getZySettleMny().add(feeVO.getLwSettleMny())));

    }

    private void getOrg(Map<Long, SettleVO> twoOrgMap, List<SettleVO> list) {
        if (CollectionUtils.isNotEmpty(list)){
            for (SettleVO settleVO : list){
                if (twoOrgMap.containsKey(settleVO.getProjectId())){
                    getTwoOrgData(twoOrgMap, settleVO);
                }
            }
        }
    }

    private void getTwoOrgData(Map<Long, SettleVO> twoOrgMap, SettleVO settleVO) {
        SettleVO settleVOPro = twoOrgMap.get(settleVO.getProjectId());
        settleVO.setTwoOrgId(settleVOPro.getTwoOrgId());
        settleVO.setTwoOrgName(settleVOPro.getTwoOrgName());
        settleVO.setProjectStatus(settleVOPro.getProjectStatus());
    }
}
