package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.UnsettledProBusinessEntity;
import com.ejianc.business.analysis.mapper.UnsettledProBusinessMapper;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.ProjectBusinessVO;
import com.ejianc.business.analysis.vo.SettledProBusinessVO;
import com.ejianc.business.analysis.vo.UnsettledProBusinessVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.analysis.mapper.SettledProBusinessMapper;
import com.ejianc.business.analysis.bean.SettledProBusinessEntity;
import com.ejianc.business.analysis.service.ISettledProBusinessService;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 竣工已结算项目商务报表
 *
 * @author generator
 *
 */
@Service("settledProBusinessService")
public class SettledProBusinessServiceImpl extends BaseServiceImpl<SettledProBusinessMapper, SettledProBusinessEntity> implements ISettledProBusinessService{
    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private ISettledProBusinessService settledProBusinessService;

    @Autowired
    private SettledProBusinessMapper settledProBusinessMapper;

    @Autowired
    private UnsettledProBusinessMapper unsettledProBusinessMapper;
    @Autowired
    private IDefdocApi defdocApi;


    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        //获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);

        //先删后增
        LambdaQueryWrapper<SettledProBusinessEntity> lambdaFee = Wrappers.<SettledProBusinessEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaFee.in(SettledProBusinessEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(SettledProBusinessEntity::getReportingMonth, reportingMonth);
        settledProBusinessService.remove(lambdaFee);

        //查询项目信息数据
        List<SettledProBusinessVO> settledProBusinessVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            settledProBusinessVOList = settledProBusinessMapper.queryProjectIds(projectIdList);
        }else{
            //等于1代表预生成数据
            settledProBusinessVOList = settledProBusinessMapper.queryProjectIds(null);
        }
        //过滤掉公司费用类公共项目
        CommonResponse<List<DefdocDetailVO>> plProject = defdocApi.getDefDocByDefCode("pl_project");
        if (!plProject.isSuccess()){
            throw new BusinessException("根据档案编码查询档案项失败!");
        }
        List<DefdocDetailVO> defdocDetailVOList = plProject.getData();

        Map<String, List<DefdocDetailVO>> nameMap = new HashMap<>();

        if (CollectionUtils.isNotEmpty(defdocDetailVOList)){
            nameMap =defdocDetailVOList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getName()
                    ));
        }

//过滤掉过滤掉公司费用类公共项目
        if (CollectionUtils.isNotEmpty(settledProBusinessVOList)){
            Map<String, List<DefdocDetailVO>> finalNameMap = nameMap;
            settledProBusinessVOList = settledProBusinessVOList.stream().filter(s-> !finalNameMap.containsKey(s.getProjectName())).collect(Collectors.toList());
        }


        List<Long> projectIds = settledProBusinessVOList.stream().map(SettledProBusinessVO::getProjectId).collect(Collectors.toList());

        // 查询施工类合同
        List<SettledProBusinessVO> contractVOS = settledProBusinessMapper.queryContract(projectIds);
        Map<Long, SettledProBusinessVO> contractMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(contractVOS)) {
            contractMap = contractVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }
        // 查询项目目标管理责任书
        List<SettledProBusinessVO> bookVOS = settledProBusinessMapper.queryBook(projectIds);
        Map<Long, SettledProBusinessVO> bookMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(bookVOS)) {
            bookMap = bookVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }
        // 查询项目月度成本分析报告
        List<SettledProBusinessVO> costanalysisVOS = settledProBusinessMapper.queryCostanalysis(projectIds,reportingMonth);
        Map<Long, List<SettledProBusinessVO>> costanalysisMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(costanalysisVOS)) {
            costanalysisMap= costanalysisVOS.stream().collect(
                    Collectors.groupingBy(
                            s->s.getProjectId()
                    ));
        }
        // 查询项目月度成本分析报告往期值
        List<UnsettledProBusinessVO> costanalysisHistoryVOS = unsettledProBusinessMapper.queryCostanalysisHistory(projectIds,getEndDateNear());
        Map<Long,List<UnsettledProBusinessVO>> costanalysisHistoryGrBy = new HashMap<>();
        if (CollectionUtils.isNotEmpty(costanalysisHistoryVOS)) {
            costanalysisHistoryGrBy= costanalysisHistoryVOS.stream().collect(
                    Collectors.groupingBy(
                            s->s.getProjectId()
                    ));
        }
        // 查询总包结算定案会签表
        List<SettledProBusinessVO> settlementFinalizedVOS = settledProBusinessMapper.querySettlementFinalized(projectIds);
        Map<Long, SettledProBusinessVO> settlementFinalizedMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(settlementFinalizedVOS)) {
            settlementFinalizedMap = settlementFinalizedVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }
        // 查询目标责任书竣工考核兑现申报
        List<SettledProBusinessVO> applyVOS = settledProBusinessMapper.queryApply(projectIds);
        // 查询工程计量台账
        List<SettledProBusinessVO> engineermeasurementVOS = settledProBusinessMapper.queryEngineermeasurement(projectIds,reportingMonth);
        Map<Long, SettledProBusinessVO> engineermeasurementMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(engineermeasurementVOS)){
            engineermeasurementMap = engineermeasurementVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }
        // 查询工程计量台账往期值
        List<UnsettledProBusinessVO> engineermeasurementHistoryVOS = unsettledProBusinessMapper.queryEngineermeasurementHistory(projectIds,reportingMonth);
        Map<Long,List<UnsettledProBusinessVO>> engineermeasurementHistoryGrBy = new HashMap<>();
        if (CollectionUtils.isNotEmpty(engineermeasurementHistoryVOS)) {
            engineermeasurementHistoryGrBy= engineermeasurementHistoryVOS.stream().collect(
                    Collectors.groupingBy(
                            s->s.getProjectId()
                    ));
        }
        for (SettledProBusinessVO vo : settledProBusinessVOList) {
            vo.setReportingMonth(reportingMonth);
            Long projectId = vo.getProjectId();
            if (!contractMap.isEmpty() && contractMap.containsKey(projectId)) {
                vo.setPromoter(contractMap.get(projectId).getPromoter());
                vo.setPromoterName(contractMap.get(projectId).getPromoterName());
                vo.setProjectLocation(contractMap.get(projectId).getProjectLocation());
                vo.setContractSignTime(contractMap.get(projectId).getContractSignTime());
                vo.setContractStartDate(contractMap.get(projectId).getContractStartDate());
                vo.setContractEndDate(contractMap.get(projectId).getContractEndDate());
                vo.setContractAmount(contractMap.get(projectId).getAfterChangeAmount() != null ? contractMap.get(projectId).getAfterChangeAmount() : contractMap.get(projectId).getContractAmountByContract());
                vo.setAcContractAmount(contractMap.get(projectId).getAcContractAmount());
            }
            if (!bookMap.isEmpty() && bookMap.containsKey(projectId)) {
                vo.setUndertakeRate(bookMap.get(projectId).getUndertakeRate());
                vo.setTargetRate(bookMap.get(projectId).getTargetRate());
            }
            if (!costanalysisMap.isEmpty() && costanalysisMap.containsKey(projectId)) {
                List<SettledProBusinessVO> collectCompare = costanalysisMap.get(projectId).stream().sorted(Comparator.comparing(SettledProBusinessVO::getReportingMonth).reversed())
                        .collect(Collectors.toList());
                SettledProBusinessVO settledProBusinessVO = collectCompare.stream().findFirst().get();
                vo.setContractIncome(settledProBusinessVO.getContractIncome());
                vo.setAcContractIncome(settledProBusinessVO.getContractIncome());
                vo.setRealCost(settledProBusinessVO.getRealCost());
                vo.setAcRealCost(settledProBusinessVO.getRealCost());
            }
            if (!engineermeasurementMap.isEmpty() && engineermeasurementMap.containsKey(projectId)) {
                vo.setSettlementAmount(engineermeasurementMap.get(projectId).getSettlementAmount());
                vo.setAcSettlementAmount(engineermeasurementMap.get(projectId).getSettlementAmount());
                vo.setContractReceivableMny(engineermeasurementMap.get(projectId).getContractReceivableMny());
                vo.setOperatingRevenue(engineermeasurementMap.get(projectId).getOperatingRevenue());
                vo.setRealRecrived(engineermeasurementMap.get(projectId).getRealRecrived());
            }
            if (!costanalysisHistoryGrBy.isEmpty() && costanalysisHistoryGrBy.containsKey(projectId)) {
                List<UnsettledProBusinessVO> businessVOList = costanalysisHistoryGrBy.get(projectId);
                List<UnsettledProBusinessVO> collectCompare = businessVOList.stream().sorted(Comparator.comparing(UnsettledProBusinessVO::getReportingMonth).reversed())
                        .collect(Collectors.toList());
                vo.setCumulativeIncome(collectCompare.stream().findFirst().get().getCumulativeIncome());
                vo.setCumulativeIncomeYou(collectCompare.stream().findFirst().get().getCumulativeIncome());
            }
            if (!engineermeasurementHistoryGrBy.isEmpty() && engineermeasurementHistoryGrBy.containsKey(projectId)) {
                List<UnsettledProBusinessVO> businessVOList = engineermeasurementHistoryGrBy.get(projectId);
                List<UnsettledProBusinessVO> collectCompare = businessVOList.stream().sorted(Comparator.comparing(UnsettledProBusinessVO::getReportingMonth).reversed())
                        .collect(Collectors.toList());
                vo.setCumulativeBatch(collectCompare.stream().findFirst().get().getCumulativeBatch());
                vo.setCumulativeBatchYou(collectCompare.stream().findFirst().get().getCumulativeBatch());
            }
            if (!settlementFinalizedMap.isEmpty() && settlementFinalizedMap.containsKey(projectId)) {
                vo.setSettlementFinalizeDate(settlementFinalizedMap.get(vo.getProjectId()).getCreateTime());
            }
            //补全二级组织信息
            CommonResponse<OrgVO> orgVo = orgApi.detailById(vo.getProjectDepartmentId());
            if (orgVo.isSuccess() && null != orgVo.getData()) {
                String innerCode = orgVo.getData().getInnerCode();
                String[] strs = innerCode.split("\\|");
                CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                if (orgVos.isSuccess() && null != orgVos.getData()) {
                    //二级组织信息
                    vo.setThreeOrgId(orgVos.getData().getId());
                    vo.setThreeOrgName(orgVos.getData().getName());
                }
            }
            if (vo.getFourOrgId() != null) {
                CommonResponse<OrgVO> fourOrgVO = orgApi.detailById(vo.getFourOrgId());
                if (fourOrgVO.isSuccess() && null != fourOrgVO.getData()) {
                    vo.setFourOrgName(fourOrgVO.getData().getName());// 股份公司四级单位
                }
            }
            if (vo.getContractorName() == null) {
                CommonResponse<OrgVO> orgVO = orgApi.detailById(vo.getContractor());
                if (orgVO.isSuccess() && null != orgVO.getData()) {
                    vo.setContractorName(orgVO.getData().getName());// 承包人名称
                }
            }
            if (vo.getSettlementFinalizeDate() != null && vo.getEndDate() != null) {
                // 结算周期（天数）
                vo.setSettlementCycleDays(ComputeUtil.safeDiv(new BigDecimal(vo.getSettlementFinalizeDate().getTime() - vo.getEndDate().getTime()), new BigDecimal(86400000)));
            }
            // 利润率(%) = (结算额 - 实际成本)/结算额
            vo.setProfitRate(CommonUtils.calculateRate(ComputeUtil.safeSub(vo.getSettlementAmount()!=null?vo.getSettlementAmount():BigDecimal.ZERO, vo.getRealCost()!=null?vo.getRealCost():BigDecimal.ZERO), vo.getSettlementAmount()!=null?vo.getSettlementAmount():BigDecimal.ZERO));
            // 自施利润率(%) = (自施结算额 - 自施实际成本)
            vo.setAcProfitRate(CommonUtils.calculateRate(ComputeUtil.safeSub(vo.getAcSettlementAmount()!=null?vo.getAcSettlementAmount():BigDecimal.ZERO, vo.getAcRealCost()!=null?vo.getAcRealCost():BigDecimal.ZERO), vo.getAcSettlementAmount()!=null?vo.getAcSettlementAmount():BigDecimal.ZERO));
            if (CommonUtils.setBigDecimalDefaultValue(vo.getAcProfitRate()).compareTo(CommonUtils.setBigDecimalDefaultValue(vo.getTargetRate())) == 1) {
                vo.setCompleteTargetBenefitFlag(1);
            }else {
                vo.setCompleteTargetBenefitFlag(0);
            }
            if (applyVOS.size() != 0) {
                vo.setCompleteExamineCashAuditFlag(1);
            } else {
                vo.setCompleteExamineCashAuditFlag(0);
            }
        }
        List<SettledProBusinessEntity> settledProBusinessEntityList = BeanMapper.mapList(settledProBusinessVOList, SettledProBusinessEntity.class);
        settledProBusinessService.saveBatch(settledProBusinessEntityList);
    }

    @Override
    public List<SettledProBusinessVO> dealData(List<SettledProBusinessVO> settledProBusinessVOS) {
        //处理第一行合计值
        SettledProBusinessVO settledProBusinessVO = new SettledProBusinessVO();
        ArrayList<SettledProBusinessVO> newList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(settledProBusinessVOS)) {
            getSumDate(settledProBusinessVOS, settledProBusinessVO);
            settledProBusinessVO.setNumber("合计");
            settledProBusinessVO.setId(IdWorker.getId());
            newList.add(settledProBusinessVO);
        }
        Integer number = 1;
        for (SettledProBusinessVO vo : settledProBusinessVOS) {
            vo.setNumber(String.valueOf(number));
            number++;
            vo.setContractAmount(CommonUtils.parseYuanToWanZ(vo.getContractAmount()));
            vo.setAcContractAmount(CommonUtils.parseYuanToWanZ(vo.getAcContractAmount()));
            vo.setContractIncome(CommonUtils.parseYuanToWanZ(vo.getContractIncome()));
            vo.setAcContractIncome(CommonUtils.parseYuanToWanZ(vo.getAcContractIncome()));
            vo.setRealCost(CommonUtils.parseYuanToWanZ(vo.getRealCost()));
            vo.setAcRealCost(CommonUtils.parseYuanToWanZ(vo.getAcRealCost()));
            vo.setSettlementAmount(CommonUtils.parseYuanToWanZ(vo.getSettlementAmount()));
            vo.setAcSettlementAmount(CommonUtils.parseYuanToWanZ(vo.getAcSettlementAmount()));
            vo.setContractReceivableMny(CommonUtils.parseYuanToWanZ(vo.getContractReceivableMny()));
            vo.setOperatingRevenue(CommonUtils.parseYuanToWanZ(vo.getOperatingRevenue()));
            vo.setRealRecrived(CommonUtils.parseYuanToWanZ(vo.getRealRecrived()));
            vo.setCumulativeIncome(CommonUtils.parseYuanToWanZ(vo.getCumulativeIncome()));
            vo.setCumulativeIncomeYou(CommonUtils.parseYuanToWanZ(vo.getCumulativeIncomeYou()));
            vo.setCumulativeBatch(CommonUtils.parseYuanToWanZ(vo.getCumulativeBatch()));
            vo.setCumulativeBatchYou(CommonUtils.parseYuanToWanZ(vo.getCumulativeBatchYou()));
            switch (String.valueOf(vo.getProjectCategory())) {
                case "1470216164541710337":vo.setProjectCategoryName("工业厂房");break;
                case "1470216222511185922":vo.setProjectCategoryName("公共建筑");break;
                case "1470216274176622593":vo.setProjectCategoryName("民用住宅");break;
                case "1470216311648534530":vo.setProjectCategoryName("基础设施");break;
                case "1470216348239642626":vo.setProjectCategoryName("其它");break;
            }
            switch (vo.getCompleteTargetBenefitFlag()) {
                case 0:vo.setCompleteTargetBenefitFlagName("否");break;
                case 1:vo.setCompleteTargetBenefitFlagName("是");break;
            }
            switch (vo.getCompleteExamineCashAuditFlag()) {
                case 0:vo.setCompleteExamineCashAuditFlagName("否");break;
                case 1:vo.setCompleteExamineCashAuditFlagName("是");break;
            }
        }
        newList.addAll(settledProBusinessVOS);
        return newList;
    }

    private void getSumDate(List<SettledProBusinessVO> settledProBusinessVOS, SettledProBusinessVO settledProBusinessVO) {
        settledProBusinessVO.setContractAmount(CommonUtils.parseYuanToWanZ(settledProBusinessVOS.stream().filter(s -> s.getContractAmount() != null).map(SettledProBusinessVO::getContractAmount).reduce(BigDecimal.ZERO, BigDecimal::add)));
        settledProBusinessVO.setAcContractAmount(CommonUtils.parseYuanToWanZ(settledProBusinessVOS.stream().filter(s -> s.getAcContractAmount() != null).map(SettledProBusinessVO::getAcContractAmount).reduce(BigDecimal.ZERO, BigDecimal::add)));
        settledProBusinessVO.setContractIncome(CommonUtils.parseYuanToWanZ(settledProBusinessVOS.stream().filter(s -> s.getContractIncome() != null).map(SettledProBusinessVO::getContractIncome).reduce(BigDecimal.ZERO, BigDecimal::add)));
        settledProBusinessVO.setAcContractIncome(CommonUtils.parseYuanToWanZ(settledProBusinessVOS.stream().filter(s -> s.getAcContractIncome() != null).map(SettledProBusinessVO::getAcContractIncome).reduce(BigDecimal.ZERO, BigDecimal::add)));
        settledProBusinessVO.setRealCost(CommonUtils.parseYuanToWanZ(settledProBusinessVOS.stream().filter(s -> s.getRealCost() != null).map(SettledProBusinessVO::getRealCost).reduce(BigDecimal.ZERO, BigDecimal::add)));
        settledProBusinessVO.setAcRealCost(CommonUtils.parseYuanToWanZ(settledProBusinessVOS.stream().filter(s -> s.getAcRealCost() != null).map(SettledProBusinessVO::getAcRealCost).reduce(BigDecimal.ZERO, BigDecimal::add)));
        settledProBusinessVO.setContractReceivableMny(CommonUtils.parseYuanToWanZ(settledProBusinessVOS.stream().filter(s -> s.getContractReceivableMny() != null).map(SettledProBusinessVO::getContractReceivableMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
        settledProBusinessVO.setOperatingRevenue(CommonUtils.parseYuanToWanZ(settledProBusinessVOS.stream().filter(s -> s.getOperatingRevenue() != null).map(SettledProBusinessVO::getOperatingRevenue).reduce(BigDecimal.ZERO, BigDecimal::add)));
        settledProBusinessVO.setRealRecrived(CommonUtils.parseYuanToWanZ(settledProBusinessVOS.stream().filter(s -> s.getRealRecrived() != null).map(SettledProBusinessVO::getRealRecrived).reduce(BigDecimal.ZERO, BigDecimal::add)));
    }
    //减去一年
    private static String getEndDateNear() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Calendar ca = Calendar.getInstance();
        ca.add(Calendar.YEAR, -1);
        Date d = ca.getTime();
        String endDate = format.format(d);
        return endDate;
    }
}
