/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.ConstructionBudgetEntity;
import com.ejianc.business.analysis.mapper.ConstructionBudgetMapper;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.service.IConstructionBudgetService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.ConstructionBudgetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="constructionBudgetService")
public class ConstructionBudgetServiceImpl
extends BaseServiceImpl<ConstructionBudgetMapper, ConstructionBudgetEntity>
implements IConstructionBudgetService {
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;
    @Autowired
    private ConstructionBudgetMapper constructionBudgetMapper;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IDefdocApi defdocApi;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        List constructionBudgetVOList;
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        LambdaQueryWrapper lambdaFee = Wrappers.lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaFee.in(ConstructionBudgetEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ConstructionBudgetEntity::getReportingMonth, (Object)reportingMonth);
        this.remove((Wrapper)lambdaFee);
        List<Object> profitIncomeVOList = new ArrayList();
        profitIncomeVOList = CollectionUtils.isNotEmpty(projectIdList) ? this.profitIncomeMapper.getProjects(projectIdList, 2) : this.profitIncomeMapper.getProjects(null, 2);
        CommonResponse plProject = this.defdocApi.getDefDocByDefCode("pl_project");
        if (!plProject.isSuccess()) {
            throw new BusinessException("\u6839\u636e\u6863\u6848\u7f16\u7801\u67e5\u8be2\u6863\u6848\u9879\u5931\u8d25!");
        }
        List defdocDetailVOList = (List)plProject.getData();
        Map<Object, Object> nameMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)defdocDetailVOList)) {
            nameMap = defdocDetailVOList.stream().collect(Collectors.groupingBy(s -> s.getName()));
        }
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            HashMap finalNameMap = nameMap;
            profitIncomeVOList = profitIncomeVOList.stream().filter(s -> !finalNameMap.containsKey(s.getProjectName())).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(profitIncomeVOList) && CollectionUtils.isNotEmpty((Collection)(constructionBudgetVOList = BeanMapper.mapList(profitIncomeVOList, ConstructionBudgetVO.class)))) {
            List<Object> constructionBudgetVOS = new ArrayList();
            List<Object> conDrawList = new ArrayList();
            if (CollectionUtils.isNotEmpty(projectIdList)) {
                constructionBudgetVOS = this.constructionBudgetMapper.getContract(projectIdList);
                conDrawList = this.constructionBudgetMapper.getDraw(projectIdList);
            } else {
                List<Long> idList = constructionBudgetVOList.stream().map(ConstructionBudgetVO::getProjectId).collect(Collectors.toList());
                constructionBudgetVOS = this.constructionBudgetMapper.getContract(idList);
                conDrawList = this.constructionBudgetMapper.getDraw(idList);
            }
            for (ConstructionBudgetVO constructionBudgetVO : constructionBudgetVOList) {
                String innerCode;
                String[] strs;
                CommonResponse orgVos;
                CommonResponse orgVo;
                Map conDrawMap;
                ConstructionBudgetVO constructionBudgetVO1;
                Map constructionBudgetMap;
                constructionBudgetVO.setReportingMonth(reportingMonth);
                if (CollectionUtils.isNotEmpty(constructionBudgetVOS) && (constructionBudgetMap = constructionBudgetVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2))).containsKey(constructionBudgetVO.getProjectId())) {
                    constructionBudgetVO1 = (ConstructionBudgetVO)((Object)constructionBudgetMap.get(constructionBudgetVO.getProjectId()));
                    constructionBudgetVO.setSignContract(ComputeUtil.safeAdd((BigDecimal)CommonUtils.parseNullValue(constructionBudgetVO1.getContractAmount()), (BigDecimal)CommonUtils.parseNullValue(constructionBudgetVO1.getChangeAmount())));
                    constructionBudgetVO.setOneselfContract(CommonUtils.parseNullValue(constructionBudgetVO1.getSelfConstructionContractAmount()));
                }
                if (CollectionUtils.isNotEmpty(conDrawList) && (conDrawMap = conDrawList.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2))).containsKey(constructionBudgetVO.getProjectId())) {
                    constructionBudgetVO1 = (ConstructionBudgetVO)((Object)conDrawMap.get(constructionBudgetVO.getProjectId()));
                    constructionBudgetVO.setBudgetLimit(CommonUtils.parseNullValue(constructionBudgetVO1.getBudgetMny()));
                }
                if (!(orgVo = this.orgApi.detailById(constructionBudgetVO.getProjectDepartmentId())).isSuccess() || null == orgVo.getData() || !(orgVos = this.orgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() || null == orgVos.getData()) continue;
                constructionBudgetVO.setTwoOrgId(((OrgVO)orgVos.getData()).getId());
                constructionBudgetVO.setTwoOrgName(((OrgVO)orgVos.getData()).getShortName());
                constructionBudgetVO.setTwoOrgCode(((OrgVO)orgVos.getData()).getCode());
                constructionBudgetVO.setOrgStatusOrder(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence());
            }
            this.saveBatch(BeanMapper.mapList((Iterable)constructionBudgetVOList, ConstructionBudgetEntity.class));
        }
    }

    @Override
    public List<ConstructionBudgetVO> dealData(List<ConstructionBudgetVO> constructionBudgetVOList) {
        for (ConstructionBudgetVO paymentVONum : constructionBudgetVOList) {
            paymentVONum.setSignContract(CommonUtils.parseYuanToWan(paymentVONum.getSignContract()));
            paymentVONum.setOneselfContract(CommonUtils.parseYuanToWan(paymentVONum.getOneselfContract()));
            paymentVONum.setBudgetLimit(CommonUtils.parseYuanToWan(paymentVONum.getBudgetLimit()));
        }
        ConstructionBudgetVO constructionBudgetVO = new ConstructionBudgetVO();
        ArrayList<ConstructionBudgetVO> conNewList = new ArrayList<ConstructionBudgetVO>();
        if (CollectionUtils.isNotEmpty(constructionBudgetVOList)) {
            this.getSumData(constructionBudgetVOList, constructionBudgetVO);
            constructionBudgetVO.setNumber("\u5408\u8ba1");
            constructionBudgetVO.setId(IdWorker.getId());
            conNewList.add(constructionBudgetVO);
            for (ConstructionBudgetVO constructionBudgetVO1 : constructionBudgetVOList) {
                constructionBudgetVO1.setProjectStatusOrder(CommonUtils.getProjectOrderNum(constructionBudgetVO1.getProjectStatus() == null ? 6 : constructionBudgetVO1.getProjectStatus()));
            }
            constructionBudgetVOList = constructionBudgetVOList.stream().sorted(Comparator.comparing(ConstructionBudgetVO::getProjectStatusOrder)).collect(Collectors.toList());
            Map<Integer, List<ConstructionBudgetVO>> mapProjectStatusOrder = constructionBudgetVOList.stream().collect(Collectors.groupingBy(s -> s.getProjectStatusOrder()));
            mapProjectStatusOrder.forEach((projectStatusKey, projectStatusList) -> {
                ConstructionBudgetVO constructionBudgetVO1 = new ConstructionBudgetVO();
                constructionBudgetVO1.setNumber("\u9879\u76ee\u72b6\u6001\u5408\u8ba1");
                constructionBudgetVO1.setId(IdWorker.getId());
                constructionBudgetVO1.setProjectStatusName(CommonUtils.getProjectStatusNameProject(projectStatusKey));
                this.getSumData((List<ConstructionBudgetVO>)projectStatusList, constructionBudgetVO1);
                conNewList.add(constructionBudgetVO1);
                projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(ConstructionBudgetVO::getOrgStatusOrder)).collect(Collectors.toList());
                Map<Integer, List<ConstructionBudgetVO>> mapOrgStatusOrder = projectStatusList.stream().collect(Collectors.groupingBy(s -> s.getOrgStatusOrder()));
                mapOrgStatusOrder.forEach((orgStatusKey, orgStatusList) -> {
                    ConstructionBudgetVO orgStatusSumpayVO = new ConstructionBudgetVO();
                    orgStatusSumpayVO.setNumber("\u5355\u4f4d\u5c0f\u8ba1");
                    orgStatusSumpayVO.setId(IdWorker.getId());
                    orgStatusSumpayVO.setProjectStatusName(CommonUtils.getProjectStatusName(((ConstructionBudgetVO)((Object)((Object)((Object)orgStatusList.stream().findFirst().get())))).getProjectStatus()));
                    orgStatusSumpayVO.setTwoOrgName(((ConstructionBudgetVO)((Object)((Object)((Object)orgStatusList.stream().findFirst().get())))).getTwoOrgName());
                    this.getSumData((List<ConstructionBudgetVO>)orgStatusList, orgStatusSumpayVO);
                    conNewList.add(orgStatusSumpayVO);
                    Integer number = 1;
                    orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ConstructionBudgetVO::getProjectCreateTime)).collect(Collectors.toList());
                    for (ConstructionBudgetVO paymentVONum : orgStatusList) {
                        paymentVONum.setNumber(number + "");
                        number = number + 1;
                        paymentVONum.setProjectStatusName(CommonUtils.getProjectStatusName(paymentVONum.getProjectStatus()));
                    }
                    conNewList.addAll((Collection<ConstructionBudgetVO>)orgStatusList);
                });
            });
        }
        return conNewList;
    }

    private void getSumData(List<ConstructionBudgetVO> constructionBudgetVOList, ConstructionBudgetVO constructionBudgetVO) {
        BigDecimal signContract = constructionBudgetVOList.stream().filter(s -> s.getSignContract() != null).map(ConstructionBudgetVO::getSignContract).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal oneselfContract = constructionBudgetVOList.stream().filter(s -> s.getOneselfContract() != null).map(ConstructionBudgetVO::getOneselfContract).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal budgetLimit = constructionBudgetVOList.stream().filter(s -> s.getBudgetLimit() != null).map(ConstructionBudgetVO::getBudgetLimit).reduce(BigDecimal.ZERO, BigDecimal::add);
        constructionBudgetVO.setSignContract(signContract);
        constructionBudgetVO.setOneselfContract(oneselfContract);
        constructionBudgetVO.setBudgetLimit(budgetLimit);
    }
}

