/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.ProjectCheckEntity;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.mapper.ProjectCheckMapper;
import com.ejianc.business.analysis.service.IProjectCheckService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.ProjectCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectCheckService")
public class ProjectCheckServiceImpl
extends BaseServiceImpl<ProjectCheckMapper, ProjectCheckEntity>
implements IProjectCheckService {
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;
    @Autowired
    private ProjectCheckMapper projectCheckMapper;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IDefdocApi defdocApi;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        LambdaQueryWrapper lambdaFee = Wrappers.lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaFee.in(ProjectCheckEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ProjectCheckEntity::getReportingMonth, (Object)reportingMonth);
        this.remove((Wrapper)lambdaFee);
        List<Object> profitIncomeVOList = new ArrayList();
        profitIncomeVOList = CollectionUtils.isNotEmpty(projectIdList) ? this.profitIncomeMapper.getProjects(projectIdList, 1) : this.profitIncomeMapper.getProjects(null, 1);
        CommonResponse plProject = this.defdocApi.getDefDocByDefCode("pl_project");
        if (!plProject.isSuccess()) {
            throw new BusinessException("\u6839\u636e\u6863\u6848\u7f16\u7801\u67e5\u8be2\u6863\u6848\u9879\u5931\u8d25!");
        }
        List defdocDetailVOList = (List)plProject.getData();
        Map<Object, Object> nameMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)defdocDetailVOList)) {
            nameMap = defdocDetailVOList.stream().collect(Collectors.groupingBy(s -> s.getName()));
        }
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            HashMap finalNameMap = nameMap;
            profitIncomeVOList = profitIncomeVOList.stream().filter(s -> !finalNameMap.containsKey(s.getProjectName())).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            List projectCheckVOList = BeanMapper.mapList(profitIncomeVOList, ProjectCheckVO.class);
            List<ProjectCheckVO> pcList = this.projectCheckMapper.quertOptimization(projectIdList);
            List<ProjectCheckVO> rewardList = this.projectCheckMapper.quertReward(projectIdList);
            List<ProjectCheckVO> assessList = this.projectCheckMapper.quertAssess(projectIdList);
            List<ProjectCheckVO> approvalList = this.projectCheckMapper.quertApproval(projectIdList);
            List<ProjectCheckVO> nodeGrantList = this.projectCheckMapper.quertNodeGrant(projectIdList);
            List<ProjectCheckVO> finishApproveList = this.projectCheckMapper.quertFinishApprove(projectIdList);
            List<ProjectCheckVO> finishOutList = this.projectCheckMapper.quertFinishOut(projectIdList);
            List<ProjectCheckVO> finishRefundList = this.projectCheckMapper.quertFinishRefund(projectIdList);
            List<ProjectCheckVO> generalApprovalList = this.projectCheckMapper.quertGeneralApproval(projectIdList);
            for (ProjectCheckVO projectCheckVO : projectCheckVOList) {
                String innerCode;
                String[] strs;
                CommonResponse orgVos;
                CommonResponse orgVo;
                Map<Long, List<ProjectCheckVO>> generalApprovalListMap;
                Map<Long, List<ProjectCheckVO>> finishRefundListMap;
                Map<Long, List<ProjectCheckVO>> finishOutListMap;
                Map<Long, List<ProjectCheckVO>> finishApproveListMap;
                BigDecimal actualMny;
                Map<Long, List<ProjectCheckVO>> nodeGrantListMap;
                BigDecimal chairmanCashMny;
                Map<Long, List<ProjectCheckVO>> assessListMap;
                Map<Long, List<ProjectCheckVO>> rewardListMap;
                List<ProjectCheckVO> projectNumList;
                Map<Long, List<ProjectCheckVO>> pcListMap;
                projectCheckVO.setReportingMonth(reportingMonth);
                if (CollectionUtils.isNotEmpty(pcList) && (pcListMap = pcList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()))).containsKey(projectCheckVO.getProjectId())) {
                    projectNumList = pcListMap.get(projectCheckVO.getProjectId());
                    BigDecimal benefitMny = projectNumList.stream().filter(s -> s.getBenefitMny() != null).map(ProjectCheckVO::getBenefitMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    projectCheckVO.setPredictEarnings(benefitMny);
                    projectCheckVO.setProjectApprovalNumber(projectNumList.size());
                }
                if (CollectionUtils.isNotEmpty(rewardList) && (rewardListMap = rewardList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()))).containsKey(projectCheckVO.getProjectId())) {
                    projectNumList = rewardListMap.get(projectCheckVO.getProjectId());
                    BigDecimal benefitMny2 = projectNumList.stream().filter(s -> s.getBenefitMny2() != null).map(ProjectCheckVO::getBenefitMny2).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal chairmanCashMny2 = projectNumList.stream().filter(s -> s.getChairmanCashMny() != null).map(ProjectCheckVO::getChairmanCashMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    projectCheckVO.setAlreadyEmbodiment(projectNumList.size());
                    projectCheckVO.setNetEarning(benefitMny2);
                    projectCheckVO.setCashingMoney(chairmanCashMny2);
                }
                if (CollectionUtils.isNotEmpty(assessList) && (assessListMap = assessList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()))).containsKey(projectCheckVO.getProjectId())) {
                    projectNumList = assessListMap.get(projectCheckVO.getProjectId());
                    projectCheckVO.setCourseAssess(projectNumList.size());
                }
                if (CollectionUtils.isNotEmpty(approvalList) && (assessListMap = approvalList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()))).containsKey(projectCheckVO.getProjectId())) {
                    projectNumList = assessListMap.get(projectCheckVO.getProjectId());
                    chairmanCashMny = projectNumList.stream().filter(s -> s.getChairmanCashMny() != null).map(ProjectCheckVO::getChairmanCashMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    projectCheckVO.setCourseAssessMoney(chairmanCashMny);
                }
                if (CollectionUtils.isNotEmpty(nodeGrantList) && (nodeGrantListMap = nodeGrantList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()))).containsKey(projectCheckVO.getProjectId())) {
                    projectNumList = nodeGrantListMap.get(projectCheckVO.getProjectId());
                    actualMny = projectNumList.stream().filter(s -> s.getActualMny() != null).map(ProjectCheckVO::getActualMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    projectCheckVO.setPracticalCourseAssessMoney(actualMny);
                }
                if (CollectionUtils.isNotEmpty(finishApproveList) && (finishApproveListMap = finishApproveList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()))).containsKey(projectCheckVO.getProjectId())) {
                    projectNumList = finishApproveListMap.get(projectCheckVO.getProjectId());
                    chairmanCashMny = projectNumList.stream().filter(s -> s.getChairmanCashMny() != null).map(ProjectCheckVO::getChairmanCashMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    projectCheckVO.setCompletedAssessMoney(chairmanCashMny);
                }
                if (CollectionUtils.isNotEmpty(finishOutList) && (finishOutListMap = finishOutList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()))).containsKey(projectCheckVO.getProjectId())) {
                    projectNumList = finishOutListMap.get(projectCheckVO.getProjectId());
                    actualMny = projectNumList.stream().filter(s -> s.getActualMny() != null).map(ProjectCheckVO::getActualMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    projectCheckVO.setRealityMoney(actualMny);
                }
                if (CollectionUtils.isNotEmpty(finishRefundList) && (finishRefundListMap = finishRefundList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()))).containsKey(projectCheckVO.getProjectId())) {
                    projectNumList = finishRefundListMap.get(projectCheckVO.getProjectId());
                    BigDecimal reservedMoney = projectNumList.stream().filter(s -> s.getDepartmentApplyMny() != null).map(ProjectCheckVO::getDepartmentApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal chairmanActualMny = projectNumList.stream().filter(s -> s.getChairmanActualMny() != null).map(ProjectCheckVO::getChairmanActualMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    projectCheckVO.setReservedMoney(reservedMoney);
                    projectCheckVO.setReservedMoneyReturn(chairmanActualMny);
                }
                if (CollectionUtils.isNotEmpty(generalApprovalList) && (generalApprovalListMap = generalApprovalList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()))).containsKey(projectCheckVO.getProjectId())) {
                    projectNumList = generalApprovalListMap.get(projectCheckVO.getProjectId());
                    chairmanCashMny = projectNumList.stream().filter(s -> s.getChairmanCashMny() != null).map(ProjectCheckVO::getChairmanCashMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                    projectCheckVO.setStatementAssessMoney(chairmanCashMny);
                }
                if (!(orgVo = this.orgApi.detailById(projectCheckVO.getProjectDepartmentId())).isSuccess() || null == orgVo.getData() || !(orgVos = this.orgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() || null == orgVos.getData()) continue;
                projectCheckVO.setTwoOrgId(((OrgVO)orgVos.getData()).getId());
                projectCheckVO.setTwoOrgName(((OrgVO)orgVos.getData()).getShortName());
                projectCheckVO.setTwoOrgCode(((OrgVO)orgVos.getData()).getCode());
                projectCheckVO.setOrgStatusOrder(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence());
            }
            this.saveBatch(BeanMapper.mapList((Iterable)projectCheckVOList, ProjectCheckEntity.class));
        }
    }

    @Override
    public List<ProjectCheckVO> dealData(List<ProjectCheckVO> projectCheckVOList) {
        for (ProjectCheckVO paymentVONum : projectCheckVOList) {
            paymentVONum.setPredictEarnings(CommonUtils.parseYuanToWan(paymentVONum.getPredictEarnings()));
            paymentVONum.setNetEarning(CommonUtils.parseYuanToWan(paymentVONum.getNetEarning()));
            paymentVONum.setCashingMoney(CommonUtils.parseYuanToWan(paymentVONum.getCashingMoney()));
            paymentVONum.setCourseAssessMoney(CommonUtils.parseYuanToWan(paymentVONum.getCourseAssessMoney()));
            paymentVONum.setPracticalCourseAssessMoney(CommonUtils.parseYuanToWan(paymentVONum.getPracticalCourseAssessMoney()));
            paymentVONum.setCompletedAssessMoney(CommonUtils.parseYuanToWan(paymentVONum.getCompletedAssessMoney()));
            paymentVONum.setRealityMoney(CommonUtils.parseYuanToWan(paymentVONum.getRealityMoney()));
            paymentVONum.setReservedMoney(CommonUtils.parseYuanToWan(paymentVONum.getReservedMoney()));
            paymentVONum.setReservedMoneyReturn(CommonUtils.parseYuanToWan(paymentVONum.getReservedMoneyReturn()));
            paymentVONum.setStatementAssessMoney(CommonUtils.parseYuanToWan(paymentVONum.getStatementAssessMoney()));
        }
        ProjectCheckVO projectCheckVO = new ProjectCheckVO();
        ArrayList<ProjectCheckVO> conNewList = new ArrayList<ProjectCheckVO>();
        if (CollectionUtils.isNotEmpty(projectCheckVOList)) {
            this.getSumData(projectCheckVOList, projectCheckVO);
            projectCheckVO.setNumber("\u5408\u8ba1");
            projectCheckVO.setId(IdWorker.getId());
            conNewList.add(projectCheckVO);
            for (ProjectCheckVO projectCheckVO1 : projectCheckVOList) {
                projectCheckVO1.setProjectStatusOrder(CommonUtils.getProjectOrderNum(projectCheckVO1.getProjectStatus() == null ? 6 : projectCheckVO1.getProjectStatus()));
            }
            projectCheckVOList = projectCheckVOList.stream().sorted(Comparator.comparing(ProjectCheckVO::getProjectStatusOrder)).collect(Collectors.toList());
            Map<Integer, List<ProjectCheckVO>> mapProjectStatusOrder = projectCheckVOList.stream().collect(Collectors.groupingBy(s -> s.getProjectStatusOrder()));
            mapProjectStatusOrder.forEach((projectStatusKey, projectStatusList) -> {
                ProjectCheckVO projectCheckVO1 = new ProjectCheckVO();
                projectCheckVO1.setNumber("\u9879\u76ee\u72b6\u6001\u5408\u8ba1");
                projectCheckVO1.setId(IdWorker.getId());
                projectCheckVO1.setProjectStatusName(CommonUtils.getProjectStatusNameProject(projectStatusKey));
                this.getSumData((List<ProjectCheckVO>)projectStatusList, projectCheckVO1);
                conNewList.add(projectCheckVO1);
                projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(ProjectCheckVO::getOrgStatusOrder)).collect(Collectors.toList());
                Map<Integer, List<ProjectCheckVO>> mapOrgStatusOrder = projectStatusList.stream().collect(Collectors.groupingBy(s -> s.getOrgStatusOrder()));
                mapOrgStatusOrder.forEach((orgStatusKey, orgStatusList) -> {
                    ProjectCheckVO orgStatusSumpayVO = new ProjectCheckVO();
                    orgStatusSumpayVO.setNumber("\u5355\u4f4d\u5c0f\u8ba1");
                    orgStatusSumpayVO.setId(IdWorker.getId());
                    orgStatusSumpayVO.setProjectStatusName(CommonUtils.getProjectStatusName(((ProjectCheckVO)((Object)((Object)((Object)orgStatusList.stream().findFirst().get())))).getProjectStatus()));
                    orgStatusSumpayVO.setTwoOrgName(((ProjectCheckVO)((Object)((Object)((Object)orgStatusList.stream().findFirst().get())))).getTwoOrgName());
                    this.getSumData((List<ProjectCheckVO>)orgStatusList, orgStatusSumpayVO);
                    conNewList.add(orgStatusSumpayVO);
                    Integer number = 1;
                    orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ProjectCheckVO::getProjectCreateTime)).collect(Collectors.toList());
                    for (ProjectCheckVO paymentVONum : orgStatusList) {
                        paymentVONum.setNumber(number + "");
                        number = number + 1;
                        paymentVONum.setProjectStatusName(CommonUtils.getProjectStatusName(paymentVONum.getProjectStatus()));
                        paymentVONum.setProjectApprovalNumber(CommonUtils.isIntNull(paymentVONum.getProjectApprovalNumber()));
                        paymentVONum.setAlreadyEmbodiment(CommonUtils.isIntNull(paymentVONum.getAlreadyEmbodiment()));
                        paymentVONum.setCourseAssess(CommonUtils.isIntNull(paymentVONum.getCourseAssess()));
                    }
                    conNewList.addAll((Collection<ProjectCheckVO>)orgStatusList);
                });
            });
        }
        return conNewList;
    }

    private void getSumData(List<ProjectCheckVO> projectCheckVOList, ProjectCheckVO projectCheckVO) {
        Integer projectApprovalNumber = projectCheckVOList.stream().filter(s -> s.getProjectApprovalNumber() != null).map(ProjectCheckVO::getProjectApprovalNumber).reduce(0, Integer::sum);
        BigDecimal predictEarnings = projectCheckVOList.stream().filter(s -> s.getPredictEarnings() != null).map(ProjectCheckVO::getPredictEarnings).reduce(BigDecimal.ZERO, BigDecimal::add);
        Integer alreadyEmbodiment = projectCheckVOList.stream().filter(s -> s.getAlreadyEmbodiment() != null).map(ProjectCheckVO::getAlreadyEmbodiment).reduce(0, Integer::sum);
        BigDecimal netEarning = projectCheckVOList.stream().filter(s -> s.getNetEarning() != null).map(ProjectCheckVO::getNetEarning).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal cashingMoney = projectCheckVOList.stream().filter(s -> s.getCashingMoney() != null).map(ProjectCheckVO::getCashingMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        Integer courseAssess = projectCheckVOList.stream().filter(s -> s.getCourseAssess() != null).map(ProjectCheckVO::getCourseAssess).reduce(0, Integer::sum);
        BigDecimal courseAssessMoney = projectCheckVOList.stream().filter(s -> s.getCourseAssessMoney() != null).map(ProjectCheckVO::getCourseAssessMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal practicalCourseAssessMoney = projectCheckVOList.stream().filter(s -> s.getPracticalCourseAssessMoney() != null).map(ProjectCheckVO::getPracticalCourseAssessMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal completedAssessMoney = projectCheckVOList.stream().filter(s -> s.getCompletedAssessMoney() != null).map(ProjectCheckVO::getCompletedAssessMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal realityMoney = projectCheckVOList.stream().filter(s -> s.getRealityMoney() != null).map(ProjectCheckVO::getRealityMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal reservedMoney = projectCheckVOList.stream().filter(s -> s.getReservedMoney() != null).map(ProjectCheckVO::getReservedMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal reservedMoneyReturn = projectCheckVOList.stream().filter(s -> s.getReservedMoneyReturn() != null).map(ProjectCheckVO::getReservedMoneyReturn).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal statementAssessMoney = projectCheckVOList.stream().filter(s -> s.getStatementAssessMoney() != null).map(ProjectCheckVO::getStatementAssessMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        projectCheckVO.setProjectApprovalNumber(projectApprovalNumber);
        projectCheckVO.setPredictEarnings(predictEarnings);
        projectCheckVO.setAlreadyEmbodiment(alreadyEmbodiment);
        projectCheckVO.setNetEarning(netEarning);
        projectCheckVO.setCashingMoney(cashingMoney);
        projectCheckVO.setCourseAssess(courseAssess);
        projectCheckVO.setCourseAssessMoney(courseAssessMoney);
        projectCheckVO.setPracticalCourseAssessMoney(practicalCourseAssessMoney);
        projectCheckVO.setCompletedAssessMoney(completedAssessMoney);
        projectCheckVO.setRealityMoney(realityMoney);
        projectCheckVO.setReservedMoney(reservedMoney);
        projectCheckVO.setReservedMoneyReturn(reservedMoneyReturn);
        projectCheckVO.setStatementAssessMoney(statementAssessMoney);
    }
}

