/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.ProjectPaymentEntity;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.mapper.ProjectPaymentMapper;
import com.ejianc.business.analysis.service.IProjectPaymentService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.ProjectPaymentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectPaymentService")
public class ProjectPaymentServiceImpl
extends BaseServiceImpl<ProjectPaymentMapper, ProjectPaymentEntity>
implements IProjectPaymentService {
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;
    @Autowired
    private ProjectPaymentMapper projectPaymentMapper;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        LambdaQueryWrapper lambdaFee = Wrappers.lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaFee.in(ProjectPaymentEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ProjectPaymentEntity::getReportingMonth, (Object)reportingMonth);
        this.remove((Wrapper)lambdaFee);
        List<Object> profitIncomeVOList = new ArrayList();
        profitIncomeVOList = CollectionUtils.isNotEmpty(projectIdList) ? this.profitIncomeMapper.getProjects(projectIdList, 1) : this.profitIncomeMapper.getProjects(null, 1);
        CommonResponse plProject = this.defdocApi.getDefDocByDefCode("pl_project");
        if (!plProject.isSuccess()) {
            throw new BusinessException("\u6839\u636e\u6863\u6848\u7f16\u7801\u67e5\u8be2\u6863\u6848\u9879\u5931\u8d25!");
        }
        List defdocDetailVOList = (List)plProject.getData();
        Map<Object, Object> nameMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)defdocDetailVOList)) {
            nameMap = defdocDetailVOList.stream().collect(Collectors.groupingBy(s -> s.getName()));
        }
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            HashMap finalNameMap = nameMap;
            profitIncomeVOList = profitIncomeVOList.stream().filter(s -> !finalNameMap.containsKey(s.getProjectName())).collect(Collectors.toList());
        }
        String yearMonth = CommonUtils.getSysYearAndFirstMonth();
        List<ProjectPaymentVO> enginnerList = this.projectPaymentMapper.quertEngineermeasurement(yearMonth, reportingMonth, projectIdList);
        List<ProjectPaymentVO> enginnerTotalList = this.projectPaymentMapper.quertEngineermeasurementTotal(reportingMonth, projectIdList);
        List<ProjectPaymentVO> costanalysisList = this.projectPaymentMapper.quertCostanalysis(yearMonth, reportingMonth, projectIdList);
        List<ProjectPaymentVO> costanalysisTotalList = this.projectPaymentMapper.quertCostanalysisTotal(reportingMonth, projectIdList);
        Map<Object, Object> costanalysisTotalListMap = new HashMap();
        if (CollectionUtils.isNotEmpty(costanalysisTotalList)) {
            costanalysisTotalListMap = costanalysisTotalList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        List<ProjectPaymentVO> quertPaymentTotalList = this.projectPaymentMapper.quertPaymentTotal(reportingMonth, projectIdList);
        Map<Object, Object> quertPaymentTotalListMap = new HashMap();
        if (CollectionUtils.isNotEmpty(quertPaymentTotalList)) {
            quertPaymentTotalListMap = quertPaymentTotalList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        List<ProjectPaymentVO> quertAnalysisList = this.projectPaymentMapper.quertAnalysis(reportingMonth, projectIdList);
        Map<Object, Object> mxMap = new HashMap();
        if (CollectionUtils.isNotEmpty(quertAnalysisList)) {
            ArrayList projectPaymentVOList1 = new ArrayList();
            Map<Long, List<ProjectPaymentVO>> quertAnalysisListGrBy = quertAnalysisList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
            quertAnalysisListGrBy.forEach((orgStatusKey, orgStatusList) -> {
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ProjectPaymentVO::getReportingMonth).reversed()).collect(Collectors.toList());
                projectPaymentVOList1.add(orgStatusList.stream().findFirst().get());
            });
            ArrayList<Long> idList = new ArrayList<Long>();
            for (ProjectPaymentVO paymentVO2 : projectPaymentVOList1) {
                idList.add(paymentVO2.getAnalysisId());
            }
            if (CollectionUtils.isNotEmpty(idList)) {
                List<ProjectPaymentVO> quertCosthuizongList = this.projectPaymentMapper.quertCosthuizong(idList);
                if (CollectionUtils.isNotEmpty(quertCosthuizongList)) {
                    Map<Long, List<ProjectPaymentVO>> quertCosthuizongListMap = quertCosthuizongList.stream().collect(Collectors.groupingBy(s -> s.getAnalysisId()));
                    for (ProjectPaymentVO paymentVO : projectPaymentVOList1) {
                        if (!quertCosthuizongListMap.containsKey(paymentVO.getAnalysisId())) continue;
                        List<ProjectPaymentVO> projectPaymentVOList = quertCosthuizongListMap.get(paymentVO.getAnalysisId());
                        BigDecimal acostActual = projectPaymentVOList.stream().filter(s -> s.getAcostActual() != null).map(ProjectPaymentVO::getAcostActual).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal havePaidTotal = projectPaymentVOList.stream().filter(s -> s.getHavePaidTotal() != null).map(ProjectPaymentVO::getHavePaidTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
                        paymentVO.setHavePaidTotal(havePaidTotal);
                        paymentVO.setAcostActual(acostActual);
                    }
                }
                if (CollectionUtils.isNotEmpty(projectPaymentVOList1)) {
                    mxMap = projectPaymentVOList1.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
                }
            }
        }
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            List projectPaymentVOList = BeanMapper.mapList(profitIncomeVOList, ProjectPaymentVO.class);
            for (ProjectPaymentVO projectPaymentVO : projectPaymentVOList) {
                String innerCode;
                String[] strs;
                CommonResponse orgVos;
                ProjectPaymentVO paymentVO;
                List collectCompare;
                List paymentVOList;
                Map costanalysisListMap;
                Map enginnerTotalListMap;
                Map enginnerListMap;
                ProjectPaymentVO paymentVO2;
                projectPaymentVO.setReportingMonth(reportingMonth);
                if (CollectionUtils.isNotEmpty(enginnerList) && (enginnerListMap = enginnerList.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2))).containsKey(projectPaymentVO.getProjectId())) {
                    paymentVO2 = (ProjectPaymentVO)((Object)enginnerListMap.get(projectPaymentVO.getProjectId()));
                    projectPaymentVO.setOwnerAffirmProductionNear(CommonUtils.parseNullValue(paymentVO2.getOwnerAffirmProductionNear()));
                    projectPaymentVO.setContractReceiptNear(CommonUtils.parseNullValue(paymentVO2.getContractReceiptNear()));
                    projectPaymentVO.setProjectFundsNear(CommonUtils.parseNullValue(paymentVO2.getProjectFundsNear()));
                }
                if (CollectionUtils.isNotEmpty(enginnerTotalList) && (enginnerTotalListMap = enginnerTotalList.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2))).containsKey(projectPaymentVO.getProjectId())) {
                    paymentVO2 = (ProjectPaymentVO)((Object)enginnerTotalListMap.get(projectPaymentVO.getProjectId()));
                    projectPaymentVO.setOwnerAffirmProduction(CommonUtils.parseNullValue(paymentVO2.getOwnerAffirmProduction()));
                    projectPaymentVO.setContractReceipt(CommonUtils.parseNullValue(paymentVO2.getContractReceipt()));
                    projectPaymentVO.setProjectFunds(CommonUtils.parseNullValue(paymentVO2.getProjectFunds()));
                }
                if (CollectionUtils.isNotEmpty(costanalysisList) && (costanalysisListMap = costanalysisList.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2))).containsKey(projectPaymentVO.getProjectId())) {
                    paymentVO2 = (ProjectPaymentVO)((Object)costanalysisListMap.get(projectPaymentVO.getProjectId()));
                    projectPaymentVO.setActualFinishProductionNear(CommonUtils.parseNullValue(paymentVO2.getActualFinishProductionNear()));
                    projectPaymentVO.setActualCostNear(CommonUtils.parseNullValue(paymentVO2.getActualCostNear()));
                }
                if (CollectionUtils.isNotEmpty(costanalysisTotalList) && costanalysisTotalListMap.containsKey(projectPaymentVO.getProjectId())) {
                    paymentVOList = (List)costanalysisTotalListMap.get(projectPaymentVO.getProjectId());
                    collectCompare = paymentVOList.stream().sorted(Comparator.comparing(ProjectPaymentVO::getReportingMonth).reversed()).collect(Collectors.toList());
                    paymentVO = (ProjectPaymentVO)((Object)collectCompare.stream().findFirst().get());
                    projectPaymentVO.setActualFinishProduction(CommonUtils.parseNullValue(paymentVO.getActualFinishProduction()));
                    projectPaymentVO.setActualCost(CommonUtils.parseNullValue(paymentVO.getActualCost()));
                }
                if (CollectionUtils.isNotEmpty(quertPaymentTotalList) && quertPaymentTotalListMap.containsKey(projectPaymentVO.getProjectId())) {
                    paymentVOList = (List)quertPaymentTotalListMap.get(projectPaymentVO.getProjectId());
                    collectCompare = paymentVOList.stream().sorted(Comparator.comparing(ProjectPaymentVO::getReportingMonth).reversed()).collect(Collectors.toList());
                    paymentVO = (ProjectPaymentVO)((Object)collectCompare.stream().findFirst().get());
                    projectPaymentVO.setAmountPayable(CommonUtils.parseNullValue(paymentVO.getAccountsPayableTotal()));
                    projectPaymentVO.setAmountPaid(CommonUtils.parseNullValue(paymentVO.getHavePaidTotal()));
                }
                if (mxMap.containsKey(projectPaymentVO.getProjectId())) {
                    ProjectPaymentVO paymentVO3 = (ProjectPaymentVO)((Object)mxMap.get(projectPaymentVO.getProjectId()));
                    projectPaymentVO.setAmountPayable(ComputeUtil.safeAdd((BigDecimal)CommonUtils.parseNullValue(projectPaymentVO.getAmountPayable()), (BigDecimal)CommonUtils.parseNullValue(paymentVO3.getHavePaidTotal())));
                    projectPaymentVO.setAmountPaid(ComputeUtil.safeAdd((BigDecimal)CommonUtils.parseNullValue(projectPaymentVO.getAmountPaid()), (BigDecimal)CommonUtils.parseNullValue(paymentVO3.getAcostActual())));
                }
                projectPaymentVO.setAmountPayable(projectPaymentVO.getAmountPayable() == null ? BigDecimal.ZERO : projectPaymentVO.getAmountPayable());
                projectPaymentVO.setAmountPaid(projectPaymentVO.getAmountPaid() == null ? BigDecimal.ZERO : projectPaymentVO.getAmountPaid());
                CommonResponse orgVo = this.orgApi.detailById(projectPaymentVO.getProjectDepartmentId());
                if (!orgVo.isSuccess() || null == orgVo.getData() || !(orgVos = this.orgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() || null == orgVos.getData()) continue;
                projectPaymentVO.setTwoOrgId(((OrgVO)orgVos.getData()).getId());
                projectPaymentVO.setTwoOrgName(((OrgVO)orgVos.getData()).getShortName());
                projectPaymentVO.setTwoOrgCode(((OrgVO)orgVos.getData()).getCode());
                projectPaymentVO.setOrgStatusOrder(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence());
            }
            this.saveBatch(BeanMapper.mapList((Iterable)projectPaymentVOList, ProjectPaymentEntity.class));
        }
    }

    @Override
    public List<ProjectPaymentVO> dealData(List<ProjectPaymentVO> projectPaymentVOList) {
        for (ProjectPaymentVO paymentVONum : projectPaymentVOList) {
            paymentVONum.setOwnerAffirmProductionNear(CommonUtils.parseYuanToWan(paymentVONum.getOwnerAffirmProductionNear()));
            paymentVONum.setActualFinishProductionNear(CommonUtils.parseYuanToWan(paymentVONum.getActualFinishProductionNear()));
            paymentVONum.setActualCostNear(CommonUtils.parseYuanToWan(paymentVONum.getActualCostNear()));
            paymentVONum.setContractReceiptNear(CommonUtils.parseYuanToWan(paymentVONum.getContractReceiptNear()));
            paymentVONum.setProjectFundsNear(CommonUtils.parseYuanToWan(paymentVONum.getProjectFundsNear()));
            paymentVONum.setOwnerAffirmProduction(CommonUtils.parseYuanToWan(paymentVONum.getOwnerAffirmProduction()));
            paymentVONum.setActualFinishProduction(CommonUtils.parseYuanToWan(paymentVONum.getActualFinishProduction()));
            paymentVONum.setActualCost(CommonUtils.parseYuanToWan(paymentVONum.getActualCost()));
            paymentVONum.setContractReceipt(CommonUtils.parseYuanToWan(paymentVONum.getContractReceipt()));
            paymentVONum.setProjectFunds(CommonUtils.parseYuanToWan(paymentVONum.getProjectFunds()));
            paymentVONum.setAdvance(CommonUtils.parseYuanToWan(paymentVONum.getAdvance()));
            paymentVONum.setAmountPayable(CommonUtils.parseYuanToWan(paymentVONum.getAmountPayable()));
            paymentVONum.setAmountPaid(CommonUtils.parseYuanToWan(paymentVONum.getAmountPaid()));
        }
        ProjectPaymentVO projectPaymentVO = new ProjectPaymentVO();
        ArrayList<ProjectPaymentVO> proNewList = new ArrayList<ProjectPaymentVO>();
        if (CollectionUtils.isNotEmpty(projectPaymentVOList)) {
            this.getSumData(projectPaymentVOList, projectPaymentVO);
            projectPaymentVO.setNumber("\u5408\u8ba1");
            projectPaymentVO.setId(IdWorker.getId());
            proNewList.add(projectPaymentVO);
            for (ProjectPaymentVO paymentVO : projectPaymentVOList) {
                paymentVO.setProjectStatusOrder(CommonUtils.getProjectOrderNum(paymentVO.getProjectStatus() == null ? 6 : paymentVO.getProjectStatus()));
            }
            projectPaymentVOList = projectPaymentVOList.stream().sorted(Comparator.comparing(ProjectPaymentVO::getProjectStatusOrder)).collect(Collectors.toList());
            Map<Integer, List<ProjectPaymentVO>> mapProjectStatusOrder = projectPaymentVOList.stream().collect(Collectors.groupingBy(s -> s.getProjectStatusOrder()));
            mapProjectStatusOrder.forEach((projectStatusKey, projectStatusList) -> {
                ProjectPaymentVO paymentVO = new ProjectPaymentVO();
                paymentVO.setNumber("\u9879\u76ee\u72b6\u6001\u5408\u8ba1");
                paymentVO.setId(IdWorker.getId());
                paymentVO.setProjectStatusName(CommonUtils.getProjectStatusNameProject(projectStatusKey));
                this.getSumData((List<ProjectPaymentVO>)projectStatusList, paymentVO);
                proNewList.add(paymentVO);
                projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(ProjectPaymentVO::getOrgStatusOrder)).collect(Collectors.toList());
                Map<Integer, List<ProjectPaymentVO>> mapOrgStatusOrder = projectStatusList.stream().collect(Collectors.groupingBy(s -> s.getOrgStatusOrder()));
                mapOrgStatusOrder.forEach((orgStatusKey, orgStatusList) -> {
                    ProjectPaymentVO orgStatusSumpayVO = new ProjectPaymentVO();
                    orgStatusSumpayVO.setNumber("\u5355\u4f4d\u5c0f\u8ba1");
                    orgStatusSumpayVO.setId(IdWorker.getId());
                    orgStatusSumpayVO.setProjectStatusName(CommonUtils.getProjectStatusName(((ProjectPaymentVO)((Object)((Object)((Object)orgStatusList.stream().findFirst().get())))).getProjectStatus()));
                    orgStatusSumpayVO.setTwoOrgName(((ProjectPaymentVO)((Object)((Object)((Object)orgStatusList.stream().findFirst().get())))).getTwoOrgName());
                    this.getSumData((List<ProjectPaymentVO>)orgStatusList, orgStatusSumpayVO);
                    proNewList.add(orgStatusSumpayVO);
                    Integer number = 1;
                    orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ProjectPaymentVO::getProjectCreateTime)).collect(Collectors.toList());
                    for (ProjectPaymentVO paymentVONum : orgStatusList) {
                        paymentVONum.setNumber(number + "");
                        number = number + 1;
                        paymentVONum.setProjectStatusName(CommonUtils.getProjectStatusName(paymentVONum.getProjectStatus()));
                        paymentVONum.setConfirmationRateNear(CommonUtils.calculateRate(paymentVONum.getOwnerAffirmProductionNear(), paymentVONum.getActualFinishProductionNear()));
                        paymentVONum.setConfirmationRate(CommonUtils.calculateRate(paymentVONum.getOwnerAffirmProduction(), paymentVONum.getActualFinishProduction()));
                        paymentVONum.setNonPayment(ComputeUtil.safeSub((BigDecimal)paymentVONum.getContractReceipt(), (BigDecimal)paymentVONum.getProjectFunds()));
                        if (paymentVONum.getNonPayment().compareTo(BigDecimal.ZERO) < 0) {
                            paymentVONum.setNonPayment(BigDecimal.ZERO);
                        }
                        paymentVONum.setNearTotal(CommonUtils.calculateRate(paymentVONum.getProjectFundsNear(), paymentVONum.getOwnerAffirmProductionNear()));
                        paymentVONum.setNearAccumulated(CommonUtils.calculateRate(paymentVONum.getProjectFunds(), paymentVONum.getOwnerAffirmProduction()));
                        paymentVONum.setContractReceiptRate(CommonUtils.calculateRate(paymentVONum.getProjectFunds(), paymentVONum.getContractReceipt()));
                        paymentVONum.setGatheringProject(ComputeUtil.safeSub((BigDecimal)paymentVONum.getProjectFunds(), (BigDecimal)paymentVONum.getAdvance()));
                        paymentVONum.setCostRate(CommonUtils.calculateRate(paymentVONum.getGatheringProject(), paymentVONum.getActualCost()));
                        paymentVONum.setAccountPayable(ComputeUtil.safeSub((BigDecimal)paymentVONum.getAmountPayable(), (BigDecimal)paymentVONum.getAmountPaid()));
                        paymentVONum.setCostToRate(CommonUtils.calculateRate(paymentVONum.getAmountPaid(), paymentVONum.getActualCost()));
                    }
                    proNewList.addAll((Collection<ProjectPaymentVO>)orgStatusList);
                });
            });
        }
        return proNewList;
    }

    private void getSumData(List<ProjectPaymentVO> projectPaymentVOList, ProjectPaymentVO projectPaymentVO) {
        BigDecimal ownerAffirmProductionNear = projectPaymentVOList.stream().filter(s -> s.getOwnerAffirmProductionNear() != null).map(ProjectPaymentVO::getOwnerAffirmProductionNear).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualFinishProductionNear = projectPaymentVOList.stream().filter(s -> s.getActualFinishProductionNear() != null).map(ProjectPaymentVO::getActualFinishProductionNear).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualCostNear = projectPaymentVOList.stream().filter(s -> s.getActualCostNear() != null).map(ProjectPaymentVO::getActualCostNear).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal contractReceiptNear = projectPaymentVOList.stream().filter(s -> s.getContractReceiptNear() != null).map(ProjectPaymentVO::getContractReceiptNear).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal projectFundsNear = projectPaymentVOList.stream().filter(s -> s.getProjectFundsNear() != null).map(ProjectPaymentVO::getProjectFundsNear).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal ownerAffirmProduction = projectPaymentVOList.stream().filter(s -> s.getOwnerAffirmProduction() != null).map(ProjectPaymentVO::getOwnerAffirmProduction).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualFinishProduction = projectPaymentVOList.stream().filter(s -> s.getActualFinishProduction() != null).map(ProjectPaymentVO::getActualFinishProduction).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualCost = projectPaymentVOList.stream().filter(s -> s.getActualCost() != null).map(ProjectPaymentVO::getActualCost).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal contractReceipt = projectPaymentVOList.stream().filter(s -> s.getContractReceipt() != null).map(ProjectPaymentVO::getContractReceipt).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal projectFunds = projectPaymentVOList.stream().filter(s -> s.getProjectFunds() != null).map(ProjectPaymentVO::getProjectFunds).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal advance = projectPaymentVOList.stream().filter(s -> s.getAdvance() != null).map(ProjectPaymentVO::getAdvance).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amountPayable = projectPaymentVOList.stream().filter(s -> s.getAmountPayable() != null).map(ProjectPaymentVO::getAmountPayable).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amountPaid = projectPaymentVOList.stream().filter(s -> s.getAmountPaid() != null).map(ProjectPaymentVO::getAmountPaid).reduce(BigDecimal.ZERO, BigDecimal::add);
        projectPaymentVO.setOwnerAffirmProductionNear(ownerAffirmProductionNear);
        projectPaymentVO.setActualFinishProductionNear(actualFinishProductionNear);
        projectPaymentVO.setActualCostNear(actualCostNear);
        projectPaymentVO.setContractReceiptNear(contractReceiptNear);
        projectPaymentVO.setProjectFundsNear(projectFundsNear);
        projectPaymentVO.setOwnerAffirmProduction(ownerAffirmProduction);
        projectPaymentVO.setActualFinishProduction(actualFinishProduction);
        projectPaymentVO.setActualCost(actualCost);
        projectPaymentVO.setContractReceipt(contractReceipt);
        projectPaymentVO.setProjectFunds(projectFunds);
        projectPaymentVO.setAdvance(advance);
        projectPaymentVO.setAmountPayable(amountPayable);
        projectPaymentVO.setAmountPaid(amountPaid);
        projectPaymentVO.setConfirmationRateNear(CommonUtils.calculateRate(projectPaymentVO.getOwnerAffirmProductionNear(), projectPaymentVO.getActualFinishProductionNear()));
        projectPaymentVO.setConfirmationRate(CommonUtils.calculateRate(projectPaymentVO.getOwnerAffirmProduction(), projectPaymentVO.getActualFinishProduction()));
        projectPaymentVO.setNonPayment(ComputeUtil.safeSub((BigDecimal)projectPaymentVO.getContractReceipt(), (BigDecimal)projectPaymentVO.getProjectFunds()));
        if (projectPaymentVO.getNonPayment().compareTo(BigDecimal.ZERO) < 0) {
            projectPaymentVO.setNonPayment(BigDecimal.ZERO);
        }
        projectPaymentVO.setNearTotal(CommonUtils.calculateRate(projectPaymentVO.getProjectFundsNear(), projectPaymentVO.getOwnerAffirmProductionNear()));
        projectPaymentVO.setNearAccumulated(CommonUtils.calculateRate(projectPaymentVO.getProjectFunds(), projectPaymentVO.getOwnerAffirmProduction()));
        projectPaymentVO.setContractReceiptRate(CommonUtils.calculateRate(projectPaymentVO.getProjectFunds(), projectPaymentVO.getContractReceipt()));
        projectPaymentVO.setGatheringProject(ComputeUtil.safeSub((BigDecimal)projectPaymentVO.getProjectFunds(), (BigDecimal)projectPaymentVO.getAdvance()));
        projectPaymentVO.setCostRate(CommonUtils.calculateRate(projectPaymentVO.getGatheringProject(), projectPaymentVO.getActualCost()));
        projectPaymentVO.setAccountPayable(ComputeUtil.safeSub((BigDecimal)projectPaymentVO.getAmountPayable(), (BigDecimal)projectPaymentVO.getAmountPaid()));
        projectPaymentVO.setCostToRate(CommonUtils.calculateRate(projectPaymentVO.getAmountPaid(), projectPaymentVO.getActualCost()));
    }
}

