/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.ActualValueEntity;
import com.ejianc.business.analysis.mapper.ActualValueMapper;
import com.ejianc.business.analysis.mapper.ConstructionBudgetMapper;
import com.ejianc.business.analysis.mapper.ProSignReserveMapper;
import com.ejianc.business.analysis.service.IActualValueService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.ActualValueVO;
import com.ejianc.business.analysis.vo.ConstructionBudgetVO;
import com.ejianc.business.analysis.vo.ProSignReserveVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="actualValueService")
public class ActualValueServiceImpl
extends BaseServiceImpl<ActualValueMapper, ActualValueEntity>
implements IActualValueService {
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IActualValueService actualValueService;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private ActualValueMapper actualValueMapper;
    @Autowired
    private ProSignReserveMapper proSignReserveMapper;
    @Autowired
    private ConstructionBudgetMapper constructionBudgetMapper;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        LambdaQueryWrapper lambdaFee = Wrappers.lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaFee.in(ActualValueEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ActualValueEntity::getReportingMonth, (Object)reportingMonth);
        this.actualValueService.remove((Wrapper)lambdaFee);
        List<Object> actualValueVOList = new ArrayList();
        actualValueVOList = CollectionUtils.isNotEmpty(projectIdList) ? this.actualValueMapper.getProjects(projectIdList) : this.actualValueMapper.getProjects(null);
        CommonResponse plProject = this.defdocApi.getDefDocByDefCode("pl_project");
        if (!plProject.isSuccess()) {
            throw new BusinessException("\u6839\u636e\u6863\u6848\u7f16\u7801\u67e5\u8be2\u6863\u6848\u9879\u5931\u8d25!");
        }
        List defdocDetailVOList = (List)plProject.getData();
        Map<Object, Object> nameMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)defdocDetailVOList)) {
            nameMap = defdocDetailVOList.stream().collect(Collectors.groupingBy(s -> s.getName()));
        }
        if (CollectionUtils.isNotEmpty(actualValueVOList)) {
            HashMap finalNameMap = nameMap;
            actualValueVOList = actualValueVOList.stream().filter(s -> !finalNameMap.containsKey(s.getProjectName())).collect(Collectors.toList());
        }
        String startYear = CommonUtils.getSysYearAndFirstMonth();
        Calendar date = Calendar.getInstance();
        String endYear = String.valueOf(date.get(1)) + "-12";
        List<Long> projectIds = actualValueVOList.stream().map(ActualValueVO::getProjectId).collect(Collectors.toList());
        List<ActualValueVO> costanalysisYearVOS = this.actualValueMapper.queryCostanalysisYear(projectIds, startYear, endYear);
        Map<Object, Object> costanalysisYearMap = new HashMap();
        if (CollectionUtils.isNotEmpty(costanalysisYearVOS)) {
            costanalysisYearMap = costanalysisYearVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        List<ActualValueVO> costanalysisTotalVOS = this.actualValueMapper.queryCostanalysisTotal(projectIds, reportingMonth);
        Map<Object, Object> costanalysisTotalMap = new HashMap();
        if (CollectionUtils.isNotEmpty(costanalysisTotalVOS)) {
            costanalysisTotalMap = costanalysisTotalVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        List<ActualValueVO> bookVOS = this.actualValueMapper.queryBook(projectIds);
        Map<Object, Object> bookMap = new HashMap();
        if (CollectionUtils.isNotEmpty(bookVOS)) {
            bookMap = bookVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        List<ProSignReserveVO> responseCost = this.proSignReserveMapper.queryResponseCost(projectIds);
        Map<Object, Object> responseCostMap = new HashMap();
        if (CollectionUtils.isNotEmpty(bookVOS)) {
            responseCostMap = responseCost.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        List<Object> constructionBudgetVOS = new ArrayList();
        constructionBudgetVOS = this.constructionBudgetMapper.getContract(projectIdList);
        Map<Object, Object> constructionBudgetMap = new HashMap();
        if (CollectionUtils.isNotEmpty(constructionBudgetVOS)) {
            constructionBudgetMap = constructionBudgetVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        for (ActualValueVO actualValueVO : actualValueVOList) {
            String innerCode;
            String[] strs;
            CommonResponse orgVos;
            CommonResponse orgVo;
            actualValueVO.setReportingMonth(reportingMonth);
            Long projectId = actualValueVO.getProjectId();
            if (!costanalysisYearMap.isEmpty() && costanalysisYearMap.containsKey(projectId)) {
                actualValueVO.setYearActualCompleteValue(((List)costanalysisYearMap.get(projectId)).stream().filter(s -> s.getYearActualCompleteValue() != null).map(s -> s.getYearActualCompleteValue()).reduce(BigDecimal.ZERO, BigDecimal::add));
                actualValueVO.setYearResponsibilityCost(((List)costanalysisYearMap.get(projectId)).stream().map(s -> s.getYearResponsibilityCost()).reduce(BigDecimal.ZERO, BigDecimal::add));
                actualValueVO.setYearRealCost(((List)costanalysisYearMap.get(projectId)).stream().map(s -> s.getYearRealCost()).reduce(BigDecimal.ZERO, BigDecimal::add));
                actualValueVO.setYearActualProfit(ComputeUtil.safeSub((BigDecimal)actualValueVO.getYearActualCompleteValue(), (BigDecimal)actualValueVO.getYearRealCost()));
            }
            if (!costanalysisTotalMap.isEmpty() && costanalysisTotalMap.containsKey(projectId)) {
                List actualValueVOS = (List)costanalysisTotalMap.get(projectId);
                List collectCompare = actualValueVOS.stream().sorted(Comparator.comparing(ActualValueVO::getCostanalysisMonth).reversed()).collect(Collectors.toList());
                ActualValueVO actualValueVO2 = (ActualValueVO)collectCompare.stream().findFirst().get();
                actualValueVO.setAccumulateActualCompleteValue(actualValueVO2.getAccumulateActualCompleteValue());
                actualValueVO.setAccumulateResponsibilityCost(actualValueVO2.getAccumulateResponsibilityCost());
                actualValueVO.setAccumulateRealCost(actualValueVO2.getAccumulateRealCost());
            }
            if (!bookMap.isEmpty() && bookMap.containsKey(projectId)) {
                actualValueVO.setOverallProfitMargin(((ActualValueVO)bookMap.get(projectId)).getOverallProfitMargin());
            }
            if (!responseCostMap.isEmpty() && responseCostMap.containsKey(projectId)) {
                actualValueVO.setUndertakingBenefitsRate(((ProSignReserveVO)responseCostMap.get(projectId)).getUndertakingBenefitsRate());
            }
            if (constructionBudgetMap.containsKey(projectId)) {
                ConstructionBudgetVO constructionBudgetVO1 = (ConstructionBudgetVO)((Object)constructionBudgetMap.get(projectId));
                actualValueVO.setAcContractAmount(CommonUtils.parseNullValue(constructionBudgetVO1.getSelfConstructionContractAmount()));
            } else {
                actualValueVO.setAcContractAmount(BigDecimal.ZERO);
            }
            if (!(orgVo = this.orgApi.detailById(actualValueVO.getProjectDepartmentId())).isSuccess() || null == orgVo.getData() || !(orgVos = this.orgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() || null == orgVos.getData()) continue;
            actualValueVO.setTwoOrgId(((OrgVO)orgVos.getData()).getId());
            actualValueVO.setTwoOrgName(((OrgVO)orgVos.getData()).getShortName());
            actualValueVO.setTwoOrgCode(((OrgVO)orgVos.getData()).getCode());
            actualValueVO.setOrgStatusOrder(Integer.valueOf(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence()));
        }
        List actualValueEntityList = BeanMapper.mapList(actualValueVOList, ActualValueEntity.class);
        this.actualValueService.saveBatch(actualValueEntityList);
    }

    @Override
    public List<ActualValueVO> dealData(List<ActualValueVO> actualValueVOS) {
        for (ActualValueVO actualValueVO : actualValueVOS) {
            actualValueVO.setYearActualCompleteValue(CommonUtils.parseYuanToWanZ(actualValueVO.getYearActualCompleteValue()));
            actualValueVO.setYearResponsibilityCost(CommonUtils.parseYuanToWanZ(actualValueVO.getYearResponsibilityCost()));
            actualValueVO.setYearRealCost(CommonUtils.parseYuanToWanZ(actualValueVO.getYearRealCost()));
            actualValueVO.setYearActualProfit(CommonUtils.parseYuanToWanZ(actualValueVO.getYearActualProfit()));
            actualValueVO.setAccumulateActualCompleteValue(CommonUtils.parseYuanToWanZ(actualValueVO.getAccumulateActualCompleteValue()));
            actualValueVO.setAccumulateResponsibilityCost(CommonUtils.parseYuanToWanZ(actualValueVO.getAccumulateResponsibilityCost()));
            actualValueVO.setAccumulateRealCost(CommonUtils.parseYuanToWanZ(actualValueVO.getAccumulateRealCost()));
            actualValueVO.setAcContractAmount(CommonUtils.parseYuanToWanZ(actualValueVO.getAcContractAmount()));
        }
        ActualValueVO actualValueVO = new ActualValueVO();
        ArrayList<ActualValueVO> arrayList = new ArrayList<ActualValueVO>();
        if (CollectionUtils.isNotEmpty(actualValueVOS)) {
            this.getSumData(actualValueVOS, actualValueVO);
            actualValueVO.setNumber("\u5408\u8ba1");
            actualValueVO.setId(Long.valueOf(IdWorker.getId()));
            arrayList.add(actualValueVO);
        }
        for (ActualValueVO actualValueVO2 : actualValueVOS) {
            actualValueVO2.setProjectStatusOrder(CommonUtils.getProjectOrderNum(actualValueVO2.getProjectStatus().intValue()));
        }
        actualValueVOS = actualValueVOS.stream().sorted(Comparator.comparing(ActualValueVO::getProjectStatusOrder)).collect(Collectors.toList());
        Map<Integer, List<ActualValueVO>> mapProjectStatusOrder = actualValueVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectStatusOrder()));
        mapProjectStatusOrder.forEach((projectStatusKey, projectStatusList) -> {
            ActualValueVO projectStatusSumfeeVO = new ActualValueVO();
            projectStatusSumfeeVO.setNumber("\u9879\u76ee\u72b6\u6001\u5408\u8ba1");
            projectStatusSumfeeVO.setId(Long.valueOf(IdWorker.getId()));
            projectStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusNameProject(projectStatusKey));
            this.getSumData((List<ActualValueVO>)projectStatusList, projectStatusSumfeeVO);
            newList.add(projectStatusSumfeeVO);
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(ActualValueVO::getOrgStatusOrder)).collect(Collectors.toList());
            Map<Integer, List<ActualValueVO>> mapOrgStatusOrder = projectStatusList.stream().collect(Collectors.groupingBy(s -> s.getOrgStatusOrder()));
            mapOrgStatusOrder.forEach((orgStatusKey, orgStatusList) -> {
                ActualValueVO orgStatusSumfeeVO = new ActualValueVO();
                orgStatusSumfeeVO.setNumber("\u5355\u4f4d\u5c0f\u8ba1");
                orgStatusSumfeeVO.setId(Long.valueOf(IdWorker.getId()));
                orgStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(((ActualValueVO)orgStatusList.stream().findFirst().get()).getProjectStatus().intValue()));
                orgStatusSumfeeVO.setTwoOrgName(((ActualValueVO)orgStatusList.stream().findFirst().get()).getTwoOrgName());
                this.getSumData((List<ActualValueVO>)orgStatusList, orgStatusSumfeeVO);
                newList.add(orgStatusSumfeeVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ActualValueVO::getProjectCreateTime)).collect(Collectors.toList());
                for (ActualValueVO actualValueVONum : orgStatusList) {
                    actualValueVONum.setNumber(number + "");
                    number = number + 1;
                    actualValueVONum.setProjectStatusName(CommonUtils.getProjectStatusName(actualValueVONum.getProjectStatus().intValue()));
                    actualValueVONum.setYearActualCompleteValue(actualValueVONum.getYearActualCompleteValue());
                    actualValueVONum.setYearResponsibilityCost(actualValueVONum.getYearResponsibilityCost());
                    actualValueVONum.setYearRealCost(actualValueVONum.getYearRealCost());
                    actualValueVONum.setYearActualProfit(actualValueVONum.getYearActualProfit());
                    actualValueVONum.setAccumulateActualCompleteValue(actualValueVONum.getAccumulateActualCompleteValue());
                    actualValueVONum.setAccumulateResponsibilityCost(actualValueVONum.getAccumulateResponsibilityCost());
                    actualValueVONum.setAccumulateRealCost(actualValueVONum.getAccumulateRealCost());
                    actualValueVONum.setAccumulateActualProfit(ComputeUtil.safeSub((BigDecimal)actualValueVONum.getAccumulateActualCompleteValue(), (BigDecimal)actualValueVONum.getAccumulateRealCost()));
                    actualValueVONum.setYearProfitRate(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(actualValueVONum.getYearActualProfit()), CommonUtils.setBigDecimalDefaultValue(actualValueVONum.getYearActualCompleteValue())));
                    actualValueVONum.setAccumulateProfitRate(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(actualValueVONum.getAccumulateActualProfit()), CommonUtils.setBigDecimalDefaultValue(actualValueVONum.getAccumulateActualCompleteValue())));
                    actualValueVONum.setYearReduceRate(CommonUtils.calculateRate(ComputeUtil.safeSub((BigDecimal)CommonUtils.setBigDecimalDefaultValue(actualValueVONum.getYearResponsibilityCost()), (BigDecimal)CommonUtils.setBigDecimalDefaultValue(actualValueVONum.getYearRealCost())), CommonUtils.setBigDecimalDefaultValue(actualValueVONum.getYearResponsibilityCost())));
                    actualValueVONum.setAccumulateReduceRate(CommonUtils.calculateRate(ComputeUtil.safeSub((BigDecimal)CommonUtils.setBigDecimalDefaultValue(actualValueVONum.getAccumulateResponsibilityCost()), (BigDecimal)CommonUtils.setBigDecimalDefaultValue(actualValueVONum.getAccumulateRealCost())), CommonUtils.setBigDecimalDefaultValue(actualValueVONum.getAccumulateResponsibilityCost())));
                }
                newList.addAll((Collection<ActualValueVO>)orgStatusList);
            });
        });
        return arrayList;
    }

    private void getSumData(List<ActualValueVO> actualValueVOS, ActualValueVO actualValueVO) {
        actualValueVO.setYearActualCompleteValue(actualValueVOS.stream().filter(s -> s.getYearActualCompleteValue() != null).map(ActualValueVO::getYearActualCompleteValue).reduce(BigDecimal.ZERO, BigDecimal::add));
        actualValueVO.setYearResponsibilityCost(actualValueVOS.stream().filter(s -> s.getYearResponsibilityCost() != null).map(ActualValueVO::getYearResponsibilityCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        actualValueVO.setYearRealCost(actualValueVOS.stream().filter(s -> s.getYearRealCost() != null).map(ActualValueVO::getYearRealCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        actualValueVO.setYearActualProfit(actualValueVOS.stream().filter(s -> s.getYearActualProfit() != null).map(ActualValueVO::getYearActualProfit).reduce(BigDecimal.ZERO, BigDecimal::add));
        actualValueVO.setAccumulateActualCompleteValue(actualValueVOS.stream().filter(s -> s.getAccumulateActualCompleteValue() != null).map(ActualValueVO::getAccumulateActualCompleteValue).reduce(BigDecimal.ZERO, BigDecimal::add));
        actualValueVO.setAccumulateResponsibilityCost(actualValueVOS.stream().filter(s -> s.getAccumulateResponsibilityCost() != null).map(ActualValueVO::getAccumulateResponsibilityCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        actualValueVO.setAccumulateRealCost(actualValueVOS.stream().filter(s -> s.getAccumulateRealCost() != null).map(ActualValueVO::getAccumulateRealCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        actualValueVO.setAcContractAmount(actualValueVOS.stream().filter(s -> s.getAcContractAmount() != null).map(ActualValueVO::getAcContractAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        actualValueVO.setAccumulateActualProfit(ComputeUtil.safeSub((BigDecimal)actualValueVO.getAccumulateActualCompleteValue(), (BigDecimal)actualValueVO.getAccumulateRealCost()));
        actualValueVO.setYearProfitRate(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(actualValueVO.getYearActualProfit()), CommonUtils.setBigDecimalDefaultValue(actualValueVO.getYearActualCompleteValue())));
        actualValueVO.setAccumulateProfitRate(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(actualValueVO.getAccumulateActualProfit()), CommonUtils.setBigDecimalDefaultValue(actualValueVO.getAccumulateActualCompleteValue())));
        actualValueVO.setYearReduceRate(CommonUtils.calculateRate(ComputeUtil.safeSub((BigDecimal)CommonUtils.setBigDecimalDefaultValue(actualValueVO.getYearResponsibilityCost()), (BigDecimal)CommonUtils.setBigDecimalDefaultValue(actualValueVO.getYearRealCost())), CommonUtils.setBigDecimalDefaultValue(actualValueVO.getYearResponsibilityCost())));
        actualValueVO.setAccumulateReduceRate(CommonUtils.calculateRate(ComputeUtil.safeSub((BigDecimal)CommonUtils.setBigDecimalDefaultValue(actualValueVO.getAccumulateResponsibilityCost()), (BigDecimal)CommonUtils.setBigDecimalDefaultValue(actualValueVO.getAccumulateRealCost())), CommonUtils.setBigDecimalDefaultValue(actualValueVO.getAccumulateResponsibilityCost())));
        BigDecimal acContractAmount = BigDecimal.ZERO;
        BigDecimal OverallProfitMarginMny = BigDecimal.ZERO;
        for (ActualValueVO proSignReserve : actualValueVOS) {
            acContractAmount = acContractAmount.add(CommonUtils.parseNullValue(proSignReserve.getAcContractAmount()).multiply(CommonUtils.parseNullValue(proSignReserve.getUndertakingBenefitsRate()).divide(new BigDecimal(100))));
            OverallProfitMarginMny = OverallProfitMarginMny.add(CommonUtils.parseNullValue(proSignReserve.getAcContractAmount()).multiply(CommonUtils.parseNullValue(proSignReserve.getOverallProfitMargin()).divide(new BigDecimal(100))));
        }
        actualValueVO.setUndertakingBenefitsRate(CommonUtils.calculateRate(acContractAmount, actualValueVO.getAcContractAmount()));
        actualValueVO.setOverallProfitMargin(CommonUtils.calculateRate(OverallProfitMarginMny, actualValueVO.getAcContractAmount()));
    }
}

