/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.CompleteSettlementEntity;
import com.ejianc.business.analysis.mapper.CompleteSettlementMapper;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.service.ICompleteSettlementService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.CompleteSettlementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="completeSettlementService")
public class CompleteSettlementServiceImpl
extends BaseServiceImpl<CompleteSettlementMapper, CompleteSettlementEntity>
implements ICompleteSettlementService {
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;
    @Autowired
    private CompleteSettlementMapper completeSettlementMapper;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        LambdaQueryWrapper lambdaFee = Wrappers.lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaFee.in(CompleteSettlementEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(CompleteSettlementEntity::getReportingMonth, (Object)reportingMonth);
        this.remove((Wrapper)lambdaFee);
        List<Object> profitIncomeVOList = new ArrayList();
        profitIncomeVOList = CollectionUtils.isNotEmpty(projectIdList) ? this.profitIncomeMapper.getProjects(projectIdList, 1) : this.profitIncomeMapper.getProjects(null, 1);
        CommonResponse plProject = this.defdocApi.getDefDocByDefCode("pl_project");
        if (!plProject.isSuccess()) {
            throw new BusinessException("\u6839\u636e\u6863\u6848\u7f16\u7801\u67e5\u8be2\u6863\u6848\u9879\u5931\u8d25!");
        }
        List defdocDetailVOList = (List)plProject.getData();
        Map<Object, Object> nameMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)defdocDetailVOList)) {
            nameMap = defdocDetailVOList.stream().collect(Collectors.groupingBy(s -> s.getName()));
        }
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            HashMap finalNameMap = nameMap;
            profitIncomeVOList = profitIncomeVOList.stream().filter(s -> !finalNameMap.containsKey(s.getProjectName())).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            List completeSettlementVOList = BeanMapper.mapList(profitIncomeVOList, CompleteSettlementVO.class);
            Map completeSettlementVOMap = completeSettlementVOList.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
            List<CompleteSettlementVO> completeSettlementVOS = this.quertRestoremetricsanalyse(reportingMonth, projectIdList);
            List<CompleteSettlementVO> quertAnalysisList = this.quertAnalysis(reportingMonth, projectIdList);
            if (CollectionUtils.isNotEmpty(completeSettlementVOS)) {
                ArrayList completeSettlementVOSList = new ArrayList();
                Map<Long, List<CompleteSettlementVO>> completeSettlementVOSGrBy = completeSettlementVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
                completeSettlementVOSGrBy.forEach((orgStatusKey, orgStatusList) -> {
                    orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(BaseVO::getCreateTime).reversed()).collect(Collectors.toList());
                    completeSettlementVOSList.add(orgStatusList.stream().findFirst().get());
                });
                for (CompleteSettlementVO completeSettlementVO : completeSettlementVOSList) {
                    Map<Long, List<CompleteSettlementVO>> costanalysisListGrBy;
                    if (completeSettlementVOMap.containsKey(completeSettlementVO.getProjectId())) {
                        String innerCode;
                        String[] strs;
                        CommonResponse orgVos;
                        CompleteSettlementVO completeSettlementVO1 = (CompleteSettlementVO)((Object)completeSettlementVOMap.get(completeSettlementVO.getProjectId()));
                        completeSettlementVO.setReportingMonth(reportingMonth);
                        completeSettlementVO.setProjectStatus(completeSettlementVO1.getProjectStatus());
                        completeSettlementVO.setProjectDepartmentId(completeSettlementVO1.getProjectDepartmentId());
                        completeSettlementVO.setProjectCode(completeSettlementVO1.getProjectCode());
                        completeSettlementVO.setProjectCreateTime(completeSettlementVO1.getProjectCreateTime());
                        completeSettlementVO.setTenantId(completeSettlementVO1.getTenantId());
                        completeSettlementVO.setOrgId(completeSettlementVO1.getOrgId());
                        completeSettlementVO.setOrgName(completeSettlementVO1.getOrgName());
                        CommonResponse orgVo = this.orgApi.detailById(completeSettlementVO.getProjectDepartmentId());
                        if (orgVo.isSuccess() && null != orgVo.getData() && (orgVos = this.orgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() && null != orgVos.getData()) {
                            completeSettlementVO.setTwoOrgId(((OrgVO)orgVos.getData()).getId());
                            completeSettlementVO.setTwoOrgName(((OrgVO)orgVos.getData()).getShortName());
                            completeSettlementVO.setTwoOrgCode(((OrgVO)orgVos.getData()).getCode());
                            completeSettlementVO.setOrgStatusOrder(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence());
                        }
                    }
                    if (!CollectionUtils.isNotEmpty(quertAnalysisList) || !(costanalysisListGrBy = quertAnalysisList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()))).containsKey(completeSettlementVO.getProjectId())) continue;
                    List<CompleteSettlementVO> completeSettlementVO1 = costanalysisListGrBy.get(completeSettlementVO.getProjectId());
                    List collectCompare = completeSettlementVO1.stream().sorted(Comparator.comparing(CompleteSettlementVO::getReportingMonth).reversed()).collect(Collectors.toList());
                    CompleteSettlementVO completeSettlementVO2 = (CompleteSettlementVO)((Object)collectCompare.stream().findFirst().get());
                    completeSettlementVO.setTotalMoney(completeSettlementVO2.getSumPlanCost());
                    completeSettlementVO.setPerMeterCost(ComputeUtil.safeMultiply((BigDecimal)CommonUtils.setBigDecimalDefaultValue(completeSettlementVO2.getSumPlanCost()), (BigDecimal)CommonUtils.setBigDecimalDefaultValue(completeSettlementVO.getBuildArea())));
                }
                this.saveBatch(BeanMapper.mapList(completeSettlementVOS, CompleteSettlementEntity.class));
            }
        }
    }

    @Override
    public List<CompleteSettlementVO> dealData(List<CompleteSettlementVO> completeSettlementVOList) {
        ArrayList<CompleteSettlementVO> feeNewList = new ArrayList<CompleteSettlementVO>();
        for (CompleteSettlementVO completeSettlementVO : completeSettlementVOList) {
            completeSettlementVO.setProjectStatusOrder(CommonUtils.getProjectOrderNum(completeSettlementVO.getProjectStatus()));
        }
        completeSettlementVOList = completeSettlementVOList.stream().sorted(Comparator.comparing(CompleteSettlementVO::getProjectStatusOrder)).collect(Collectors.toList());
        Map<Integer, List<CompleteSettlementVO>> mapProjectStatusOrder = completeSettlementVOList.stream().collect(Collectors.groupingBy(s -> s.getProjectStatusOrder()));
        mapProjectStatusOrder.forEach((projectStatusKey, projectStatusList) -> {
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(CompleteSettlementVO::getOrgStatusOrder)).collect(Collectors.toList());
            Map<Integer, List<CompleteSettlementVO>> mapOrgStatusOrder = projectStatusList.stream().collect(Collectors.groupingBy(s -> s.getOrgStatusOrder()));
            mapOrgStatusOrder.forEach((orgStatusKey, orgStatusList) -> {
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(CompleteSettlementVO::getProjectCreateTime)).collect(Collectors.toList());
                feeNewList.addAll((Collection<CompleteSettlementVO>)orgStatusList);
            });
        });
        Integer number = 1;
        for (CompleteSettlementVO compVONum : feeNewList) {
            compVONum.setNumber(number + "");
            number = number + 1;
            compVONum.setProjectStatusName(CommonUtils.getProjectStatusName(compVONum.getProjectStatus()));
            compVONum.setTotalMoney(CommonUtils.parseYuanToWanZ(compVONum.getTotalMoney()));
        }
        return feeNewList;
    }

    @Override
    public List<CompleteSettlementVO> quertRestoremetricsanalyse(String endDate, List<Long> idList) {
        return this.completeSettlementMapper.quertRestoremetricsanalyse(endDate, idList);
    }

    @Override
    public List<CompleteSettlementVO> quertAnalysis(String endDate, List<Long> projectIdList) {
        return this.completeSettlementMapper.quertAnalysis(endDate, projectIdList);
    }
}

