/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.CostEntity;
import com.ejianc.business.analysis.mapper.CostMapper;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.service.ICostService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.CostVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="costService")
public class CostServiceImpl
extends BaseServiceImpl<CostMapper, CostEntity>
implements ICostService {
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;
    @Autowired
    private CostMapper costMapper;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ICostService costService;
    @Autowired
    private IDefdocApi defdocApi;

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        LambdaQueryWrapper lambdaFee = Wrappers.lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaFee.in(CostEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(CostEntity::getReportingMonth, (Object)reportingMonth);
        this.costService.remove((Wrapper)lambdaFee);
        List<Object> profitIncomeVOList = new ArrayList();
        profitIncomeVOList = CollectionUtils.isNotEmpty(projectIdList) ? this.profitIncomeMapper.getProjects(projectIdList, 1) : this.profitIncomeMapper.getProjects(null, 1);
        CommonResponse plProject = this.defdocApi.getDefDocByDefCode("pl_project");
        if (!plProject.isSuccess()) {
            throw new BusinessException("\u6839\u636e\u6863\u6848\u7f16\u7801\u67e5\u8be2\u6863\u6848\u9879\u5931\u8d25!");
        }
        List defdocDetailVOList = (List)plProject.getData();
        Map<Object, Object> nameMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)defdocDetailVOList)) {
            nameMap = defdocDetailVOList.stream().collect(Collectors.groupingBy(s -> s.getName()));
        }
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            HashMap finalNameMap = nameMap;
            profitIncomeVOList = profitIncomeVOList.stream().filter(s -> !finalNameMap.containsKey(s.getProjectName())).collect(Collectors.toList());
        }
        List<CostVO> costVOList = this.costMapper.getData(reportingMonth, projectIdList);
        Map<Object, Object> mapLj = new HashMap();
        Map<Object, Object> mapProAndPeriod = new HashMap();
        if (CollectionUtils.isNotEmpty(costVOList)) {
            mapLj = costVOList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
            mapProAndPeriod = costVOList.stream().collect(Collectors.groupingBy(s -> s.getProjectId() + "-" + s.getReportingMonth()));
        }
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            List feeVOList = BeanMapper.mapList(profitIncomeVOList, CostVO.class);
            for (CostVO feeVO : feeVOList) {
                String innerCode;
                String[] strs;
                CommonResponse orgVos;
                CommonResponse orgVo;
                feeVO.setReportingMonth(reportingMonth);
                feeVO.setCreateTime(new Date());
                if (mapLj.containsKey(feeVO.getProjectId())) {
                    List feeVOS = (List)mapLj.get(feeVO.getProjectId());
                    List collectCompare = feeVOS.stream().sorted(Comparator.comparing(CostVO::getReportingMonth).reversed()).collect(Collectors.toList());
                    CostVO periodVO = (CostVO)collectCompare.stream().findFirst().get();
                    String key = feeVO.getProjectId() + "-" + periodVO.getReportingMonth();
                    if (mapProAndPeriod.containsKey(key)) {
                        List listLast = (List)mapProAndPeriod.get(key);
                        Map<String, List<CostVO>> costMap = listLast.stream().collect(Collectors.groupingBy(s -> s.getCode()));
                        feeVO.setXcMny(CommonUtils.parseNullValue(((CostVO)costMap.get("\u4e00").stream().findFirst().get()).getCostMny()));
                        feeVO.setBgMny(CommonUtils.parseNullValue(((CostVO)costMap.get("\u4e8c").stream().findFirst().get()).getCostMny()));
                        feeVO.setClMny(CommonUtils.parseNullValue(((CostVO)costMap.get("\u4e09").stream().findFirst().get()).getCostMny()));
                        feeVO.setZdMny(CommonUtils.parseNullValue(((CostVO)costMap.get("\u56db").stream().findFirst().get()).getCostMny()));
                        feeVO.setQtMny(CommonUtils.parseNullValue(((CostVO)costMap.get("\u4e94").stream().findFirst().get()).getCostMny()));
                        feeVO.setMny(CommonUtils.parseNullValue(((CostVO)listLast.stream().findFirst().get()).getMny()));
                    } else {
                        feeVO.setXcMny(BigDecimal.ZERO);
                        feeVO.setBgMny(BigDecimal.ZERO);
                        feeVO.setClMny(BigDecimal.ZERO);
                        feeVO.setZdMny(BigDecimal.ZERO);
                        feeVO.setQtMny(BigDecimal.ZERO);
                        feeVO.setMny(BigDecimal.ZERO);
                    }
                } else {
                    feeVO.setXcMny(BigDecimal.ZERO);
                    feeVO.setBgMny(BigDecimal.ZERO);
                    feeVO.setClMny(BigDecimal.ZERO);
                    feeVO.setZdMny(BigDecimal.ZERO);
                    feeVO.setQtMny(BigDecimal.ZERO);
                    feeVO.setMny(BigDecimal.ZERO);
                }
                if (!(orgVo = this.orgApi.detailById(feeVO.getProjectDepartmentId())).isSuccess() || null == orgVo.getData() || !(orgVos = this.orgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() || null == orgVos.getData()) continue;
                feeVO.setTwoOrgId(((OrgVO)orgVos.getData()).getId());
                feeVO.setTwoOrgName(((OrgVO)orgVos.getData()).getShortName());
                feeVO.setTwoOrgCode(((OrgVO)orgVos.getData()).getCode());
                feeVO.setOrgStatusOrder(Integer.valueOf(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence()));
            }
            List feeEntityList = BeanMapper.mapList((Iterable)feeVOList, CostEntity.class);
            this.costService.saveBatch(feeEntityList);
        }
    }

    @Override
    public List<CostVO> dealData(List<CostVO> feeVOS) {
        for (CostVO costVO : feeVOS) {
            costVO.setXcMny(CommonUtils.parseYuanToWan(costVO.getXcMny()));
            costVO.setBgMny(CommonUtils.parseYuanToWan(costVO.getBgMny()));
            costVO.setClMny(CommonUtils.parseYuanToWan(costVO.getClMny()));
            costVO.setZdMny(CommonUtils.parseYuanToWan(costVO.getZdMny()));
            costVO.setQtMny(CommonUtils.parseYuanToWan(costVO.getQtMny()));
            costVO.setMny(CommonUtils.parseYuanToWan(costVO.getMny()));
        }
        CostVO costVO = new CostVO();
        ArrayList<CostVO> arrayList = new ArrayList<CostVO>();
        if (CollectionUtils.isNotEmpty(feeVOS)) {
            this.getSumData(feeVOS, costVO);
            costVO.setNumber("\u5408\u8ba1");
            costVO.setId(Long.valueOf(IdWorker.getId()));
            arrayList.add(costVO);
        }
        for (CostVO costVO2 : feeVOS) {
            costVO2.setProjectStatusOrder(CommonUtils.getProjectOrderNum(costVO2.getProjectStatus()));
        }
        feeVOS = feeVOS.stream().sorted(Comparator.comparing(CostVO::getProjectStatusOrder)).collect(Collectors.toList());
        Map<Integer, List<CostVO>> mapProjectStatusOrder = feeVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectStatusOrder()));
        mapProjectStatusOrder.forEach((projectStatusKey, projectStatusList) -> {
            CostVO projectStatusSumfeeVO = new CostVO();
            projectStatusSumfeeVO.setNumber("\u9879\u76ee\u72b6\u6001\u5408\u8ba1");
            projectStatusSumfeeVO.setId(Long.valueOf(IdWorker.getId()));
            projectStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusNameProject(projectStatusKey));
            this.getSumData((List<CostVO>)projectStatusList, projectStatusSumfeeVO);
            feeNewList.add(projectStatusSumfeeVO);
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(CostVO::getOrgStatusOrder)).collect(Collectors.toList());
            Map<Integer, List<CostVO>> mapOrgStatusOrder = projectStatusList.stream().collect(Collectors.groupingBy(s -> s.getOrgStatusOrder()));
            mapOrgStatusOrder.forEach((orgStatusKey, orgStatusList) -> {
                CostVO orgStatusSumfeeVO = new CostVO();
                orgStatusSumfeeVO.setNumber("\u5355\u4f4d\u5c0f\u8ba1");
                orgStatusSumfeeVO.setId(Long.valueOf(IdWorker.getId()));
                orgStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(((CostVO)orgStatusList.stream().findFirst().get()).getProjectStatus()));
                orgStatusSumfeeVO.setTwoOrgName(((CostVO)orgStatusList.stream().findFirst().get()).getTwoOrgName());
                this.getSumData((List<CostVO>)orgStatusList, orgStatusSumfeeVO);
                feeNewList.add(orgStatusSumfeeVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(CostVO::getProjectCreateTime)).collect(Collectors.toList());
                for (CostVO feeVONum : orgStatusList) {
                    feeVONum.setNumber(number + "");
                    number = number + 1;
                    feeVONum.setProjectStatusName(CommonUtils.getProjectStatusName(feeVONum.getProjectStatus()));
                    feeVONum.setXcRate(CommonUtils.calculateRate(feeVONum.getXcMny(), feeVONum.getMny()));
                    feeVONum.setBgRate(CommonUtils.calculateRate(feeVONum.getBgMny(), feeVONum.getMny()));
                    feeVONum.setClRate(CommonUtils.calculateRate(feeVONum.getClMny(), feeVONum.getMny()));
                    feeVONum.setZdRate(CommonUtils.calculateRate(feeVONum.getZdMny(), feeVONum.getMny()));
                    feeVONum.setQtRate(CommonUtils.calculateRate(feeVONum.getQtMny(), feeVONum.getMny()));
                }
                feeNewList.addAll((Collection<CostVO>)orgStatusList);
            });
        });
        return arrayList;
    }

    private void getSumData(List<CostVO> feeVOS, CostVO feeVO) {
        BigDecimal xcMny = feeVOS.stream().map(CostVO::getXcMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal bgMny = feeVOS.stream().map(CostVO::getBgMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal clMny = feeVOS.stream().map(CostVO::getClMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal zdMny = feeVOS.stream().map(CostVO::getZdMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal qtMny = feeVOS.stream().map(CostVO::getQtMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal mny = feeVOS.stream().map(CostVO::getMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        feeVO.setXcMny(xcMny);
        feeVO.setBgMny(bgMny);
        feeVO.setClMny(clMny);
        feeVO.setZdMny(zdMny);
        feeVO.setQtMny(qtMny);
        feeVO.setMny(mny);
        feeVO.setXcRate(CommonUtils.calculateRate(feeVO.getXcMny(), feeVO.getMny()));
        feeVO.setBgRate(CommonUtils.calculateRate(feeVO.getBgMny(), feeVO.getMny()));
        feeVO.setClRate(CommonUtils.calculateRate(feeVO.getClMny(), feeVO.getMny()));
        feeVO.setZdRate(CommonUtils.calculateRate(feeVO.getZdMny(), feeVO.getMny()));
        feeVO.setQtRate(CommonUtils.calculateRate(feeVO.getQtMny(), feeVO.getMny()));
    }
}

