package com.ejianc.business.analysis.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 实际产值利润情况分析表
 *
 * @author generator
 *
 */
@TableName("ejc_analysis_actual_value")
public class ActualValueEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="create_user_name")
    private String createUserName; // 创建人名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_status")
    private Long projectStatus; // 项目状态
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="year_actual_complete_value")
    private BigDecimal yearActualCompleteValue; // 本年实际完成产值
    @TableField(value="year_responsibility_cost")
    private BigDecimal yearResponsibilityCost; // 本年责任成本(万元)
    @TableField(value="year_real_cost")
    private BigDecimal yearRealCost; // 本年实际成本
    @TableField(value="year_actual_profit")
    private BigDecimal yearActualProfit; // 本年实际利润
    @TableField(value="accumulate_actual_complete_value")
    private BigDecimal accumulateActualCompleteValue; // 开累实际完成产值
    @TableField(value="accumulate_responsibility_cost")
    private BigDecimal accumulateResponsibilityCost; // 开累责任成本(万元)
    @TableField(value="accumulate_real_cost")
    private BigDecimal accumulateRealCost; // 开累实际成本
    @TableField(value="accumulate_actual_profit")
    private BigDecimal accumulateActualProfit; // 开累实际利润
    @TableField(value="year_profit_rate")
    private BigDecimal yearProfitRate; // 当年利润率(%)
    @TableField(value="accumulate_profit_rate")
    private BigDecimal accumulateProfitRate; // 开累利润率(%)
    @TableField(value="year_reduce_rate")
    private BigDecimal yearReduceRate; // 当年降低率(%)
    @TableField(value="accumulate_reduce_rate")
    private BigDecimal accumulateReduceRate; // 开累降低率(%)
    @TableField(value="undertaking_benefits_rate")
    private BigDecimal undertakingBenefitsRate; // 承接效益率(%)
    @TableField(value="overall_profit_margin")
    private BigDecimal overallProfitMargin; // 整体上缴利润率(%)
    @TableField(value="reporting_month")
    private String reportingMonth; // 报表日期
    @TableField(value="org_status_order")
    private Integer orgStatusOrder; // 二级组织排序
    @TableField(value="project_create_time")
    private Date projectCreateTime; // 项目创建日期
    @TableField(value="two_org_id")
    private Long twoOrgId; // 二级组织id
    @TableField(value="two_org_code")
    private String twoOrgCode; // 二级组织编码
    @TableField(value="two_org_name")
    private String twoOrgName; // 二级组织名称
    @TableField(value="short_name")
    private String shortName;//组织简称
    @TableField(value="ac_contract_amount")
    private BigDecimal acContractAmount; // 其中：自施合同额


    public BigDecimal getAcContractAmount() {
        return acContractAmount;
    }

    public void setAcContractAmount(BigDecimal acContractAmount) {
        this.acContractAmount = acContractAmount;
    }

    public String getShortName() {
        return shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }





    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(Long projectStatus) {
        this.projectStatus = projectStatus;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public BigDecimal getYearActualCompleteValue() {
        return yearActualCompleteValue;
    }

    public void setYearActualCompleteValue(BigDecimal yearActualCompleteValue) {
        this.yearActualCompleteValue = yearActualCompleteValue;
    }
    public BigDecimal getYearResponsibilityCost() {
        return yearResponsibilityCost;
    }

    public void setYearResponsibilityCost(BigDecimal yearResponsibilityCost) {
        this.yearResponsibilityCost = yearResponsibilityCost;
    }
    public BigDecimal getYearRealCost() {
        return yearRealCost;
    }

    public void setYearRealCost(BigDecimal yearRealCost) {
        this.yearRealCost = yearRealCost;
    }
    public BigDecimal getYearActualProfit() {
        return yearActualProfit;
    }

    public void setYearActualProfit(BigDecimal yearActualProfit) {
        this.yearActualProfit = yearActualProfit;
    }
    public BigDecimal getAccumulateActualCompleteValue() {
        return accumulateActualCompleteValue;
    }

    public void setAccumulateActualCompleteValue(BigDecimal accumulateActualCompleteValue) {
        this.accumulateActualCompleteValue = accumulateActualCompleteValue;
    }
    public BigDecimal getAccumulateResponsibilityCost() {
        return accumulateResponsibilityCost;
    }

    public void setAccumulateResponsibilityCost(BigDecimal accumulateResponsibilityCost) {
        this.accumulateResponsibilityCost = accumulateResponsibilityCost;
    }
    public BigDecimal getAccumulateRealCost() {
        return accumulateRealCost;
    }

    public void setAccumulateRealCost(BigDecimal accumulateRealCost) {
        this.accumulateRealCost = accumulateRealCost;
    }
    public BigDecimal getAccumulateActualProfit() {
        return accumulateActualProfit;
    }

    public void setAccumulateActualProfit(BigDecimal accumulateActualProfit) {
        this.accumulateActualProfit = accumulateActualProfit;
    }
    public BigDecimal getYearProfitRate() {
        return yearProfitRate;
    }

    public void setYearProfitRate(BigDecimal yearProfitRate) {
        this.yearProfitRate = yearProfitRate;
    }
    public BigDecimal getAccumulateProfitRate() {
        return accumulateProfitRate;
    }

    public void setAccumulateProfitRate(BigDecimal accumulateProfitRate) {
        this.accumulateProfitRate = accumulateProfitRate;
    }
    public BigDecimal getYearReduceRate() {
        return yearReduceRate;
    }

    public void setYearReduceRate(BigDecimal yearReduceRate) {
        this.yearReduceRate = yearReduceRate;
    }
    public BigDecimal getAccumulateReduceRate() {
        return accumulateReduceRate;
    }

    public void setAccumulateReduceRate(BigDecimal accumulateReduceRate) {
        this.accumulateReduceRate = accumulateReduceRate;
    }
    public BigDecimal getUndertakingBenefitsRate() {
        return undertakingBenefitsRate;
    }

    public void setUndertakingBenefitsRate(BigDecimal undertakingBenefitsRate) {
        this.undertakingBenefitsRate = undertakingBenefitsRate;
    }
    public BigDecimal getOverallProfitMargin() {
        return overallProfitMargin;
    }

    public void setOverallProfitMargin(BigDecimal overallProfitMargin) {
        this.overallProfitMargin = overallProfitMargin;
    }
    public String getReportingMonth() {
        return reportingMonth;
    }

    public void setReportingMonth(String reportingMonth) {
        this.reportingMonth = reportingMonth;
    }
    public Integer getOrgStatusOrder() {
        return orgStatusOrder;
    }

    public void setOrgStatusOrder(Integer orgStatusOrder) {
        this.orgStatusOrder = orgStatusOrder;
    }
    public Date getProjectCreateTime() {
        return projectCreateTime;
    }

    public void setProjectCreateTime(Date projectCreateTime) {
        this.projectCreateTime = projectCreateTime;
    }

    public Long getTwoOrgId() {
        return twoOrgId;
    }

    public void setTwoOrgId(Long twoOrgId) {
        this.twoOrgId = twoOrgId;
    }

    public String getTwoOrgCode() {
        return twoOrgCode;
    }

    public void setTwoOrgCode(String twoOrgCode) {
        this.twoOrgCode = twoOrgCode;
    }

    public String getTwoOrgName() {
        return twoOrgName;
    }

    public void setTwoOrgName(String twoOrgName) {
        this.twoOrgName = twoOrgName;
    }
}
