package com.ejianc.business.analysis.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 项目确权情况分析
 * 
 * @author generator
 * 
 */
 @TableName("ejc_analysis_authentic_right")
public class AuthenticRightEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="org_id")
    private Long orgId; // 项目组织id
    @TableField(value="org_code")
    private String orgCode; // 项目组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="two_org_id")
    private Long twoOrgId; // 二级组织id
    @TableField(value="two_org_code")
    private String twoOrgCode; // 二级组织编码
    @TableField(value="two_org_name")
    private String twoOrgName; // 二级组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_status")
    private Integer projectStatus; // 项目状态
    @TableField(value="reporting_month")
    private Date reportingMonth; // 报表日期
    @TableField(value="notarize_product_year")
    private BigDecimal notarizeProductYear; // 业主确认产值（本年）
    @TableField(value="real_product_year")
    private BigDecimal realProductYear; // 实际完成产值（本年）
    @TableField(value="actual_cost_year")
    private BigDecimal actualCostYear; // 实际成本（本年）
    @TableField(value="notarize_product_total")
    private BigDecimal notarizeProductTotal; // 业主确认产值（开累）
    @TableField(value="real_product_total")
    private BigDecimal realProductTotal; // 实际完成产值（开累）
    @TableField(value="actual_cost_total")
    private BigDecimal actualCostTotal; // 实际成本（开累）
    @TableField(value="project_create_time")
    private Date projectCreateTime; // 项目创建日期
    @TableField(value="notarize_rate")
    private BigDecimal notarizeRate; // 年确认率
    @TableField(value="notarize_rate_total")
    private BigDecimal notarizeRateTotal; // 开累确认率
    @TableField(value="authentic_right_rate")
    private BigDecimal authenticRightRate; // 年确权率
    @TableField(value="authentic_right_rate_total")
    private BigDecimal authenticRightRateTotal; // 开累年确权率
    @TableField(value="project_unit_create_time")
    private Date projectUnitCreateTime; // 工程计量时间
    @TableField(value="cost_analyse_create_time")
    private Date costAnalyseCreateTime; // 成本分析时间
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="short_name")
    private String shortName;//组织简称
    public String getShortName() {
        return shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }
    
    

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getTwoOrgId() {
        return twoOrgId;
    }

    public void setTwoOrgId(Long twoOrgId) {
        this.twoOrgId = twoOrgId;
    }
    public String getTwoOrgCode() {
        return twoOrgCode;
    }

    public void setTwoOrgCode(String twoOrgCode) {
        this.twoOrgCode = twoOrgCode;
    }
    public String getTwoOrgName() {
        return twoOrgName;
    }

    public void setTwoOrgName(String twoOrgName) {
        this.twoOrgName = twoOrgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Integer getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(Integer projectStatus) {
        this.projectStatus = projectStatus;
    }
    public Date getReportingMonth() {
        return reportingMonth;
    }

    public void setReportingMonth(Date reportingMonth) {
        this.reportingMonth = reportingMonth;
    }
    public BigDecimal getNotarizeProductYear() {
        return notarizeProductYear;
    }

    public void setNotarizeProductYear(BigDecimal notarizeProductYear) {
        this.notarizeProductYear = notarizeProductYear;
    }
    public BigDecimal getRealProductYear() {
        return realProductYear;
    }

    public void setRealProductYear(BigDecimal realProductYear) {
        this.realProductYear = realProductYear;
    }
    public BigDecimal getActualCostYear() {
        return actualCostYear;
    }

    public void setActualCostYear(BigDecimal actualCostYear) {
        this.actualCostYear = actualCostYear;
    }
    public BigDecimal getNotarizeProductTotal() {
        return notarizeProductTotal;
    }

    public void setNotarizeProductTotal(BigDecimal notarizeProductTotal) {
        this.notarizeProductTotal = notarizeProductTotal;
    }
    public BigDecimal getRealProductTotal() {
        return realProductTotal;
    }

    public void setRealProductTotal(BigDecimal realProductTotal) {
        this.realProductTotal = realProductTotal;
    }
    public BigDecimal getActualCostTotal() {
        return actualCostTotal;
    }

    public void setActualCostTotal(BigDecimal actualCostTotal) {
        this.actualCostTotal = actualCostTotal;
    }
    public Date getProjectCreateTime() {
        return projectCreateTime;
    }

    public void setProjectCreateTime(Date projectCreateTime) {
        this.projectCreateTime = projectCreateTime;
    }
    public BigDecimal getNotarizeRate() {
        return notarizeRate;
    }

    public void setNotarizeRate(BigDecimal notarizeRate) {
        this.notarizeRate = notarizeRate;
    }
    public BigDecimal getNotarizeRateTotal() {
        return notarizeRateTotal;
    }

    public void setNotarizeRateTotal(BigDecimal notarizeRateTotal) {
        this.notarizeRateTotal = notarizeRateTotal;
    }
    public BigDecimal getAuthenticRightRate() {
        return authenticRightRate;
    }

    public void setAuthenticRightRate(BigDecimal authenticRightRate) {
        this.authenticRightRate = authenticRightRate;
    }
    public BigDecimal getAuthenticRightRateTotal() {
        return authenticRightRateTotal;
    }

    public void setAuthenticRightRateTotal(BigDecimal authenticRightRateTotal) {
        this.authenticRightRateTotal = authenticRightRateTotal;
    }
    public Date getProjectUnitCreateTime() {
        return projectUnitCreateTime;
    }

    public void setProjectUnitCreateTime(Date projectUnitCreateTime) {
        this.projectUnitCreateTime = projectUnitCreateTime;
    }
    public Date getCostAnalyseCreateTime() {
        return costAnalyseCreateTime;
    }

    public void setCostAnalyseCreateTime(Date costAnalyseCreateTime) {
        this.costAnalyseCreateTime = costAnalyseCreateTime;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
