package com.ejianc.business.analysis.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 项目目标管理及运营情况分析表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_analysis_business")
public class BusinessEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_code")
    private String orgCode; // 所属组织编码
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="two_org_id")
    private Long twoOrgId; // 二级组织id
    @TableField(value="two_org_code")
    private String twoOrgCode; // 二级组织编码
    @TableField(value="two_org_name")
    private String twoOrgName; // 二级组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_status")
    private Integer projectStatus; // 项目状态
    @TableField(value="reporting_month")
    private String reportingMonth; // 报表日期
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="project_create_time")
    private Date projectCreateTime; // 项目创建日期
    @TableField(value="cost_analysis_create_time")
    private Date costAnalysisCreateTime; // 月度分析报告创建时间
    @TableField(value="org_status_order")
    private Integer orgStatusOrder; // 二级组织排序
    @TableField(value="pattern")
    private String pattern; // 模式
    @TableField(value="sign_contract")
    private BigDecimal signContract; // 签约合同价(万元)
    @TableField(value="oneself_contract")
    private BigDecimal oneselfContract; // 自施合同额（万元）
    @TableField(value="budget_limit")
    private BigDecimal budgetLimit; // 施工图预算额（万元）
    @TableField(value="project_type")
    private String projectType; // 施工类型
    @TableField(value="contractual_model_name")
    private String contractualModelName; // 承包模式
    @TableField(value="responsibility_cost")
    private BigDecimal responsibilityCost; // 项目目标责任成本(责任成本(万元))
    @TableField(value="book_sign_time")
    private Date bookSignTime; // 项目目标管理责任书签订日期(责任书签订时间)
    @TableField(value="undertaking_benefits_rate")
    private BigDecimal undertakingBenefitsRate; // 中标利润率(承接效益率)
    @TableField(value="overall_profit_margin")
    private BigDecimal overallProfitMargin; // 目标责任书利润比例%(整体上缴利润率)
    @TableField(value="yyl_mny")
    private BigDecimal yylMny; // 应预留风险金额（元）
    @TableField(value="actual_mny")
    private BigDecimal actualMny; // 实际预留风险金额（元）
    @TableField(value="business_flag")
    private String businessFlag; // 编制商务策划书（是/否）
    @TableField(value="approval_total")
    private Integer approvalTotal; //累计立项（项）
    @TableField(value="predict_money")
    private BigDecimal predictMoney; // 策划预计创效金额（万元）
    @TableField(value="amount")
    private Integer amount; // 实施项（项）(数量（项）)
    @TableField(value="plan_money")
    private BigDecimal planMoney; // 策划创效金额（万元）
    @TableField(value="production_money")
    private BigDecimal productionMoney; // 本月实际完成产值（自行完成）
    @TableField(value="actual_cost_money")
    private BigDecimal actualCostMoney; // 本月实际成本（含税）
    @TableField(value="actual_profit_money")
    private BigDecimal actualProfitMoney; // 本月实际利润（不含税）
    @TableField(value="sum_actual_cost_money")
    private BigDecimal sumActualCostMoney; // 项目累计发生实际成本（含税）
    @TableField(value="sum_response_cost_money")
    private BigDecimal sumResponseCostMoney; // 累计责任成本（含税）
    @TableField(value="difference_money")
    private BigDecimal differenceMoney; // 累计责任成本与实际成本差
    @TableField(value="actual_finish_production_near")
    private BigDecimal actualFinishProductionNear; // 本年度实际产值（自行完成部分）(实际完成产值（年）/万元)
    @TableField(value="owner_affirm_production")
    private BigDecimal ownerAffirmProduction; // 业主累计确认产值（自行完成部分）(业主确认产值(开累)
    @TableField(value="actual_finish_production")
    private BigDecimal actualFinishProduction; // 项目累计完成实际产值（自行完成部分）(实际完成产值(开累))
    @TableField(value="affirm_rate")
    private BigDecimal affirmRate; // 工程计量确认率%
    @TableField(value="production_rate")
    private BigDecimal productionRate; // 产值确权率
    @TableField(value="profit_mny")
    private BigDecimal profitMny; // 实际利润（不含税）
    @TableField(value="profit_rate")
    private BigDecimal profitRate; // 实际产值利润率%（不含税）
    @TableField(value="completed_balance")
    private BigDecimal completedBalance; // 已完工未结算
    @TableField(value="stock_up")
    private BigDecimal stockUp; // 存货
    @TableField(value="account_receive")
    private BigDecimal accountReceive; // 应收账款
    @TableField(value="out_income_mny")
    private BigDecimal outIncomeMny; // 未列报收入
    @TableField(value="out_cost_mny")
    private BigDecimal outCostMny; // 未列报成本
    @TableField(value="income_mny")
    private BigDecimal incomeMny; // 财务累计已列报收入（自行完成部分）（财务）(财务累计列报收入)
    @TableField(value="cost_mny")
    private BigDecimal costMny; // 财务列报成本（不含指定分包）（财务）(财务账面成本)
    @TableField(value="report_profit_mny")
    private BigDecimal reportProfitMny; // 财务报表利润（财务）
    @TableField(value="report_profit_rate")
    private BigDecimal reportProfitRate; // 财务报出利润率%（不含税）（财务）
    @TableField(value="contract_receipt")
    private BigDecimal contractReceipt; // 按合同应收款(开累)
    @TableField(value="project_funds")
    private BigDecimal projectFunds; // 已收工程款(开累)
    @TableField(value="advance")
    private BigDecimal advance; // 其中预付款(开累)
    @TableField(value="ysws_money")
    private BigDecimal yswsMoney; // 应收未收账款
    @TableField(value="ysws_rate")
    private BigDecimal yswsRate; // 工程款实际回收比例（已收款除以业主确认产值）
    @TableField(value="amount_payable")
    private BigDecimal amountPayable; // 应付款金额
    @TableField(value="amount_paid")
    private BigDecimal amountPaid; // 已付款金额
    @TableField(value="contract_yfwf_mny")
    private BigDecimal contractYfwfMny; // 按合同应付未付工程款
    @TableField(value="cost_sx_rate")
    private BigDecimal costSxRate; // 成本收现率
    @TableField(value="cost_fx_rate")
    private BigDecimal costFxRate; // 成本付现率
    @TableField(value="short_name")
    private String shortName;//组织简称
    public String getShortName() {
        return shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }
    
    

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getTwoOrgId() {
        return twoOrgId;
    }

    public void setTwoOrgId(Long twoOrgId) {
        this.twoOrgId = twoOrgId;
    }
    public String getTwoOrgCode() {
        return twoOrgCode;
    }

    public void setTwoOrgCode(String twoOrgCode) {
        this.twoOrgCode = twoOrgCode;
    }
    public String getTwoOrgName() {
        return twoOrgName;
    }

    public void setTwoOrgName(String twoOrgName) {
        this.twoOrgName = twoOrgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Integer getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(Integer projectStatus) {
        this.projectStatus = projectStatus;
    }
    public String getReportingMonth() {
        return reportingMonth;
    }

    public void setReportingMonth(String reportingMonth) {
        this.reportingMonth = reportingMonth;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getProjectCreateTime() {
        return projectCreateTime;
    }

    public void setProjectCreateTime(Date projectCreateTime) {
        this.projectCreateTime = projectCreateTime;
    }
    public Date getCostAnalysisCreateTime() {
        return costAnalysisCreateTime;
    }

    public void setCostAnalysisCreateTime(Date costAnalysisCreateTime) {
        this.costAnalysisCreateTime = costAnalysisCreateTime;
    }
    public Integer getOrgStatusOrder() {
        return orgStatusOrder;
    }

    public void setOrgStatusOrder(Integer orgStatusOrder) {
        this.orgStatusOrder = orgStatusOrder;
    }
    public String getPattern() {
        return pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
    public BigDecimal getSignContract() {
        return signContract;
    }

    public void setSignContract(BigDecimal signContract) {
        this.signContract = signContract;
    }
    public BigDecimal getOneselfContract() {
        return oneselfContract;
    }

    public void setOneselfContract(BigDecimal oneselfContract) {
        this.oneselfContract = oneselfContract;
    }
    public BigDecimal getBudgetLimit() {
        return budgetLimit;
    }

    public void setBudgetLimit(BigDecimal budgetLimit) {
        this.budgetLimit = budgetLimit;
    }
    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }
    public String getContractualModelName() {
        return contractualModelName;
    }

    public void setContractualModelName(String contractualModelName) {
        this.contractualModelName = contractualModelName;
    }
    public BigDecimal getResponsibilityCost() {
        return responsibilityCost;
    }

    public void setResponsibilityCost(BigDecimal responsibilityCost) {
        this.responsibilityCost = responsibilityCost;
    }
    public Date getBookSignTime() {
        return bookSignTime;
    }

    public void setBookSignTime(Date bookSignTime) {
        this.bookSignTime = bookSignTime;
    }
    public BigDecimal getUndertakingBenefitsRate() {
        return undertakingBenefitsRate;
    }

    public void setUndertakingBenefitsRate(BigDecimal undertakingBenefitsRate) {
        this.undertakingBenefitsRate = undertakingBenefitsRate;
    }
    public BigDecimal getOverallProfitMargin() {
        return overallProfitMargin;
    }

    public void setOverallProfitMargin(BigDecimal overallProfitMargin) {
        this.overallProfitMargin = overallProfitMargin;
    }
    public BigDecimal getYylMny() {
        return yylMny;
    }

    public void setYylMny(BigDecimal yylMny) {
        this.yylMny = yylMny;
    }
    public BigDecimal getActualMny() {
        return actualMny;
    }

    public void setActualMny(BigDecimal actualMny) {
        this.actualMny = actualMny;
    }
    public String getBusinessFlag() {
        return businessFlag;
    }

    public void setBusinessFlag(String businessFlag) {
        this.businessFlag = businessFlag;
    }
    public Integer getApprovalTotal() {
        return approvalTotal;
    }

    public void setApprovalTotal(Integer approvalTotal) {
        this.approvalTotal = approvalTotal;
    }
    public BigDecimal getPredictMoney() {
        return predictMoney;
    }

    public void setPredictMoney(BigDecimal predictMoney) {
        this.predictMoney = predictMoney;
    }
    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }
    public BigDecimal getPlanMoney() {
        return planMoney;
    }

    public void setPlanMoney(BigDecimal planMoney) {
        this.planMoney = planMoney;
    }
    public BigDecimal getProductionMoney() {
        return productionMoney;
    }

    public void setProductionMoney(BigDecimal productionMoney) {
        this.productionMoney = productionMoney;
    }
    public BigDecimal getActualCostMoney() {
        return actualCostMoney;
    }

    public void setActualCostMoney(BigDecimal actualCostMoney) {
        this.actualCostMoney = actualCostMoney;
    }

    public BigDecimal getActualProfitMoney() {
        return actualProfitMoney;
    }

    public void setActualProfitMoney(BigDecimal actualProfitMoney) {
        this.actualProfitMoney = actualProfitMoney;
    }

    public BigDecimal getSumActualCostMoney() {
        return sumActualCostMoney;
    }

    public void setSumActualCostMoney(BigDecimal sumActualCostMoney) {
        this.sumActualCostMoney = sumActualCostMoney;
    }
    public BigDecimal getSumResponseCostMoney() {
        return sumResponseCostMoney;
    }

    public void setSumResponseCostMoney(BigDecimal sumResponseCostMoney) {
        this.sumResponseCostMoney = sumResponseCostMoney;
    }
    public BigDecimal getDifferenceMoney() {
        return differenceMoney;
    }

    public void setDifferenceMoney(BigDecimal differenceMoney) {
        this.differenceMoney = differenceMoney;
    }
    public BigDecimal getActualFinishProductionNear() {
        return actualFinishProductionNear;
    }

    public void setActualFinishProductionNear(BigDecimal actualFinishProductionNear) {
        this.actualFinishProductionNear = actualFinishProductionNear;
    }
    public BigDecimal getOwnerAffirmProduction() {
        return ownerAffirmProduction;
    }

    public void setOwnerAffirmProduction(BigDecimal ownerAffirmProduction) {
        this.ownerAffirmProduction = ownerAffirmProduction;
    }
    public BigDecimal getActualFinishProduction() {
        return actualFinishProduction;
    }

    public void setActualFinishProduction(BigDecimal actualFinishProduction) {
        this.actualFinishProduction = actualFinishProduction;
    }
    public BigDecimal getAffirmRate() {
        return affirmRate;
    }

    public void setAffirmRate(BigDecimal affirmRate) {
        this.affirmRate = affirmRate;
    }
    public BigDecimal getProductionRate() {
        return productionRate;
    }

    public void setProductionRate(BigDecimal productionRate) {
        this.productionRate = productionRate;
    }
    public BigDecimal getProfitMny() {
        return profitMny;
    }

    public void setProfitMny(BigDecimal profitMny) {
        this.profitMny = profitMny;
    }
    public BigDecimal getProfitRate() {
        return profitRate;
    }

    public void setProfitRate(BigDecimal profitRate) {
        this.profitRate = profitRate;
    }
    public BigDecimal getCompletedBalance() {
        return completedBalance;
    }

    public void setCompletedBalance(BigDecimal completedBalance) {
        this.completedBalance = completedBalance;
    }
    public BigDecimal getStockUp() {
        return stockUp;
    }

    public void setStockUp(BigDecimal stockUp) {
        this.stockUp = stockUp;
    }
    public BigDecimal getAccountReceive() {
        return accountReceive;
    }

    public void setAccountReceive(BigDecimal accountReceive) {
        this.accountReceive = accountReceive;
    }
    public BigDecimal getOutIncomeMny() {
        return outIncomeMny;
    }

    public void setOutIncomeMny(BigDecimal outIncomeMny) {
        this.outIncomeMny = outIncomeMny;
    }
    public BigDecimal getOutCostMny() {
        return outCostMny;
    }

    public void setOutCostMny(BigDecimal outCostMny) {
        this.outCostMny = outCostMny;
    }
    public BigDecimal getIncomeMny() {
        return incomeMny;
    }

    public void setIncomeMny(BigDecimal incomeMny) {
        this.incomeMny = incomeMny;
    }
    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }
    public BigDecimal getReportProfitMny() {
        return reportProfitMny;
    }

    public void setReportProfitMny(BigDecimal reportProfitMny) {
        this.reportProfitMny = reportProfitMny;
    }
    public BigDecimal getReportProfitRate() {
        return reportProfitRate;
    }

    public void setReportProfitRate(BigDecimal reportProfitRate) {
        this.reportProfitRate = reportProfitRate;
    }
    public BigDecimal getContractReceipt() {
        return contractReceipt;
    }

    public void setContractReceipt(BigDecimal contractReceipt) {
        this.contractReceipt = contractReceipt;
    }
    public BigDecimal getProjectFunds() {
        return projectFunds;
    }

    public void setProjectFunds(BigDecimal projectFunds) {
        this.projectFunds = projectFunds;
    }
    public BigDecimal getAdvance() {
        return advance;
    }

    public void setAdvance(BigDecimal advance) {
        this.advance = advance;
    }
    public BigDecimal getYswsMoney() {
        return yswsMoney;
    }

    public void setYswsMoney(BigDecimal yswsMoney) {
        this.yswsMoney = yswsMoney;
    }
    public BigDecimal getYswsRate() {
        return yswsRate;
    }

    public void setYswsRate(BigDecimal yswsRate) {
        this.yswsRate = yswsRate;
    }
    public BigDecimal getAmountPayable() {
        return amountPayable;
    }

    public void setAmountPayable(BigDecimal amountPayable) {
        this.amountPayable = amountPayable;
    }
    public BigDecimal getAmountPaid() {
        return amountPaid;
    }

    public void setAmountPaid(BigDecimal amountPaid) {
        this.amountPaid = amountPaid;
    }
    public BigDecimal getContractYfwfMny() {
        return contractYfwfMny;
    }

    public void setContractYfwfMny(BigDecimal contractYfwfMny) {
        this.contractYfwfMny = contractYfwfMny;
    }
    public BigDecimal getCostSxRate() {
        return costSxRate;
    }

    public void setCostSxRate(BigDecimal costSxRate) {
        this.costSxRate = costSxRate;
    }
    public BigDecimal getCostFxRate() {
        return costFxRate;
    }

    public void setCostFxRate(BigDecimal costFxRate) {
        this.costFxRate = costFxRate;
    }
    
}
