package com.ejianc.business.analysis.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 竣工已结算项目商务报表
 *
 * @author generator
 *
 */
 @TableName("ejc_analysis_settled_pro_business")
public class SettledProBusinessEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="create_user_name")
    private String createUserName; // 创建人名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="project_category")
    private String projectCategory; // 项目类别
    @TableField(value="project_location")
    private String projectLocation; // 工程地点
    @TableField(value="promoter")
    private Long promoter; // 发包人
    @TableField(value="promoter_name")
    private String promoterName; // 发包人名称
    @TableField(value="promoter_org_id")
    private Long promoterOrgId; // 发包人所属集团
    @TableField(value="promoter_org_name")
    private String promoterOrgName; // 发包人所属集团名称
    @TableField(value="contractor")
    private Long contractor; // 承包人
    @TableField(value="contractor_name")
    private String contractorName; // 承包人名称
    @TableField(value="three_org_id")
    private Long threeOrgId; // 股份公司三级单位
    @TableField(value="three_org_name")
    private String threeOrgName; // 股份公司三级单位名称
    @TableField(value="four_org_id")
    private Long fourOrgId; // 股份公司四级单位
    @TableField(value="four_org_name")
    private String fourOrgName; // 股份公司四级单位名称
    @TableField(value="contract_sign_time")
    private Date contractSignTime; // 合同签订日期
    @TableField(value="contract_start_date")
    private Date contractStartDate; // 合同开工日期
    @TableField(value="contract_end_date")
    private Date contractEndDate; // 合同竣工日期
    @TableField(value="real_start_date")
    private Date realStartDate; // 实际开工日期
    @TableField(value="end_date")
    private Date endDate; // 竣工日期
    @TableField(value="contract_amount")
    private BigDecimal contractAmount; // 合同额
    @TableField(value="ac_contract_amount")
    private BigDecimal acContractAmount; // 其中：自施合同额
    @TableField(value="contract_income")
    private BigDecimal contractIncome; // 产值（合同收入）
    @TableField(value="ac_contract_income")
    private BigDecimal acContractIncome; // 自施产值（自施合同收入）
    @TableField(value="real_cost")
    private BigDecimal realCost; // 实际成本
    @TableField(value="ac_real_cost")
    private BigDecimal acRealCost; // 自施实际成本
    @TableField(value="cost_lock_flag")
    private Integer costLockFlag; // 成本锁定与否  否:0  是:1
    @TableField(value="settlement_amount")
    private BigDecimal settlementAmount; // 结算额
    @TableField(value="ac_settlement_amount")
    private BigDecimal acSettlementAmount; // 自施结算额
    @TableField(value="contract_receivable_mny")
    private BigDecimal contractReceivableMny; // 合同应收款
    @TableField(value="settlement_finalize_date")
    private Date settlementFinalizeDate; // 结算定案日期
    @TableField(value="settlement_cycle_days")
    private BigDecimal settlementCycleDays; // 结算周期（天数）
    @TableField(value="profit_rate")
    private BigDecimal profitRate; // 利润率(%)
    @TableField(value="ac_profit_rate")
    private BigDecimal acProfitRate; // 自施利润率(%)
    @TableField(value="undertake_rate")
    private BigDecimal undertakeRate; // 承接效益率(%)
    @TableField(value="target_rate")
    private BigDecimal targetRate; // 目标效益率(%)
    @TableField(value="complete_target_benefit_flag")
    private Integer completeTargetBenefitFlag; // 是否完成目标效益  否:0  是:1
    @TableField(value="complete_examine_cash_audit_flag")
    private Integer completeExamineCashAuditFlag; // 是否完成考核兑现审计  否:0  是:1
    @TableField(value="operating_revenue")
    private BigDecimal operatingRevenue; // 营业收入
    @TableField(value="real_recrived")
    private BigDecimal realRecrived; // 实际已收款
    @TableField(value="reason")
    private String reason; // 竣工超过六个月未结算原因
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="reporting_month")
    private String reportingMonth; // 报表日期
    @TableField(value="cumulative_income")
    private BigDecimal cumulativeIncome;//累计产值收入 -对应报表-  上年度末参值
    @TableField(value="cumulative_income_you")
    private BigDecimal cumulativeIncomeYou;//上年度末自施产值
    @TableField(value="cumulative_batch")
    private BigDecimal cumulativeBatch;//累计批量 -- 对应上年度末业主确认产值
    @TableField(value="cumulative_batch_you")
    private BigDecimal cumulativeBatchYou;//对应上年度末业主确认自施产值
    @TableField(value="short_name")
    private String shortName;//组织简称
    public String getShortName() {
        return shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }
    public BigDecimal getCumulativeIncome() {
        return cumulativeIncome;
    }

    public void setCumulativeIncome(BigDecimal cumulativeIncome) {
        this.cumulativeIncome = cumulativeIncome;
    }

    public BigDecimal getCumulativeIncomeYou() {
        return cumulativeIncomeYou;
    }

    public void setCumulativeIncomeYou(BigDecimal cumulativeIncomeYou) {
        this.cumulativeIncomeYou = cumulativeIncomeYou;
    }

    public BigDecimal getCumulativeBatch() {
        return cumulativeBatch;
    }

    public void setCumulativeBatch(BigDecimal cumulativeBatch) {
        this.cumulativeBatch = cumulativeBatch;
    }

    public BigDecimal getCumulativeBatchYou() {
        return cumulativeBatchYou;
    }

    public void setCumulativeBatchYou(BigDecimal cumulativeBatchYou) {
        this.cumulativeBatchYou = cumulativeBatchYou;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCategory() {
        return projectCategory;
    }

    public void setProjectCategory(String projectCategory) {
        this.projectCategory = projectCategory;
    }
    public String getProjectLocation() {
        return projectLocation;
    }

    public void setProjectLocation(String projectLocation) {
        this.projectLocation = projectLocation;
    }
    public Long getPromoter() {
        return promoter;
    }

    public void setPromoter(Long promoter) {
        this.promoter = promoter;
    }
    public String getPromoterName() {
        return promoterName;
    }

    public void setPromoterName(String promoterName) {
        this.promoterName = promoterName;
    }
    public Long getPromoterOrgId() {
        return promoterOrgId;
    }

    public void setPromoterOrgId(Long promoterOrgId) {
        this.promoterOrgId = promoterOrgId;
    }
    public String getPromoterOrgName() {
        return promoterOrgName;
    }

    public void setPromoterOrgName(String promoterOrgName) {
        this.promoterOrgName = promoterOrgName;
    }
    public Long getContractor() {
        return contractor;
    }

    public void setContractor(Long contractor) {
        this.contractor = contractor;
    }
    public String getContractorName() {
        return contractorName;
    }

    public void setContractorName(String contractorName) {
        this.contractorName = contractorName;
    }
    public Long getThreeOrgId() {
        return threeOrgId;
    }

    public void setThreeOrgId(Long threeOrgId) {
        this.threeOrgId = threeOrgId;
    }
    public String getThreeOrgName() {
        return threeOrgName;
    }

    public void setThreeOrgName(String threeOrgName) {
        this.threeOrgName = threeOrgName;
    }
    public Long getFourOrgId() {
        return fourOrgId;
    }

    public void setFourOrgId(Long fourOrgId) {
        this.fourOrgId = fourOrgId;
    }
    public String getFourOrgName() {
        return fourOrgName;
    }

    public void setFourOrgName(String fourOrgName) {
        this.fourOrgName = fourOrgName;
    }
    public Date getContractSignTime() {
        return contractSignTime;
    }

    public void setContractSignTime(Date contractSignTime) {
        this.contractSignTime = contractSignTime;
    }
    public Date getContractStartDate() {
        return contractStartDate;
    }

    public void setContractStartDate(Date contractStartDate) {
        this.contractStartDate = contractStartDate;
    }
    public Date getContractEndDate() {
        return contractEndDate;
    }

    public void setContractEndDate(Date contractEndDate) {
        this.contractEndDate = contractEndDate;
    }
    public Date getRealStartDate() {
        return realStartDate;
    }

    public void setRealStartDate(Date realStartDate) {
        this.realStartDate = realStartDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public BigDecimal getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }
    public BigDecimal getAcContractAmount() {
        return acContractAmount;
    }

    public void setAcContractAmount(BigDecimal acContractAmount) {
        this.acContractAmount = acContractAmount;
    }
    public BigDecimal getContractIncome() {
        return contractIncome;
    }

    public void setContractIncome(BigDecimal contractIncome) {
        this.contractIncome = contractIncome;
    }
    public BigDecimal getAcContractIncome() {
        return acContractIncome;
    }

    public void setAcContractIncome(BigDecimal acContractIncome) {
        this.acContractIncome = acContractIncome;
    }
    public BigDecimal getRealCost() {
        return realCost;
    }

    public void setRealCost(BigDecimal realCost) {
        this.realCost = realCost;
    }
    public BigDecimal getAcRealCost() {
        return acRealCost;
    }

    public void setAcRealCost(BigDecimal acRealCost) {
        this.acRealCost = acRealCost;
    }
    public Integer getCostLockFlag() {
        return costLockFlag;
    }

    public void setCostLockFlag(Integer costLockFlag) {
        this.costLockFlag = costLockFlag;
    }
    public BigDecimal getSettlementAmount() {
        return settlementAmount;
    }

    public void setSettlementAmount(BigDecimal settlementAmount) {
        this.settlementAmount = settlementAmount;
    }
    public BigDecimal getAcSettlementAmount() {
        return acSettlementAmount;
    }

    public void setAcSettlementAmount(BigDecimal acSettlementAmount) {
        this.acSettlementAmount = acSettlementAmount;
    }
    public BigDecimal getContractReceivableMny() {
        return contractReceivableMny;
    }

    public void setContractReceivableMny(BigDecimal contractReceivableMny) {
        this.contractReceivableMny = contractReceivableMny;
    }
    public Date getSettlementFinalizeDate() {
        return settlementFinalizeDate;
    }

    public void setSettlementFinalizeDate(Date settlementFinalizeDate) {
        this.settlementFinalizeDate = settlementFinalizeDate;
    }
    public BigDecimal getSettlementCycleDays() {
        return settlementCycleDays;
    }

    public void setSettlementCycleDays(BigDecimal settlementCycleDays) {
        this.settlementCycleDays = settlementCycleDays;
    }
    public BigDecimal getProfitRate() {
        return profitRate;
    }

    public void setProfitRate(BigDecimal profitRate) {
        this.profitRate = profitRate;
    }
    public BigDecimal getAcProfitRate() {
        return acProfitRate;
    }

    public void setAcProfitRate(BigDecimal acProfitRate) {
        this.acProfitRate = acProfitRate;
    }
    public BigDecimal getUndertakeRate() {
        return undertakeRate;
    }

    public void setUndertakeRate(BigDecimal undertakeRate) {
        this.undertakeRate = undertakeRate;
    }
    public BigDecimal getTargetRate() {
        return targetRate;
    }

    public void setTargetRate(BigDecimal targetRate) {
        this.targetRate = targetRate;
    }
    public Integer getCompleteTargetBenefitFlag() {
        return completeTargetBenefitFlag;
    }

    public void setCompleteTargetBenefitFlag(Integer completeTargetBenefitFlag) {
        this.completeTargetBenefitFlag = completeTargetBenefitFlag;
    }
    public Integer getCompleteExamineCashAuditFlag() {
        return completeExamineCashAuditFlag;
    }

    public void setCompleteExamineCashAuditFlag(Integer completeExamineCashAuditFlag) {
        this.completeExamineCashAuditFlag = completeExamineCashAuditFlag;
    }
    public BigDecimal getOperatingRevenue() {
        return operatingRevenue;
    }

    public void setOperatingRevenue(BigDecimal operatingRevenue) {
        this.operatingRevenue = operatingRevenue;
    }
    public BigDecimal getRealRecrived() {
        return realRecrived;
    }

    public void setRealRecrived(BigDecimal realRecrived) {
        this.realRecrived = realRecrived;
    }
    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public String getReportingMonth() {
        return reportingMonth;
    }

    public void setReportingMonth(String reportingMonth) {
        this.reportingMonth = reportingMonth;
    }
}
