package com.ejianc.business.analysis.mapper;

import com.ejianc.business.analysis.bean.ActualValueEntity;
import com.ejianc.business.analysis.vo.ActualValueVO;
import com.ejianc.business.analysis.vo.ProDurationDelayVO;
import com.ejianc.business.analysis.vo.ProjectBusinessVO;
import com.ejianc.business.analysis.vo.ProjectPaymentVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 成本
 *
 * @author generator
 *
 */
@Mapper
public interface PortalMapper extends BaseCrudMapper<ActualValueEntity> {

    //产值效益分析
    List<ActualValueVO> getOutputValueBenefitAnalysis(Map<String,Object> params);

    //中建科技项目商务策划分析管理报表
    List<ProjectBusinessVO> getBusinessPlan(Map<String,Object> params);

    //工程确权收付款情况
    List<ProjectPaymentVO> getOutputValueConfirmationRate(Map<String, Object> param);

    //工期延误项目成本风险化解情况
    List<ProDurationDelayVO> getScheduleDelay(Map<String, Object> param);
}
