package com.ejianc.business.analysis.mapper;

import com.ejianc.business.analysis.vo.ProjectCheckVO;
import com.ejianc.business.analysis.vo.ProjectIndexVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.analysis.bean.ProjectCheckEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 项目考核兑现统计表
 * 
 * @author generator
 * 
 */
@Mapper
public interface ProjectCheckMapper extends BaseCrudMapper<ProjectCheckEntity> {

    //查询项目优化立项申报
    List<ProjectCheckVO> quertOptimization(@Param("projectIdList") List<Long> projectIdList);

    //查询项目优化奖励申请
    List<ProjectCheckVO> quertReward(@Param("projectIdList") List<Long> projectIdList);

    //查询项目过程奖分析考核
    List<ProjectCheckVO> quertAssess(@Param("projectIdList") List<Long> projectIdList);

    //查询工程项目过程目标奖金审批
    List<ProjectCheckVO> quertApproval(@Param("projectIdList") List<Long> projectIdList);

    //查询过程目标奖金考核发放
    List<ProjectCheckVO> quertNodeGrant(@Param("projectIdList") List<Long> projectIdList);

    //查询目标责任书竣工兑现审批
    List<ProjectCheckVO> quertFinishApprove(@Param("projectIdList") List<Long> projectIdList);

    //竣工目标考核奖金发放
    List<ProjectCheckVO> quertFinishOut(@Param("projectIdList") List<Long> projectIdList);

    //兑现预留奖金返还审批
    List<ProjectCheckVO> quertFinishRefund(@Param("projectIdList") List<Long> projectIdList);

    //总包结算考核奖审批
    List<ProjectCheckVO> quertGeneralApproval(@Param("projectIdList") List<Long> projectIdList);


















}
