package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.FeeEntity;
import com.ejianc.business.analysis.mapper.*;
import com.ejianc.business.analysis.service.IFeeService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.analysis.bean.BusinessEntity;
import com.ejianc.business.analysis.service.IBusinessService;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 项目目标管理及运营情况分析表
 * 
 * @author generator
 * 
 */
@Service("businessService")
public class BusinessServiceImpl extends BaseServiceImpl<BusinessMapper, BusinessEntity> implements IBusinessService{
    @Autowired
    private IBusinessService businessService;
    @Autowired
    private BusinessMapper businessMapper;
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;
    @Autowired
    private ConstructionBudgetMapper constructionBudgetMapper;
    @Autowired
    private ProSignReserveMapper proSignReserveMapper;
    @Autowired
    private ProjectBusinessMapper projectBusinessMapper;
    @Autowired
    private ProjectPaymentMapper projectPaymentMapper;
    @Autowired
    private GoldMapper goldMapper;
    @Autowired
    private ProfitMapper profitMapper;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IDefdocApi defdocApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        //获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);

        //先删后增
        LambdaQueryWrapper<BusinessEntity> lambdaFee = Wrappers.<BusinessEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaFee.in(BusinessEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(BusinessEntity::getReportingMonth, reportingMonth);
        businessService.remove(lambdaFee);

        //查询项目信息数据
        List<ProfitIncomeVO> profitIncomeVOList = new ArrayList<>();
        //过滤掉公司费用类公共项目
        CommonResponse<List<DefdocDetailVO>> plProject = defdocApi.getDefDocByDefCode("pl_project");
        if (!plProject.isSuccess()){
            throw new BusinessException("根据档案编码查询档案项失败!");
        }
        List<DefdocDetailVO> defdocDetailVOList = plProject.getData();

        Map<String, List<DefdocDetailVO>> nameMap = new HashMap<>();

        if (CollectionUtils.isNotEmpty(defdocDetailVOList)){
            nameMap =defdocDetailVOList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getName()
                    ));
        }

        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(projectIdList,2);
        }else{
            //等于1代表预生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(null,2);
        }

        //过滤掉过滤掉公司费用类公共项目
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)){
            Map<String, List<DefdocDetailVO>> finalNameMap = nameMap;
            profitIncomeVOList = profitIncomeVOList.stream().filter(s-> !finalNameMap.containsKey(s.getProjectName())).collect(Collectors.toList());
        }

        //获取间接费明细数据
        //获取当年月初的年月
        String yearMonth = CommonUtils.getSysYearAndFirstMonth();

        //施工图预算编制情况--数据
        //查询合同信息
        List<ConstructionBudgetVO> constructionBudgetVOS = new ArrayList<>();
        //查询施工图
        List<ConstructionBudgetVO> conDrawList = new ArrayList<>();
        constructionBudgetVOS= constructionBudgetMapper.getContract(projectIdList);
        conDrawList= constructionBudgetMapper.getDraw(projectIdList);
        Map<Long, ConstructionBudgetVO> constructionBudgetMap = new HashMap<>();
        //间接费+其他费map
        Map<Long, ProjectPaymentVO> mxMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(constructionBudgetVOS)) {
            constructionBudgetMap = constructionBudgetVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        Map<Long, ConstructionBudgetVO> conDrawMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(conDrawList)) {
            conDrawMap = conDrawList.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }

//        项目责任书签订及风险金预留情况
        // 查询项目目标管理责任书
        List<ProSignReserveVO> bookVOS = proSignReserveMapper.queryBook(projectIdList);
        Map<Long, ProSignReserveVO> bookMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(bookVOS)) {
            bookMap = bookVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }

//        中建科技项目商务策划分析管理报表
        //查询商务策划会签
        List<ProjectBusinessVO> countersignatureList = projectBusinessMapper.queryCountersignature(projectIdList);
        //查询项目商务策划效果
        List<ProjectBusinessVO> businessplanningeffectList = projectBusinessMapper.queryBusinessplanningeffect(projectIdList);
        Map<Long, ProjectBusinessVO> businessplanningeffectListMap = businessplanningeffectList.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        Map<Long, List<ProjectBusinessVO>> countersignatureListMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(countersignatureList)){
            countersignatureListMap = countersignatureList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getProjectId()
                    ));
        }
        List<BusinessVO> businessVORiskList = businessMapper.getRiskMny(reportingMonth,projectIdList);
        Map<Long, List<BusinessVO>> mapRisk = new HashMap<>();

        if (CollectionUtils.isNotEmpty(businessVORiskList)){
            mapRisk = businessVORiskList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getProjectId()
                    ));
        }

        //取生效的《月度成本分析》当月的-本期产值收入
        Map<Long, BusinessVO> CurrentMonthMap = new HashMap<>();
        List<BusinessVO> currentMonthList = businessMapper.getCurrentMonthMny(reportingMonth,projectIdList);
        if (CollectionUtils.isNotEmpty(currentMonthList)){
            CurrentMonthMap = currentMonthList.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }
        //查询实际成本本年值
        List<ProjectPaymentVO> costanalysisList = projectPaymentMapper.quertCostanalysis(yearMonth, reportingMonth, projectIdList);
        Map<Long, ProjectPaymentVO> costanalysisListMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(costanalysisList)){
            costanalysisListMap = costanalysisList.stream()
                    .collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }

        //查询中间计量工程计量开累值
        List<ProjectPaymentVO> enginnerTotalList = projectPaymentMapper.quertEngineermeasurementTotal(reportingMonth, projectIdList);
        Map<Long, ProjectPaymentVO> enginnerTotalListMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(enginnerTotalList)){
            enginnerTotalListMap = enginnerTotalList.stream()
                    .collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }
        //查询实际成本开累值
        List<ProjectPaymentVO> costanalysisTotalList = projectPaymentMapper.quertCostanalysisTotal(reportingMonth, projectIdList);

        Map<Long, List<ProjectPaymentVO>> costanalysisTotalListMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(costanalysisTotalList)){
            costanalysisTotalListMap = costanalysisTotalList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getProjectId()
                    ));
        }


//        Map<Long, ProjectPaymentVO> costanalysisTotalListMap = new HashMap<>();
//        if(CollectionUtils.isNotEmpty(costanalysisTotalList)){
//            costanalysisTotalListMap = costanalysisTotalList.stream()
//                    .collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
//        }

        List<BusinessVO> sumMonthList = businessMapper.getSumMonthMny(reportingMonth,projectIdList);
        Map<Long, List<BusinessVO>> sumMonthMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(sumMonthList)){
            sumMonthMap = sumMonthList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getProjectId()
                    ));
        }

        //项目财务两金分析
        List<GoldVO> ljData = goldMapper.getLjData(reportingMonth, projectIdList);
        Map<Long, List<GoldVO>> mapLj = new HashMap<>();
        if (CollectionUtils.isNotEmpty(ljData)){
            mapLj = ljData.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getProjectId()
                    ));
        }

        //获取财务累计列报收入数据
        List<ProfitVO> bqData = profitMapper.getIncomeData(reportingMonth, projectIdList);

        Map<Long, List<ProfitVO>> mapIncome = new HashMap<>();
        if (CollectionUtils.isNotEmpty(bqData)){
            mapIncome = bqData.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getProjectId()
                    ));
        }

        //获取累计值
        List<ProfitVO> ljDataProfit = profitMapper.getLjData(reportingMonth, projectIdList);

        Map<Long, List<ProfitVO>> mapLjProfit = new HashMap<>();
        if (CollectionUtils.isNotEmpty(ljDataProfit)){
            mapLjProfit = ljDataProfit.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getProjectId()
                    ));
        }

        //查询付款登记
        List<ProjectPaymentVO> quertPaymentTotalList = projectPaymentMapper.quertPaymentTotal(reportingMonth,projectIdList);
        Map<Long, List<ProjectPaymentVO>> quertPaymentTotalListMap = new HashMap<>();
        //查询实际成本
        List<ProjectPaymentVO> quertAnalysisList = projectPaymentMapper.quertAnalysis(reportingMonth,projectIdList);
        if(CollectionUtils.isNotEmpty(quertPaymentTotalList)){
            quertPaymentTotalListMap = quertPaymentTotalList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getProjectId()
                    ));

//            quertPaymentTotalListMap = quertPaymentTotalList.stream()
//                    .collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));

        }

        //应付款金额，已付款金额赋值
        if(CollectionUtils.isNotEmpty(quertAnalysisList)){
            List<ProjectPaymentVO> projectPaymentVOList1 = new ArrayList<>();
            Map<Long, List<ProjectPaymentVO>> quertAnalysisListGrBy =quertAnalysisList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getProjectId()
                    ));

            //遍历
            quertAnalysisListGrBy.forEach((orgStatusKey,orgStatusList)->{
                //排序
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ProjectPaymentVO::getReportingMonth).reversed())
                        .collect(Collectors.toList());
                projectPaymentVOList1.add(orgStatusList.stream().findFirst().get());
            });

            List<Long> idList = new ArrayList<>();
            for(ProjectPaymentVO paymentVO : projectPaymentVOList1){
                idList.add(paymentVO.getAnalysisId());
            }
            if(CollectionUtils.isNotEmpty(idList)){
                //实际成本明细
                List<ProjectPaymentVO>  quertCosthuizongList = projectPaymentMapper.quertCosthuizong(idList);
                if(CollectionUtils.isNotEmpty(quertCosthuizongList)){
                    Map<Long, List<ProjectPaymentVO>> quertCosthuizongListMap = quertCosthuizongList.stream().collect(
                            Collectors.groupingBy(
                                    s -> s.getAnalysisId()
                            ));

                    for(ProjectPaymentVO paymentVO :projectPaymentVOList1){
                        if(quertCosthuizongListMap.containsKey(paymentVO.getAnalysisId())){
                            List<ProjectPaymentVO> projectPaymentVOList = quertCosthuizongListMap.get(paymentVO.getAnalysisId());
                            BigDecimal acostActual = projectPaymentVOList.stream().filter(s->s.getAcostActual()!=null).map(ProjectPaymentVO::getAcostActual)
                                    .reduce(BigDecimal.ZERO, BigDecimal::add);
                            paymentVO.setAcostActual(acostActual);//间接费+其他
                            BigDecimal havePaidTotal = projectPaymentVOList.stream().filter(s->s.getHavePaidTotal()!=null).map(ProjectPaymentVO::getHavePaidTotal)
                                    .reduce(BigDecimal.ZERO, BigDecimal::add);
                            paymentVO.setHavePaidTotal(havePaidTotal);//间接费+其他
                        }
                    }
                }


            }

            //间接费+其他
            if (CollectionUtils.isNotEmpty(projectPaymentVOList1)){
                mxMap = projectPaymentVOList1.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
            }
        }

//        if(CollectionUtils.isNotEmpty(quertAnalysisList)){
//            quertAnalysisListMap = quertAnalysisList.stream()
//                    .collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
//        }


        if (CollectionUtils.isNotEmpty(profitIncomeVOList)){
            List<BusinessVO> businessVOList = BeanMapper.mapList(profitIncomeVOList, BusinessVO.class);
            for (BusinessVO businessVO : businessVOList){
                businessVO.setReportingMonth(reportingMonth);//取当前生成月份日期
                businessVO.setCreateTime(new Date());
                Long projectId = businessVO.getProjectId();
                if(constructionBudgetMap.containsKey(businessVO.getProjectId())){
                    ConstructionBudgetVO constructionBudgetVO1 = constructionBudgetMap.get(businessVO.getProjectId());
                    businessVO.setSignContract(CommonUtils.parseNullValue(constructionBudgetVO1.getContractAmount()));
                    businessVO.setOneselfContract(CommonUtils.parseNullValue(constructionBudgetVO1.getSelfConstructionContractAmount()));
                }else{
                    businessVO.setSignContract(BigDecimal.ZERO);
                    businessVO.setOneselfContract(BigDecimal.ZERO);

                }
                if(conDrawMap.containsKey(businessVO.getProjectId())){
                    ConstructionBudgetVO constructionBudgetVO1 = conDrawMap.get(businessVO.getProjectId());
                    businessVO.setBudgetLimit(CommonUtils.parseNullValue(constructionBudgetVO1.getBudgetMny()));
                }else{
                    businessVO.setBudgetLimit(BigDecimal.ZERO);

                }

                if (!bookMap.isEmpty() && bookMap.containsKey(businessVO.getProjectId())) {
                    businessVO.setBookSignTime(bookMap.get(projectId).getBookSignTime());
                    businessVO.setResponsibilityCost(CommonUtils.setBigDecimalDefaultValue(bookMap.get(projectId).getResponsibilityCost()));
                    businessVO.setUndertakingBenefitsRate(CommonUtils.setBigDecimalDefaultValue(bookMap.get(projectId).getUndertakingBenefitsRate()));
                    businessVO.setOverallProfitMargin(bookMap.get(projectId).getAllScale());
                }else{
                    businessVO.setResponsibilityCost(BigDecimal.ZERO);
                    businessVO.setUndertakingBenefitsRate(BigDecimal.ZERO);
                    businessVO.setOverallProfitMargin(BigDecimal.ZERO);
                }

                if(businessplanningeffectListMap.containsKey(businessVO.getProjectId())){
                    ProjectBusinessVO projectBusinessVO1 = businessplanningeffectListMap.get(businessVO.getProjectId());
                    businessVO.setApprovalTotal(CommonUtils.isIntNull(projectBusinessVO1.getSetUpItem()));
                    businessVO.setPredictMoney(CommonUtils.parseNullValue(projectBusinessVO1.getExpectEffect()));
                    businessVO.setAmount(CommonUtils.isIntNull(projectBusinessVO1.getImplementItem()));
                    businessVO.setPlanMoney(CommonUtils.parseNullValue(projectBusinessVO1.getPlanEffect()));
                }else{
                    businessVO.setApprovalTotal(0);
                    businessVO.setPredictMoney(BigDecimal.ZERO);
                    businessVO.setAmount(0);
                    businessVO.setPlanMoney(BigDecimal.ZERO);
                }
                if(countersignatureListMap.containsKey(businessVO.getProjectId())){
                    List<ProjectBusinessVO> projectBusinessVOS = countersignatureListMap.get(businessVO.getProjectId());
                    businessVO.setBusinessFlag(projectBusinessVOS.size() > 0 ? "是":"否");
                }else{
                    businessVO.setBusinessFlag("否");
                }

                if (mapRisk.containsKey(businessVO.getProjectId())){
                    List<BusinessVO> feeVOS = mapRisk.get(businessVO.getProjectId());
                    //排序获取最近的月份数据
                    List<BusinessVO> collectCompare = feeVOS.stream().sorted(Comparator.comparing(BusinessVO::getReportingMonth).reversed())
                            .collect(Collectors.toList());
                    BusinessVO feeVOLj = collectCompare.stream().findFirst().get();
                    businessVO.setYylMny(CommonUtils.parseNullValue(feeVOLj.getYylMny()));
                    businessVO.setActualMny(CommonUtils.parseNullValue(feeVOLj.getActualMny()));
                }else{
                    businessVO.setYylMny(BigDecimal.ZERO);
                    businessVO.setActualMny(BigDecimal.ZERO);
                }

                if (CurrentMonthMap.containsKey(businessVO.getProjectId())){
                    BusinessVO feeVOS = CurrentMonthMap.get(businessVO.getProjectId());
                    businessVO.setProductionMoney(CommonUtils.parseNullValue(feeVOS.getProductionMoney()));
                    businessVO.setActualCostMoney(CommonUtils.parseNullValue(feeVOS.getActualCostMoney()));
                }else{
                    businessVO.setProductionMoney(BigDecimal.ZERO);
                    businessVO.setActualCostMoney(BigDecimal.ZERO);
                }

                //筛入实际成本本年值
                if(costanalysisListMap.containsKey(businessVO.getProjectId())){
                    ProjectPaymentVO paymentVO = costanalysisListMap.get(businessVO.getProjectId());
                    businessVO.setActualFinishProductionNear(CommonUtils.parseNullValue(paymentVO.getActualFinishProductionNear()));
                }else{
                    businessVO.setActualFinishProductionNear(BigDecimal.ZERO);
                }

                //筛入中间计量开累值
                if(enginnerTotalListMap.containsKey(businessVO.getProjectId())){
                    ProjectPaymentVO paymentVO = enginnerTotalListMap.get(businessVO.getProjectId());
                    businessVO.setOwnerAffirmProduction(CommonUtils.parseNullValue(paymentVO.getOwnerAffirmProduction()));
                }else{
                    businessVO.setOwnerAffirmProduction(BigDecimal.ZERO);
                }


                //筛入实际成本开累值
                if(costanalysisTotalListMap.containsKey(businessVO.getProjectId())){

                    List<ProjectPaymentVO> paymentVOList = costanalysisTotalListMap.get(businessVO.getProjectId());
                    List<ProjectPaymentVO> collectCompare = paymentVOList.stream().sorted(Comparator.comparing(ProjectPaymentVO::getReportingMonth).reversed())
                            .collect(Collectors.toList());
                    ProjectPaymentVO paymentVO = collectCompare.stream().findFirst().get();
                    businessVO.setActualFinishProduction(CommonUtils.parseNullValue(paymentVO.getActualFinishProduction()));
                }else{
                    businessVO.setActualFinishProduction(BigDecimal.ZERO);
                }
//如果项目状态=已竣已结算  业主确认产值=实际完成产值
                if(businessVO.getProjectStatus() != null && businessVO.getProjectStatus() == 6){
                    businessVO.setOwnerAffirmProduction(CommonUtils.setBigDecimalDefaultValue(businessVO.getActualFinishProduction()));
                }
                if (sumMonthMap.containsKey(businessVO.getProjectId())){
                    List<BusinessVO> feeVOS = sumMonthMap.get(businessVO.getProjectId());
                    //排序获取最近的月份数据
                    List<BusinessVO> collectCompare = feeVOS.stream().sorted(Comparator.comparing(BusinessVO::getReportingMonth).reversed())
                            .collect(Collectors.toList());
                    BusinessVO feeVOLj = collectCompare.stream().findFirst().get();
                    businessVO.setSumActualCostMoney(CommonUtils.parseNullValue(feeVOLj.getSumActualCostMoney()));
                    businessVO.setSumResponseCostMoney(CommonUtils.parseNullValue(feeVOLj.getSumResponseCostMoney()));
                }else{
                    businessVO.setSumActualCostMoney(BigDecimal.ZERO);
                    businessVO.setSumResponseCostMoney(BigDecimal.ZERO);
                }

                //设置累计值
                if (mapLj.containsKey(businessVO.getProjectId())){
                    List<GoldVO> feeVOS = mapLj.get(businessVO.getProjectId());
                    //排序获取最近的月份数据
                    List<GoldVO> collectCompare = feeVOS.stream().sorted(Comparator.comparing(GoldVO::getReportingMonth).reversed())
                            .collect(Collectors.toList());
                    GoldVO feeVOLj = collectCompare.stream().findFirst().get();
                    businessVO.setCompletedBalance(CommonUtils.parseNullValue(feeVOLj.getCompletedBalance()));
                    businessVO.setStockUp(CommonUtils.parseNullValue(feeVOLj.getStockUp()));
                    businessVO.setAccountReceive(CommonUtils.parseNullValue(feeVOLj.getAccountReceive()));
                }else{
                    businessVO.setCompletedBalance(BigDecimal.ZERO);
                    businessVO.setStockUp(BigDecimal.ZERO);
                    businessVO.setAccountReceive(BigDecimal.ZERO);
                }

                //设置累计值
                if (mapLjProfit.containsKey(businessVO.getProjectId())){
                    List<ProfitVO> feeVOS = mapLjProfit.get(businessVO.getProjectId());
                    //排序获取最近的月份数据
                    List<ProfitVO> collectCompare = feeVOS.stream().sorted(Comparator.comparing(ProfitVO::getReportingMonth).reversed())
                            .collect(Collectors.toList());
                    ProfitVO feeVOLj = collectCompare.stream().findFirst().get();
                    businessVO.setCostMny(CommonUtils.parseNullValue(feeVOLj.getCostMny()));
                }else{
                    businessVO.setCostMny(BigDecimal.ZERO);
                }

                //设置财务累计列报收入
                if (mapIncome.containsKey(businessVO.getProjectId())){
                    List<ProfitVO> feeVOS = mapIncome.get(businessVO.getProjectId());
                    List<ProfitVO> collectCompare = feeVOS.stream().sorted(Comparator.comparing(ProfitVO::getReportingMonth).reversed())
                            .collect(Collectors.toList());
                    ProfitVO feeVOIncome = collectCompare.stream().findFirst().get();
                    businessVO.setIncomeMny(CommonUtils.parseNullValue(feeVOIncome.getIncomeMny()));
                }else{
                    businessVO.setIncomeMny(BigDecimal.ZERO);
                }

                if(CollectionUtils.isNotEmpty(enginnerTotalList)){
                    if(enginnerTotalListMap.containsKey(businessVO.getProjectId())){
                        ProjectPaymentVO paymentVO = enginnerTotalListMap.get(businessVO.getProjectId());
                        businessVO.setContractReceipt(CommonUtils.parseNullValue(paymentVO.getContractReceipt()));
                        businessVO.setProjectFunds(CommonUtils.parseNullValue(paymentVO.getProjectFunds()));
                    }else{
                        businessVO.setContractReceipt(BigDecimal.ZERO);
                        businessVO.setProjectFunds(BigDecimal.ZERO);
                    }
                }
                //筛入实际成本开累值
                if(quertPaymentTotalListMap.containsKey(businessVO.getProjectId())){
                    List<ProjectPaymentVO> paymentVOList = quertPaymentTotalListMap.get(businessVO.getProjectId());
                    List<ProjectPaymentVO> collectCompare = paymentVOList.stream().sorted(Comparator.comparing(ProjectPaymentVO::getReportingMonth).reversed())
                            .collect(Collectors.toList());
                    ProjectPaymentVO projectPaymentVO = collectCompare.stream().findFirst().get();
                    businessVO.setAmountPayable(CommonUtils.parseNullValue(projectPaymentVO.getAccountsPayableTotal()));
                    businessVO.setAmountPaid(CommonUtils.parseNullValue(projectPaymentVO.getHavePaidTotal()));
                }
                //取值间接费+其他 实际成本开累值
                if(mxMap.containsKey(businessVO.getProjectId())){
                    ProjectPaymentVO paymentVO = mxMap.get(businessVO.getProjectId());
                    businessVO.setAmountPayable(ComputeUtil.safeAdd(CommonUtils.parseNullValue(businessVO.getAmountPayable()),CommonUtils.parseNullValue(paymentVO.getHavePaidTotal())));//应付款金额
                    businessVO.setAmountPaid(ComputeUtil.safeAdd(CommonUtils.parseNullValue(businessVO.getAmountPaid()),CommonUtils.parseNullValue(paymentVO.getAcostActual())));//已付款金额
                }
                businessVO.setAmountPayable(businessVO.getAmountPayable() == null ? BigDecimal.ZERO : businessVO.getAmountPayable());
                businessVO.setAmountPaid(businessVO.getAmountPaid() == null ? BigDecimal.ZERO : businessVO.getAmountPaid());


                        //补全二级组织信息
                CommonResponse<OrgVO> orgVo = orgApi.detailById(businessVO.getProjectDepartmentId());//此处是项目部id 1286211352287834113
                if (orgVo.isSuccess() && null != orgVo.getData()) {
                    String innerCode = orgVo.getData().getInnerCode();
                    String[] strs = innerCode.split("\\|");
                    CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                    if (orgVos.isSuccess() && null != orgVos.getData()) {
                        //二级组织信息
                        businessVO.setTwoOrgId(orgVos.getData().getId());
                        businessVO.setTwoOrgName(orgVos.getData().getShortName());
                        businessVO.setTwoOrgCode(orgVos.getData().getCode());
                        businessVO.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());
                    }
                }
            }

            List<BusinessEntity> feeEntityList = BeanMapper.mapList(businessVOList, BusinessEntity.class);
            businessService.saveBatch(feeEntityList);
        }

    }

    @Override
    public List<BusinessVO> dealData(List<BusinessVO> feeVOS) {
        //转万元
        for(BusinessVO feeVO : feeVOS){
            feeVO.setSignContract(CommonUtils.parseYuanToWan(feeVO.getSignContract()));
            feeVO.setOneselfContract(CommonUtils.parseYuanToWan(feeVO.getOneselfContract()));
            feeVO.setBudgetLimit(CommonUtils.parseYuanToWan(feeVO.getBudgetLimit()));
            feeVO.setResponsibilityCost(CommonUtils.parseYuanToWan(feeVO.getResponsibilityCost()));
            feeVO.setYylMny(CommonUtils.parseYuanToWan(feeVO.getYylMny()));
            feeVO.setActualMny(CommonUtils.parseYuanToWan(feeVO.getActualMny()));
//            feeVO.setPredictMoney(CommonUtils.parseYuanToWan(feeVO.getPredictMoney()));
//            feeVO.setPlanMoney(CommonUtils.parseYuanToWan(feeVO.getPlanMoney()));
            feeVO.setProductionMoney(CommonUtils.parseYuanToWan(feeVO.getProductionMoney()));
            feeVO.setActualCostMoney(CommonUtils.parseYuanToWan(feeVO.getActualCostMoney()));
            feeVO.setSumResponseCostMoney(CommonUtils.parseYuanToWan(feeVO.getSumResponseCostMoney()));
            feeVO.setActualFinishProductionNear(CommonUtils.parseYuanToWan(feeVO.getActualFinishProductionNear()));
            feeVO.setOwnerAffirmProduction(CommonUtils.parseYuanToWan(feeVO.getOwnerAffirmProduction()));
            feeVO.setActualFinishProduction(CommonUtils.parseYuanToWan(feeVO.getActualFinishProduction()));
            feeVO.setProfitMny(CommonUtils.parseYuanToWan(feeVO.getProfitMny()));
            feeVO.setCompletedBalance(CommonUtils.parseYuanToWan(feeVO.getCompletedBalance()));
            feeVO.setStockUp(CommonUtils.parseYuanToWan(feeVO.getStockUp()));
            feeVO.setAccountReceive(CommonUtils.parseYuanToWan(feeVO.getAccountReceive()));
            feeVO.setOutCostMny(CommonUtils.parseYuanToWan(feeVO.getOutCostMny()));
            feeVO.setIncomeMny(CommonUtils.parseYuanToWan(feeVO.getIncomeMny()));
            feeVO.setCostMny(CommonUtils.parseYuanToWan(feeVO.getCostMny()));
            feeVO.setContractReceipt(CommonUtils.parseYuanToWan(feeVO.getContractReceipt()));
            feeVO.setProjectFunds(CommonUtils.parseYuanToWan(feeVO.getProjectFunds()));
            feeVO.setAdvance(CommonUtils.parseYuanToWan(feeVO.getAdvance()));
            feeVO.setYswsMoney(CommonUtils.parseYuanToWan(feeVO.getYswsMoney()));
            feeVO.setAmountPayable(CommonUtils.parseYuanToWan(feeVO.getAmountPayable()));
            feeVO.setAmountPaid(CommonUtils.parseYuanToWan(feeVO.getAmountPaid()));
            feeVO.setContractYfwfMny(CommonUtils.parseYuanToWan(feeVO.getContractYfwfMny()));
            feeVO.setSumActualCostMoney(CommonUtils.parseYuanToWan(feeVO.getSumActualCostMoney()));
            //计算
            feeVO.setActualProfitMoney(feeVO.getProductionMoney().subtract(feeVO.getActualCostMoney()));
            feeVO.setDifferenceMoney(feeVO.getSumResponseCostMoney().subtract(feeVO.getSumActualCostMoney()));
            feeVO.setProfitMny(feeVO.getActualFinishProduction().subtract(feeVO.getSumActualCostMoney()));
            feeVO.setOutIncomeMny(feeVO.getActualFinishProduction().divide(new BigDecimal(1.09),0,BigDecimal.ROUND_HALF_UP).subtract(feeVO.getIncomeMny()));
            feeVO.setOutCostMny(feeVO.getSumActualCostMoney().divide(new BigDecimal(1.09),0,BigDecimal.ROUND_HALF_UP).subtract(feeVO.getCostMny()));
            feeVO.setReportProfitMny(feeVO.getIncomeMny().subtract(feeVO.getCostMny()));
            feeVO.setYswsMoney(feeVO.getContractReceipt().subtract(feeVO.getProjectFunds()));
            feeVO.setContractYfwfMny(feeVO.getAmountPayable().subtract(feeVO.getAmountPaid()));
        }

        //处理第一行合计值
        BusinessVO feeVO = new BusinessVO();
        ArrayList<BusinessVO> feeNewList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(feeVOS)){
            getSumData(feeVOS, feeVO);
            feeVO.setNumber("合计");
            feeVO.setId(IdWorker.getId());
            feeNewList.add(feeVO);
        }
        //计算排序字段
        for(BusinessVO feeVOrder :feeVOS){
            feeVOrder.setProjectStatusOrder(CommonUtils.getProjectOrderNum(feeVOrder.getProjectStatus()));
        }
        //计算项目状态合计
        feeVOS = feeVOS.stream().sorted(Comparator.comparing(BusinessVO::getProjectStatusOrder))
                .collect(Collectors.toList());
        Map<Integer, List<BusinessVO>> mapProjectStatusOrder = feeVOS.stream().collect(
                Collectors.groupingBy(
                        s -> s.getProjectStatusOrder()
                ));

        mapProjectStatusOrder.forEach((projectStatusKey,projectStatusList)->{
            BusinessVO projectStatusSumfeeVO = new BusinessVO();
            projectStatusSumfeeVO.setNumber("项目状态合计");
            projectStatusSumfeeVO.setId(IdWorker.getId());
            projectStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusNameProject(projectStatusKey));
            getSumData(projectStatusList, projectStatusSumfeeVO);
            feeNewList.add(projectStatusSumfeeVO);

            //计算组织状态合计
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(BusinessVO::getOrgStatusOrder))
                    .collect(Collectors.toList());
            Map<Integer, List<BusinessVO>> mapOrgStatusOrder = projectStatusList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getOrgStatusOrder()
                    ));
            mapOrgStatusOrder.forEach((orgStatusKey,orgStatusList)->{
                BusinessVO orgStatusSumfeeVO = new BusinessVO();
                orgStatusSumfeeVO.setNumber("单位小计");
                orgStatusSumfeeVO.setId(IdWorker.getId());
                orgStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(orgStatusList.stream().findFirst().get().getProjectStatus()));
                orgStatusSumfeeVO.setTwoOrgName(orgStatusList.stream().findFirst().get().getTwoOrgName());
                getSumData(orgStatusList, orgStatusSumfeeVO);
                feeNewList.add(orgStatusSumfeeVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(BusinessVO::getProjectCreateTime))
                        .collect(Collectors.toList());
                for (BusinessVO feeVONum : orgStatusList){
                    feeVONum.setNumber(number +"");
                    number = number + 1;
                    feeVONum.setProjectStatusName(CommonUtils.getProjectStatusName(feeVONum.getProjectStatus()));

                    //计算占比
                    feeVONum.setAffirmRate(CommonUtils.calculateRate(feeVONum.getOwnerAffirmProduction(),feeVONum.getSumActualCostMoney()));
                    feeVONum.setProductionRate(CommonUtils.calculateRate(feeVONum.getOwnerAffirmProduction(),feeVONum.getActualFinishProduction()));
                    feeVONum.setProfitRate(CommonUtils.calculateRate(feeVONum.getProfitMny(),feeVONum.getActualFinishProduction()));
                    feeVONum.setReportProfitRate(CommonUtils.calculateRate(feeVONum.getReportProfitMny(),feeVONum.getIncomeMny()));
                    feeVONum.setYswsRate(CommonUtils.calculateRate(feeVONum.getProjectFunds().add(feeVONum.getAdvance()),feeVONum.getOwnerAffirmProduction()));
                    feeVONum.setCostSxRate(CommonUtils.calculateRate(feeVONum.getProjectFunds().subtract(feeVONum.getAdvance()),feeVONum.getSumActualCostMoney()));
                    feeVONum.setCostFxRate(CommonUtils.calculateRate(feeVONum.getAmountPaid(),feeVONum.getSumActualCostMoney()));
                }
                feeNewList.addAll(orgStatusList);
            });

        });
        return feeNewList;
    }

    private void getSumData(List<BusinessVO> feeVOS, BusinessVO feeVO) {

        BigDecimal signContract = feeVOS.stream().map(BusinessVO::getSignContract).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal oneselfContract = feeVOS.stream().map(BusinessVO::getOneselfContract).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal budgetLimit = feeVOS.stream().map(BusinessVO::getBudgetLimit).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal responsibilityCost = feeVOS.stream().map(BusinessVO::getResponsibilityCost).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal yylMny = feeVOS.stream().map(BusinessVO::getYylMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualMny = feeVOS.stream().map(BusinessVO::getActualMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal predictMoney = feeVOS.stream().map(BusinessVO::getPredictMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal planMoney = feeVOS.stream().map(BusinessVO::getPlanMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal productionMoney = feeVOS.stream().map(BusinessVO::getProductionMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualCostMoney = feeVOS.stream().map(BusinessVO::getActualCostMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualProfitMoney = feeVOS.stream().map(BusinessVO::getActualProfitMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumResponseCostMoney = feeVOS.stream().map(BusinessVO::getSumResponseCostMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal differenceMoney = feeVOS.stream().map(BusinessVO::getDifferenceMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualFinishProductionNear = feeVOS.stream().map(BusinessVO::getActualFinishProductionNear).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal ownerAffirmProduction = feeVOS.stream().map(BusinessVO::getOwnerAffirmProduction).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualFinishProduction = feeVOS.stream().map(BusinessVO::getActualFinishProduction).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal profitMny = feeVOS.stream().map(BusinessVO::getProfitMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal completedBalance = feeVOS.stream().map(BusinessVO::getCompletedBalance).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal stockUp = feeVOS.stream().map(BusinessVO::getStockUp).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal accountReceive = feeVOS.stream().map(BusinessVO::getAccountReceive).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal outIncomeMny = feeVOS.stream().map(BusinessVO::getOutIncomeMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal outCostMny = feeVOS.stream().map(BusinessVO::getOutCostMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal incomeMny = feeVOS.stream().map(BusinessVO::getIncomeMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal costMny = feeVOS.stream().map(BusinessVO::getCostMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal reportProfitMny = feeVOS.stream().map(BusinessVO::getReportProfitMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal contractReceipt = feeVOS.stream().map(BusinessVO::getContractReceipt).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal projectFunds = feeVOS.stream().map(BusinessVO::getProjectFunds).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal advance = feeVOS.stream().map(BusinessVO::getAdvance).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal yswsMoney = feeVOS.stream().map(BusinessVO::getYswsMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amountPayable = feeVOS.stream().map(BusinessVO::getAmountPayable).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amountPaid = feeVOS.stream().map(BusinessVO::getAmountPaid).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal contractYfwfMny = feeVOS.stream().map(BusinessVO::getContractYfwfMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumActualCostMoney = feeVOS.stream().map(BusinessVO::getSumActualCostMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        Integer approvalTotal = feeVOS.stream().collect(Collectors.summingInt(BusinessVO::getApprovalTotal));
        Integer amount = feeVOS.stream().collect(Collectors.summingInt(BusinessVO::getAmount));

        //计算中标利润率
//        中标利润率计算规则：∑（所属项目合同额*项目中标利润率）/∑所属项目合同额；
//        目标责任书利润率计算规则：∑（所属项目合同额*项目目标责任书利润率）/∑所属项目合同额
        BigDecimal zblrData = BigDecimal.ZERO;
        BigDecimal mbzrsData = BigDecimal.ZERO;
        for (BusinessVO businessVO : feeVOS){
            //中标利润
            BigDecimal undertakingBenefitsRate = CommonUtils.setBigDecimalDefaultValue(businessVO.getUndertakingBenefitsRate());
            BigDecimal signContractData = CommonUtils.setBigDecimalDefaultValue(businessVO.getSignContract());
            BigDecimal oneselfContractData = CommonUtils.setBigDecimalDefaultValue(businessVO.getOneselfContract());
            zblrData = zblrData.add(signContractData.multiply(undertakingBenefitsRate.divide(new BigDecimal(100))));
            //目标责任书利润
            BigDecimal overallProfitMargin = CommonUtils.setBigDecimalDefaultValue(businessVO.getOverallProfitMargin());
            mbzrsData = mbzrsData.add(oneselfContractData.multiply(overallProfitMargin.divide(new BigDecimal(100))));
        }
        feeVO.setUndertakingBenefitsRate(CommonUtils.calculateRate(zblrData,signContract));
        feeVO.setOverallProfitMargin(CommonUtils.calculateRate(mbzrsData,oneselfContract));

        //赋值
        feeVO.setSignContract(signContract);
        feeVO.setOneselfContract(oneselfContract);
        feeVO.setBudgetLimit(budgetLimit);
        feeVO.setResponsibilityCost(responsibilityCost);
        feeVO.setYylMny(yylMny);
        feeVO.setActualMny(actualMny);
        feeVO.setPredictMoney(predictMoney);
        feeVO.setPlanMoney(planMoney);
        feeVO.setProductionMoney(productionMoney);
        feeVO.setActualCostMoney(actualCostMoney);
        feeVO.setActualProfitMoney(actualProfitMoney);
        feeVO.setSumResponseCostMoney(sumResponseCostMoney);
        feeVO.setDifferenceMoney(differenceMoney);
        feeVO.setActualFinishProductionNear(actualFinishProductionNear);
        feeVO.setOwnerAffirmProduction(ownerAffirmProduction);
        feeVO.setActualFinishProduction(actualFinishProduction);
        feeVO.setProfitMny(profitMny);
        feeVO.setCompletedBalance(completedBalance);
        feeVO.setStockUp(stockUp);
        feeVO.setAccountReceive(accountReceive);
        feeVO.setOutIncomeMny(outIncomeMny);
        feeVO.setOutCostMny(outCostMny);
        feeVO.setIncomeMny(incomeMny);
        feeVO.setCostMny(costMny);
        feeVO.setReportProfitMny(reportProfitMny);
        feeVO.setContractReceipt(contractReceipt);
        feeVO.setProjectFunds(projectFunds);
        feeVO.setAdvance(advance);
        feeVO.setYswsMoney(yswsMoney);
        feeVO.setAmountPayable(amountPayable);
        feeVO.setAmountPaid(amountPaid);
        feeVO.setContractYfwfMny(contractYfwfMny);
        feeVO.setSumActualCostMoney(sumActualCostMoney);
        feeVO.setApprovalTotal(approvalTotal);
        feeVO.setAmount(amount);
        //计算%
        feeVO.setAffirmRate(CommonUtils.calculateRate(feeVO.getOwnerAffirmProduction(),feeVO.getSumActualCostMoney()));
        feeVO.setProductionRate(CommonUtils.calculateRate(feeVO.getOwnerAffirmProduction(),feeVO.getActualFinishProduction()));
        feeVO.setProfitRate(CommonUtils.calculateRate(feeVO.getProfitMny(),feeVO.getActualFinishProduction()));
        feeVO.setReportProfitRate(CommonUtils.calculateRate(feeVO.getReportProfitMny(),feeVO.getIncomeMny()));
        feeVO.setYswsRate(CommonUtils.calculateRate(feeVO.getProjectFunds(),feeVO.getOwnerAffirmProduction()));
        feeVO.setCostSxRate(CommonUtils.calculateRate(feeVO.getProjectFunds().subtract(feeVO.getAdvance()),feeVO.getSumActualCostMoney()));
        feeVO.setCostFxRate(CommonUtils.calculateRate(feeVO.getAmountPaid(),feeVO.getSumActualCostMoney()));

    }
}
