package com.ejianc.business.analysis.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.FeeEntity;
import com.ejianc.business.analysis.mapper.ProjectPaymentMapper;
import com.ejianc.business.analysis.mapper.UnsettledProBusinessMapper;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.ibatis.annotations.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.analysis.mapper.ConstructProBusinessMapper;
import com.ejianc.business.analysis.bean.ConstructProBusinessEntity;
import com.ejianc.business.analysis.service.IConstructProBusinessService;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 在建项目商务报表
 *
 * @author generator
 *
 */
@Service("constructProBusinessService")
public class ConstructProBusinessServiceImpl extends BaseServiceImpl<ConstructProBusinessMapper, ConstructProBusinessEntity> implements IConstructProBusinessService{

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IConstructProBusinessService constructProBusinessService;
    @Autowired
    private ConstructProBusinessMapper constructProBusinessMapper;
    @Autowired
    private ProjectPaymentMapper projectPaymentMapper;
    @Autowired
    private UnsettledProBusinessMapper unsettledProBusinessMapper;
    @Autowired
    private IDefdocApi defdocApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        //获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        String dateLast = getEndDateLast();

        //先删后增
        LambdaQueryWrapper<ConstructProBusinessEntity> lambdaFee = Wrappers.<ConstructProBusinessEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaFee.in(ConstructProBusinessEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ConstructProBusinessEntity::getReportingMonth, reportingMonth);

        constructProBusinessService.remove(lambdaFee);

        //查询项目信息数据
        List<ConstructProBusinessVO> constructProBusinessVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            constructProBusinessVOList = constructProBusinessMapper.queryProjectIds(projectIdList);
        }else{
            //等于1代表预生成数据
            constructProBusinessVOList = constructProBusinessMapper.queryProjectIds(null);
        }

        //过滤掉公司费用类公共项目
        CommonResponse<List<DefdocDetailVO>> plProject = defdocApi.getDefDocByDefCode("pl_project");
        if (!plProject.isSuccess()){
            throw new BusinessException("根据档案编码查询档案项失败!");
        }
        List<DefdocDetailVO> defdocDetailVOList = plProject.getData();

        Map<String, List<DefdocDetailVO>> nameMap = new HashMap<>();

        if (CollectionUtils.isNotEmpty(defdocDetailVOList)){
            nameMap =defdocDetailVOList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getName()
                    ));
        }

//过滤掉过滤掉公司费用类公共项目
        if (CollectionUtils.isNotEmpty(constructProBusinessVOList)){
            Map<String, List<DefdocDetailVO>> finalNameMap = nameMap;
            constructProBusinessVOList = constructProBusinessVOList.stream().filter(s-> !finalNameMap.containsKey(s.getProjectName())).collect(Collectors.toList());
        }

        List<Long> projectIds = constructProBusinessVOList.stream().map(ConstructProBusinessVO::getProjectId).collect(Collectors.toList());
        // 查询施工类合同
        List<ConstructProBusinessVO> contractVOS = constructProBusinessMapper.queryContract(projectIds);
        Map<Long, ConstructProBusinessVO> contractMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(contractVOS)) {
            contractMap = contractVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }
        // 查询项目目标管理责任书
        List<ConstructProBusinessVO> bookVOS = constructProBusinessMapper.queryBook(projectIds);
        Map<Long, ConstructProBusinessVO> bookMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(bookVOS)) {
            bookMap = bookVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }
        // 查询项目商务策划会签
        List<ConstructProBusinessVO> countersignatureVOS = constructProBusinessMapper.queryCountersignature(projectIds);
        Map<Long, ConstructProBusinessVO> countersignatureMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(countersignatureVOS)) {
            countersignatureMap = countersignatureVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }
        // 查询项目商务策划效果
        List<ConstructProBusinessVO> businessplanningeffectVOS = constructProBusinessMapper.queryBusinessplanningeffect(projectIds);
        Map<Long, ConstructProBusinessVO> businessplanningeffectMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(businessplanningeffectVOS)) {
            businessplanningeffectMap = businessplanningeffectVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }
        //查询实际成本开累值
        List<ProjectPaymentVO> costanalysisTotalList = projectPaymentMapper.quertCostanalysisTotal(reportingMonth, projectIdList);

        Map<Long, List<ProjectPaymentVO>> costanalysisTotalListMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(costanalysisTotalList)){
            costanalysisTotalListMap = costanalysisTotalList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getProjectId()
                    ));
        }

        // 查询项目月度成本分析报告
//        List<ConstructProBusinessVO> costanalysisVOS = constructProBusinessMapper.queryCostanalysis(projectIds,reportingMonth);
//        Map<Long, ConstructProBusinessVO> costanalysisMap = new HashMap<>();
//        if (CollectionUtils.isNotEmpty(costanalysisVOS)) {
//            for (ConstructProBusinessVO costanalysisVO : costanalysisVOS) {
//                if (!costanalysisMap.containsKey(costanalysisVO.getProjectId())) {
//                    costanalysisMap.put(costanalysisVO.getProjectId(), costanalysisVO);
//                }else {
//                    if (costanalysisMap.get(costanalysisVO.getProjectId()).getContractIncome()==null && costanalysisVO.getContractIncome() != null) {
//                        costanalysisMap.get(costanalysisVO.getProjectId()).setContractIncome(costanalysisVO.getContractIncome());
//                    }
//                    if (costanalysisMap.get(costanalysisVO.getProjectId()).getRealCost()==null && costanalysisVO.getRealCost() != null) {
//                        costanalysisMap.get(costanalysisVO.getProjectId()).setRealCost(costanalysisVO.getRealCost());
//                    }
//                }
//            }
//        }
        // 查询项目月度成本分析报告往期值

        logger.info("dateLast"+dateLast);
        List<UnsettledProBusinessVO> costanalysisHistoryVOS = unsettledProBusinessMapper.queryCostanalysisHistory(projectIds,getEndDateLast());
        Map<Long,List<UnsettledProBusinessVO>> costanalysisHistoryGrBy = new HashMap<>();
        if (CollectionUtils.isNotEmpty(costanalysisHistoryVOS)) {
            costanalysisHistoryGrBy= costanalysisHistoryVOS.stream().collect(
                    Collectors.groupingBy(
                            s->s.getProjectId()
                    ));
        }

        // 查询工程计量台账
        List<ConstructProBusinessVO> engineermeasurementVOS = constructProBusinessMapper.queryEngineermeasurement(projectIds,reportingMonth);
        Map<Long, List<ConstructProBusinessVO>> engineermeasurementMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(engineermeasurementVOS)){
            engineermeasurementMap = engineermeasurementVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        // 查询工程计量台账往期值
        List<UnsettledProBusinessVO> engineermeasurementHistoryVOS = unsettledProBusinessMapper.queryEngineermeasurementHistory(projectIds,dateLast);
        logger.info("reportingLastMonth"+dateLast);
        Map<Long,List<UnsettledProBusinessVO>> engineermeasurementHistoryGrBy = new HashMap<>();
        if (CollectionUtils.isNotEmpty(engineermeasurementHistoryVOS)) {
            engineermeasurementHistoryGrBy= engineermeasurementHistoryVOS.stream().collect(
                    Collectors.groupingBy(
                            s->s.getProjectId()
                    ));
        }
        for (ConstructProBusinessVO vo : constructProBusinessVOList) {
            vo.setReportingMonth(reportingMonth);
            Long projectId = vo.getProjectId();
            if (!contractMap.isEmpty() && contractMap.containsKey(projectId)) {
                vo.setPromoter(contractMap.get(projectId).getPromoter());
                vo.setPromoterName(contractMap.get(projectId).getPromoterName());
                vo.setProjectLocation(contractMap.get(projectId).getProjectLocation());
                vo.setContractSignTime(contractMap.get(projectId).getContractSignTime());
                vo.setContractStartDate(contractMap.get(projectId).getContractStartDate());
                vo.setContractEndDate(contractMap.get(projectId).getContractEndDate());
                // 合同“变更后金额”有值时取值，否则取“合同签订金额”
//                vo.setContractAmount(contractMap.get(projectId).getAfterChangeAmount() != null ? contractMap.get(projectId).getAfterChangeAmount() : contractMap.get(projectId).getContractAmountByContract());
                vo.setContractAmount(contractMap.get(projectId).getContractAmountByContract());
                vo.setAcContractAmount(contractMap.get(projectId).getAcContractAmount());
            }
            if (!bookMap.isEmpty() && bookMap.containsKey(projectId)) {
                vo.setUndertakeRate(CommonUtils.setBigDecimalDefaultValue(bookMap.get(projectId).getUndertakeRate()));
                vo.setTargetRate(CommonUtils.setBigDecimalDefaultValue(bookMap.get(projectId).getTargetRate()));
                vo.setSignDate(bookMap.get(projectId).getSignDate());
            }
            if (!countersignatureMap.isEmpty() && countersignatureMap.containsKey(projectId)) {
                vo.setBusinessPlanApprovalDate(countersignatureMap.get(projectId).getBusinessPlanApprovalDate());
            }
            if (!businessplanningeffectMap.isEmpty() && businessplanningeffectMap.containsKey(projectId)) {
                vo.setPlanExpectedRevenueGenerationAmount(CommonUtils.parseNullValue(businessplanningeffectMap.get(projectId).getPlanExpectedRevenueGenerationAmount()));
                vo.setPlanRevenueGenerationAmount(CommonUtils.setBigDecimalDefaultValue(businessplanningeffectMap.get(projectId).getPlanRevenueGenerationAmount()));
            }
            if (!costanalysisHistoryGrBy.isEmpty() && costanalysisHistoryGrBy.containsKey(projectId)) {

                List<UnsettledProBusinessVO> businessVOList = costanalysisHistoryGrBy.get(projectId);

                List<UnsettledProBusinessVO> collectCompare = businessVOList.stream().sorted(Comparator.comparing(UnsettledProBusinessVO::getReportingMonth).reversed())
                        .collect(Collectors.toList());
                BigDecimal cumulativeIncome = collectCompare.stream().findFirst().get().getCumulativeIncome();
                vo.setCumulativeIncome(collectCompare.stream().findFirst().get().getCumulativeIncome());
                vo.setCumulativeIncomeYou(collectCompare.stream().findFirst().get().getCumulativeIncome());
            }
            if (!engineermeasurementHistoryGrBy.isEmpty() && engineermeasurementHistoryGrBy.containsKey(projectId)) {
                List<UnsettledProBusinessVO> businessVOList = engineermeasurementHistoryGrBy.get(projectId);
                List<UnsettledProBusinessVO> collectCompare = businessVOList.stream().sorted(Comparator.comparing(UnsettledProBusinessVO::getReportingMonth).reversed())
                        .collect(Collectors.toList());
                vo.setCumulativeBatch(collectCompare.stream().findFirst().get().getCumulativeBatch());
                vo.setCumulativeBatchYou(collectCompare.stream().findFirst().get().getCumulativeBatch());
            }
//            if (!costanalysisMap.isEmpty() && costanalysisMap.containsKey(projectId)) {
//                vo.setContractIncome(costanalysisMap.get(projectId).getContractIncome());
//                vo.setAcContractIncome(costanalysisMap.get(projectId).getContractIncome());
//                vo.setRealCost(costanalysisMap.get(projectId).getRealCost());
//                vo.setAcRealCost(costanalysisMap.get(projectId).getRealCost());
//            }

            //筛入实际成本开累值
            if(costanalysisTotalListMap.containsKey(projectId)){
                List<ProjectPaymentVO> paymentVOList = costanalysisTotalListMap.get(projectId);
                List<ProjectPaymentVO> collectCompare = paymentVOList.stream().sorted(Comparator.comparing(ProjectPaymentVO::getReportingMonth).reversed())
                        .collect(Collectors.toList());
                ProjectPaymentVO paymentVO = collectCompare.stream().findFirst().get();
                vo.setContractIncome(CommonUtils.parseNullValue(paymentVO.getActualFinishProduction()));
                vo.setAcContractIncome(CommonUtils.parseNullValue(paymentVO.getActualFinishProduction()));
                vo.setRealCost(CommonUtils.parseNullValue(paymentVO.getActualCost()));
                vo.setAcRealCost(CommonUtils.parseNullValue(paymentVO.getActualCost()));
            }

            if (!engineermeasurementMap.isEmpty() && engineermeasurementMap.containsKey(projectId)) {
                vo.setOwnerCrValue(engineermeasurementMap.get(projectId).stream().filter(s->s.getCurrentBatch() != null).map(it -> it.getCurrentBatch()).reduce(BigDecimal.ZERO, BigDecimal::add));
                vo.setOwnerCrAcValue(vo.getOwnerCrValue());
                vo.setContractReceivableMny(engineermeasurementMap.get(projectId).stream().filter(s->s.getCurrentReceivables() != null).map(it -> it.getCurrentReceivables()).reduce(BigDecimal.ZERO, BigDecimal::add));

                List<ConstructProBusinessVO> feeVOS = engineermeasurementMap.get(projectId);
                List<ConstructProBusinessVO> collectCompare = feeVOS.stream().sorted(Comparator.comparing(ConstructProBusinessVO::getReportingMonth).reversed())
                        .collect(Collectors.toList());
                ConstructProBusinessVO feeVOIncome = collectCompare.stream().findFirst().get();
                vo.setOperatingRevenue(feeVOIncome.getFinanceReportIncome());

                vo.setRealRecrived(engineermeasurementMap.get(projectId).stream().filter(s->s.getCurrentCollection() != null).map(it -> it.getCurrentCollection()).reduce(BigDecimal.ZERO, BigDecimal::add));
                vo.setSettlementFlag(1);// 是否办理其中结算  否:0  是:1
            } else {
                vo.setSettlementFlag(0);// 是否办理其中结算  否:0  是:1
            }
            //补全二级组织信息
            CommonResponse<OrgVO> orgVo = orgApi.detailById(vo.getProjectDepartmentId());
            if (orgVo.isSuccess() && null != orgVo.getData()) {
                String innerCode = orgVo.getData().getInnerCode();
                String[] strs = innerCode.split("\\|");
                CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                if (orgVos.isSuccess() && null != orgVos.getData()) {
                    //二级组织信息
                    vo.setThreeOrgId(orgVos.getData().getId());
                    vo.setThreeOrgName(orgVos.getData().getName());
                }
            }
            vo.setPergaContractAmountProportion(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(vo.getPlanExpectedRevenueGenerationAmount()), CommonUtils.setBigDecimalDefaultValue(vo.getAcContractAmount())));//策划预计创效金额占自施合同额比
            vo.setPrgaContractIncomeProportion(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(vo.getPlanRevenueGenerationAmount()), CommonUtils.setBigDecimalDefaultValue(vo.getAcContractIncome())));//策划创效金额占自施产值比
//            vo.setProfit(ComputeUtil.safeSub(CommonUtils.setBigDecimalDefaultValue(vo.getContractIncome()),CommonUtils.setBigDecimalDefaultValue(vo.getRealCost())));//利润
//            vo.setProfitRate(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(vo.getProfit()), CommonUtils.setBigDecimalDefaultValue(vo.getContractIncome())));//利润率(%)
//            vo.setAcProfitRate(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(vo.getProfit()), CommonUtils.setBigDecimalDefaultValue(vo.getAcContractIncome())));//自施利润率(%)
//            vo.setValueCrRate(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(vo.getOwnerCrValue()),CommonUtils.setBigDecimalDefaultValue(vo.getContractIncome())));//产值确权率(%)
//            vo.setAcValueCrRate(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(vo.getOwnerCrAcValue()), CommonUtils.setBigDecimalDefaultValue(vo.getAcContractIncome())));//自施产值确权率(%)
//            vo.setRevenueCrRate(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(vo.getOwnerCrValue()), CommonUtils.setBigDecimalDefaultValue(vo.getOperatingRevenue())));//营收确权率(%)
            if (vo.getFourOrgId() != null) {
                CommonResponse<OrgVO> fourOrgVO = orgApi.detailById(vo.getFourOrgId());
                if (fourOrgVO.isSuccess() && null != fourOrgVO.getData()) {
                    vo.setFourOrgName(fourOrgVO.getData().getName());// 股份公司四级单位
                }
            }
            if (vo.getContractorName() == null) {
                CommonResponse<OrgVO> orgVO = orgApi.detailById(vo.getContractor());
                if (orgVO.isSuccess() && null != orgVO.getData()) {
                    vo.setContractorName(orgVO.getData().getName());// 承包人名称
                }
            }
        }
        List<ConstructProBusinessEntity> constructProBusinessEntityList = BeanMapper.mapList(constructProBusinessVOList, ConstructProBusinessEntity.class);
        constructProBusinessService.saveBatch(constructProBusinessEntityList);
    }

    @Override
    public List<ConstructProBusinessVO> dealData(List<ConstructProBusinessVO> constructProBusinessVOS) {
        //转万元
        for (ConstructProBusinessVO constructProBusinessVO1 : constructProBusinessVOS){
            constructProBusinessVO1.setContractAmount(CommonUtils.parseYuanToWanZ(constructProBusinessVO1.getContractAmount()));
            constructProBusinessVO1.setAcContractAmount(CommonUtils.parseYuanToWanZ(constructProBusinessVO1.getAcContractAmount()));
//            constructProBusinessVO1.setPlanExpectedRevenueGenerationAmount(CommonUtils.parseYuanToWanZ(constructProBusinessVO1.getPlanExpectedRevenueGenerationAmount()));
//            constructProBusinessVO1.setPlanRevenueGenerationAmount(CommonUtils.parseYuanToWanZ(constructProBusinessVO1.getPlanRevenueGenerationAmount()));
            constructProBusinessVO1.setContractIncome(CommonUtils.parseYuanToWanZ(constructProBusinessVO1.getContractIncome()));
            constructProBusinessVO1.setAcContractIncome(CommonUtils.parseYuanToWanZ(constructProBusinessVO1.getAcContractIncome()));
            constructProBusinessVO1.setRealCost(CommonUtils.parseYuanToWanZ(constructProBusinessVO1.getRealCost()));
            constructProBusinessVO1.setAcRealCost(CommonUtils.parseYuanToWanZ(constructProBusinessVO1.getAcRealCost()));
//            constructProBusinessVO1.setProfit(CommonUtils.parseYuanToWanZ(constructProBusinessVO1.getProfit()));
            constructProBusinessVO1.setOwnerCrValue(CommonUtils.parseYuanToWanZ(constructProBusinessVO1.getOwnerCrValue()));
            constructProBusinessVO1.setOwnerCrAcValue(CommonUtils.parseYuanToWanZ(constructProBusinessVO1.getOwnerCrAcValue()));
            constructProBusinessVO1.setContractReceivableMny(CommonUtils.parseYuanToWanZ(constructProBusinessVO1.getContractReceivableMny()));
            constructProBusinessVO1.setOperatingRevenue(CommonUtils.parseYuanToWanZ(constructProBusinessVO1.getOperatingRevenue()));
            constructProBusinessVO1.setRealRecrived(CommonUtils.parseYuanToWanZ(constructProBusinessVO1.getRealRecrived()));
            constructProBusinessVO1.setCumulativeBatchYou(CommonUtils.parseYuanToWanZ(constructProBusinessVO1.getCumulativeBatchYou()));
            constructProBusinessVO1.setCumulativeBatch(CommonUtils.parseYuanToWanZ(constructProBusinessVO1.getCumulativeBatch()));
            constructProBusinessVO1.setCumulativeIncome(CommonUtils.parseYuanToWanZ(constructProBusinessVO1.getCumulativeIncome()));
            constructProBusinessVO1.setCumulativeIncomeYou(CommonUtils.parseYuanToWanZ(constructProBusinessVO1.getCumulativeIncomeYou()));
        }

        //处理第一行合计值
        ConstructProBusinessVO constructProBusinessVO = new ConstructProBusinessVO();
        ArrayList<ConstructProBusinessVO> newList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(constructProBusinessVOS)) {
            getSumDate(constructProBusinessVOS, constructProBusinessVO);
            constructProBusinessVO.setNumber("合计");
            constructProBusinessVO.setId(IdWorker.getId());
            newList.add(constructProBusinessVO);
        }
        Integer number = 1;
        for (ConstructProBusinessVO vo : constructProBusinessVOS) {
            vo.setNumber(String.valueOf(number));
            number++;
            vo.setProjectStatusName(CommonUtils.getProjectStatusName(vo.getProjectStatus()));
            vo.setProjectStatusNameTwo(CommonUtils.getProjectStatusName(vo.getProjectStatus()));
            vo.setProfit(ComputeUtil.safeSub(vo.getContractIncome(),vo.getRealCost()));
            vo.setProfitRate(CommonUtils.calculateRate(vo.getProfit(), (vo.getContractIncome())));//利润率(%)
            vo.setAcProfitRate(CommonUtils.calculateRate((vo.getProfit()), (vo.getAcContractIncome())));//自施利润率(%)
            vo.setValueCrRate(CommonUtils.calculateRate((vo.getOwnerCrValue()),(vo.getContractIncome())));//产值确权率(%)
            vo.setAcValueCrRate(CommonUtils.calculateRate((vo.getOwnerCrAcValue()), (vo.getAcContractIncome())));//自施产值确权率(%)
            vo.setRevenueCrRate(CommonUtils.calculateRate((vo.getOwnerCrValue()), CommonUtils.setBigDecimalDefaultValue(vo.getOperatingRevenue())));//营收确权率(%)
//            策划预计创效金额占自施合同额比=策划预计创效金额÷自施合同额（就是合同额期中：自施合同额）；策划创效金额占自施产值比=策划创效金额÷自施产值；
            vo.setPergaContractAmountProportion(CommonUtils.calculateRate(vo.getPlanExpectedRevenueGenerationAmount(),vo.getAcContractAmount()));
            vo.setPrgaContractIncomeProportion(CommonUtils.calculateRate(vo.getPlanRevenueGenerationAmount(),vo.getAcContractIncome()));


            switch (vo.getSettlementFlag()) {
                case 0:vo.setSettlementFlagName("否");break;
                case 1:vo.setSettlementFlagName("是");break;
            }
            switch (String.valueOf(vo.getProjectCategory())) {
                case "1470216164541710337":vo.setProjectCategoryName("工业厂房");break;
                case "1470216222511185922":vo.setProjectCategoryName("公共建筑");break;
                case "1470216274176622593":vo.setProjectCategoryName("民用住宅");break;
                case "1470216311648534530":vo.setProjectCategoryName("基础设施");break;
                case "1470216348239642626":vo.setProjectCategoryName("其它");break;
            }
        }

        newList.addAll(constructProBusinessVOS);
        return newList;
    }

    private void getSumDate(List<ConstructProBusinessVO> constructProBusinessVOS, ConstructProBusinessVO constructProBusinessVO) {

        constructProBusinessVO.setContractAmount(constructProBusinessVOS.stream().filter(s -> s.getContractAmount() != null).map(ConstructProBusinessVO::getContractAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setAcContractAmount(constructProBusinessVOS.stream().filter(s -> s.getAcContractAmount() != null).map(ConstructProBusinessVO::getAcContractAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setPlanExpectedRevenueGenerationAmount(constructProBusinessVOS.stream().filter(s -> s.getPlanExpectedRevenueGenerationAmount() != null).map(ConstructProBusinessVO::getPlanExpectedRevenueGenerationAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setPlanRevenueGenerationAmount(constructProBusinessVOS.stream().filter(s -> s.getPlanRevenueGenerationAmount() != null).map(ConstructProBusinessVO::getPlanRevenueGenerationAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setContractIncome(constructProBusinessVOS.stream().filter(s -> s.getContractIncome() != null).map(ConstructProBusinessVO::getContractIncome).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setAcContractIncome(constructProBusinessVOS.stream().filter(s -> s.getAcContractIncome() != null).map(ConstructProBusinessVO::getAcContractIncome).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setCumulativeIncome(constructProBusinessVOS.stream().filter(s -> s.getCumulativeIncome() != null).map(ConstructProBusinessVO::getCumulativeIncome).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setCumulativeIncomeYou(constructProBusinessVOS.stream().filter(s -> s.getCumulativeIncomeYou() != null).map(ConstructProBusinessVO::getCumulativeIncomeYou).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setCumulativeBatch(constructProBusinessVOS.stream().filter(s -> s.getCumulativeBatch() != null).map(ConstructProBusinessVO::getCumulativeBatch).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setCumulativeBatchYou(constructProBusinessVOS.stream().filter(s -> s.getCumulativeBatchYou() != null).map(ConstructProBusinessVO::getCumulativeBatchYou).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setRealCost(constructProBusinessVOS.stream().filter(s -> s.getRealCost() != null).map(ConstructProBusinessVO::getRealCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setAcRealCost(constructProBusinessVOS.stream().filter(s -> s.getAcRealCost() != null).map(ConstructProBusinessVO::getAcRealCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setOwnerCrValue(constructProBusinessVOS.stream().filter(s -> s.getOwnerCrValue() != null).map(ConstructProBusinessVO::getOwnerCrValue).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setOwnerCrAcValue(constructProBusinessVOS.stream().filter(s -> s.getOwnerCrAcValue() != null).map(ConstructProBusinessVO::getOwnerCrAcValue).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setContractReceivableMny(constructProBusinessVOS.stream().filter(s -> s.getContractReceivableMny() != null).map(ConstructProBusinessVO::getContractReceivableMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setOperatingRevenue(constructProBusinessVOS.stream().filter(s -> s.getOperatingRevenue() != null).map(ConstructProBusinessVO::getOperatingRevenue).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setRealRecrived(constructProBusinessVOS.stream().filter(s -> s.getRealRecrived() != null).map(ConstructProBusinessVO::getRealRecrived).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setProfit(ComputeUtil.safeSub(constructProBusinessVO.getContractIncome(),constructProBusinessVO.getRealCost()));
        constructProBusinessVO.setProfitRate(CommonUtils.calculateRate(constructProBusinessVO.getProfit(), (constructProBusinessVO.getContractIncome())));//利润率(%)
        constructProBusinessVO.setAcProfitRate(CommonUtils.calculateRate((constructProBusinessVO.getProfit()), (constructProBusinessVO.getAcContractIncome())));//自施利润率(%)
        constructProBusinessVO.setValueCrRate(CommonUtils.calculateRate((constructProBusinessVO.getOwnerCrValue()),(constructProBusinessVO.getContractIncome())));//产值确权率(%)
        constructProBusinessVO.setAcValueCrRate(CommonUtils.calculateRate((constructProBusinessVO.getOwnerCrAcValue()), (constructProBusinessVO.getAcContractIncome())));//自施产值确权率(%)
        constructProBusinessVO.setRevenueCrRate(CommonUtils.calculateRate((constructProBusinessVO.getOwnerCrValue()), CommonUtils.setBigDecimalDefaultValue(constructProBusinessVO.getOperatingRevenue())));//营收确权率(%)

        //汇总∑（向下所属项目自施合同额*承接效益率）/∑向下所属项目自施合同额
        //汇总∑（向下所属项目自施合同额*承接效益率）
        BigDecimal acContractAmount = BigDecimal.ZERO;
//        单位小计=∑（向下所属项目自施合同额*目标效益率）/∑向下所属项目自施合同额
//        状态合计=（向下所属项目自施合同额*目标效益率）/∑向下所属项目自施合同额
        //目标效益率计算
        BigDecimal OverallProfitMarginMny = BigDecimal.ZERO;
        for (ConstructProBusinessVO proSignReserve : constructProBusinessVOS){
            acContractAmount = acContractAmount.add(CommonUtils.parseNullValue(proSignReserve.getAcContractAmount()).multiply(CommonUtils.parseNullValue(proSignReserve.getUndertakeRate()).divide(new BigDecimal(100))));
            OverallProfitMarginMny = OverallProfitMarginMny.add(CommonUtils.parseNullValue(proSignReserve.getAcContractAmount()).multiply(CommonUtils.parseNullValue(proSignReserve.getTargetRate()).divide(new BigDecimal(100))));
        }
        constructProBusinessVO.setUndertakeRate(CommonUtils.calculateRate(acContractAmount,constructProBusinessVO.getAcContractAmount()));
        constructProBusinessVO.setTargetRate(CommonUtils.calculateRate(OverallProfitMarginMny,constructProBusinessVO.getAcContractAmount()));

//        策划预计创效金额占自施合同额比=策划预计创效金额÷自施合同额（就是合同额期中：自施合同额）；策划创效金额占自施产值比=策划创效金额÷自施产值；

        constructProBusinessVO.setPergaContractAmountProportion(CommonUtils.calculateRate(constructProBusinessVO.getPlanExpectedRevenueGenerationAmount(),constructProBusinessVO.getAcContractAmount()));
        constructProBusinessVO.setPrgaContractIncomeProportion(CommonUtils.calculateRate(constructProBusinessVO.getPlanRevenueGenerationAmount(),constructProBusinessVO.getAcContractIncome()));

    }

    //减去一年
    private static String getEndDateNear() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Calendar ca = Calendar.getInstance();
        ca.add(Calendar.YEAR, -1);
        Date d = ca.getTime();
        String endDate = format.format(d);
        return endDate;
    }
    //取值上一年末年月
    private static String getEndDateLast() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        Calendar ca = Calendar.getInstance();
        ca.add(Calendar.YEAR, -1);
        Date d = ca.getTime();
        String endDate = format.format(d);
        endDate = endDate + "-12";
        return endDate;
    }
}
