package com.ejianc.business.analysis.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.analysis.service.IPortalService;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;

/**
 * 门户
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("portal")
public class PortalController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPortalService service;

    //产值效益分析
    @RequestMapping(value = "/getOutputValueBenefitAnalysis", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getOutputValueBenefitAnalysis(@RequestParam(required = false) String section,
                                                                 @RequestParam(required = false) String year,
                                                                 @RequestParam(required = false) String projectStatus) {
        JSONObject json = service.getOutputValueBenefitAnalysis(section, year, projectStatus);
        return CommonResponse.success("查询详情数据成功！",json);
    }

    //目标责任分析
    @RequestMapping(value = "/getTargetResponsibilityAnalysis", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getTargetResponsibilityAnalysis(@RequestParam(required = false) String projectStatus) {
        JSONObject json = service.getTargetResponsibilityAnalysis(projectStatus);
        return CommonResponse.success("查询详情数据成功！",json);
    }

    //商务策划实施率
    @RequestMapping(value = "/getBusinessPlan", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getBusinessPlan() {
        JSONObject json = service.getBusinessPlan();
        return CommonResponse.success("查询详情数据成功！",json);
    }

    //产值确权率
    @RequestMapping(value = "/getOutputValueConfirmationRate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getOutputValueConfirmationRate() {
        JSONObject json = service.getOutputValueConfirmationRate();
        return CommonResponse.success("查询详情数据成功！",json);
    }

    //成本收现率、成本付现率
    @RequestMapping(value = "/getCostRate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getCostRate(@RequestParam(required = false) String projectStatus) {
        JSONObject json = service.getCostRate(projectStatus);
        return CommonResponse.success("查询详情数据成功！",json);
    }

    //工期延误增加成本情况
    @RequestMapping(value = "/getScheduleDelay", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getScheduleDelay() {
        JSONObject json = service.getScheduleDelay();
        return CommonResponse.success("查询详情数据成功！",json);
    }

}
