package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.FeeEntity;
import com.ejianc.business.analysis.bean.UnsettledProBusinessEntity;
import com.ejianc.business.analysis.mapper.ConstructionBudgetMapper;
import com.ejianc.business.analysis.mapper.ProSignReserveMapper;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.analysis.mapper.ActualValueMapper;
import com.ejianc.business.analysis.bean.ActualValueEntity;
import com.ejianc.business.analysis.service.IActualValueService;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 实际产值利润情况分析表
 *
 * @author generator
 *
 */
@Service("actualValueService")
public class ActualValueServiceImpl extends BaseServiceImpl<ActualValueMapper, ActualValueEntity> implements IActualValueService{
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IActualValueService actualValueService;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private ActualValueMapper actualValueMapper;
    @Autowired
    private ProSignReserveMapper proSignReserveMapper;
    @Autowired
    private ConstructionBudgetMapper constructionBudgetMapper;


    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        //获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);

        //先删后增
        LambdaQueryWrapper<ActualValueEntity> lambdaFee = Wrappers.<ActualValueEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaFee.in(ActualValueEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ActualValueEntity::getReportingMonth, reportingMonth);
        actualValueService.remove(lambdaFee);

        //查询项目信息数据
        List<ActualValueVO> actualValueVOList = new ArrayList<>();

        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            actualValueVOList = actualValueMapper.getProjects(projectIdList);
        }else{
            //等于1代表预生成数据
            actualValueVOList = actualValueMapper.getProjects(null);
        }
        //过滤掉公司费用类公共项目
        CommonResponse<List<DefdocDetailVO>> plProject = defdocApi.getDefDocByDefCode("pl_project");
        if (!plProject.isSuccess()){
            throw new BusinessException("根据档案编码查询档案项失败!");
        }
        List<DefdocDetailVO> defdocDetailVOList = plProject.getData();

        Map<String, List<DefdocDetailVO>> nameMap = new HashMap<>();

        if (CollectionUtils.isNotEmpty(defdocDetailVOList)){
            nameMap =defdocDetailVOList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getName()
                    ));
        }

        //过滤掉过滤掉公司费用类公共项目
        if (CollectionUtils.isNotEmpty(actualValueVOList)){
            Map<String, List<DefdocDetailVO>> finalNameMap = nameMap;
            actualValueVOList = actualValueVOList.stream().filter(s-> !finalNameMap.containsKey(s.getProjectName())).collect(Collectors.toList());
        }


        //获取当年月初的年月
        String startYear = CommonUtils.getSysYearAndFirstMonth();
        Calendar date = Calendar.getInstance();
        String endYear = String.valueOf(date.get(Calendar.YEAR)) + "-12";

        List<Long> projectIds = actualValueVOList.stream().map(ActualValueVO::getProjectId).collect(Collectors.toList());
        //查询项目月度成本分析年累计
        List<ActualValueVO> costanalysisYearVOS = actualValueMapper.queryCostanalysisYear(projectIds,startYear,endYear);
        Map<Long, List<ActualValueVO>> costanalysisYearMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(costanalysisYearVOS)) {
            costanalysisYearMap = costanalysisYearVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        //查询项目月度成本分析开累
        List<ActualValueVO> costanalysisTotalVOS = actualValueMapper.queryCostanalysisTotal(projectIds,reportingMonth);
        Map<Long, List<ActualValueVO>> costanalysisTotalMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(costanalysisTotalVOS)) {
            costanalysisTotalMap = costanalysisTotalVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }

        // 查询项目目标管理责任书
        List<ActualValueVO> bookVOS = actualValueMapper.queryBook(projectIds);
        Map<Long, ActualValueVO> bookMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(bookVOS)) {
            bookMap = bookVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }

        // 查询责任成本数据
        List<ProSignReserveVO> responseCost = proSignReserveMapper.queryResponseCost(projectIds);
        Map<Long, ProSignReserveVO> responseCostMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(bookVOS)) {
            responseCostMap = responseCost.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }

        //查询合同信息

        List<ConstructionBudgetVO> constructionBudgetVOS = new ArrayList<>();
        constructionBudgetVOS= constructionBudgetMapper.getContract(projectIdList);
        Map<Long, ConstructionBudgetVO> constructionBudgetMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(constructionBudgetVOS)) {
            constructionBudgetMap = constructionBudgetVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }


        for (ActualValueVO vo : actualValueVOList) {
            vo.setReportingMonth(reportingMonth);
            Long projectId = vo.getProjectId();
            if (!costanalysisYearMap.isEmpty() && costanalysisYearMap.containsKey(projectId)) {
                vo.setYearActualCompleteValue(costanalysisYearMap.get(projectId).stream().filter(s -> s.getYearActualCompleteValue() != null).map(s -> s.getYearActualCompleteValue()).reduce(BigDecimal.ZERO, BigDecimal::add));
                vo.setYearResponsibilityCost(costanalysisYearMap.get(projectId).stream().map(s -> s.getYearResponsibilityCost()).reduce(BigDecimal.ZERO, BigDecimal::add));
                vo.setYearRealCost(costanalysisYearMap.get(projectId).stream().map(s -> s.getYearRealCost()).reduce(BigDecimal.ZERO, BigDecimal::add));
                vo.setYearActualProfit(ComputeUtil.safeSub(vo.getYearActualCompleteValue(), vo.getYearRealCost()));
            }
            if (!costanalysisTotalMap.isEmpty() && costanalysisTotalMap.containsKey(projectId)) {
                List<ActualValueVO> actualValueVOS =  costanalysisTotalMap.get(projectId);
                List<ActualValueVO> collectCompare = actualValueVOS.stream().sorted(Comparator.comparing(ActualValueVO::getCostanalysisMonth).reversed())
                        .collect(Collectors.toList());
                //取排序之后的第一行
                ActualValueVO actualValueVO = collectCompare.stream().findFirst().get();
                vo.setAccumulateActualCompleteValue(actualValueVO.getAccumulateActualCompleteValue());
                vo.setAccumulateResponsibilityCost(actualValueVO.getAccumulateResponsibilityCost());
                vo.setAccumulateRealCost(actualValueVO.getAccumulateRealCost());
//                vo.setAccumulateActualProfit(ComputeUtil.safeSub(vo.getAccumulateActualCompleteValue(), vo.getAccumulateRealCost()));
            }
            if (!bookMap.isEmpty() && bookMap.containsKey(projectId)){
//                vo.setUndertakingBenefitsRate(bookMap.get(projectId).getUndertakingBenefitsRate());
                vo.setOverallProfitMargin(bookMap.get(projectId).getOverallProfitMargin());
            }

            if (!responseCostMap.isEmpty() && responseCostMap.containsKey(projectId)){
                vo.setUndertakingBenefitsRate(responseCostMap.get(projectId).getUndertakingBenefitsRate());
            }

            if(constructionBudgetMap.containsKey(projectId)){
                ConstructionBudgetVO constructionBudgetVO1 = constructionBudgetMap.get(projectId);
                vo.setAcContractAmount(CommonUtils.parseNullValue(constructionBudgetVO1.getSelfConstructionContractAmount()));
            }else{
                vo.setAcContractAmount(BigDecimal.ZERO);
            }

            //补全二级组织信息
            CommonResponse<OrgVO> orgVo = orgApi.detailById(vo.getProjectDepartmentId());//此处是项目部id 1286211352287834113
            if (orgVo.isSuccess() && null != orgVo.getData()) {
                String innerCode = orgVo.getData().getInnerCode();
                String[] strs = innerCode.split("\\|");
                CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                if (orgVos.isSuccess() && null != orgVos.getData()) {
                    //二级组织信息
                    vo.setTwoOrgId(orgVos.getData().getId());
                    vo.setTwoOrgName(orgVos.getData().getShortName());
                    vo.setTwoOrgCode(orgVos.getData().getCode());
                    vo.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());
                }
            }
        }
        List<ActualValueEntity> actualValueEntityList = BeanMapper.mapList(actualValueVOList, ActualValueEntity.class);
        actualValueService.saveBatch(actualValueEntityList);
    }

    @Override
    public List<ActualValueVO> dealData(List<ActualValueVO> actualValueVOS) {
        for (ActualValueVO actualValueVO : actualValueVOS){
            actualValueVO.setYearActualCompleteValue(CommonUtils.parseYuanToWanZ(actualValueVO.getYearActualCompleteValue()));
            actualValueVO.setYearResponsibilityCost(CommonUtils.parseYuanToWanZ(actualValueVO.getYearResponsibilityCost()));
            actualValueVO.setYearRealCost(CommonUtils.parseYuanToWanZ(actualValueVO.getYearRealCost()));
            actualValueVO.setYearActualProfit(CommonUtils.parseYuanToWanZ(actualValueVO.getYearActualProfit()));
            actualValueVO.setAccumulateActualCompleteValue(CommonUtils.parseYuanToWanZ(actualValueVO.getAccumulateActualCompleteValue()));
            actualValueVO.setAccumulateResponsibilityCost(CommonUtils.parseYuanToWanZ(actualValueVO.getAccumulateResponsibilityCost()));
            actualValueVO.setAccumulateRealCost(CommonUtils.parseYuanToWanZ(actualValueVO.getAccumulateRealCost()));
//            actualValueVO.setAccumulateActualProfit(CommonUtils.parseYuanToWanZ(actualValueVO.getAccumulateActualProfit()));
            actualValueVO.setAcContractAmount(CommonUtils.parseYuanToWanZ(actualValueVO.getAcContractAmount()));
        }

        //处理第一行合计值
        ActualValueVO actualValueVO = new ActualValueVO();
        ArrayList<ActualValueVO> newList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(actualValueVOS)){
            getSumData(actualValueVOS, actualValueVO);
            actualValueVO.setNumber("合计");
            actualValueVO.setId(IdWorker.getId());
            newList.add(actualValueVO);
        }

        //计算排序字段
        for(ActualValueVO actualValueVOrder :actualValueVOS){
            actualValueVOrder.setProjectStatusOrder(CommonUtils.getProjectOrderNum(actualValueVOrder.getProjectStatus().intValue()));
        }

        //计算项目状态合计
        actualValueVOS = actualValueVOS.stream().sorted(Comparator.comparing(ActualValueVO::getProjectStatusOrder))
                .collect(Collectors.toList());
        Map<Integer, List<ActualValueVO>> mapProjectStatusOrder = actualValueVOS.stream().collect(
                Collectors.groupingBy(
                        s -> s.getProjectStatusOrder()
                ));

        mapProjectStatusOrder.forEach((projectStatusKey,projectStatusList)->{
            ActualValueVO projectStatusSumfeeVO = new ActualValueVO();
            projectStatusSumfeeVO.setNumber("项目状态合计");
            projectStatusSumfeeVO.setId(IdWorker.getId());
            projectStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusNameProject(projectStatusKey));
            getSumData(projectStatusList, projectStatusSumfeeVO);
            newList.add(projectStatusSumfeeVO);

            //计算组织状态合计
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(ActualValueVO::getOrgStatusOrder))
                    .collect(Collectors.toList());
            Map<Integer, List<ActualValueVO>> mapOrgStatusOrder = projectStatusList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getOrgStatusOrder()
                    ));
            mapOrgStatusOrder.forEach((orgStatusKey,orgStatusList)->{
                ActualValueVO orgStatusSumfeeVO = new ActualValueVO();
                orgStatusSumfeeVO.setNumber("单位小计");
                orgStatusSumfeeVO.setId(IdWorker.getId());
                orgStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(orgStatusList.stream().findFirst().get().getProjectStatus().intValue()));
                orgStatusSumfeeVO.setTwoOrgName(orgStatusList.stream().findFirst().get().getTwoOrgName());
                getSumData(orgStatusList, orgStatusSumfeeVO);
                newList.add(orgStatusSumfeeVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ActualValueVO::getProjectCreateTime))
                        .collect(Collectors.toList());
                for (ActualValueVO actualValueVONum : orgStatusList){
                    actualValueVONum.setNumber(number +"");
                    number = number + 1;
                    actualValueVONum.setProjectStatusName(CommonUtils.getProjectStatusName(actualValueVONum.getProjectStatus().intValue()));
                    actualValueVONum.setYearActualCompleteValue((actualValueVONum.getYearActualCompleteValue()));
                    actualValueVONum.setYearResponsibilityCost((actualValueVONum.getYearResponsibilityCost()));
                    actualValueVONum.setYearRealCost((actualValueVONum.getYearRealCost()));
                    actualValueVONum.setYearActualProfit((actualValueVONum.getYearActualProfit()));
                    actualValueVONum.setAccumulateActualCompleteValue((actualValueVONum.getAccumulateActualCompleteValue()));
                    actualValueVONum.setAccumulateResponsibilityCost((actualValueVONum.getAccumulateResponsibilityCost()));
                    actualValueVONum.setAccumulateRealCost((actualValueVONum.getAccumulateRealCost()));
                    actualValueVONum.setAccumulateActualProfit(ComputeUtil.safeSub(actualValueVONum.getAccumulateActualCompleteValue(), actualValueVONum.getAccumulateRealCost()));

                    actualValueVONum.setYearProfitRate(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(actualValueVONum.getYearActualProfit()), CommonUtils.setBigDecimalDefaultValue(actualValueVONum.getYearActualCompleteValue())));
                    actualValueVONum.setAccumulateProfitRate(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(actualValueVONum.getAccumulateActualProfit()), CommonUtils.setBigDecimalDefaultValue(actualValueVONum.getAccumulateActualCompleteValue())));
                    actualValueVONum.setYearReduceRate(CommonUtils.calculateRate(ComputeUtil.safeSub(CommonUtils.setBigDecimalDefaultValue(actualValueVONum.getYearResponsibilityCost()), CommonUtils.setBigDecimalDefaultValue(actualValueVONum.getYearRealCost())), CommonUtils.setBigDecimalDefaultValue(actualValueVONum.getYearResponsibilityCost())));
                    actualValueVONum.setAccumulateReduceRate(CommonUtils.calculateRate(ComputeUtil.safeSub(CommonUtils.setBigDecimalDefaultValue(actualValueVONum.getAccumulateResponsibilityCost()), CommonUtils.setBigDecimalDefaultValue(actualValueVONum.getAccumulateRealCost())), CommonUtils.setBigDecimalDefaultValue(actualValueVONum.getAccumulateResponsibilityCost())));


                }
                newList.addAll(orgStatusList);
            });

        });
        return newList;
    }

    private void getSumData(List<ActualValueVO> actualValueVOS, ActualValueVO actualValueVO) {
        actualValueVO.setYearActualCompleteValue(actualValueVOS.stream().filter(s -> s.getYearActualCompleteValue() != null).map(ActualValueVO::getYearActualCompleteValue).reduce(BigDecimal.ZERO, BigDecimal::add));
        actualValueVO.setYearResponsibilityCost(actualValueVOS.stream().filter(s -> s.getYearResponsibilityCost() != null).map(ActualValueVO::getYearResponsibilityCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        actualValueVO.setYearRealCost(actualValueVOS.stream().filter(s -> s.getYearRealCost() != null).map(ActualValueVO::getYearRealCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        actualValueVO.setYearActualProfit(actualValueVOS.stream().filter(s -> s.getYearActualProfit() != null).map(ActualValueVO::getYearActualProfit).reduce(BigDecimal.ZERO, BigDecimal::add));
        actualValueVO.setAccumulateActualCompleteValue(actualValueVOS.stream().filter(s -> s.getAccumulateActualCompleteValue() != null).map(ActualValueVO::getAccumulateActualCompleteValue).reduce(BigDecimal.ZERO, BigDecimal::add));
        actualValueVO.setAccumulateResponsibilityCost(actualValueVOS.stream().filter(s -> s.getAccumulateResponsibilityCost() != null).map(ActualValueVO::getAccumulateResponsibilityCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        actualValueVO.setAccumulateRealCost(actualValueVOS.stream().filter(s -> s.getAccumulateRealCost() != null).map(ActualValueVO::getAccumulateRealCost).reduce(BigDecimal.ZERO, BigDecimal::add));
//        actualValueVO.setAccumulateActualProfit(actualValueVOS.stream().filter(s -> s.getAccumulateActualProfit() != null).map(ActualValueVO::getAccumulateActualProfit).reduce(BigDecimal.ZERO, BigDecimal::add));
        actualValueVO.setAcContractAmount(actualValueVOS.stream().filter(s -> s.getAcContractAmount() != null).map(ActualValueVO::getAcContractAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        actualValueVO.setAccumulateActualProfit(ComputeUtil.safeSub(actualValueVO.getAccumulateActualCompleteValue(), actualValueVO.getAccumulateRealCost()));

        //比例计算
        actualValueVO.setYearProfitRate(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(actualValueVO.getYearActualProfit()), CommonUtils.setBigDecimalDefaultValue(actualValueVO.getYearActualCompleteValue())));
        actualValueVO.setAccumulateProfitRate(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(actualValueVO.getAccumulateActualProfit()), CommonUtils.setBigDecimalDefaultValue(actualValueVO.getAccumulateActualCompleteValue())));
        actualValueVO.setYearReduceRate(CommonUtils.calculateRate(ComputeUtil.safeSub(CommonUtils.setBigDecimalDefaultValue(actualValueVO.getYearResponsibilityCost()), CommonUtils.setBigDecimalDefaultValue(actualValueVO.getYearRealCost())), CommonUtils.setBigDecimalDefaultValue(actualValueVO.getYearResponsibilityCost())));
        actualValueVO.setAccumulateReduceRate(CommonUtils.calculateRate(ComputeUtil.safeSub(CommonUtils.setBigDecimalDefaultValue(actualValueVO.getAccumulateResponsibilityCost()), CommonUtils.setBigDecimalDefaultValue(actualValueVO.getAccumulateRealCost())), CommonUtils.setBigDecimalDefaultValue(actualValueVO.getAccumulateResponsibilityCost())));

        //汇总∑（向下所属项目自施合同额*承接效益率）/∑向下所属项目自施合同额
        //汇总∑（向下所属项目自施合同额*承接效益率）
        BigDecimal acContractAmount = BigDecimal.ZERO;
//        单位小计=∑（向下所属项目自施合同额*目标效益率）/∑向下所属项目自施合同额
//        状态合计=（向下所属项目自施合同额*目标效益率）/∑向下所属项目自施合同额
        //目标效益率计算
        BigDecimal OverallProfitMarginMny = BigDecimal.ZERO;
        for (ActualValueVO proSignReserve : actualValueVOS){

            acContractAmount = acContractAmount.add(CommonUtils.parseNullValue(proSignReserve.getAcContractAmount()).multiply(CommonUtils.parseNullValue(proSignReserve.getUndertakingBenefitsRate()).divide(new BigDecimal(100))));
            OverallProfitMarginMny = OverallProfitMarginMny.add(CommonUtils.parseNullValue(proSignReserve.getAcContractAmount()).multiply(CommonUtils.parseNullValue(proSignReserve.getOverallProfitMargin()).divide(new BigDecimal(100))));
        }
        actualValueVO.setUndertakingBenefitsRate(CommonUtils.calculateRate(acContractAmount,actualValueVO.getAcContractAmount()));
        actualValueVO.setOverallProfitMargin(CommonUtils.calculateRate(OverallProfitMarginMny,actualValueVO.getAcContractAmount()));


    }


}
