package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.ConstructionBudgetEntity;
import com.ejianc.business.analysis.mapper.ConstructionBudgetMapper;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.service.IConstructionBudgetService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.ConstructionBudgetVO;
import com.ejianc.business.analysis.vo.FeeVO;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.business.analysis.vo.ProjectPaymentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 施工图预算编制情况
 * 
 * @author generator
 * 
 */
@Service("constructionBudgetService")
public class ConstructionBudgetServiceImpl extends BaseServiceImpl<ConstructionBudgetMapper, ConstructionBudgetEntity> implements IConstructionBudgetService{


    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;

    @Autowired
    private ConstructionBudgetMapper constructionBudgetMapper;

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        //获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);

        //先删后增
        LambdaQueryWrapper<ConstructionBudgetEntity> lambdaFee = Wrappers.<ConstructionBudgetEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaFee.in(ConstructionBudgetEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ConstructionBudgetEntity::getReportingMonth, reportingMonth);
        remove(lambdaFee);

        //查询项目信息数据
        List<ProfitIncomeVO> profitIncomeVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(projectIdList,2);
        }else{
            //等于1代表预生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(null,2);
        }
        //过滤掉公司费用类公共项目
        CommonResponse<List<DefdocDetailVO>> plProject = defdocApi.getDefDocByDefCode("pl_project");
        if (!plProject.isSuccess()){
            throw new BusinessException("根据档案编码查询档案项失败!");
        }
        List<DefdocDetailVO> defdocDetailVOList = plProject.getData();

        Map<String, List<DefdocDetailVO>> nameMap = new HashMap<>();

        if (CollectionUtils.isNotEmpty(defdocDetailVOList)){
            nameMap =defdocDetailVOList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getName()
                    ));
        }

//过滤掉过滤掉公司费用类公共项目
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)){
            Map<String, List<DefdocDetailVO>> finalNameMap = nameMap;
            profitIncomeVOList = profitIncomeVOList.stream().filter(s-> !finalNameMap.containsKey(s.getProjectName())).collect(Collectors.toList());
        }
        //查询合同信息
        List<ConstructionBudgetVO> constructionBudgetVOS = new ArrayList<>();
        constructionBudgetVOS= constructionBudgetMapper.getContract(projectIdList);
        Map<Long, ConstructionBudgetVO> constructionBudgetMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(constructionBudgetVOS)) {
            constructionBudgetMap = constructionBudgetVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }



        if(CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            List<ConstructionBudgetVO> constructionBudgetVOList = BeanMapper.mapList(profitIncomeVOList, ConstructionBudgetVO.class);
            if(CollectionUtils.isNotEmpty(constructionBudgetVOList)) {
                //查询施工图
                List<ConstructionBudgetVO> conDrawList = new ArrayList<>();

                if(CollectionUtils.isNotEmpty(projectIdList)) {
                    conDrawList= constructionBudgetMapper.getDraw(projectIdList);
                }else{
                    List<Long> idList =constructionBudgetVOList.stream().map(ConstructionBudgetVO::getProjectId).collect(Collectors.toList());
                    conDrawList= constructionBudgetMapper.getDraw(idList);
                }
                for(ConstructionBudgetVO constructionBudgetVO : constructionBudgetVOList){
                    constructionBudgetVO.setReportingMonth(reportingMonth);
                    if(constructionBudgetMap.containsKey(constructionBudgetVO.getProjectId())){
                        ConstructionBudgetVO constructionBudgetVO1 = constructionBudgetMap.get(constructionBudgetVO.getProjectId());
                        constructionBudgetVO.setSignContract(CommonUtils.parseNullValue(constructionBudgetVO1.getContractAmount()));
                        constructionBudgetVO.setOneselfContract(CommonUtils.parseNullValue(constructionBudgetVO1.getSelfConstructionContractAmount()));
                    }else{
                        constructionBudgetVO.setSignContract(BigDecimal.ZERO);
                        constructionBudgetVO.setOneselfContract(BigDecimal.ZERO);
                    }

//                    if(CollectionUtils.isNotEmpty(constructionBudgetVOS)) {
//                        if(constructionBudgetMap.containsKey(constructionBudgetVO.getProjectId())){
//                            ConstructionBudgetVO constructionBudgetVO1 = constructionBudgetMap.get(constructionBudgetVO.getProjectId());
//                            constructionBudgetVO.setSignContract(ComputeUtil.safeAdd(CommonUtils.parseNullValue(constructionBudgetVO1.getContractAmount()),CommonUtils.parseNullValue(constructionBudgetVO1.getChangeAmount())));
//                            constructionBudgetVO.setOneselfContract(CommonUtils.parseNullValue(constructionBudgetVO1.getSelfConstructionContractAmount()));
//                        }
//                    }
                    if(CollectionUtils.isNotEmpty(conDrawList)) {
                        Map<Long, ConstructionBudgetVO> conDrawMap = conDrawList.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
                        if(conDrawMap.containsKey(constructionBudgetVO.getProjectId())){
                            ConstructionBudgetVO constructionBudgetVO1 = conDrawMap.get(constructionBudgetVO.getProjectId());
                            constructionBudgetVO.setBudgetLimit(CommonUtils.parseNullValue(constructionBudgetVO1.getBudgetMny()));
                        }
                    }


                    CommonResponse<OrgVO> orgVo = orgApi.detailById(constructionBudgetVO.getProjectDepartmentId());//此处是项目部id 1286211352287834113
                    if (orgVo.isSuccess() && null != orgVo.getData()) {
                        String innerCode = orgVo.getData().getInnerCode();
                        String[] strs = innerCode.split("\\|");
                        CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                        if (orgVos.isSuccess() && null != orgVos.getData()) {
                            //二级组织信息
                            constructionBudgetVO.setTwoOrgId(orgVos.getData().getId());
                            constructionBudgetVO.setTwoOrgName(orgVos.getData().getShortName());
                            constructionBudgetVO.setTwoOrgCode(orgVos.getData().getCode());
                            constructionBudgetVO.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());
                        }
                    }
                }
                saveBatch(BeanMapper.mapList(constructionBudgetVOList, ConstructionBudgetEntity.class));
            }
        }
    }

    @Override
    public List<ConstructionBudgetVO> dealData(List<ConstructionBudgetVO> constructionBudgetVOList) {

        //转万元
        for(ConstructionBudgetVO paymentVONum : constructionBudgetVOList){
            paymentVONum.setSignContract(CommonUtils.parseYuanToWan(paymentVONum.getSignContract()));
            paymentVONum.setOneselfContract(CommonUtils.parseYuanToWan(paymentVONum.getOneselfContract()));
            paymentVONum.setBudgetLimit(CommonUtils.parseYuanToWan(paymentVONum.getBudgetLimit()));
        }

        //处理第一行合计值
        ConstructionBudgetVO constructionBudgetVO = new ConstructionBudgetVO();
        ArrayList<ConstructionBudgetVO> conNewList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(constructionBudgetVOList)){
            getSumData(constructionBudgetVOList, constructionBudgetVO);
            constructionBudgetVO.setNumber("合计");
            constructionBudgetVO.setId(IdWorker.getId());
            conNewList.add(constructionBudgetVO);

            //计算排序字段
            for(ConstructionBudgetVO constructionBudgetVO1 :constructionBudgetVOList){
                constructionBudgetVO1.setProjectStatusOrder(CommonUtils.getProjectOrderNum(constructionBudgetVO1.getProjectStatus() == null ? 6:constructionBudgetVO1.getProjectStatus()));
            }
            //计算项目状态合计
            constructionBudgetVOList = constructionBudgetVOList.stream().sorted(Comparator.comparing(ConstructionBudgetVO::getProjectStatusOrder))
                    .collect(Collectors.toList());
            Map<Integer, List<ConstructionBudgetVO>> mapProjectStatusOrder = constructionBudgetVOList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getProjectStatusOrder()
                    ));

            mapProjectStatusOrder.forEach((projectStatusKey,projectStatusList)->{
                ConstructionBudgetVO constructionBudgetVO1 = new ConstructionBudgetVO();
                constructionBudgetVO1.setNumber("项目状态合计");
                constructionBudgetVO1.setId(IdWorker.getId());
                constructionBudgetVO1.setProjectStatusName(CommonUtils.getProjectStatusNameProject(projectStatusKey));
                getSumData(projectStatusList, constructionBudgetVO1);
                conNewList.add(constructionBudgetVO1);

                //计算组织状态合计
                projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(ConstructionBudgetVO::getOrgStatusOrder))
                        .collect(Collectors.toList());
                Map<Integer, List<ConstructionBudgetVO>> mapOrgStatusOrder = projectStatusList.stream().collect(
                        Collectors.groupingBy(
                                s -> s.getOrgStatusOrder()
                        ));

                mapOrgStatusOrder.forEach((orgStatusKey,orgStatusList)->{
                    ConstructionBudgetVO orgStatusSumpayVO = new ConstructionBudgetVO();
                    orgStatusSumpayVO.setNumber("单位小计");
                    orgStatusSumpayVO.setId(IdWorker.getId());
                    orgStatusSumpayVO.setProjectStatusName(CommonUtils.getProjectStatusName(orgStatusList.stream().findFirst().get().getProjectStatus()));
                    orgStatusSumpayVO.setTwoOrgName(orgStatusList.stream().findFirst().get().getTwoOrgName());
                    getSumData(orgStatusList, orgStatusSumpayVO);
                    conNewList.add(orgStatusSumpayVO);

                    Integer number = 1;
                    orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ConstructionBudgetVO::getProjectCreateTime))
                            .collect(Collectors.toList());
                    for (ConstructionBudgetVO paymentVONum : orgStatusList){
                        paymentVONum.setNumber(number +"");
                        number = number + 1;
                        paymentVONum.setProjectStatusName(CommonUtils.getProjectStatusName(paymentVONum.getProjectStatus()));

                    }
                    conNewList.addAll(orgStatusList);
                });
            });
        }
        return conNewList;
    }
    private void getSumData(List<ConstructionBudgetVO> constructionBudgetVOList, ConstructionBudgetVO constructionBudgetVO) {

        BigDecimal signContract = constructionBudgetVOList.stream().filter(s->s.getSignContract()!=null).map(ConstructionBudgetVO::getSignContract)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal oneselfContract = constructionBudgetVOList.stream().filter(s->s.getOneselfContract()!=null).map(ConstructionBudgetVO::getOneselfContract)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal budgetLimit = constructionBudgetVOList.stream().filter(s->s.getBudgetLimit()!=null).map(ConstructionBudgetVO::getBudgetLimit)
                .reduce(BigDecimal.ZERO, BigDecimal::add);

        //转万元赋值
        constructionBudgetVO.setSignContract(signContract);
        constructionBudgetVO.setOneselfContract(oneselfContract);
        constructionBudgetVO.setBudgetLimit(budgetLimit);
    }
}
