package com.ejianc.business.analysis.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.analysis.bean.ProSignReserveEntity;
import com.ejianc.business.analysis.mapper.PortalMapper;
import com.ejianc.business.analysis.service.IActualValueService;
import com.ejianc.business.analysis.service.IPortalService;
import com.ejianc.business.analysis.service.IProSignReserveService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;

/**
 * 门户
 * 
 * @author generator
 * 
 */
@Service("portalService")
public class PortalServiceImpl implements IPortalService {
    @Autowired
    private PortalMapper portalMapper;
    @Autowired
    private IProSignReserveService proSignReserveService;
    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IDefdocApi defdocApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    //产值效益分析
    @Override
    public JSONObject getOutputValueBenefitAnalysis(String section, String year, String projectStatus) {
        JSONObject json = new JSONObject();
        String reportingMonth = getReportingMonth(section, year);
        LinkedHashMap<String, String> orgMap = getOrg();
        LinkedList<String> orgId = new LinkedList<>();
        LinkedList<String> orgName = new LinkedList<>();
        for(String key : orgMap.keySet()){
            orgId.add(key);
            orgName.add(orgMap.get(key));
        }
        LinkedList<BigDecimal> outputValueDataList = new LinkedList<>();//项目产值
        LinkedList<BigDecimal> costDataList = new LinkedList<>();//项目成本
        LinkedList<BigDecimal> benefitDataList = new LinkedList<>();//利润率

        Map<String,Object> param = new HashMap<>();
        param.put("reportingMonth", reportingMonth);
        param.put("orgIds", orgId);
        param.put("projectStatus", projectStatus);
        param.put("tenantId", InvocationInfoProxy.getTenantid());
        param.put("type", "outputValueBenefitAnalysis");
        List<ActualValueVO> orgData = portalMapper.getOutputValueBenefitAnalysis(param);

        Map<String, ActualValueVO> dataList = new HashMap<>();
        for(ActualValueVO vo : orgData){
            dataList.put(vo.getTwoOrgId().toString(), vo);
        }
        param.put("range", "all");
        param.remove("orgIds");
        List<ActualValueVO> allData = portalMapper.getOutputValueBenefitAnalysis(param);
        if("yearCumulative".equals(section)){
            //年累
            if(allData!=null && allData.size()>0 && allData.get(0)!=null){
                outputValueDataList.add(CommonUtils.parseYuanToYi(allData.get(0).getYearActualCompleteValue()));//本年实际完成产值汇总
                costDataList.add(CommonUtils.parseYuanToYi(allData.get(0).getYearRealCost()));//本年实际成本
//            利润率 = 本年实际利润/本年实际完成产值
                BigDecimal yearProfitRate = CommonUtils.calculateRate2(allData.get(0).getYearActualProfit(), CommonUtils.setBigDecimalDefaultValue(allData.get(0).getYearActualCompleteValue()));
                benefitDataList.add(yearProfitRate);//利润率
            }else{
                outputValueDataList.add(new BigDecimal(0));//本年实际完成产值汇总
                costDataList.add(new BigDecimal(0));//本年实际成本
                benefitDataList.add(new BigDecimal(0));//利润率
            }
            for(int i=1; i<orgId.size(); i++){
                String id = orgId.get(i);
                ActualValueVO vo = dataList.get(id);
                if(vo!=null){
                    outputValueDataList.add(CommonUtils.parseYuanToYi(vo.getYearActualCompleteValue()));//本年实际完成产值汇总
                    costDataList.add(CommonUtils.parseYuanToYi(vo.getYearRealCost()));//本年实际成本
//            利润率 = 本年实际利润/本年实际完成产值
                    BigDecimal yearProfitRate1 = CommonUtils.calculateRate2(vo.getYearActualProfit(), CommonUtils.setBigDecimalDefaultValue(vo.getYearActualCompleteValue()));
                    benefitDataList.add(yearProfitRate1);//利润率
                }else{
                    outputValueDataList.add(new BigDecimal(0));//本年实际完成产值汇总
                    costDataList.add(new BigDecimal(0));//本年实际成本
                    benefitDataList.add(new BigDecimal(0));//利润率
                }
            }
        }else {
            //开累
            if(allData!=null && allData.size()>0 && allData.get(0)!=null) {
                outputValueDataList.add(CommonUtils.parseYuanToYi(allData.get(0).getAccumulateActualCompleteValue()));//本年实际完成产值汇总
                costDataList.add(CommonUtils.parseYuanToYi(allData.get(0).getAccumulateRealCost()));//本年实际成本
//            利润率 = 本年实际利润/本年实际完成产值
                BigDecimal accumulateProfitRate = CommonUtils.calculateRate2(allData.get(0).getAccumulateActualProfit(), CommonUtils.setBigDecimalDefaultValue(allData.get(0).getAccumulateActualCompleteValue()));
                benefitDataList.add(accumulateProfitRate);//利润率
            }else{
                outputValueDataList.add(new BigDecimal(0));//本年实际完成产值汇总
                costDataList.add(new BigDecimal(0));//本年实际成本
                benefitDataList.add(new BigDecimal(0));//利润率
            }
            for(int i=1; i<orgId.size(); i++){
                String id = orgId.get(i);
                ActualValueVO vo = dataList.get(id);
                if(vo!=null){
                    outputValueDataList.add(CommonUtils.parseYuanToYi(vo.getAccumulateActualCompleteValue()));//本年实际完成产值汇总
                    costDataList.add(CommonUtils.parseYuanToYi(vo.getAccumulateRealCost()));//本年实际成本
//            利润率 = 本年实际利润/本年实际完成产值
                    BigDecimal accumulateProfitRate1 = CommonUtils.calculateRate2(vo.getAccumulateActualProfit(), CommonUtils.setBigDecimalDefaultValue(vo.getAccumulateActualCompleteValue()));
                    benefitDataList.add(accumulateProfitRate1);//利润率
                }else{
                    outputValueDataList.add(new BigDecimal(0));//本年实际完成产值汇总
                    costDataList.add(new BigDecimal(0));//本年实际成本
                    benefitDataList.add(new BigDecimal(0));//利润率
                }
            }
        }
        logger.info("orgName:{}",orgName);
        json.put("legendData", orgName);
        json.put("outputValueData", outputValueDataList);
        json.put("costData", costDataList);
        json.put("benefitData", benefitDataList);
        return json;
    }

    //目标责任分析
    @Override
    public JSONObject getTargetResponsibilityAnalysis(String projectStatus) {
        JSONObject json = new JSONObject();
        String reportingMonth = getReportingMonth("cumulative", "");
        LinkedHashMap<String, String> orgMap = getOrg();
        LinkedList<String> orgIds = new LinkedList<>();
        LinkedList<String> orgName = new LinkedList<>();
        for(String key : orgMap.keySet()){
            orgIds.add(key);
            orgName.add(orgMap.get(key));
        }
        LinkedList<BigDecimal> undertakeData = new LinkedList<>();//承接效益率
        LinkedList<BigDecimal> targetData = new LinkedList<>();//目标利润率
        LinkedList<BigDecimal> actualData = new LinkedList<>();//实际利润率

        QueryParam param = new QueryParam();
        param.getParams().put("reportingMonth", new Parameter(QueryParam.EQ, reportingMonth));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("projectStatus", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("two_org_id", new Parameter(QueryParam.IN, orgIds));
        List<ProSignReserveEntity> allData = proSignReserveService.queryList(param,false);
        Map<String, List<ProSignReserveEntity>> orgDataMap = new HashMap<>();
        for(ProSignReserveEntity entity : allData){
            String orgId = entity.getTwoOrgId().toString();
            if(orgIds.contains(orgId)){
                if(orgDataMap.get(orgId)!=null){
                    List<ProSignReserveEntity> orgData = orgDataMap.get(orgId);
                    orgData.add(entity);
                    orgDataMap.put(orgId, orgData);
                }else{
                    List<ProSignReserveEntity> orgData = new ArrayList<>();
                    orgData.add(entity);
                    orgDataMap.put(orgId, orgData);
                }
            }
        }
        ProSignReserveEntity allVO = getProSignReserveSumData(allData);
        undertakeData.add(allVO.getUndertakingBenefitsRate());//本年实际完成产值汇总
        targetData.add(allVO.getOverallProfitMargin());//本年实际成本
        for(int i=1; i<orgIds.size(); i++){
            String id = orgIds.get(i);
            if(orgDataMap.get(id)!=null){
                ProSignReserveEntity org = getProSignReserveSumData(orgDataMap.get(id));
                undertakeData.add(org.getUndertakingBenefitsRate());//本年实际完成产值汇总
                targetData.add(org.getOverallProfitMargin());//本年实际成本
            }else{
                undertakeData.add(new BigDecimal(0));//本年实际完成产值汇总
                targetData.add(new BigDecimal(0));//本年实际成本
            }
        }

        //查询实际利润率----开累实际利润/开累实际完成产值
        Map<String,Object> actualParam = new HashMap<>();
        actualParam.put("reportingMonth", reportingMonth);
        actualParam.put("orgIds", orgIds);
        actualParam.put("projectStatus", projectStatus);
        actualParam.put("tenantId", InvocationInfoProxy.getTenantid());
        actualParam.put("type", "targetActual");
        List<ActualValueVO> orgActualData = portalMapper.getOutputValueBenefitAnalysis(actualParam);

        Map<String, ActualValueVO> dataActualList = new HashMap<>();
        for(ActualValueVO vo : orgActualData){
            dataActualList.put(vo.getTwoOrgId().toString(), vo);
        }
        actualParam.put("range", "all");
        List<ActualValueVO> allActualData = portalMapper.getOutputValueBenefitAnalysis(actualParam);
        if(allData!=null && allData.size()>0 && allData.get(0)!=null) {
            //利润率 = 本年实际利润/本年实际完成产值
            BigDecimal accumulateProfitRate = CommonUtils.calculateRate2(CommonUtils.setBigDecimalDefaultValue(allActualData.get(0).getAccumulateActualProfit()), CommonUtils.setBigDecimalDefaultValue(allActualData.get(0).getAccumulateActualCompleteValue()));
            actualData.add(accumulateProfitRate);//利润率
        }else {
            actualData.add(new BigDecimal(0));//利润率
        }
        for(int i=1; i<orgIds.size(); i++){
            String id = orgIds.get(i);
            ActualValueVO vo = dataActualList.get(id);
            if(vo!=null){
                BigDecimal accumulateProfitRate1 = CommonUtils.calculateRate2(CommonUtils.setBigDecimalDefaultValue(vo.getAccumulateActualProfit()), CommonUtils.setBigDecimalDefaultValue(vo.getAccumulateActualCompleteValue()));
                actualData.add(accumulateProfitRate1);//利润率
            }else{
                actualData.add(new BigDecimal(0));//利润率
            }
        }

        json.put("legendData", orgName);
        json.put("undertakeData", undertakeData);
        json.put("targetData", targetData);
        json.put("actualData", actualData);
        return json;
    }

    private ProSignReserveEntity getProSignReserveSumData(List<ProSignReserveEntity> proSignReserveEntityS) {
        ProSignReserveEntity proSignReserveEntity = new ProSignReserveEntity();
        proSignReserveEntity.setAcContractAmount((proSignReserveEntityS.stream().filter(it -> it.getAcContractAmount() != null).map(it -> it.getAcContractAmount()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        BigDecimal acContractAmount = BigDecimal.ZERO;
        BigDecimal OverallProfitMarginMny = BigDecimal.ZERO;
        for (ProSignReserveEntity proSignReserve : proSignReserveEntityS){
            acContractAmount = acContractAmount.add(CommonUtils.parseNullValue(proSignReserve.getAcContractAmount()).multiply(CommonUtils.parseNullValue(proSignReserve.getUndertakingBenefitsRate()).divide(new BigDecimal(100))));
            OverallProfitMarginMny = OverallProfitMarginMny.add(CommonUtils.parseNullValue(proSignReserve.getAcContractAmount()).multiply(CommonUtils.parseNullValue(proSignReserve.getOverallProfitMargin()).divide(new BigDecimal(100))));
        }
        //汇总∑（向下所属项目自施合同额*承接效益率）/∑向下所属项目自施合同额
        proSignReserveEntity.setUndertakingBenefitsRate(CommonUtils.calculateRate2(acContractAmount,proSignReserveEntity.getAcContractAmount()));
        //汇总∑（向下所属项目自施合同额*整体上缴利润率）/∑向下所属项目自施合同额
        proSignReserveEntity.setOverallProfitMargin(CommonUtils.calculateRate2(OverallProfitMarginMny,proSignReserveEntity.getAcContractAmount()));
        return proSignReserveEntity;
    }


    //商务策划实施率
    @Override
    public JSONObject getBusinessPlan() {
        JSONObject json = new JSONObject();
        String reportingMonth = getReportingMonth("cumulative", "");
        LinkedHashMap<String, String> orgMap = getOrg();
        LinkedList<String> orgId = new LinkedList<>();
        LinkedList<String> orgName = new LinkedList<>();
        for(String key : orgMap.keySet()){
            orgId.add(key);
            orgName.add(orgMap.get(key));
        }
        LinkedList<BigDecimal> planDataList = new LinkedList<>();//策划创效率
        LinkedList<BigDecimal> predictDataList = new LinkedList<>();//策划预计床效率

        Map<String,Object> param = new HashMap<>();
        param.put("reportingMonth", reportingMonth);
        param.put("orgIds", orgId);
        param.put("projectStatus", "2");//在建项目
        param.put("tenantId", InvocationInfoProxy.getTenantid());
        List<ProjectBusinessVO> orgData = portalMapper.getBusinessPlan(param);

        Map<String, ProjectBusinessVO> dataList = new HashMap<>();
        for(ProjectBusinessVO vo : orgData){
            dataList.put(vo.getTwoOrgId().toString(), vo);
        }
        param.put("range", "all");
        param.remove("orgIds");
        List<ProjectBusinessVO> allData = portalMapper.getBusinessPlan(param);

        //开累
        if(allData!=null && allData.size()>0 && allData.get(0)!=null) {
//            策划创效率 = 策划创效金额/实际完成产值
            allData.get(0).setRealityMoney(CommonUtils.parseYuanToWanZ(allData.get(0).getRealityMoney()));
            allData.get(0).setOneselfContract(CommonUtils.parseYuanToWanZ(allData.get(0).getOneselfContract()));

            BigDecimal planRatio = CommonUtils.calculateRate2(CommonUtils.setBigDecimalDefaultValue(allData.get(0).getPlanMoney()), CommonUtils.setBigDecimalDefaultValue(allData.get(0).getRealityMoney()));
            planDataList.add(planRatio);//策划创效率
//            策划预计创效率（%） = 策划预计创效金额/自施合同额
            BigDecimal predictRatio = CommonUtils.calculateRate2(CommonUtils.setBigDecimalDefaultValue(allData.get(0).getPredictMoney()), CommonUtils.setBigDecimalDefaultValue(allData.get(0).getOneselfContract()));
            predictDataList.add(predictRatio);//策划预计创效率（%）
        }else{
            planDataList.add(new BigDecimal(0));//策划创效率
            predictDataList.add(new BigDecimal(0));//策划预计创效率
        }
        for(int i=1; i<orgId.size(); i++){
            String id = orgId.get(i);
            ProjectBusinessVO vo = dataList.get(id);
            if(vo!=null){
//            策划创效率 = 策划创效金额/实际完成产值
                vo.setRealityMoney(CommonUtils.parseYuanToWanZ(vo.getRealityMoney()));
                vo.setOneselfContract(CommonUtils.parseYuanToWanZ(vo.getOneselfContract()));
                BigDecimal planRatio1 = CommonUtils.calculateRate2(CommonUtils.setBigDecimalDefaultValue(vo.getPlanMoney()),CommonUtils.setBigDecimalDefaultValue(vo.getRealityMoney()));
                planDataList.add(planRatio1);//策划创效率
//            策划预计创效率（%） = 策划预计创效金额/自施合同额
                BigDecimal predictRatio1 = CommonUtils.calculateRate2(CommonUtils.setBigDecimalDefaultValue(vo.getPredictMoney()),CommonUtils.setBigDecimalDefaultValue(vo.getOneselfContract()));
                predictDataList.add(predictRatio1);//策划预计创效率（%）
            }else{
                planDataList.add(new BigDecimal(0));//策划创效率
                predictDataList.add(new BigDecimal(0));//策划预计创效率
            }
        }

        json.put("legendData", orgName);
        json.put("planDataList", planDataList);
        json.put("predictDataList", predictDataList);

        json.put("targetValue", predictDataList.get(0));
        json.put("achieveValue", planDataList.get(0));
        return json;
    }

    //产值确权率
    @Override
    public JSONObject getOutputValueConfirmationRate() {
        JSONObject json = new JSONObject();
        String reportingMonth = getReportingMonth("cumulative", "");
        LinkedHashMap<String, String> orgMap = getOrg();
        LinkedList<String> orgId = new LinkedList<>();
        LinkedList<String> orgName = new LinkedList<>();
        for(String key : orgMap.keySet()){
            orgId.add(key);
            orgName.add(orgMap.get(key));
        }
        LinkedList<BigDecimal> ownerAffirmProductionDataList = new LinkedList<>();//业主确认产值
        LinkedList<BigDecimal> actualFinishProductionDataList = new LinkedList<>();//实际完成产值
        LinkedList<BigDecimal> confirmationRateDataList = new LinkedList<>();//确权率

        Map<String,Object> param = new HashMap<>();
        param.put("reportingMonth", reportingMonth);
        param.put("orgIds", orgId);
        param.put("projectStatus", "2");//在建项目
        param.put("tenantId", InvocationInfoProxy.getTenantid());
        param.put("type", "outputValueConfirmationRate");
        List<ProjectPaymentVO> orgData = portalMapper.getOutputValueConfirmationRate(param);

        Map<String, ProjectPaymentVO> dataList = new HashMap<>();
        for(ProjectPaymentVO vo : orgData){
            dataList.put(vo.getTwoOrgId().toString(), vo);
        }
        param.put("range", "all");
        param.remove("orgIds");
        List<ProjectPaymentVO> allData = portalMapper.getOutputValueConfirmationRate(param);

        //开累
        if(allData!=null && allData.size()>0 && allData.get(0)!=null) {
            ownerAffirmProductionDataList.add(CommonUtils.parseYuanToYi(allData.get(0).getOwnerAffirmProduction()));
            actualFinishProductionDataList.add(CommonUtils.parseYuanToYi(allData.get(0).getActualFinishProduction()));
//            确权率（%） = 业主确认产值/实际完成产值
            BigDecimal confirmationRate = CommonUtils.calculateRate2(CommonUtils.setBigDecimalDefaultValue(allData.get(0).getOwnerAffirmProduction()), CommonUtils.setBigDecimalDefaultValue(allData.get(0).getActualFinishProduction()));
            confirmationRateDataList.add(confirmationRate);//确权率（%）
        }else{
            ownerAffirmProductionDataList.add(new BigDecimal(0));//业主确认产值
            actualFinishProductionDataList.add(new BigDecimal(0));//实际完成产值
            confirmationRateDataList.add(new BigDecimal(0));//确权率
        }
        for(int i=1; i<orgId.size(); i++){
            String id = orgId.get(i);
            ProjectPaymentVO vo = dataList.get(id);
            if(vo!=null){
                ownerAffirmProductionDataList.add(CommonUtils.parseYuanToYi(vo.getOwnerAffirmProduction()));
                actualFinishProductionDataList.add(CommonUtils.parseYuanToYi(vo.getActualFinishProduction()));
//            确权率（%） = 业主确认产值/实际完成产值
                BigDecimal confirmationRate1 = CommonUtils.calculateRate2(CommonUtils.setBigDecimalDefaultValue(vo.getOwnerAffirmProduction()),CommonUtils.setBigDecimalDefaultValue(vo.getActualFinishProduction()));
                confirmationRateDataList.add(confirmationRate1);//确权率（%）
            }else{
                ownerAffirmProductionDataList.add(new BigDecimal(0));//业主确认产值
                actualFinishProductionDataList.add(new BigDecimal(0));//实际完成产值
                confirmationRateDataList.add(new BigDecimal(0));//确权率
            }
        }

        json.put("legendData", orgName);
        json.put("ownerAffirmProductionDataList", ownerAffirmProductionDataList);
        json.put("actualFinishProductionDataList", actualFinishProductionDataList);
        json.put("confirmationRateDataList", confirmationRateDataList);
        return json;
    }

    //成本收现率、成本付现率
    @Override
    public JSONObject getCostRate(String projectStatus) {
        JSONObject json = new JSONObject();
        String reportingMonth = getReportingMonth("cumulative", "");
        LinkedHashMap<String, String> orgMap = getOrg();
        LinkedList<String> orgId = new LinkedList<>();
        LinkedList<String> orgName = new LinkedList<>();
        for(String key : orgMap.keySet()){
            orgId.add(key);
            orgName.add(orgMap.get(key));
        }
        LinkedList<BigDecimal> costRateDataList = new LinkedList<>();//成本收现率
        LinkedList<BigDecimal> costToRateDataList = new LinkedList<>();//成本付现率

        Map<String,Object> param = new HashMap<>();
        param.put("reportingMonth", reportingMonth);
        param.put("orgIds", orgId);
        param.put("projectStatus", projectStatus);//在建项目
        param.put("tenantId", InvocationInfoProxy.getTenantid());
        param.put("type", "costRate");
        List<ProjectPaymentVO> orgData = portalMapper.getOutputValueConfirmationRate(param);

        Map<String, ProjectPaymentVO> dataList = new HashMap<>();
        for(ProjectPaymentVO vo : orgData){
            dataList.put(vo.getTwoOrgId().toString(), vo);
        }
        param.put("range", "all");
        param.remove("orgIds");
        List<ProjectPaymentVO> allData = portalMapper.getOutputValueConfirmationRate(param);

        //开累
        if(allData!=null && allData.size()>0 && allData.get(0)!=null) {
            //扣除预付款后收款金额 = 其中预付款(开累)+已收工程款(开累)
            BigDecimal gatheringProject = ComputeUtil.safeSub(allData.get(0).getProjectFunds(), allData.get(0).getAdvance());
            //成本收现率	= (其中预付款(开累)+已收工程款(开累))/实际成本(开累)
            BigDecimal costRate = CommonUtils.calculateRate2(CommonUtils.setBigDecimalDefaultValue(gatheringProject), CommonUtils.setBigDecimalDefaultValue(allData.get(0).getActualCost()));
            costRateDataList.add(costRate);//成本收现率
            //成本付现率	= 已付款金额/实际成本(开累)
            BigDecimal costToRate = CommonUtils.calculateRate2(CommonUtils.setBigDecimalDefaultValue(allData.get(0).getAmountPaid()),CommonUtils.setBigDecimalDefaultValue(allData.get(0).getActualCost()));
            costToRateDataList.add(costToRate);//成本付现率
        }else{
            costRateDataList.add(new BigDecimal(0));//成本收现率
            costToRateDataList.add(new BigDecimal(0));//成本付现率
        }
        for(int i=1; i<orgId.size(); i++){
            String id = orgId.get(i);
            ProjectPaymentVO vo = dataList.get(id);
            if(vo!=null){
                //扣除预付款后收款金额 = 其中预付款(开累)+已收工程款(开累)
                BigDecimal gatheringProject1 = ComputeUtil.safeSub(vo.getProjectFunds(), vo.getAdvance());
                //成本收现率	= (其中预付款(开累)+已收工程款(开累))/实际成本(开累)
                BigDecimal costRate1 = CommonUtils.calculateRate2(CommonUtils.setBigDecimalDefaultValue(gatheringProject1),CommonUtils.setBigDecimalDefaultValue(vo.getActualCost()));
                costRateDataList.add(costRate1);//成本收现率

                //成本付现率	= 已付款金额/实际成本(开累)
                BigDecimal costToRate1 = CommonUtils.calculateRate2(CommonUtils.setBigDecimalDefaultValue(vo.getAmountPaid()),CommonUtils.setBigDecimalDefaultValue(vo.getActualCost()));
                costToRateDataList.add(costToRate1);//成本付现率
            }else{
                costRateDataList.add(new BigDecimal(0));//成本收现率
                costToRateDataList.add(new BigDecimal(0));//成本付现率
            }
        }

        json.put("legendData", orgName);
        json.put("costRateDataList", costRateDataList);
        json.put("costToRateDataList", costToRateDataList);
        return json;
    }

    //工期延误增加成本情况
    @Override
    public JSONObject getScheduleDelay() {
        JSONObject json = new JSONObject();
        String reportingMonth = getReportingMonth("cumulative", "");
        LinkedHashMap<String, String> orgMap = getOrg();
        LinkedList<String> orgId = new LinkedList<>();
        LinkedList<String> orgName = new LinkedList<>();
        for(String key : orgMap.keySet()){
            orgId.add(key);
            orgName.add(orgMap.get(key));
        }
        LinkedList<BigDecimal> delayDaysTotalDataList = new LinkedList<>();//延误天数合计
        LinkedList<BigDecimal> delayCostTotalDataList = new LinkedList<>();//增加成本合计

        Map<String,Object> param = new HashMap<>();
        param.put("reportingMonth", reportingMonth);
        param.put("orgIds", orgId);
        param.put("tenantId", InvocationInfoProxy.getTenantid());
        List<ProDurationDelayVO> orgData = portalMapper.getScheduleDelay(param);

        Map<String, ProDurationDelayVO> dataList = new HashMap<>();
        for(ProDurationDelayVO vo : orgData){
            dataList.put(vo.getTwoOrgId().toString(), vo);
        }
        param.put("range", "all");
        param.remove("orgIds");
        List<ProDurationDelayVO> allData = portalMapper.getScheduleDelay(param);

        //开累
        if(allData!=null && allData.size()>0 && allData.get(0)!=null) {
            delayDaysTotalDataList.add(allData.get(0).getDelayDaysTotal());
            delayCostTotalDataList.add(CommonUtils.parseYuanToWanZ(allData.get(0).getDelayCostTotal()));
        }else{
            delayDaysTotalDataList.add(new BigDecimal(0));//
            delayCostTotalDataList.add(new BigDecimal(0));//
        }
        for(int i=1; i<orgId.size(); i++){
            String id = orgId.get(i);
            ProDurationDelayVO vo = dataList.get(id);
            if(vo!=null){
                delayDaysTotalDataList.add(vo.getDelayDaysTotal());
                delayCostTotalDataList.add(CommonUtils.parseYuanToWanZ(vo.getDelayCostTotal()));
            }else{
                delayDaysTotalDataList.add(new BigDecimal(0));//
                delayCostTotalDataList.add(new BigDecimal(0));//
            }
        }

        json.put("legendData", orgName);
        json.put("delayDaysTotalDataList", delayDaysTotalDataList);
        json.put("delayCostTotalDataList", delayCostTotalDataList);
        return json;
    }

    //获取要查询的报表日期
    private String getReportingMonth(String section, String year){
        String reportingMonth = null;
        if("yearCumulative".equals(section)){
            //年累---该年最后一期
            SimpleDateFormat format = new SimpleDateFormat("yyyy");
            String nowYear = format.format(new Date());
            if(year.equals(nowYear)){
                //本年的查询上一个月的
                LocalDateTime currentTime = LocalDateTime.now();
                LocalDateTime lastMonth = currentTime.minusMonths(1);
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
                reportingMonth = lastMonth.format(formatter);
            }else{
                reportingMonth = year + "-12";;
            }
        }else{
            //开累（cumulative）---最新一期的
            LocalDateTime currentTime = LocalDateTime.now();
            LocalDateTime lastMonth = currentTime.minusMonths(1);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
            reportingMonth = lastMonth.format(formatter);
        }
        return reportingMonth;
    }

    private LinkedHashMap<String, String> getOrg(){
        LinkedHashMap<String, String> orgMap = new LinkedHashMap<>();
        CommonResponse<List<DefdocDetailVO>> defdocResponse = defdocApi.getDefDocByDefCode("zjkj_cost_portal_org");
        if(defdocResponse.isSuccess() && defdocResponse.getData()!=null){
            for(DefdocDetailVO vo : defdocResponse.getData()){
                orgMap.put(vo.getCode(), vo.getName());
                logger.info("code:{},name:{}",vo.getCode(),vo.getName());
            }
        }else{
            throw new BusinessException("未获取到组织信息");
        }
        return orgMap;
    }

    public static void main(String[] args) {
        LocalDateTime currentTime = LocalDateTime.now();
        LocalDateTime lastMonth = currentTime.minusMonths(1);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
        String lastMonthDate = lastMonth.format(formatter);
        System.out.println("上一个月的日期为：" + lastMonthDate);

        List<BigDecimal> delayDaysTotalDataList = new ArrayList<>();//延误天数合计
        delayDaysTotalDataList.add(null);
        System.out.println(delayDaysTotalDataList);
    }
}
