package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.FeeEntity;
import com.ejianc.business.analysis.mapper.ConstructionBudgetMapper;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.ibatis.annotations.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.analysis.mapper.ProSignReserveMapper;
import com.ejianc.business.analysis.bean.ProSignReserveEntity;
import com.ejianc.business.analysis.service.IProSignReserveService;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 项目责任书签订及风险金预留情况
 *
 * @author generator
 *
 */
@Service("proSignReserveService")
public class ProSignReserveServiceImpl extends BaseServiceImpl<ProSignReserveMapper, ProSignReserveEntity> implements IProSignReserveService{
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProSignReserveService proSignReserveService;
    @Autowired
    private ProSignReserveMapper proSignReserveMapper;

    @Autowired
    private ConstructionBudgetMapper constructionBudgetMapper;

    @Autowired
    private IDefdocApi defdocApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());



    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        //获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);

        //先删后增
        LambdaQueryWrapper<ProSignReserveEntity> lambdaFee = Wrappers.<ProSignReserveEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaFee.in(ProSignReserveEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ProSignReserveEntity::getReportingMonth, reportingMonth);
        proSignReserveService.remove(lambdaFee);

        //查询项目信息数据
        List<ProSignReserveVO> proSignReserveVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            proSignReserveVOList = proSignReserveMapper.getProjects(projectIdList);
        }else{
            //等于1代表预生成数据
            proSignReserveVOList = proSignReserveMapper.getProjects(null);
        }

        //过滤掉公司费用类公共项目
        CommonResponse<List<DefdocDetailVO>> plProject = defdocApi.getDefDocByDefCode("pl_project");
        if (!plProject.isSuccess()){
            throw new BusinessException("根据档案编码查询档案项失败!");
        }
        List<DefdocDetailVO> defdocDetailVOList = plProject.getData();

        Map<String, List<DefdocDetailVO>> nameMap = new HashMap<>();

        if (CollectionUtils.isNotEmpty(defdocDetailVOList)){
            nameMap =defdocDetailVOList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getName()
                    ));
        }

//过滤掉过滤掉公司费用类公共项目
        if (CollectionUtils.isNotEmpty(proSignReserveVOList)){
            Map<String, List<DefdocDetailVO>> finalNameMap = nameMap;
            proSignReserveVOList = proSignReserveVOList.stream().filter(s-> !finalNameMap.containsKey(s.getProjectName())).collect(Collectors.toList());
        }



        List<Long> projectIds = proSignReserveVOList.stream().map(ProSignReserveVO::getProjectId).collect(Collectors.toList());

        // 查询施工类合同
//        List<ProSignReserveVO> contractVOS = proSignReserveMapper.queryContract(projectIds,reportingMonth);

        //查询合同信息

        List<ConstructionBudgetVO> constructionBudgetVOS = new ArrayList<>();
        constructionBudgetVOS= constructionBudgetMapper.getContract(projectIdList);
        Map<Long, ConstructionBudgetVO> constructionBudgetMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(constructionBudgetVOS)) {
            constructionBudgetMap = constructionBudgetVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }


        Map<Long, List<ProSignReserveVO>> contractMap = new HashMap<>();
//        if (CollectionUtils.isNotEmpty(contractVOS)) {
//            List<ProSignReserveVO> proSignReserveVOList1 = contractVOS.stream().filter(s -> !s.getContractName().contains("备案")).collect(Collectors.toList());
//            for (ProSignReserveVO contractVO : proSignReserveVOList1) {
//                contractVO.setContractAmount(contractVO.getAfterChangeAmount() != null ? contractVO.getAfterChangeAmount() : CommonUtils.setBigDecimalDefaultValue(contractVO.getContractAmountByContract()));
//            }
//            if (CollectionUtils.isNotEmpty(proSignReserveVOList1)){
//                contractMap = proSignReserveVOList1.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
//            }
//        }
        // 查询项目目标管理责任书
        List<ProSignReserveVO> bookVOS = proSignReserveMapper.queryBook(projectIds);
        Map<Long, ProSignReserveVO> bookMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(bookVOS)) {
            bookMap = bookVOS.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }
        // 查询责任成本数据
        List<ProSignReserveVO> responseCost = proSignReserveMapper.queryResponseCost(projectIds);
        Map<Long, ProSignReserveVO> responseCostMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(bookVOS)) {
            responseCostMap = responseCost.stream().collect(Collectors.toMap(x->x.getProjectId(), Function.identity(),(k1, k2) ->k2));
        }

        // 查询项目部人员风险金预留分配表
        List<ProSignReserveVO> allocateVOS = proSignReserveMapper.queryAllocate(projectIds, reportingMonth);
        Map<Long,  List<ProSignReserveVO>> allocateMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(allocateVOS)) {
            allocateMap = allocateVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }

        for (ProSignReserveVO vo : proSignReserveVOList) {
            vo.setReportingMonth(reportingMonth);
            Long projectId = vo.getProjectId();
//            if (!contractMap.isEmpty() && contractMap.containsKey(projectId)){
//                vo.setContractSignTime(contractMap.get(projectId).get(0).getCreateTime());
//                vo.setContractAmount(contractMap.get(projectId).stream().map(it -> it.getContractAmount()).reduce(BigDecimal.ZERO, BigDecimal::add));
//                vo.setAcContractAmount(contractMap.get(projectId).stream().map(it -> it.getAcContractAmount()).reduce(BigDecimal.ZERO, BigDecimal::add));
//            }

            if(constructionBudgetMap.containsKey(projectId)){
                ConstructionBudgetVO constructionBudgetVO1 = constructionBudgetMap.get(projectId);
                vo.setContractSignTime(constructionBudgetVO1.getCreateTime());
                vo.setContractAmount(CommonUtils.parseNullValue(constructionBudgetVO1.getContractAmount()));
                vo.setAcContractAmount(CommonUtils.parseNullValue(constructionBudgetVO1.getSelfConstructionContractAmount()));
            }else{
                vo.setContractAmount(BigDecimal.ZERO);
                vo.setAcContractAmount(BigDecimal.ZERO);

            }


            if (!bookMap.isEmpty() && bookMap.containsKey(projectId)) {
                vo.setBookSignTime(bookMap.get(projectId).getBookSignTime());
                vo.setResponsibilityCost(CommonUtils.setBigDecimalDefaultValue(bookMap.get(projectId).getResponsibilityCost()));
                vo.setUndertakingBenefits(CommonUtils.setBigDecimalDefaultValue(bookMap.get(projectId).getUndertakingBenefits()));
                vo.setUndertakingBenefitsRate(CommonUtils.setBigDecimalDefaultValue(bookMap.get(projectId).getUndertakingBenefitsRate()));
                vo.setOverallProfitMargin(CommonUtils.setBigDecimalDefaultValue(bookMap.get(projectId).getAllScale()));
            }
//            if (!responseCostMap.isEmpty() && responseCostMap.containsKey(projectId)) {
//                vo.setUndertakingBenefits(CommonUtils.setBigDecimalDefaultValue(responseCostMap.get(projectId).getUndertakingBenefits()));
//                vo.setUndertakingBenefitsRate(CommonUtils.setBigDecimalDefaultValue(responseCostMap.get(projectId).getUndertakingBenefitsRate()));
//            }
            if (!allocateMap.isEmpty() && allocateMap.containsKey(projectId)) {
                List<ProSignReserveVO> feeVOS = allocateMap.get(projectId);
                //排序获取最近的月份数据
                List<ProSignReserveVO> collectCompare = feeVOS.stream().sorted(Comparator.comparing(ProSignReserveVO::getReportingMonth).reversed())
                        .collect(Collectors.toList());
                ProSignReserveVO feeVOLj = collectCompare.stream().findFirst().get();
                vo.setTrsReservedAmount(CommonUtils.setBigDecimalDefaultValue(feeVOLj.getTrsReservedAmount()));
                vo.setApprovedReservedAmount(CommonUtils.setBigDecimalDefaultValue(feeVOLj.getApprovedReservedAmount()));
                vo.setActualReservedAmount(CommonUtils.setBigDecimalDefaultValue(feeVOLj.getActualReservedAmount()));
            }
            vo.setRiskReserve(CommonUtils.calculateRate(vo.getActualReservedAmount()!=null?vo.getActualReservedAmount():BigDecimal.ZERO, vo.getApprovedReservedAmount()!=null?vo.getApprovedReservedAmount():BigDecimal.ZERO));

            //补全二级组织信息
            CommonResponse<OrgVO> orgVo = orgApi.detailById(vo.getProjectDepartmentId());
            if (orgVo.isSuccess() && null != orgVo.getData()) {
                String innerCode = orgVo.getData().getInnerCode();
                String[] strs = innerCode.split("\\|");
                CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                if (orgVos.isSuccess() && null != orgVos.getData()) {
                    //二级组织信息
                    vo.setTwoOrgId(orgVos.getData().getId());
                    vo.setTwoOrgName(orgVos.getData().getShortName());
                    vo.setTwoOrgCode(orgVos.getData().getCode());
                    vo.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());
                }
            }
        }
        List<ProSignReserveEntity> proSignReserveEntityList = BeanMapper.mapList(proSignReserveVOList, ProSignReserveEntity.class);
        proSignReserveService.saveBatch(proSignReserveEntityList);
    }

    @Override
    public List<ProSignReserveVO> dealData(List<ProSignReserveVO> proSignReserveVOS) {
        for (ProSignReserveVO proSignReserveVO : proSignReserveVOS){
            proSignReserveVO.setContractAmount(CommonUtils.parseYuanToWanZ(proSignReserveVO.getContractAmount()));
            proSignReserveVO.setAcContractAmount(CommonUtils.parseYuanToWanZ(proSignReserveVO.getAcContractAmount()));
            proSignReserveVO.setResponsibilityCost(CommonUtils.parseYuanToWanZ(proSignReserveVO.getResponsibilityCost()));
            proSignReserveVO.setTrsReservedAmount(CommonUtils.parseYuanToWanZ(proSignReserveVO.getTrsReservedAmount()));
            proSignReserveVO.setApprovedReservedAmount(CommonUtils.parseYuanToWanZ(proSignReserveVO.getApprovedReservedAmount()));
            proSignReserveVO.setActualReservedAmount(CommonUtils.parseYuanToWanZ(proSignReserveVO.getActualReservedAmount()));
            proSignReserveVO.setUndertakingBenefits(CommonUtils.parseYuanToWanZ(proSignReserveVO.getUndertakingBenefits()));
        }

        //处理第一行合计值
        ProSignReserveVO proSignReserveVO = new ProSignReserveVO();
        ArrayList<ProSignReserveVO> newList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(proSignReserveVOS)){
            getSumData(proSignReserveVOS, proSignReserveVO);
            proSignReserveVO.setNumber("合计");
            proSignReserveVO.setId(IdWorker.getId());
            newList.add(proSignReserveVO);
        }

        //计算排序字段
        for(ProSignReserveVO proSignReserveVOrder :proSignReserveVOS){
            proSignReserveVOrder.setProjectStatusOrder(CommonUtils.getProjectOrderNum(proSignReserveVOrder.getProjectStatus().intValue()));
        }

        //计算项目状态合计
        proSignReserveVOS = proSignReserveVOS.stream().sorted(Comparator.comparing(ProSignReserveVO::getProjectStatusOrder))
                .collect(Collectors.toList());
        Map<Integer, List<ProSignReserveVO>> mapProjectStatusOrder = proSignReserveVOS.stream().collect(
                Collectors.groupingBy(
                        s -> s.getProjectStatusOrder()
                ));
        mapProjectStatusOrder.forEach((projectStatusKey,projectStatusList)->{
            ProSignReserveVO projectStatusSumVO = new ProSignReserveVO();
            projectStatusSumVO.setNumber("项目状态合计");
            projectStatusSumVO.setId(IdWorker.getId());
            projectStatusSumVO.setProjectStatusName(CommonUtils.getProjectStatusNameProject(projectStatusKey));
            getSumData(projectStatusList, projectStatusSumVO);
            newList.add(projectStatusSumVO);

            //计算组织状态合计
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(ProSignReserveVO::getOrgStatusOrder))
                    .collect(Collectors.toList());
            Map<Integer, List<ProSignReserveVO>> mapOrgStatusOrder = projectStatusList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getOrgStatusOrder()
                    ));
            mapOrgStatusOrder.forEach((orgStatusKey,orgStatusList)->{
                ProSignReserveVO orgStatusSumVO = new ProSignReserveVO();
                orgStatusSumVO.setNumber("单位小计");
                orgStatusSumVO.setId(IdWorker.getId());
                orgStatusSumVO.setProjectStatusName(CommonUtils.getProjectStatusName(orgStatusList.stream().findFirst().get().getProjectStatus().intValue()));
                orgStatusSumVO.setTwoOrgName(orgStatusList.stream().findFirst().get().getTwoOrgName());
                getSumData(orgStatusList, orgStatusSumVO);
                newList.add(orgStatusSumVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ProSignReserveVO::getProjectCreateTime))
                        .collect(Collectors.toList());
                for (ProSignReserveVO proSignReserveVONum : orgStatusList){
                    proSignReserveVONum.setNumber(number +"");
                    number = number + 1;
                    proSignReserveVONum.setProjectStatusName(CommonUtils.getProjectStatusName(proSignReserveVONum.getProjectStatus().intValue()));
                }
                newList.addAll(orgStatusList);
            });

        });
        return newList;
    }

    private void getSumData(List<ProSignReserveVO> proSignReserveVOS, ProSignReserveVO proSignReserveVO) {

        proSignReserveVO.setContractAmount((proSignReserveVOS.stream().filter(it -> it.getContractAmount() != null).map(it -> it.getContractAmount()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proSignReserveVO.setAcContractAmount((proSignReserveVOS.stream().filter(it -> it.getAcContractAmount() != null).map(it -> it.getAcContractAmount()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proSignReserveVO.setResponsibilityCost((proSignReserveVOS.stream().filter(it -> it.getResponsibilityCost() != null).map(it -> it.getResponsibilityCost()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proSignReserveVO.setTrsReservedAmount((proSignReserveVOS.stream().filter(it -> it.getTrsReservedAmount() != null).map(it -> it.getTrsReservedAmount()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proSignReserveVO.setApprovedReservedAmount((proSignReserveVOS.stream().filter(it -> it.getApprovedReservedAmount() != null).map(it -> it.getApprovedReservedAmount()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proSignReserveVO.setActualReservedAmount((proSignReserveVOS.stream().filter(it -> it.getActualReservedAmount() != null).map(it -> it.getActualReservedAmount()).reduce(BigDecimal.ZERO, BigDecimal::add)));
        proSignReserveVO.setUndertakingBenefits((proSignReserveVOS.stream().filter(it -> it.getUndertakingBenefits() != null).map(it -> it.getUndertakingBenefits()).reduce(BigDecimal.ZERO, BigDecimal::add)));

        //汇总∑（向下所属项目自施合同额*承接效益率）/∑向下所属项目自施合同额
        //汇总∑（向下所属项目自施合同额*承接效益率）
        BigDecimal acContractAmount = BigDecimal.ZERO;
//        单位小计=∑（向下所属项目自施合同额*目标效益率）/∑向下所属项目自施合同额
//        状态合计=（向下所属项目自施合同额*目标效益率）/∑向下所属项目自施合同额
        //目标效益率计算
        BigDecimal OverallProfitMarginMny = BigDecimal.ZERO;
        for (ProSignReserveVO proSignReserve : proSignReserveVOS){

            acContractAmount = acContractAmount.add(CommonUtils.parseNullValue(proSignReserve.getAcContractAmount()).multiply(CommonUtils.parseNullValue(proSignReserve.getUndertakingBenefitsRate()).divide(new BigDecimal(100))));
            OverallProfitMarginMny = OverallProfitMarginMny.add(CommonUtils.parseNullValue(proSignReserve.getAcContractAmount()).multiply(CommonUtils.parseNullValue(proSignReserve.getOverallProfitMargin()).divide(new BigDecimal(100))));
        }
        proSignReserveVO.setUndertakingBenefitsRate(CommonUtils.calculateRate(acContractAmount,proSignReserveVO.getAcContractAmount()));
        proSignReserveVO.setOverallProfitMargin(CommonUtils.calculateRate(OverallProfitMarginMny,proSignReserveVO.getAcContractAmount()));


    }
}
