package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.CostEntity;
import com.ejianc.business.analysis.bean.FeeEntity;
import com.ejianc.business.analysis.mapper.CostMapper;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.service.ICostService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.FeeVO;
import com.ejianc.business.analysis.vo.ProfitIncomeVO;
import com.ejianc.business.analysis.vo.ProfitVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.analysis.mapper.ProfitMapper;
import com.ejianc.business.analysis.bean.ProfitEntity;
import com.ejianc.business.analysis.service.IProfitService;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 财务账面利润情况
 * 
 * @author generator
 * 
 */
@Service("profitService")
public class ProfitServiceImpl extends BaseServiceImpl<ProfitMapper, ProfitEntity> implements IProfitService{
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;
    @Autowired
    private ProfitMapper profitMapper;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProfitService profitService;
    @Autowired
    private IDefdocApi defdocApi;
    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
//获取查询数据的截止时间
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
//        String reportingMonth = "2023-06";

        //先删后增
        LambdaQueryWrapper<ProfitEntity> lambdaFee = Wrappers.<ProfitEntity>lambdaQuery();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            lambdaFee.in(ProfitEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ProfitEntity::getReportingMonth, reportingMonth);
        profitService.remove(lambdaFee);

        //查询项目信息数据
        List<ProfitIncomeVO> profitIncomeVOList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(projectIdList)){
            //如果projectList不为空，证明是修改数据，而不是生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(projectIdList,1);
        }else{
            //等于1代表预生成数据
            profitIncomeVOList = profitIncomeMapper.getProjects(null,1);
        }
        //过滤掉公司费用类公共项目
        CommonResponse<List<DefdocDetailVO>> plProject = defdocApi.getDefDocByDefCode("pl_project");
        if (!plProject.isSuccess()){
            throw new BusinessException("根据档案编码查询档案项失败!");
        }
        List<DefdocDetailVO> defdocDetailVOList = plProject.getData();

        Map<String, List<DefdocDetailVO>> nameMap = new HashMap<>();

        if (CollectionUtils.isNotEmpty(defdocDetailVOList)){
            nameMap =defdocDetailVOList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getName()
                    ));
        }

//过滤掉过滤掉公司费用类公共项目
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)){
            Map<String, List<DefdocDetailVO>> finalNameMap = nameMap;
            profitIncomeVOList = profitIncomeVOList.stream().filter(s-> !finalNameMap.containsKey(s.getProjectName())).collect(Collectors.toList());
        }

        //获取财务累计列报收入数据
        List<ProfitVO> bqData = profitMapper.getIncomeData(reportingMonth, projectIdList);
        //获取累计值
        List<ProfitVO> ljData = profitMapper.getLjData(reportingMonth, projectIdList);

        Map<Long, List<ProfitVO>> mapIncome = new HashMap<>();
        Map<Long, List<ProfitVO>> mapLj = new HashMap<>();
        if (CollectionUtils.isNotEmpty(bqData)){
            mapIncome = bqData.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getProjectId()
                    ));
        }
        if (CollectionUtils.isNotEmpty(ljData)){
            mapLj = ljData.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getProjectId()
                    ));
        }

        //组合数据
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)){
            List<ProfitVO> feeVOList = BeanMapper.mapList(profitIncomeVOList, ProfitVO.class);
            for (ProfitVO feeVO : feeVOList){
                feeVO.setReportingMonth(reportingMonth);//取当前生成月份日期
                feeVO.setCreateTime(new Date());
                //设置财务累计列报收入
                if (mapIncome.containsKey(feeVO.getProjectId())){
                    List<ProfitVO> feeVOS = mapIncome.get(feeVO.getProjectId());
                    List<ProfitVO> collectCompare = feeVOS.stream().sorted(Comparator.comparing(ProfitVO::getReportingMonth).reversed())
                            .collect(Collectors.toList());
                    ProfitVO feeVOIncome = collectCompare.stream().findFirst().get();
                    feeVO.setIncomeMny(CommonUtils.parseNullValue(feeVOIncome.getIncomeMny()));
                }else{
                    feeVO.setIncomeMny(BigDecimal.ZERO);
                }
                //设置累计值
                if (mapLj.containsKey(feeVO.getProjectId())){
                    List<ProfitVO> feeVOS = mapLj.get(feeVO.getProjectId());
                    //排序获取最近的月份数据
                    List<ProfitVO> collectCompare = feeVOS.stream().sorted(Comparator.comparing(ProfitVO::getReportingMonth).reversed())
                            .collect(Collectors.toList());
                    ProfitVO feeVOLj = collectCompare.stream().findFirst().get();
                    feeVO.setCostMny(CommonUtils.parseNullValue(feeVOLj.getCostMny()));
                }else{
                    feeVO.setCostMny(BigDecimal.ZERO);
                }
                //补全二级组织信息
                CommonResponse<OrgVO> orgVo = orgApi.detailById(feeVO.getProjectDepartmentId());//此处是项目部id 1286211352287834113
                if (orgVo.isSuccess() && null != orgVo.getData()) {
                    String innerCode = orgVo.getData().getInnerCode();
                    String[] strs = innerCode.split("\\|");
                    CommonResponse<OrgVO> orgVos = orgApi.detailById(Long.parseLong(strs[1]));
                    if (orgVos.isSuccess() && null != orgVos.getData()) {
                        //二级组织信息
                        feeVO.setTwoOrgId(orgVos.getData().getId());
                        feeVO.setTwoOrgName(orgVos.getData().getShortName());
                        feeVO.setTwoOrgCode(orgVos.getData().getCode());
                        feeVO.setOrgStatusOrder(orgVos.getData().getSequence() == null ? 1000: orgVos.getData().getSequence());

                    }
                }
            }

            List<ProfitEntity> feeEntityList = BeanMapper.mapList(feeVOList, ProfitEntity.class);
            profitService.saveBatch(feeEntityList);
        }

    }

    @Override
    public List<ProfitVO> dealData(List<ProfitVO> feeVOS) {
        for (ProfitVO profitVO : feeVOS){
            //转万元赋值
            profitVO.setIncomeMny(CommonUtils.parseYuanToWan(profitVO.getIncomeMny()));
            profitVO.setCostMny(CommonUtils.parseYuanToWan(profitVO.getCostMny()));
        }

        //处理第一行合计值
        ProfitVO feeVO = new ProfitVO();
        ArrayList<ProfitVO> feeNewList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(feeVOS)){
            getSumData(feeVOS, feeVO);
            feeVO.setNumber("合计");
            feeVO.setId(IdWorker.getId());
            feeNewList.add(feeVO);
        }
        //计算排序字段
        for(ProfitVO feeVOrder :feeVOS){
            feeVOrder.setProjectStatusOrder(CommonUtils.getProjectOrderNum(feeVOrder.getProjectStatus()));
//            feeVOrder.setOrgStatusOrder(CommonUtils.getOrgOrderNum(feeVOrder.getTwoOrgName()));
        }

        //计算项目状态合计
        feeVOS = feeVOS.stream().sorted(Comparator.comparing(ProfitVO::getProjectStatusOrder))
                .collect(Collectors.toList());
        Map<Integer, List<ProfitVO>> mapProjectStatusOrder = feeVOS.stream().collect(
                Collectors.groupingBy(
                        s -> s.getProjectStatusOrder()
                ));


        mapProjectStatusOrder.forEach((projectStatusKey,projectStatusList)->{
            ProfitVO projectStatusSumfeeVO = new ProfitVO();
            projectStatusSumfeeVO.setNumber("项目状态合计");
            projectStatusSumfeeVO.setId(IdWorker.getId());
            projectStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusNameProject(projectStatusKey));
            getSumData(projectStatusList, projectStatusSumfeeVO);
            feeNewList.add(projectStatusSumfeeVO);

            //计算组织状态合计
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(ProfitVO::getOrgStatusOrder))
                    .collect(Collectors.toList());
            Map<Integer, List<ProfitVO>> mapOrgStatusOrder = projectStatusList.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getOrgStatusOrder()
                    ));
            mapOrgStatusOrder.forEach((orgStatusKey,orgStatusList)->{
                ProfitVO orgStatusSumfeeVO = new ProfitVO();
                orgStatusSumfeeVO.setNumber("单位小计");
                orgStatusSumfeeVO.setId(IdWorker.getId());
                orgStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(orgStatusList.stream().findFirst().get().getProjectStatus()));
                orgStatusSumfeeVO.setTwoOrgName(orgStatusList.stream().findFirst().get().getTwoOrgName());
                getSumData(orgStatusList, orgStatusSumfeeVO);
                feeNewList.add(orgStatusSumfeeVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ProfitVO::getProjectCreateTime))
                        .collect(Collectors.toList());
                for (ProfitVO feeVONum : orgStatusList){
                    feeVONum.setNumber(number +"");
                    number = number + 1;
                    feeVONum.setProjectStatusName(CommonUtils.getProjectStatusName(feeVONum.getProjectStatus()));
                    //转万元赋值
//                    feeVONum.setIncomeMny(CommonUtils.parseYuanToWan(feeVONum.getIncomeMny()));
//                    feeVONum.setCostMny(CommonUtils.parseYuanToWan(feeVONum.getCostMny()));

                    //计算利润和占比
                    feeVONum.setProfitMny(ComputeUtil.safeSub(feeVONum.getIncomeMny(),feeVONum.getCostMny()));
                    feeVONum.setProfitRate(CommonUtils.calculateRate(feeVONum.getProfitMny(),feeVONum.getIncomeMny()));
                }
                feeNewList.addAll(orgStatusList);
            });

        });
        return feeNewList;
    }

    private void getSumData(List<ProfitVO> feeVOS, ProfitVO feeVO) {
        BigDecimal incomeMny = feeVOS.stream().filter(s->s.getIncomeMny() != null).map(ProfitVO::getIncomeMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal costMny = feeVOS.stream().filter(s->s.getCostMny() != null).map(ProfitVO::getCostMny)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
        //转万元赋值
        feeVO.setIncomeMny((incomeMny));
        feeVO.setCostMny((costMny));

        //计算利润和占比
        feeVO.setProfitMny(ComputeUtil.safeSub(feeVO.getIncomeMny(),feeVO.getCostMny()));
        feeVO.setProfitRate(CommonUtils.calculateRate(feeVO.getProfitMny(),feeVO.getIncomeMny()));

    }
}
