/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.BusinessEntity;
import com.ejianc.business.analysis.mapper.BusinessMapper;
import com.ejianc.business.analysis.mapper.ConstructionBudgetMapper;
import com.ejianc.business.analysis.mapper.GoldMapper;
import com.ejianc.business.analysis.mapper.ProSignReserveMapper;
import com.ejianc.business.analysis.mapper.ProfitIncomeMapper;
import com.ejianc.business.analysis.mapper.ProfitMapper;
import com.ejianc.business.analysis.mapper.ProjectBusinessMapper;
import com.ejianc.business.analysis.mapper.ProjectPaymentMapper;
import com.ejianc.business.analysis.service.IBusinessService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.BusinessVO;
import com.ejianc.business.analysis.vo.ConstructionBudgetVO;
import com.ejianc.business.analysis.vo.GoldVO;
import com.ejianc.business.analysis.vo.ProSignReserveVO;
import com.ejianc.business.analysis.vo.ProfitVO;
import com.ejianc.business.analysis.vo.ProjectBusinessVO;
import com.ejianc.business.analysis.vo.ProjectPaymentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="businessService")
public class BusinessServiceImpl
extends BaseServiceImpl<BusinessMapper, BusinessEntity>
implements IBusinessService {
    @Autowired
    private IBusinessService businessService;
    @Autowired
    private BusinessMapper businessMapper;
    @Autowired
    private ProfitIncomeMapper profitIncomeMapper;
    @Autowired
    private ConstructionBudgetMapper constructionBudgetMapper;
    @Autowired
    private ProSignReserveMapper proSignReserveMapper;
    @Autowired
    private ProjectBusinessMapper projectBusinessMapper;
    @Autowired
    private ProjectPaymentMapper projectPaymentMapper;
    @Autowired
    private GoldMapper goldMapper;
    @Autowired
    private ProfitMapper profitMapper;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IDefdocApi defdocApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        LambdaQueryWrapper lambdaFee = Wrappers.lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaFee.in(BusinessEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(BusinessEntity::getReportingMonth, (Object)reportingMonth);
        this.businessService.remove((Wrapper)lambdaFee);
        List<Object> profitIncomeVOList = new ArrayList();
        CommonResponse plProject = this.defdocApi.getDefDocByDefCode("pl_project");
        if (!plProject.isSuccess()) {
            throw new BusinessException("\u6839\u636e\u6863\u6848\u7f16\u7801\u67e5\u8be2\u6863\u6848\u9879\u5931\u8d25!");
        }
        List defdocDetailVOList = (List)plProject.getData();
        Map<Object, Object> nameMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)defdocDetailVOList)) {
            nameMap = defdocDetailVOList.stream().collect(Collectors.groupingBy(s -> s.getName()));
        }
        if (CollectionUtils.isNotEmpty(profitIncomeVOList = CollectionUtils.isNotEmpty(projectIdList) ? this.profitIncomeMapper.getProjects(projectIdList, 2) : this.profitIncomeMapper.getProjects(null, 2))) {
            Map<Object, Object> finalNameMap = nameMap;
            profitIncomeVOList = profitIncomeVOList.stream().filter(s -> !finalNameMap.containsKey(s.getProjectName())).collect(Collectors.toList());
        }
        String yearMonth = CommonUtils.getSysYearAndFirstMonth();
        List<Object> constructionBudgetVOS = new ArrayList();
        List<Object> conDrawList = new ArrayList();
        constructionBudgetVOS = this.constructionBudgetMapper.getContract(projectIdList);
        conDrawList = this.constructionBudgetMapper.getDraw(projectIdList);
        Map<Object, Object> constructionBudgetMap = new HashMap();
        Map<Object, Object> mxMap = new HashMap();
        if (CollectionUtils.isNotEmpty(constructionBudgetVOS)) {
            constructionBudgetMap = constructionBudgetVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        Map<Object, Object> conDrawMap = new HashMap();
        if (CollectionUtils.isNotEmpty(conDrawList)) {
            conDrawMap = conDrawList.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        List<ProSignReserveVO> bookVOS = this.proSignReserveMapper.queryBook(projectIdList);
        Map<Object, Object> bookMap = new HashMap();
        if (CollectionUtils.isNotEmpty(bookVOS)) {
            bookMap = bookVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        List<ProjectBusinessVO> countersignatureList = this.projectBusinessMapper.queryCountersignature(projectIdList);
        List<ProjectBusinessVO> businessplanningeffectList = this.projectBusinessMapper.queryBusinessplanningeffect(projectIdList);
        Map businessplanningeffectListMap = businessplanningeffectList.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        Map<Object, Object> countersignatureListMap = new HashMap();
        if (CollectionUtils.isNotEmpty(countersignatureList)) {
            countersignatureListMap = countersignatureList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        List<BusinessVO> businessVORiskList = this.businessMapper.getRiskMny(reportingMonth, projectIdList);
        Map<Object, Object> mapRisk = new HashMap();
        if (CollectionUtils.isNotEmpty(businessVORiskList)) {
            mapRisk = businessVORiskList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        Map<Object, Object> CurrentMonthMap = new HashMap();
        List<BusinessVO> currentMonthList = this.businessMapper.getCurrentMonthMny(reportingMonth, projectIdList);
        if (CollectionUtils.isNotEmpty(currentMonthList)) {
            CurrentMonthMap = currentMonthList.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        List<ProjectPaymentVO> costanalysisList = this.projectPaymentMapper.quertCostanalysis(yearMonth, reportingMonth, projectIdList);
        Map<Object, Object> costanalysisListMap = new HashMap();
        if (CollectionUtils.isNotEmpty(costanalysisList)) {
            costanalysisListMap = costanalysisList.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        List<ProjectPaymentVO> enginnerTotalList = this.projectPaymentMapper.quertEngineermeasurementTotal(reportingMonth, projectIdList);
        Map<Object, Object> enginnerTotalListMap = new HashMap();
        if (CollectionUtils.isNotEmpty(enginnerTotalList)) {
            enginnerTotalListMap = enginnerTotalList.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        List<ProjectPaymentVO> costanalysisTotalList = this.projectPaymentMapper.quertCostanalysisTotal(reportingMonth, projectIdList);
        Map<Object, Object> costanalysisTotalListMap = new HashMap();
        if (CollectionUtils.isNotEmpty(costanalysisTotalList)) {
            costanalysisTotalListMap = costanalysisTotalList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        List<BusinessVO> sumMonthList = this.businessMapper.getSumMonthMny(reportingMonth, projectIdList);
        Map<Object, Object> sumMonthMap = new HashMap();
        if (CollectionUtils.isNotEmpty(sumMonthList)) {
            sumMonthMap = sumMonthList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        List<GoldVO> ljData = this.goldMapper.getLjData(reportingMonth, projectIdList);
        Map<Object, Object> mapLj = new HashMap();
        if (CollectionUtils.isNotEmpty(ljData)) {
            mapLj = ljData.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        List<ProfitVO> bqData = this.profitMapper.getIncomeData(reportingMonth, projectIdList);
        Map<Object, Object> mapIncome = new HashMap();
        if (CollectionUtils.isNotEmpty(bqData)) {
            mapIncome = bqData.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        List<ProfitVO> ljDataProfit = this.profitMapper.getLjData(reportingMonth, projectIdList);
        Map<Object, Object> mapLjProfit = new HashMap();
        if (CollectionUtils.isNotEmpty(ljDataProfit)) {
            mapLjProfit = ljDataProfit.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        List<ProjectPaymentVO> quertPaymentTotalList = this.projectPaymentMapper.quertPaymentTotal(reportingMonth, projectIdList);
        Map<Object, Object> quertPaymentTotalListMap = new HashMap();
        List<ProjectPaymentVO> quertAnalysisList = this.projectPaymentMapper.quertAnalysis(reportingMonth, projectIdList);
        if (CollectionUtils.isNotEmpty(quertPaymentTotalList)) {
            quertPaymentTotalListMap = quertPaymentTotalList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        if (CollectionUtils.isNotEmpty(quertAnalysisList)) {
            List<ProjectPaymentVO> quertCosthuizongList;
            ArrayList projectPaymentVOList1 = new ArrayList();
            Map<Long, List<ProjectPaymentVO>> quertAnalysisListGrBy = quertAnalysisList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
            quertAnalysisListGrBy.forEach((orgStatusKey, orgStatusList) -> {
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(ProjectPaymentVO::getReportingMonth).reversed()).collect(Collectors.toList());
                projectPaymentVOList1.add(orgStatusList.stream().findFirst().get());
            });
            ArrayList<Long> idList = new ArrayList<Long>();
            for (ProjectPaymentVO paymentVO : projectPaymentVOList1) {
                idList.add(paymentVO.getAnalysisId());
            }
            if (CollectionUtils.isNotEmpty(idList) && CollectionUtils.isNotEmpty(quertCosthuizongList = this.projectPaymentMapper.quertCosthuizong(idList))) {
                Map<Long, List<ProjectPaymentVO>> quertCosthuizongListMap = quertCosthuizongList.stream().collect(Collectors.groupingBy(s -> s.getAnalysisId()));
                for (ProjectPaymentVO paymentVO2 : projectPaymentVOList1) {
                    if (!quertCosthuizongListMap.containsKey(paymentVO2.getAnalysisId())) continue;
                    List<ProjectPaymentVO> projectPaymentVOList = quertCosthuizongListMap.get(paymentVO2.getAnalysisId());
                    BigDecimal acostActual = projectPaymentVOList.stream().filter(s -> s.getAcostActual() != null).map(ProjectPaymentVO::getAcostActual).reduce(BigDecimal.ZERO, BigDecimal::add);
                    paymentVO2.setAcostActual(acostActual);
                    BigDecimal havePaidTotal = projectPaymentVOList.stream().filter(s -> s.getHavePaidTotal() != null).map(ProjectPaymentVO::getHavePaidTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
                    paymentVO2.setHavePaidTotal(havePaidTotal);
                }
            }
            if (CollectionUtils.isNotEmpty(projectPaymentVOList1)) {
                mxMap = projectPaymentVOList1.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
            }
        }
        if (CollectionUtils.isNotEmpty(profitIncomeVOList)) {
            List businessVOList = BeanMapper.mapList(profitIncomeVOList, BusinessVO.class);
            for (BusinessVO businessVO : businessVOList) {
                String innerCode;
                String[] strs;
                CommonResponse orgVos;
                List paymentVOList;
                BusinessVO feeVOLj;
                List collectCompare;
                List feeVOS;
                ConstructionBudgetVO constructionBudgetVO1;
                ProjectPaymentVO paymentVO;
                businessVO.setReportingMonth(reportingMonth);
                businessVO.setCreateTime(new Date());
                Long projectId = businessVO.getProjectId();
                if (constructionBudgetMap.containsKey(businessVO.getProjectId())) {
                    constructionBudgetVO1 = (ConstructionBudgetVO)((Object)constructionBudgetMap.get(businessVO.getProjectId()));
                    businessVO.setSignContract(CommonUtils.parseNullValue(constructionBudgetVO1.getContractAmount()));
                    businessVO.setOneselfContract(CommonUtils.parseNullValue(constructionBudgetVO1.getSelfConstructionContractAmount()));
                } else {
                    businessVO.setSignContract(BigDecimal.ZERO);
                    businessVO.setOneselfContract(BigDecimal.ZERO);
                }
                if (conDrawMap.containsKey(businessVO.getProjectId())) {
                    constructionBudgetVO1 = (ConstructionBudgetVO)((Object)conDrawMap.get(businessVO.getProjectId()));
                    businessVO.setBudgetLimit(CommonUtils.parseNullValue(constructionBudgetVO1.getBudgetMny()));
                } else {
                    businessVO.setBudgetLimit(BigDecimal.ZERO);
                }
                if (!bookMap.isEmpty() && bookMap.containsKey(businessVO.getProjectId())) {
                    businessVO.setBookSignTime(((ProSignReserveVO)bookMap.get(projectId)).getBookSignTime());
                    businessVO.setResponsibilityCost(CommonUtils.setBigDecimalDefaultValue(((ProSignReserveVO)bookMap.get(projectId)).getResponsibilityCost()));
                    businessVO.setUndertakingBenefitsRate(CommonUtils.setBigDecimalDefaultValue(((ProSignReserveVO)bookMap.get(projectId)).getUndertakingBenefitsRate()));
                    businessVO.setOverallProfitMargin(((ProSignReserveVO)bookMap.get(projectId)).getAllScale());
                } else {
                    businessVO.setResponsibilityCost(BigDecimal.ZERO);
                    businessVO.setUndertakingBenefitsRate(BigDecimal.ZERO);
                    businessVO.setOverallProfitMargin(BigDecimal.ZERO);
                }
                if (businessplanningeffectListMap.containsKey(businessVO.getProjectId())) {
                    ProjectBusinessVO projectBusinessVO1 = (ProjectBusinessVO)((Object)businessplanningeffectListMap.get(businessVO.getProjectId()));
                    businessVO.setApprovalTotal(CommonUtils.isIntNull(projectBusinessVO1.getSetUpItem()));
                    businessVO.setPredictMoney(CommonUtils.parseNullValue(projectBusinessVO1.getExpectEffect()));
                    businessVO.setAmount(CommonUtils.isIntNull(projectBusinessVO1.getImplementItem()));
                    businessVO.setPlanMoney(CommonUtils.parseNullValue(projectBusinessVO1.getPlanEffect()));
                } else {
                    businessVO.setApprovalTotal(Integer.valueOf(0));
                    businessVO.setPredictMoney(BigDecimal.ZERO);
                    businessVO.setAmount(Integer.valueOf(0));
                    businessVO.setPlanMoney(BigDecimal.ZERO);
                }
                if (countersignatureListMap.containsKey(businessVO.getProjectId())) {
                    List projectBusinessVOS = (List)countersignatureListMap.get(businessVO.getProjectId());
                    businessVO.setBusinessFlag(projectBusinessVOS.size() > 0 ? "\u662f" : "\u5426");
                } else {
                    businessVO.setBusinessFlag("\u5426");
                }
                if (mapRisk.containsKey(businessVO.getProjectId())) {
                    feeVOS = (List)mapRisk.get(businessVO.getProjectId());
                    collectCompare = feeVOS.stream().sorted(Comparator.comparing(BusinessVO::getReportingMonth).reversed()).collect(Collectors.toList());
                    feeVOLj = (BusinessVO)collectCompare.stream().findFirst().get();
                    businessVO.setYylMny(CommonUtils.parseNullValue(feeVOLj.getYylMny()));
                    businessVO.setActualMny(CommonUtils.parseNullValue(feeVOLj.getActualMny()));
                } else {
                    businessVO.setYylMny(BigDecimal.ZERO);
                    businessVO.setActualMny(BigDecimal.ZERO);
                }
                if (CurrentMonthMap.containsKey(businessVO.getProjectId())) {
                    feeVOS = (BusinessVO)CurrentMonthMap.get(businessVO.getProjectId());
                    businessVO.setProductionMoney(CommonUtils.parseNullValue(feeVOS.getProductionMoney()));
                    businessVO.setActualCostMoney(CommonUtils.parseNullValue(feeVOS.getActualCostMoney()));
                } else {
                    businessVO.setProductionMoney(BigDecimal.ZERO);
                    businessVO.setActualCostMoney(BigDecimal.ZERO);
                }
                if (costanalysisListMap.containsKey(businessVO.getProjectId())) {
                    paymentVO = (ProjectPaymentVO)((Object)costanalysisListMap.get(businessVO.getProjectId()));
                    businessVO.setActualFinishProductionNear(CommonUtils.parseNullValue(paymentVO.getActualFinishProductionNear()));
                } else {
                    businessVO.setActualFinishProductionNear(BigDecimal.ZERO);
                }
                if (enginnerTotalListMap.containsKey(businessVO.getProjectId())) {
                    paymentVO = (ProjectPaymentVO)((Object)enginnerTotalListMap.get(businessVO.getProjectId()));
                    businessVO.setOwnerAffirmProduction(CommonUtils.parseNullValue(paymentVO.getOwnerAffirmProduction()));
                } else {
                    businessVO.setOwnerAffirmProduction(BigDecimal.ZERO);
                }
                if (costanalysisTotalListMap.containsKey(businessVO.getProjectId())) {
                    ProjectPaymentVO paymentVO2;
                    paymentVOList = (List)costanalysisTotalListMap.get(businessVO.getProjectId());
                    collectCompare = paymentVOList.stream().sorted(Comparator.comparing(ProjectPaymentVO::getReportingMonth).reversed()).collect(Collectors.toList());
                    paymentVO2 = (ProjectPaymentVO)((Object)collectCompare.stream().findFirst().get());
                    businessVO.setActualFinishProduction(CommonUtils.parseNullValue(paymentVO2.getActualFinishProduction()));
                } else {
                    businessVO.setActualFinishProduction(BigDecimal.ZERO);
                }
                if (businessVO.getProjectStatus() != null && businessVO.getProjectStatus() == 6) {
                    businessVO.setOwnerAffirmProduction(CommonUtils.setBigDecimalDefaultValue(businessVO.getActualFinishProduction()));
                }
                if (sumMonthMap.containsKey(businessVO.getProjectId())) {
                    feeVOS = (List)sumMonthMap.get(businessVO.getProjectId());
                    collectCompare = feeVOS.stream().sorted(Comparator.comparing(BusinessVO::getReportingMonth).reversed()).collect(Collectors.toList());
                    feeVOLj = (BusinessVO)collectCompare.stream().findFirst().get();
                    businessVO.setSumActualCostMoney(CommonUtils.parseNullValue(feeVOLj.getSumActualCostMoney()));
                    businessVO.setSumResponseCostMoney(CommonUtils.parseNullValue(feeVOLj.getSumResponseCostMoney()));
                } else {
                    businessVO.setSumActualCostMoney(BigDecimal.ZERO);
                    businessVO.setSumResponseCostMoney(BigDecimal.ZERO);
                }
                if (mapLj.containsKey(businessVO.getProjectId())) {
                    feeVOS = (List)mapLj.get(businessVO.getProjectId());
                    collectCompare = feeVOS.stream().sorted(Comparator.comparing(GoldVO::getReportingMonth).reversed()).collect(Collectors.toList());
                    feeVOLj = (GoldVO)collectCompare.stream().findFirst().get();
                    businessVO.setCompletedBalance(CommonUtils.parseNullValue(feeVOLj.getCompletedBalance()));
                    businessVO.setStockUp(CommonUtils.parseNullValue(feeVOLj.getStockUp()));
                    businessVO.setAccountReceive(CommonUtils.parseNullValue(feeVOLj.getAccountReceive()));
                } else {
                    businessVO.setCompletedBalance(BigDecimal.ZERO);
                    businessVO.setStockUp(BigDecimal.ZERO);
                    businessVO.setAccountReceive(BigDecimal.ZERO);
                }
                if (mapLjProfit.containsKey(businessVO.getProjectId())) {
                    feeVOS = (List)mapLjProfit.get(businessVO.getProjectId());
                    collectCompare = feeVOS.stream().sorted(Comparator.comparing(ProfitVO::getReportingMonth).reversed()).collect(Collectors.toList());
                    feeVOLj = (ProfitVO)collectCompare.stream().findFirst().get();
                    businessVO.setCostMny(CommonUtils.parseNullValue(feeVOLj.getCostMny()));
                } else {
                    businessVO.setCostMny(BigDecimal.ZERO);
                }
                if (mapIncome.containsKey(businessVO.getProjectId())) {
                    feeVOS = (List)mapIncome.get(businessVO.getProjectId());
                    collectCompare = feeVOS.stream().sorted(Comparator.comparing(ProfitVO::getReportingTime).reversed()).collect(Collectors.toList());
                    ProfitVO feeVOIncome = (ProfitVO)collectCompare.stream().findFirst().get();
                    businessVO.setIncomeMny(CommonUtils.parseNullValue(feeVOIncome.getIncomeMny()));
                } else {
                    businessVO.setIncomeMny(BigDecimal.ZERO);
                }
                if (CollectionUtils.isNotEmpty(enginnerTotalList)) {
                    if (enginnerTotalListMap.containsKey(businessVO.getProjectId())) {
                        paymentVO = (ProjectPaymentVO)((Object)enginnerTotalListMap.get(businessVO.getProjectId()));
                        businessVO.setContractReceipt(CommonUtils.parseNullValue(paymentVO.getContractReceipt()));
                        businessVO.setProjectFunds(CommonUtils.parseNullValue(paymentVO.getProjectFunds()));
                    } else {
                        businessVO.setContractReceipt(BigDecimal.ZERO);
                        businessVO.setProjectFunds(BigDecimal.ZERO);
                    }
                }
                if (quertPaymentTotalListMap.containsKey(businessVO.getProjectId())) {
                    paymentVOList = (List)quertPaymentTotalListMap.get(businessVO.getProjectId());
                    collectCompare = paymentVOList.stream().sorted(Comparator.comparing(ProjectPaymentVO::getReportingMonth).reversed()).collect(Collectors.toList());
                    ProjectPaymentVO projectPaymentVO = (ProjectPaymentVO)((Object)collectCompare.stream().findFirst().get());
                    businessVO.setAmountPayable(CommonUtils.parseNullValue(projectPaymentVO.getAccountsPayableTotal()));
                    businessVO.setAmountPaid(CommonUtils.parseNullValue(projectPaymentVO.getHavePaidTotal()));
                }
                if (mxMap.containsKey(businessVO.getProjectId())) {
                    paymentVO = (ProjectPaymentVO)((Object)mxMap.get(businessVO.getProjectId()));
                    businessVO.setAmountPayable(ComputeUtil.safeAdd((BigDecimal)CommonUtils.parseNullValue(businessVO.getAmountPayable()), (BigDecimal)CommonUtils.parseNullValue(paymentVO.getHavePaidTotal())));
                    businessVO.setAmountPaid(ComputeUtil.safeAdd((BigDecimal)CommonUtils.parseNullValue(businessVO.getAmountPaid()), (BigDecimal)CommonUtils.parseNullValue(paymentVO.getAcostActual())));
                }
                businessVO.setAmountPayable(businessVO.getAmountPayable() == null ? BigDecimal.ZERO : businessVO.getAmountPayable());
                businessVO.setAmountPaid(businessVO.getAmountPaid() == null ? BigDecimal.ZERO : businessVO.getAmountPaid());
                CommonResponse orgVo = this.orgApi.detailById(businessVO.getProjectDepartmentId());
                if (!orgVo.isSuccess() || null == orgVo.getData() || !(orgVos = this.orgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() || null == orgVos.getData()) continue;
                businessVO.setTwoOrgId(((OrgVO)orgVos.getData()).getId());
                businessVO.setTwoOrgName(((OrgVO)orgVos.getData()).getShortName());
                businessVO.setTwoOrgCode(((OrgVO)orgVos.getData()).getCode());
                businessVO.setOrgStatusOrder(Integer.valueOf(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence()));
            }
            List feeEntityList = BeanMapper.mapList((Iterable)businessVOList, BusinessEntity.class);
            this.businessService.saveBatch(feeEntityList);
        }
    }

    @Override
    public List<BusinessVO> dealData(List<BusinessVO> feeVOS) {
        for (BusinessVO businessVO : feeVOS) {
            businessVO.setSignContract(CommonUtils.parseYuanToWan(businessVO.getSignContract()));
            businessVO.setOneselfContract(CommonUtils.parseYuanToWan(businessVO.getOneselfContract()));
            businessVO.setBudgetLimit(CommonUtils.parseYuanToWan(businessVO.getBudgetLimit()));
            businessVO.setResponsibilityCost(CommonUtils.parseYuanToWan(businessVO.getResponsibilityCost()));
            businessVO.setYylMny(CommonUtils.parseYuanToWan(businessVO.getYylMny()));
            businessVO.setActualMny(CommonUtils.parseYuanToWan(businessVO.getActualMny()));
            businessVO.setProductionMoney(CommonUtils.parseYuanToWan(businessVO.getProductionMoney()));
            businessVO.setActualCostMoney(CommonUtils.parseYuanToWan(businessVO.getActualCostMoney()));
            businessVO.setSumResponseCostMoney(CommonUtils.parseYuanToWan(businessVO.getSumResponseCostMoney()));
            businessVO.setActualFinishProductionNear(CommonUtils.parseYuanToWan(businessVO.getActualFinishProductionNear()));
            businessVO.setOwnerAffirmProduction(CommonUtils.parseYuanToWan(businessVO.getOwnerAffirmProduction()));
            businessVO.setActualFinishProduction(CommonUtils.parseYuanToWan(businessVO.getActualFinishProduction()));
            businessVO.setProfitMny(CommonUtils.parseYuanToWan(businessVO.getProfitMny()));
            businessVO.setCompletedBalance(CommonUtils.parseYuanToWan(businessVO.getCompletedBalance()));
            businessVO.setStockUp(CommonUtils.parseYuanToWan(businessVO.getStockUp()));
            businessVO.setAccountReceive(CommonUtils.parseYuanToWan(businessVO.getAccountReceive()));
            businessVO.setOutCostMny(CommonUtils.parseYuanToWan(businessVO.getOutCostMny()));
            businessVO.setIncomeMny(CommonUtils.parseYuanToWan(businessVO.getIncomeMny()));
            businessVO.setCostMny(CommonUtils.parseYuanToWan(businessVO.getCostMny()));
            businessVO.setContractReceipt(CommonUtils.parseYuanToWan(businessVO.getContractReceipt()));
            businessVO.setProjectFunds(CommonUtils.parseYuanToWan(businessVO.getProjectFunds()));
            businessVO.setAdvance(CommonUtils.parseYuanToWan(businessVO.getAdvance()));
            businessVO.setYswsMoney(CommonUtils.parseYuanToWan(businessVO.getYswsMoney()));
            businessVO.setAmountPayable(CommonUtils.parseYuanToWan(businessVO.getAmountPayable()));
            businessVO.setAmountPaid(CommonUtils.parseYuanToWan(businessVO.getAmountPaid()));
            businessVO.setContractYfwfMny(CommonUtils.parseYuanToWan(businessVO.getContractYfwfMny()));
            businessVO.setSumActualCostMoney(CommonUtils.parseYuanToWan(businessVO.getSumActualCostMoney()));
            businessVO.setActualProfitMoney(businessVO.getProductionMoney().subtract(businessVO.getActualCostMoney()));
            businessVO.setDifferenceMoney(businessVO.getSumResponseCostMoney().subtract(businessVO.getSumActualCostMoney()));
            businessVO.setProfitMny(businessVO.getActualFinishProduction().subtract(businessVO.getSumActualCostMoney()));
            businessVO.setOutIncomeMny(businessVO.getActualFinishProduction().divide(new BigDecimal(1.09), 0, 4).subtract(businessVO.getIncomeMny()));
            businessVO.setOutCostMny(businessVO.getSumActualCostMoney().divide(new BigDecimal(1.09), 0, 4).subtract(businessVO.getCostMny()));
            businessVO.setReportProfitMny(businessVO.getIncomeMny().subtract(businessVO.getCostMny()));
            businessVO.setYswsMoney(businessVO.getContractReceipt().subtract(businessVO.getProjectFunds()));
            businessVO.setContractYfwfMny(businessVO.getAmountPayable().subtract(businessVO.getAmountPaid()));
        }
        BusinessVO feeVO = new BusinessVO();
        ArrayList<BusinessVO> arrayList = new ArrayList<BusinessVO>();
        if (CollectionUtils.isNotEmpty(feeVOS)) {
            this.getSumData(feeVOS, feeVO);
            feeVO.setNumber("\u5408\u8ba1");
            feeVO.setId(Long.valueOf(IdWorker.getId()));
            arrayList.add(feeVO);
        }
        for (BusinessVO businessVO : feeVOS) {
            businessVO.setProjectStatusOrder(CommonUtils.getProjectOrderNum(businessVO.getProjectStatus()));
        }
        feeVOS = feeVOS.stream().sorted(Comparator.comparing(BusinessVO::getProjectStatusOrder)).collect(Collectors.toList());
        Map<Integer, List<BusinessVO>> mapProjectStatusOrder = feeVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectStatusOrder()));
        mapProjectStatusOrder.forEach((projectStatusKey, projectStatusList) -> {
            BusinessVO projectStatusSumfeeVO = new BusinessVO();
            projectStatusSumfeeVO.setNumber("\u9879\u76ee\u72b6\u6001\u5408\u8ba1");
            projectStatusSumfeeVO.setId(Long.valueOf(IdWorker.getId()));
            projectStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusNameProject(projectStatusKey));
            this.getSumData((List<BusinessVO>)projectStatusList, projectStatusSumfeeVO);
            feeNewList.add(projectStatusSumfeeVO);
            projectStatusList = projectStatusList.stream().sorted(Comparator.comparing(BusinessVO::getOrgStatusOrder)).collect(Collectors.toList());
            Map<Integer, List<BusinessVO>> mapOrgStatusOrder = projectStatusList.stream().collect(Collectors.groupingBy(s -> s.getOrgStatusOrder()));
            mapOrgStatusOrder.forEach((orgStatusKey, orgStatusList) -> {
                BusinessVO orgStatusSumfeeVO = new BusinessVO();
                orgStatusSumfeeVO.setNumber("\u5355\u4f4d\u5c0f\u8ba1");
                orgStatusSumfeeVO.setId(Long.valueOf(IdWorker.getId()));
                orgStatusSumfeeVO.setProjectStatusName(CommonUtils.getProjectStatusName(((BusinessVO)orgStatusList.stream().findFirst().get()).getProjectStatus()));
                orgStatusSumfeeVO.setTwoOrgName(((BusinessVO)orgStatusList.stream().findFirst().get()).getTwoOrgName());
                this.getSumData((List<BusinessVO>)orgStatusList, orgStatusSumfeeVO);
                feeNewList.add(orgStatusSumfeeVO);
                Integer number = 1;
                orgStatusList = orgStatusList.stream().sorted(Comparator.comparing(BusinessVO::getProjectCreateTime)).collect(Collectors.toList());
                for (BusinessVO feeVONum : orgStatusList) {
                    feeVONum.setNumber(number + "");
                    number = number + 1;
                    feeVONum.setProjectStatusName(CommonUtils.getProjectStatusName(feeVONum.getProjectStatus()));
                    feeVONum.setAffirmRate(CommonUtils.calculateRate(feeVONum.getOwnerAffirmProduction(), feeVONum.getSumActualCostMoney()));
                    feeVONum.setProductionRate(CommonUtils.calculateRate(feeVONum.getOwnerAffirmProduction(), feeVONum.getActualFinishProduction()));
                    feeVONum.setProfitRate(CommonUtils.calculateRate(feeVONum.getProfitMny(), feeVONum.getActualFinishProduction()));
                    feeVONum.setReportProfitRate(CommonUtils.calculateRate(feeVONum.getReportProfitMny(), feeVONum.getIncomeMny()));
                    feeVONum.setYswsRate(CommonUtils.calculateRate(feeVONum.getProjectFunds().add(feeVONum.getAdvance()), feeVONum.getOwnerAffirmProduction()));
                    feeVONum.setCostSxRate(CommonUtils.calculateRate(feeVONum.getProjectFunds().subtract(feeVONum.getAdvance()), feeVONum.getSumActualCostMoney()));
                    feeVONum.setCostFxRate(CommonUtils.calculateRate(feeVONum.getAmountPaid(), feeVONum.getSumActualCostMoney()));
                }
                feeNewList.addAll((Collection<BusinessVO>)orgStatusList);
            });
        });
        return arrayList;
    }

    private void getSumData(List<BusinessVO> feeVOS, BusinessVO feeVO) {
        BigDecimal signContract = feeVOS.stream().map(BusinessVO::getSignContract).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal oneselfContract = feeVOS.stream().map(BusinessVO::getOneselfContract).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal budgetLimit = feeVOS.stream().map(BusinessVO::getBudgetLimit).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal responsibilityCost = feeVOS.stream().map(BusinessVO::getResponsibilityCost).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal yylMny = feeVOS.stream().map(BusinessVO::getYylMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualMny = feeVOS.stream().map(BusinessVO::getActualMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal predictMoney = feeVOS.stream().map(BusinessVO::getPredictMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal planMoney = feeVOS.stream().map(BusinessVO::getPlanMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal productionMoney = feeVOS.stream().map(BusinessVO::getProductionMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualCostMoney = feeVOS.stream().map(BusinessVO::getActualCostMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualProfitMoney = feeVOS.stream().map(BusinessVO::getActualProfitMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumResponseCostMoney = feeVOS.stream().map(BusinessVO::getSumResponseCostMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal differenceMoney = feeVOS.stream().map(BusinessVO::getDifferenceMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualFinishProductionNear = feeVOS.stream().map(BusinessVO::getActualFinishProductionNear).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal ownerAffirmProduction = feeVOS.stream().map(BusinessVO::getOwnerAffirmProduction).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualFinishProduction = feeVOS.stream().map(BusinessVO::getActualFinishProduction).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal profitMny = feeVOS.stream().map(BusinessVO::getProfitMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal completedBalance = feeVOS.stream().map(BusinessVO::getCompletedBalance).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal stockUp = feeVOS.stream().map(BusinessVO::getStockUp).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal accountReceive = feeVOS.stream().map(BusinessVO::getAccountReceive).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal outIncomeMny = feeVOS.stream().map(BusinessVO::getOutIncomeMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal outCostMny = feeVOS.stream().map(BusinessVO::getOutCostMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal incomeMny = feeVOS.stream().map(BusinessVO::getIncomeMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal costMny = feeVOS.stream().map(BusinessVO::getCostMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal reportProfitMny = feeVOS.stream().map(BusinessVO::getReportProfitMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal contractReceipt = feeVOS.stream().map(BusinessVO::getContractReceipt).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal projectFunds = feeVOS.stream().map(BusinessVO::getProjectFunds).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal advance = feeVOS.stream().map(BusinessVO::getAdvance).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal yswsMoney = feeVOS.stream().map(BusinessVO::getYswsMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amountPayable = feeVOS.stream().map(BusinessVO::getAmountPayable).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amountPaid = feeVOS.stream().map(BusinessVO::getAmountPaid).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal contractYfwfMny = feeVOS.stream().map(BusinessVO::getContractYfwfMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumActualCostMoney = feeVOS.stream().map(BusinessVO::getSumActualCostMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        Integer approvalTotal = feeVOS.stream().collect(Collectors.summingInt(BusinessVO::getApprovalTotal));
        Integer amount = feeVOS.stream().collect(Collectors.summingInt(BusinessVO::getAmount));
        BigDecimal zblrData = BigDecimal.ZERO;
        BigDecimal mbzrsData = BigDecimal.ZERO;
        for (BusinessVO businessVO : feeVOS) {
            BigDecimal undertakingBenefitsRate = CommonUtils.setBigDecimalDefaultValue(businessVO.getUndertakingBenefitsRate());
            BigDecimal signContractData = CommonUtils.setBigDecimalDefaultValue(businessVO.getSignContract());
            BigDecimal oneselfContractData = CommonUtils.setBigDecimalDefaultValue(businessVO.getOneselfContract());
            zblrData = zblrData.add(signContractData.multiply(undertakingBenefitsRate.divide(new BigDecimal(100))));
            BigDecimal overallProfitMargin = CommonUtils.setBigDecimalDefaultValue(businessVO.getOverallProfitMargin());
            mbzrsData = mbzrsData.add(oneselfContractData.multiply(overallProfitMargin.divide(new BigDecimal(100))));
        }
        feeVO.setUndertakingBenefitsRate(CommonUtils.calculateRate(zblrData, signContract));
        feeVO.setOverallProfitMargin(CommonUtils.calculateRate(mbzrsData, oneselfContract));
        feeVO.setSignContract(signContract);
        feeVO.setOneselfContract(oneselfContract);
        feeVO.setBudgetLimit(budgetLimit);
        feeVO.setResponsibilityCost(responsibilityCost);
        feeVO.setYylMny(yylMny);
        feeVO.setActualMny(actualMny);
        feeVO.setPredictMoney(predictMoney);
        feeVO.setPlanMoney(planMoney);
        feeVO.setProductionMoney(productionMoney);
        feeVO.setActualCostMoney(actualCostMoney);
        feeVO.setActualProfitMoney(actualProfitMoney);
        feeVO.setSumResponseCostMoney(sumResponseCostMoney);
        feeVO.setDifferenceMoney(differenceMoney);
        feeVO.setActualFinishProductionNear(actualFinishProductionNear);
        feeVO.setOwnerAffirmProduction(ownerAffirmProduction);
        feeVO.setActualFinishProduction(actualFinishProduction);
        feeVO.setProfitMny(profitMny);
        feeVO.setCompletedBalance(completedBalance);
        feeVO.setStockUp(stockUp);
        feeVO.setAccountReceive(accountReceive);
        feeVO.setOutIncomeMny(outIncomeMny);
        feeVO.setOutCostMny(outCostMny);
        feeVO.setIncomeMny(incomeMny);
        feeVO.setCostMny(costMny);
        feeVO.setReportProfitMny(reportProfitMny);
        feeVO.setContractReceipt(contractReceipt);
        feeVO.setProjectFunds(projectFunds);
        feeVO.setAdvance(advance);
        feeVO.setYswsMoney(yswsMoney);
        feeVO.setAmountPayable(amountPayable);
        feeVO.setAmountPaid(amountPaid);
        feeVO.setContractYfwfMny(contractYfwfMny);
        feeVO.setSumActualCostMoney(sumActualCostMoney);
        feeVO.setApprovalTotal(approvalTotal);
        feeVO.setAmount(amount);
        feeVO.setAffirmRate(CommonUtils.calculateRate(feeVO.getOwnerAffirmProduction(), feeVO.getSumActualCostMoney()));
        feeVO.setProductionRate(CommonUtils.calculateRate(feeVO.getOwnerAffirmProduction(), feeVO.getActualFinishProduction()));
        feeVO.setProfitRate(CommonUtils.calculateRate(feeVO.getProfitMny(), feeVO.getActualFinishProduction()));
        feeVO.setReportProfitRate(CommonUtils.calculateRate(feeVO.getReportProfitMny(), feeVO.getIncomeMny()));
        feeVO.setYswsRate(CommonUtils.calculateRate(feeVO.getProjectFunds(), feeVO.getOwnerAffirmProduction()));
        feeVO.setCostSxRate(CommonUtils.calculateRate(feeVO.getProjectFunds().subtract(feeVO.getAdvance()), feeVO.getSumActualCostMoney()));
        feeVO.setCostFxRate(CommonUtils.calculateRate(feeVO.getAmountPaid(), feeVO.getSumActualCostMoney()));
    }
}

