/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.analysis.bean.ConstructProBusinessEntity;
import com.ejianc.business.analysis.mapper.ConstructProBusinessMapper;
import com.ejianc.business.analysis.mapper.ProjectPaymentMapper;
import com.ejianc.business.analysis.mapper.UnsettledProBusinessMapper;
import com.ejianc.business.analysis.service.IConstructProBusinessService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.ConstructProBusinessVO;
import com.ejianc.business.analysis.vo.ProjectPaymentVO;
import com.ejianc.business.analysis.vo.UnsettledProBusinessVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="constructProBusinessService")
public class ConstructProBusinessServiceImpl
extends BaseServiceImpl<ConstructProBusinessMapper, ConstructProBusinessEntity>
implements IConstructProBusinessService {
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IConstructProBusinessService constructProBusinessService;
    @Autowired
    private ConstructProBusinessMapper constructProBusinessMapper;
    @Autowired
    private ProjectPaymentMapper projectPaymentMapper;
    @Autowired
    private UnsettledProBusinessMapper unsettledProBusinessMapper;
    @Autowired
    private IDefdocApi defdocApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void execute(Integer inAdvanceFlag, String day, List<Long> projectIdList) {
        String reportingMonth = CommonUtils.getEndDate(inAdvanceFlag, day, projectIdList);
        String endDateLast = CommonUtils.getEndDateLast();
        LambdaQueryWrapper lambdaFee = Wrappers.lambdaQuery();
        if (CollectionUtils.isNotEmpty(projectIdList)) {
            lambdaFee.in(ConstructProBusinessEntity::getProjectId, projectIdList);
        }
        lambdaFee.eq(ConstructProBusinessEntity::getReportingMonth, (Object)reportingMonth);
        this.constructProBusinessService.remove((Wrapper)lambdaFee);
        List<Object> constructProBusinessVOList = new ArrayList();
        constructProBusinessVOList = CollectionUtils.isNotEmpty(projectIdList) ? this.constructProBusinessMapper.queryProjectIds(projectIdList) : this.constructProBusinessMapper.queryProjectIds(null);
        CommonResponse plProject = this.defdocApi.getDefDocByDefCode("pl_project");
        if (!plProject.isSuccess()) {
            throw new BusinessException("\u6839\u636e\u6863\u6848\u7f16\u7801\u67e5\u8be2\u6863\u6848\u9879\u5931\u8d25!");
        }
        List defdocDetailVOList = (List)plProject.getData();
        Map<Object, Object> nameMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)defdocDetailVOList)) {
            nameMap = defdocDetailVOList.stream().collect(Collectors.groupingBy(s -> s.getName()));
        }
        if (CollectionUtils.isNotEmpty(constructProBusinessVOList)) {
            HashMap finalNameMap = nameMap;
            constructProBusinessVOList = constructProBusinessVOList.stream().filter(s -> !finalNameMap.containsKey(s.getProjectName())).collect(Collectors.toList());
        }
        List<Long> projectIds = constructProBusinessVOList.stream().map(ConstructProBusinessVO::getProjectId).collect(Collectors.toList());
        List<ConstructProBusinessVO> contractVOS = this.constructProBusinessMapper.queryContract(projectIds);
        Map<Object, Object> contractMap = new HashMap();
        if (CollectionUtils.isNotEmpty(contractVOS)) {
            contractMap = contractVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        List<ConstructProBusinessVO> bookVOS = this.constructProBusinessMapper.queryBook(projectIds);
        Map<Object, Object> bookMap = new HashMap();
        if (CollectionUtils.isNotEmpty(bookVOS)) {
            bookMap = bookVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        List<ConstructProBusinessVO> countersignatureVOS = this.constructProBusinessMapper.queryCountersignature(projectIds);
        Map<Object, Object> countersignatureMap = new HashMap();
        if (CollectionUtils.isNotEmpty(countersignatureVOS)) {
            countersignatureMap = countersignatureVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        List<ConstructProBusinessVO> businessplanningeffectVOS = this.constructProBusinessMapper.queryBusinessplanningeffect(projectIds);
        Map<Object, Object> businessplanningeffectMap = new HashMap();
        if (CollectionUtils.isNotEmpty(businessplanningeffectVOS)) {
            businessplanningeffectMap = businessplanningeffectVOS.stream().collect(Collectors.toMap(x -> x.getProjectId(), Function.identity(), (k1, k2) -> k2));
        }
        List<ProjectPaymentVO> costanalysisTotalList = this.projectPaymentMapper.quertCostanalysisTotal(reportingMonth, projectIdList);
        Map<Object, Object> costanalysisTotalListMap = new HashMap();
        if (CollectionUtils.isNotEmpty(costanalysisTotalList)) {
            costanalysisTotalListMap = costanalysisTotalList.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        List<UnsettledProBusinessVO> costanalysisHistoryVOS = this.unsettledProBusinessMapper.queryCostanalysisHistory(projectIds, endDateLast);
        Map<Object, Object> costanalysisHistoryGrBy = new HashMap();
        if (CollectionUtils.isNotEmpty(costanalysisHistoryVOS)) {
            costanalysisHistoryGrBy = costanalysisHistoryVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        List<ConstructProBusinessVO> engineermeasurementVOS = this.constructProBusinessMapper.queryEngineermeasurement(projectIds, reportingMonth);
        Map<Object, Object> engineermeasurementMap = new HashMap();
        if (CollectionUtils.isNotEmpty(engineermeasurementVOS)) {
            engineermeasurementMap = engineermeasurementVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        List<UnsettledProBusinessVO> engineermeasurementHistoryVOS = this.unsettledProBusinessMapper.queryEngineermeasurementHistory(projectIds, endDateLast);
        this.logger.info("reportingLastMonth" + endDateLast);
        Map<Object, Object> engineermeasurementHistoryGrBy = new HashMap();
        if (CollectionUtils.isNotEmpty(engineermeasurementHistoryVOS)) {
            engineermeasurementHistoryGrBy = engineermeasurementHistoryVOS.stream().collect(Collectors.groupingBy(s -> s.getProjectId()));
        }
        for (ConstructProBusinessVO constructProBusinessVO : constructProBusinessVOList) {
            CommonResponse orgVO;
            CommonResponse fourOrgVO;
            String innerCode;
            String[] strs;
            CommonResponse orgVos;
            List collectCompare;
            List businessVOList;
            constructProBusinessVO.setReportingMonth(reportingMonth);
            Long projectId = constructProBusinessVO.getProjectId();
            if (!contractMap.isEmpty() && contractMap.containsKey(projectId)) {
                constructProBusinessVO.setPromoter(((ConstructProBusinessVO)contractMap.get(projectId)).getPromoter());
                constructProBusinessVO.setPromoterName(((ConstructProBusinessVO)contractMap.get(projectId)).getPromoterName());
                constructProBusinessVO.setProjectLocation(((ConstructProBusinessVO)contractMap.get(projectId)).getProjectLocation());
                constructProBusinessVO.setContractSignTime(((ConstructProBusinessVO)contractMap.get(projectId)).getContractSignTime());
                constructProBusinessVO.setContractStartDate(((ConstructProBusinessVO)contractMap.get(projectId)).getContractStartDate());
                constructProBusinessVO.setContractEndDate(((ConstructProBusinessVO)contractMap.get(projectId)).getContractEndDate());
                constructProBusinessVO.setContractAmount(((ConstructProBusinessVO)contractMap.get(projectId)).getContractAmountByContract());
                constructProBusinessVO.setAcContractAmount(((ConstructProBusinessVO)contractMap.get(projectId)).getAcContractAmount());
            }
            if (!bookMap.isEmpty() && bookMap.containsKey(projectId)) {
                constructProBusinessVO.setUndertakeRate(CommonUtils.setBigDecimalDefaultValue(((ConstructProBusinessVO)bookMap.get(projectId)).getUndertakeRate()));
                constructProBusinessVO.setTargetRate(CommonUtils.setBigDecimalDefaultValue(((ConstructProBusinessVO)bookMap.get(projectId)).getTargetRate()));
                constructProBusinessVO.setSignDate(((ConstructProBusinessVO)bookMap.get(projectId)).getSignDate());
            }
            if (!countersignatureMap.isEmpty() && countersignatureMap.containsKey(projectId)) {
                constructProBusinessVO.setBusinessPlanApprovalDate(((ConstructProBusinessVO)countersignatureMap.get(projectId)).getBusinessPlanApprovalDate());
            }
            if (!businessplanningeffectMap.isEmpty() && businessplanningeffectMap.containsKey(projectId)) {
                constructProBusinessVO.setPlanExpectedRevenueGenerationAmount(CommonUtils.parseNullValue(((ConstructProBusinessVO)businessplanningeffectMap.get(projectId)).getPlanExpectedRevenueGenerationAmount()));
                constructProBusinessVO.setPlanRevenueGenerationAmount(CommonUtils.setBigDecimalDefaultValue(((ConstructProBusinessVO)businessplanningeffectMap.get(projectId)).getPlanRevenueGenerationAmount()));
            }
            if (!costanalysisHistoryGrBy.isEmpty() && costanalysisHistoryGrBy.containsKey(projectId)) {
                businessVOList = (List)costanalysisHistoryGrBy.get(projectId);
                collectCompare = businessVOList.stream().sorted(Comparator.comparing(UnsettledProBusinessVO::getReportingMonth).reversed()).collect(Collectors.toList());
                BigDecimal cumulativeIncome = ((UnsettledProBusinessVO)collectCompare.stream().findFirst().get()).getCumulativeIncome();
                constructProBusinessVO.setCumulativeIncome(((UnsettledProBusinessVO)collectCompare.stream().findFirst().get()).getCumulativeIncome());
                constructProBusinessVO.setCumulativeIncomeYou(((UnsettledProBusinessVO)collectCompare.stream().findFirst().get()).getCumulativeIncome());
            }
            if (!engineermeasurementHistoryGrBy.isEmpty() && engineermeasurementHistoryGrBy.containsKey(projectId)) {
                businessVOList = (List)engineermeasurementHistoryGrBy.get(projectId);
                collectCompare = businessVOList.stream().sorted(Comparator.comparing(UnsettledProBusinessVO::getReportingMonth).reversed()).collect(Collectors.toList());
                constructProBusinessVO.setCumulativeBatch(((UnsettledProBusinessVO)collectCompare.stream().findFirst().get()).getCumulativeBatch());
                constructProBusinessVO.setCumulativeBatchYou(((UnsettledProBusinessVO)collectCompare.stream().findFirst().get()).getCumulativeBatch());
            }
            if (costanalysisTotalListMap.containsKey(projectId)) {
                List paymentVOList = (List)costanalysisTotalListMap.get(projectId);
                collectCompare = paymentVOList.stream().sorted(Comparator.comparing(ProjectPaymentVO::getReportingMonth).reversed()).collect(Collectors.toList());
                ProjectPaymentVO paymentVO = (ProjectPaymentVO)((Object)collectCompare.stream().findFirst().get());
                constructProBusinessVO.setContractIncome(CommonUtils.parseNullValue(paymentVO.getActualFinishProduction()));
                constructProBusinessVO.setAcContractIncome(CommonUtils.parseNullValue(paymentVO.getActualFinishProduction()));
                constructProBusinessVO.setRealCost(CommonUtils.parseNullValue(paymentVO.getActualCost()));
                constructProBusinessVO.setAcRealCost(CommonUtils.parseNullValue(paymentVO.getActualCost()));
            }
            if (!engineermeasurementMap.isEmpty() && engineermeasurementMap.containsKey(projectId)) {
                constructProBusinessVO.setOwnerCrValue(((List)engineermeasurementMap.get(projectId)).stream().filter(s -> s.getCurrentBatch() != null).map(it -> it.getCurrentBatch()).reduce(BigDecimal.ZERO, BigDecimal::add));
                constructProBusinessVO.setOwnerCrAcValue(constructProBusinessVO.getOwnerCrValue());
                constructProBusinessVO.setContractReceivableMny(((List)engineermeasurementMap.get(projectId)).stream().filter(s -> s.getCurrentReceivables() != null).map(it -> it.getCurrentReceivables()).reduce(BigDecimal.ZERO, BigDecimal::add));
                List feeVOS = (List)engineermeasurementMap.get(projectId);
                collectCompare = feeVOS.stream().sorted(Comparator.comparing(ConstructProBusinessVO::getReportingMonth).reversed()).collect(Collectors.toList());
                ConstructProBusinessVO feeVOIncome = (ConstructProBusinessVO)collectCompare.stream().findFirst().get();
                constructProBusinessVO.setOperatingRevenue(feeVOIncome.getFinanceReportIncome());
                constructProBusinessVO.setRealRecrived(((List)engineermeasurementMap.get(projectId)).stream().filter(s -> s.getCurrentCollection() != null).map(it -> it.getCurrentCollection()).reduce(BigDecimal.ZERO, BigDecimal::add));
                constructProBusinessVO.setSettlementFlag(Integer.valueOf(1));
            } else {
                constructProBusinessVO.setSettlementFlag(Integer.valueOf(0));
            }
            CommonResponse orgVo = this.orgApi.detailById(constructProBusinessVO.getProjectDepartmentId());
            if (orgVo.isSuccess() && null != orgVo.getData() && (orgVos = this.orgApi.detailById(Long.valueOf(Long.parseLong((strs = (innerCode = ((OrgVO)orgVo.getData()).getInnerCode()).split("\\|"))[1])))).isSuccess() && null != orgVos.getData()) {
                constructProBusinessVO.setThreeOrgId(((OrgVO)orgVos.getData()).getId());
                constructProBusinessVO.setThreeOrgName(((OrgVO)orgVos.getData()).getName());
                constructProBusinessVO.setOrgStatusOrder(Integer.valueOf(((OrgVO)orgVos.getData()).getSequence() == null ? 1000 : ((OrgVO)orgVos.getData()).getSequence()));
            }
            constructProBusinessVO.setPergaContractAmountProportion(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(constructProBusinessVO.getPlanExpectedRevenueGenerationAmount()), CommonUtils.setBigDecimalDefaultValue(constructProBusinessVO.getAcContractAmount())));
            constructProBusinessVO.setPrgaContractIncomeProportion(CommonUtils.calculateRate(CommonUtils.setBigDecimalDefaultValue(constructProBusinessVO.getPlanRevenueGenerationAmount()), CommonUtils.setBigDecimalDefaultValue(constructProBusinessVO.getAcContractIncome())));
            if (constructProBusinessVO.getFourOrgId() != null && (fourOrgVO = this.orgApi.detailById(constructProBusinessVO.getFourOrgId())).isSuccess() && null != fourOrgVO.getData()) {
                constructProBusinessVO.setFourOrgName(((OrgVO)fourOrgVO.getData()).getName());
            }
            if (constructProBusinessVO.getContractorName() != null || !(orgVO = this.orgApi.detailById(constructProBusinessVO.getContractor())).isSuccess() || null == orgVO.getData()) continue;
            constructProBusinessVO.setContractorName(((OrgVO)orgVO.getData()).getName());
        }
        List constructProBusinessEntityList = BeanMapper.mapList(constructProBusinessVOList, ConstructProBusinessEntity.class);
        this.constructProBusinessService.saveBatch(constructProBusinessEntityList);
    }

    @Override
    public List<ConstructProBusinessVO> dealData(List<ConstructProBusinessVO> constructProBusinessVOS) {
        for (ConstructProBusinessVO constructProBusinessVO : constructProBusinessVOS) {
            constructProBusinessVO.setContractAmount(CommonUtils.parseYuanToWanZ(constructProBusinessVO.getContractAmount()));
            constructProBusinessVO.setAcContractAmount(CommonUtils.parseYuanToWanZ(constructProBusinessVO.getAcContractAmount()));
            constructProBusinessVO.setContractIncome(CommonUtils.parseYuanToWanZ(constructProBusinessVO.getContractIncome()));
            constructProBusinessVO.setAcContractIncome(CommonUtils.parseYuanToWanZ(constructProBusinessVO.getAcContractIncome()));
            constructProBusinessVO.setRealCost(CommonUtils.parseYuanToWanZ(constructProBusinessVO.getRealCost()));
            constructProBusinessVO.setAcRealCost(CommonUtils.parseYuanToWanZ(constructProBusinessVO.getAcRealCost()));
            constructProBusinessVO.setOwnerCrValue(CommonUtils.parseYuanToWanZ(constructProBusinessVO.getOwnerCrValue()));
            constructProBusinessVO.setOwnerCrAcValue(CommonUtils.parseYuanToWanZ(constructProBusinessVO.getOwnerCrAcValue()));
            constructProBusinessVO.setContractReceivableMny(CommonUtils.parseYuanToWanZ(constructProBusinessVO.getContractReceivableMny()));
            constructProBusinessVO.setOperatingRevenue(CommonUtils.parseYuanToWanZ(constructProBusinessVO.getOperatingRevenue()));
            constructProBusinessVO.setRealRecrived(CommonUtils.parseYuanToWanZ(constructProBusinessVO.getRealRecrived()));
            constructProBusinessVO.setCumulativeBatchYou(CommonUtils.parseYuanToWanZ(constructProBusinessVO.getCumulativeBatchYou()));
            constructProBusinessVO.setCumulativeBatch(CommonUtils.parseYuanToWanZ(constructProBusinessVO.getCumulativeBatch()));
            constructProBusinessVO.setCumulativeIncome(CommonUtils.parseYuanToWanZ(constructProBusinessVO.getCumulativeIncome()));
            constructProBusinessVO.setCumulativeIncomeYou(CommonUtils.parseYuanToWanZ(constructProBusinessVO.getCumulativeIncomeYou()));
        }
        ConstructProBusinessVO constructProBusinessVO = new ConstructProBusinessVO();
        ArrayList<ConstructProBusinessVO> arrayList = new ArrayList<ConstructProBusinessVO>();
        if (CollectionUtils.isNotEmpty(constructProBusinessVOS)) {
            this.getSumDate(constructProBusinessVOS, constructProBusinessVO);
            constructProBusinessVO.setNumber("\u5408\u8ba1");
            constructProBusinessVO.setId(Long.valueOf(IdWorker.getId()));
            arrayList.add(constructProBusinessVO);
        }
        constructProBusinessVOS = constructProBusinessVOS.stream().sorted(Comparator.comparing(ConstructProBusinessVO::getOrgStatusOrder)).collect(Collectors.toList());
        Integer number = 1;
        for (ConstructProBusinessVO constructProBusinessVO2 : constructProBusinessVOS) {
            constructProBusinessVO2.setNumber(String.valueOf(number));
            Object object = number;
            Integer n = number = Integer.valueOf(number + 1);
            constructProBusinessVO2.setProjectStatusName(CommonUtils.getProjectStatusName(constructProBusinessVO2.getProjectStatus()));
            constructProBusinessVO2.setProjectStatusNameTwo(CommonUtils.getProjectStatusName(constructProBusinessVO2.getProjectStatus()));
            constructProBusinessVO2.setProfit(ComputeUtil.safeSub((BigDecimal)constructProBusinessVO2.getContractIncome(), (BigDecimal)constructProBusinessVO2.getRealCost()));
            constructProBusinessVO2.setProfitRate(CommonUtils.calculateRate(constructProBusinessVO2.getProfit(), constructProBusinessVO2.getContractIncome()));
            constructProBusinessVO2.setAcProfitRate(CommonUtils.calculateRate(constructProBusinessVO2.getProfit(), constructProBusinessVO2.getAcContractIncome()));
            constructProBusinessVO2.setValueCrRate(CommonUtils.calculateRate(constructProBusinessVO2.getOwnerCrValue(), constructProBusinessVO2.getContractIncome()));
            constructProBusinessVO2.setAcValueCrRate(CommonUtils.calculateRate(constructProBusinessVO2.getOwnerCrAcValue(), constructProBusinessVO2.getAcContractIncome()));
            constructProBusinessVO2.setRevenueCrRate(CommonUtils.calculateRate(constructProBusinessVO2.getOwnerCrValue(), CommonUtils.setBigDecimalDefaultValue(constructProBusinessVO2.getOperatingRevenue())));
            constructProBusinessVO2.setPergaContractAmountProportion(CommonUtils.calculateRate(constructProBusinessVO2.getPlanExpectedRevenueGenerationAmount(), constructProBusinessVO2.getAcContractAmount()));
            constructProBusinessVO2.setPrgaContractIncomeProportion(CommonUtils.calculateRate(constructProBusinessVO2.getPlanRevenueGenerationAmount(), constructProBusinessVO2.getAcContractIncome()));
            switch (constructProBusinessVO2.getSettlementFlag()) {
                case 0: {
                    constructProBusinessVO2.setSettlementFlagName("\u5426");
                    break;
                }
                case 1: {
                    constructProBusinessVO2.setSettlementFlagName("\u662f");
                }
            }
            switch (String.valueOf(constructProBusinessVO2.getProjectCategory())) {
                case "1470216164541710337": {
                    constructProBusinessVO2.setProjectCategoryName("\u5de5\u4e1a\u5382\u623f");
                    break;
                }
                case "1470216222511185922": {
                    constructProBusinessVO2.setProjectCategoryName("\u516c\u5171\u5efa\u7b51");
                    break;
                }
                case "1470216274176622593": {
                    constructProBusinessVO2.setProjectCategoryName("\u6c11\u7528\u4f4f\u5b85");
                    break;
                }
                case "1470216311648534530": {
                    constructProBusinessVO2.setProjectCategoryName("\u57fa\u7840\u8bbe\u65bd");
                    break;
                }
                case "1470216348239642626": {
                    constructProBusinessVO2.setProjectCategoryName("\u5176\u5b83");
                }
            }
        }
        arrayList.addAll(constructProBusinessVOS);
        return arrayList;
    }

    private void getSumDate(List<ConstructProBusinessVO> constructProBusinessVOS, ConstructProBusinessVO constructProBusinessVO) {
        constructProBusinessVO.setContractAmount(constructProBusinessVOS.stream().filter(s -> s.getContractAmount() != null).map(ConstructProBusinessVO::getContractAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setAcContractAmount(constructProBusinessVOS.stream().filter(s -> s.getAcContractAmount() != null).map(ConstructProBusinessVO::getAcContractAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setPlanExpectedRevenueGenerationAmount(constructProBusinessVOS.stream().filter(s -> s.getPlanExpectedRevenueGenerationAmount() != null).map(ConstructProBusinessVO::getPlanExpectedRevenueGenerationAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setPlanRevenueGenerationAmount(constructProBusinessVOS.stream().filter(s -> s.getPlanRevenueGenerationAmount() != null).map(ConstructProBusinessVO::getPlanRevenueGenerationAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setContractIncome(constructProBusinessVOS.stream().filter(s -> s.getContractIncome() != null).map(ConstructProBusinessVO::getContractIncome).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setAcContractIncome(constructProBusinessVOS.stream().filter(s -> s.getAcContractIncome() != null).map(ConstructProBusinessVO::getAcContractIncome).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setCumulativeIncome(constructProBusinessVOS.stream().filter(s -> s.getCumulativeIncome() != null).map(ConstructProBusinessVO::getCumulativeIncome).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setCumulativeIncomeYou(constructProBusinessVOS.stream().filter(s -> s.getCumulativeIncomeYou() != null).map(ConstructProBusinessVO::getCumulativeIncomeYou).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setCumulativeBatch(constructProBusinessVOS.stream().filter(s -> s.getCumulativeBatch() != null).map(ConstructProBusinessVO::getCumulativeBatch).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setCumulativeBatchYou(constructProBusinessVOS.stream().filter(s -> s.getCumulativeBatchYou() != null).map(ConstructProBusinessVO::getCumulativeBatchYou).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setRealCost(constructProBusinessVOS.stream().filter(s -> s.getRealCost() != null).map(ConstructProBusinessVO::getRealCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setAcRealCost(constructProBusinessVOS.stream().filter(s -> s.getAcRealCost() != null).map(ConstructProBusinessVO::getAcRealCost).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setOwnerCrValue(constructProBusinessVOS.stream().filter(s -> s.getOwnerCrValue() != null).map(ConstructProBusinessVO::getOwnerCrValue).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setOwnerCrAcValue(constructProBusinessVOS.stream().filter(s -> s.getOwnerCrAcValue() != null).map(ConstructProBusinessVO::getOwnerCrAcValue).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setContractReceivableMny(constructProBusinessVOS.stream().filter(s -> s.getContractReceivableMny() != null).map(ConstructProBusinessVO::getContractReceivableMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setOperatingRevenue(constructProBusinessVOS.stream().filter(s -> s.getOperatingRevenue() != null).map(ConstructProBusinessVO::getOperatingRevenue).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setRealRecrived(constructProBusinessVOS.stream().filter(s -> s.getRealRecrived() != null).map(ConstructProBusinessVO::getRealRecrived).reduce(BigDecimal.ZERO, BigDecimal::add));
        constructProBusinessVO.setProfit(ComputeUtil.safeSub((BigDecimal)constructProBusinessVO.getContractIncome(), (BigDecimal)constructProBusinessVO.getRealCost()));
        constructProBusinessVO.setProfitRate(CommonUtils.calculateRate(constructProBusinessVO.getProfit(), constructProBusinessVO.getContractIncome()));
        constructProBusinessVO.setAcProfitRate(CommonUtils.calculateRate(constructProBusinessVO.getProfit(), constructProBusinessVO.getAcContractIncome()));
        constructProBusinessVO.setValueCrRate(CommonUtils.calculateRate(constructProBusinessVO.getOwnerCrValue(), constructProBusinessVO.getContractIncome()));
        constructProBusinessVO.setAcValueCrRate(CommonUtils.calculateRate(constructProBusinessVO.getOwnerCrAcValue(), constructProBusinessVO.getAcContractIncome()));
        constructProBusinessVO.setRevenueCrRate(CommonUtils.calculateRate(constructProBusinessVO.getOwnerCrValue(), CommonUtils.setBigDecimalDefaultValue(constructProBusinessVO.getOperatingRevenue())));
        BigDecimal acContractAmount = BigDecimal.ZERO;
        BigDecimal OverallProfitMarginMny = BigDecimal.ZERO;
        for (ConstructProBusinessVO proSignReserve : constructProBusinessVOS) {
            acContractAmount = acContractAmount.add(CommonUtils.parseNullValue(proSignReserve.getAcContractAmount()).multiply(CommonUtils.parseNullValue(proSignReserve.getUndertakeRate()).divide(new BigDecimal(100))));
            OverallProfitMarginMny = OverallProfitMarginMny.add(CommonUtils.parseNullValue(proSignReserve.getAcContractAmount()).multiply(CommonUtils.parseNullValue(proSignReserve.getTargetRate()).divide(new BigDecimal(100))));
        }
        constructProBusinessVO.setUndertakeRate(CommonUtils.calculateRate(acContractAmount, constructProBusinessVO.getAcContractAmount()));
        constructProBusinessVO.setTargetRate(CommonUtils.calculateRate(OverallProfitMarginMny, constructProBusinessVO.getAcContractAmount()));
        constructProBusinessVO.setPergaContractAmountProportion(CommonUtils.calculateRate(constructProBusinessVO.getPlanExpectedRevenueGenerationAmount(), constructProBusinessVO.getAcContractAmount()));
        constructProBusinessVO.setPrgaContractIncomeProportion(CommonUtils.calculateRate(constructProBusinessVO.getPlanRevenueGenerationAmount(), constructProBusinessVO.getAcContractIncome()));
    }

    private static String getEndDateNear() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Calendar ca = Calendar.getInstance();
        ca.add(1, -1);
        Date d = ca.getTime();
        String endDate = format.format(d);
        return endDate;
    }
}

