/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.analysis.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.analysis.bean.ProSignReserveEntity;
import com.ejianc.business.analysis.mapper.PortalMapper;
import com.ejianc.business.analysis.service.IPortalService;
import com.ejianc.business.analysis.service.IProSignReserveService;
import com.ejianc.business.analysis.utils.CommonUtils;
import com.ejianc.business.analysis.vo.ActualValueVO;
import com.ejianc.business.analysis.vo.ProDurationDelayVO;
import com.ejianc.business.analysis.vo.ProjectBusinessVO;
import com.ejianc.business.analysis.vo.ProjectPaymentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="portalService")
public class PortalServiceImpl
implements IPortalService {
    @Autowired
    private PortalMapper portalMapper;
    @Autowired
    private IProSignReserveService proSignReserveService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IDefdocApi defdocApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public JSONObject getOutputValueBenefitAnalysis(String section, String year, String projectStatus) {
        JSONObject json = new JSONObject();
        String reportingMonth = this.getReportingMonth(section, year);
        LinkedHashMap<String, String> orgMap = this.getOrg();
        LinkedList<String> orgId = new LinkedList<String>();
        LinkedList<String> orgName = new LinkedList<String>();
        for (String key : orgMap.keySet()) {
            orgId.add(key);
            orgName.add(orgMap.get(key));
        }
        LinkedList<BigDecimal> outputValueDataList = new LinkedList<BigDecimal>();
        LinkedList<BigDecimal> costDataList = new LinkedList<BigDecimal>();
        LinkedList<BigDecimal> benefitDataList = new LinkedList<BigDecimal>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("reportingMonth", reportingMonth);
        param.put("orgIds", orgId);
        param.put("projectStatus", projectStatus);
        param.put("tenantId", InvocationInfoProxy.getTenantid());
        List<ActualValueVO> orgData = this.portalMapper.getOutputValueBenefitAnalysis(param);
        HashMap<String, ActualValueVO> dataList = new HashMap<String, ActualValueVO>();
        for (ActualValueVO vo : orgData) {
            dataList.put(vo.getTwoOrgId().toString(), vo);
        }
        param.put("range", "all");
        param.remove("orgIds");
        List<ActualValueVO> allData = this.portalMapper.getOutputValueBenefitAnalysis(param);
        if ("yearCumulative".equals(section)) {
            if (allData != null && allData.size() > 0 && allData.get(0) != null) {
                outputValueDataList.add(CommonUtils.parseYuanToYi(allData.get(0).getYearActualCompleteValue()));
                costDataList.add(CommonUtils.parseYuanToYi(allData.get(0).getYearRealCost()));
                BigDecimal yearProfitRate = CommonUtils.calculateRate2(allData.get(0).getYearActualProfit(), CommonUtils.setBigDecimalDefaultValue(allData.get(0).getYearActualCompleteValue()));
                benefitDataList.add(yearProfitRate);
            } else {
                outputValueDataList.add(new BigDecimal(0));
                costDataList.add(new BigDecimal(0));
                benefitDataList.add(new BigDecimal(0));
            }
            for (int i = 1; i < orgId.size(); ++i) {
                String id = (String)orgId.get(i);
                ActualValueVO vo = (ActualValueVO)dataList.get(id);
                if (vo != null) {
                    outputValueDataList.add(CommonUtils.parseYuanToYi(vo.getYearActualCompleteValue()));
                    costDataList.add(CommonUtils.parseYuanToYi(vo.getYearRealCost()));
                    BigDecimal yearProfitRate1 = CommonUtils.calculateRate2(vo.getYearActualProfit(), CommonUtils.setBigDecimalDefaultValue(vo.getYearActualCompleteValue()));
                    benefitDataList.add(yearProfitRate1);
                    continue;
                }
                outputValueDataList.add(new BigDecimal(0));
                costDataList.add(new BigDecimal(0));
                benefitDataList.add(new BigDecimal(0));
            }
        } else {
            if (allData != null && allData.size() > 0 && allData.get(0) != null) {
                outputValueDataList.add(CommonUtils.parseYuanToYi(allData.get(0).getAccumulateActualCompleteValue()));
                costDataList.add(CommonUtils.parseYuanToYi(allData.get(0).getAccumulateRealCost()));
                BigDecimal accumulateActualProfit = ComputeUtil.safeSub((BigDecimal)allData.get(0).getAccumulateActualCompleteValue(), (BigDecimal)allData.get(0).getAccumulateRealCost());
                BigDecimal accumulateProfitRate = CommonUtils.calculateRate2(accumulateActualProfit, CommonUtils.setBigDecimalDefaultValue(allData.get(0).getAccumulateActualCompleteValue()));
                benefitDataList.add(accumulateProfitRate);
            } else {
                outputValueDataList.add(new BigDecimal(0));
                costDataList.add(new BigDecimal(0));
                benefitDataList.add(new BigDecimal(0));
            }
            for (int i = 1; i < orgId.size(); ++i) {
                String id = (String)orgId.get(i);
                ActualValueVO vo = (ActualValueVO)dataList.get(id);
                if (vo != null) {
                    outputValueDataList.add(CommonUtils.parseYuanToYi(vo.getAccumulateActualCompleteValue()));
                    costDataList.add(CommonUtils.parseYuanToYi(vo.getAccumulateRealCost()));
                    BigDecimal accumulateActualProfit = ComputeUtil.safeSub((BigDecimal)vo.getAccumulateActualCompleteValue(), (BigDecimal)vo.getAccumulateRealCost());
                    BigDecimal accumulateProfitRate1 = CommonUtils.calculateRate2(accumulateActualProfit, CommonUtils.setBigDecimalDefaultValue(vo.getAccumulateActualCompleteValue()));
                    benefitDataList.add(accumulateProfitRate1);
                    continue;
                }
                outputValueDataList.add(new BigDecimal(0));
                costDataList.add(new BigDecimal(0));
                benefitDataList.add(new BigDecimal(0));
            }
        }
        json.put("legendData", orgName);
        json.put("outputValueData", outputValueDataList);
        json.put("costData", costDataList);
        json.put("benefitData", benefitDataList);
        return json;
    }

    @Override
    public JSONObject getTargetResponsibilityAnalysis(String section, String year, String projectStatus) {
        JSONObject json = new JSONObject();
        String reportingMonth = this.getReportingMonth(section, year);
        LinkedHashMap<String, String> orgMap = this.getOrg();
        LinkedList<String> orgIds = new LinkedList<String>();
        LinkedList<String> orgName = new LinkedList<String>();
        for (String key : orgMap.keySet()) {
            orgIds.add(key);
            orgName.add(orgMap.get(key));
        }
        LinkedList<BigDecimal> undertakeData = new LinkedList<BigDecimal>();
        LinkedList<BigDecimal> targetData = new LinkedList<BigDecimal>();
        LinkedList<BigDecimal> actualData = new LinkedList<BigDecimal>();
        QueryParam param = new QueryParam();
        param.getParams().put("reportingMonth", new Parameter("eq", (Object)reportingMonth));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotBlank((CharSequence)projectStatus)) {
            param.getParams().put("projectStatus", new Parameter("eq", (Object)projectStatus));
        }
        if ("yearCumulative".equals(section)) {
            param.getParams().put("bookSignTime", new Parameter("like", (Object)year));
        }
        List allData = this.proSignReserveService.queryList(param, false);
        HashMap orgDataMap = new HashMap();
        for (ProSignReserveEntity entity : allData) {
            List<ProSignReserveEntity> orgData;
            String orgId = entity.getTwoOrgId().toString();
            if (!orgIds.contains(orgId)) continue;
            if (orgDataMap.get(orgId) != null) {
                orgData = (List)orgDataMap.get(orgId);
                orgData.add(entity);
                orgDataMap.put(orgId, orgData);
                continue;
            }
            orgData = new ArrayList();
            orgData.add(entity);
            orgDataMap.put(orgId, orgData);
        }
        ProSignReserveEntity allVO = this.getProSignReserveSumData(allData);
        undertakeData.add(allVO.getUndertakingBenefitsRate());
        targetData.add(allVO.getOverallProfitMargin());
        for (int i = 1; i < orgIds.size(); ++i) {
            String id = (String)orgIds.get(i);
            if (orgDataMap.get(id) != null) {
                ProSignReserveEntity org = this.getProSignReserveSumData((List)orgDataMap.get(id));
                undertakeData.add(org.getUndertakingBenefitsRate());
                targetData.add(org.getOverallProfitMargin());
                continue;
            }
            undertakeData.add(new BigDecimal(0));
            targetData.add(new BigDecimal(0));
        }
        HashMap<String, Object> actualParam = new HashMap<String, Object>();
        actualParam.put("reportingMonth", reportingMonth);
        actualParam.put("orgIds", orgIds);
        actualParam.put("projectStatus", projectStatus);
        actualParam.put("tenantId", InvocationInfoProxy.getTenantid());
        List<ActualValueVO> orgActualData = this.portalMapper.getOutputValueBenefitAnalysis(actualParam);
        HashMap<String, ActualValueVO> dataActualList = new HashMap<String, ActualValueVO>();
        for (ActualValueVO vo : orgActualData) {
            dataActualList.put(vo.getTwoOrgId().toString(), vo);
        }
        actualParam.put("range", "all");
        actualParam.remove("orgIds");
        List<ActualValueVO> allActualData = this.portalMapper.getOutputValueBenefitAnalysis(actualParam);
        if ("yearCumulative".equals(section)) {
            if (allActualData != null && allActualData.size() > 0 && allActualData.get(0) != null) {
                BigDecimal yearProfitRate = CommonUtils.calculateRate2(allActualData.get(0).getYearActualProfit(), CommonUtils.setBigDecimalDefaultValue(allActualData.get(0).getYearActualCompleteValue()));
                actualData.add(yearProfitRate);
            } else {
                actualData.add(new BigDecimal(0));
            }
            for (int i = 1; i < orgIds.size(); ++i) {
                String id = (String)orgIds.get(i);
                ActualValueVO vo = (ActualValueVO)dataActualList.get(id);
                if (vo != null) {
                    BigDecimal yearProfitRate1 = CommonUtils.calculateRate2(vo.getYearActualProfit(), CommonUtils.setBigDecimalDefaultValue(vo.getYearActualCompleteValue()));
                    actualData.add(yearProfitRate1);
                    continue;
                }
                actualData.add(new BigDecimal(0));
            }
        } else {
            if (allActualData != null && allActualData.size() > 0 && allActualData.get(0) != null) {
                BigDecimal accumulateActualProfit = ComputeUtil.safeSub((BigDecimal)allActualData.get(0).getAccumulateActualCompleteValue(), (BigDecimal)allActualData.get(0).getAccumulateRealCost());
                BigDecimal accumulateProfitRate = CommonUtils.calculateRate2(accumulateActualProfit, CommonUtils.setBigDecimalDefaultValue(allActualData.get(0).getAccumulateActualCompleteValue()));
                actualData.add(accumulateProfitRate);
            } else {
                actualData.add(new BigDecimal(0));
            }
            for (int i = 1; i < orgIds.size(); ++i) {
                String id = (String)orgIds.get(i);
                ActualValueVO vo = (ActualValueVO)dataActualList.get(id);
                if (vo != null) {
                    BigDecimal accumulateActualProfit = ComputeUtil.safeSub((BigDecimal)vo.getAccumulateActualCompleteValue(), (BigDecimal)vo.getAccumulateRealCost());
                    BigDecimal accumulateProfitRate1 = CommonUtils.calculateRate2(accumulateActualProfit, CommonUtils.setBigDecimalDefaultValue(vo.getAccumulateActualCompleteValue()));
                    actualData.add(accumulateProfitRate1);
                    continue;
                }
                actualData.add(new BigDecimal(0));
            }
        }
        json.put("legendData", orgName);
        json.put("undertakeData", undertakeData);
        json.put("targetData", targetData);
        json.put("actualData", actualData);
        return json;
    }

    private ProSignReserveEntity getProSignReserveSumData(List<ProSignReserveEntity> proSignReserveEntityS) {
        ProSignReserveEntity proSignReserveEntity = new ProSignReserveEntity();
        proSignReserveEntity.setAcContractAmount(proSignReserveEntityS.stream().filter(it -> it.getAcContractAmount() != null).map(it -> it.getAcContractAmount()).reduce(BigDecimal.ZERO, BigDecimal::add));
        BigDecimal acContractAmount = BigDecimal.ZERO;
        BigDecimal OverallProfitMarginMny = BigDecimal.ZERO;
        for (ProSignReserveEntity proSignReserve : proSignReserveEntityS) {
            acContractAmount = acContractAmount.add(CommonUtils.parseNullValue(proSignReserve.getAcContractAmount()).multiply(CommonUtils.parseNullValue(proSignReserve.getUndertakingBenefitsRate()).divide(new BigDecimal(100))));
            OverallProfitMarginMny = OverallProfitMarginMny.add(CommonUtils.parseNullValue(proSignReserve.getAcContractAmount()).multiply(CommonUtils.parseNullValue(proSignReserve.getOverallProfitMargin()).divide(new BigDecimal(100))));
        }
        proSignReserveEntity.setUndertakingBenefitsRate(CommonUtils.calculateRate2(acContractAmount, proSignReserveEntity.getAcContractAmount()));
        proSignReserveEntity.setOverallProfitMargin(CommonUtils.calculateRate2(OverallProfitMarginMny, proSignReserveEntity.getAcContractAmount()));
        return proSignReserveEntity;
    }

    @Override
    public JSONObject getBusinessPlan() {
        JSONObject json = new JSONObject();
        String reportingMonth = this.getReportingMonth("cumulative", "");
        LinkedHashMap<String, String> orgMap = this.getOrg();
        LinkedList<String> orgId = new LinkedList<String>();
        LinkedList<String> orgName = new LinkedList<String>();
        for (String key : orgMap.keySet()) {
            orgId.add(key);
            orgName.add(orgMap.get(key));
        }
        LinkedList<BigDecimal> planDataList = new LinkedList<BigDecimal>();
        LinkedList<BigDecimal> predictDataList = new LinkedList<BigDecimal>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("reportingMonth", reportingMonth);
        param.put("orgIds", orgId);
        param.put("projectStatus", "2");
        param.put("tenantId", InvocationInfoProxy.getTenantid());
        List<ProjectBusinessVO> orgData = this.portalMapper.getBusinessPlan(param);
        HashMap<String, ProjectBusinessVO> dataList = new HashMap<String, ProjectBusinessVO>();
        for (ProjectBusinessVO vo : orgData) {
            dataList.put(vo.getTwoOrgId().toString(), vo);
        }
        param.put("range", "all");
        param.remove("orgIds");
        List<ProjectBusinessVO> allData = this.portalMapper.getBusinessPlan(param);
        if (allData != null && allData.size() > 0 && allData.get(0) != null) {
            allData.get(0).setRealityMoney(CommonUtils.parseYuanToWanZ(allData.get(0).getRealityMoney()));
            allData.get(0).setOneselfContract(CommonUtils.parseYuanToWanZ(allData.get(0).getOneselfContract()));
            BigDecimal planRatio = CommonUtils.calculateRate2(CommonUtils.setBigDecimalDefaultValue(allData.get(0).getPlanMoney()), CommonUtils.setBigDecimalDefaultValue(allData.get(0).getRealityMoney()));
            planDataList.add(planRatio);
            BigDecimal predictRatio = CommonUtils.calculateRate2(CommonUtils.setBigDecimalDefaultValue(allData.get(0).getPredictMoney()), CommonUtils.setBigDecimalDefaultValue(allData.get(0).getOneselfContract()));
            predictDataList.add(predictRatio);
        } else {
            planDataList.add(new BigDecimal(0));
            predictDataList.add(new BigDecimal(0));
        }
        for (int i = 1; i < orgId.size(); ++i) {
            String id = (String)orgId.get(i);
            ProjectBusinessVO vo = (ProjectBusinessVO)((Object)dataList.get(id));
            if (vo != null) {
                vo.setRealityMoney(CommonUtils.parseYuanToWanZ(vo.getRealityMoney()));
                vo.setOneselfContract(CommonUtils.parseYuanToWanZ(vo.getOneselfContract()));
                BigDecimal planRatio1 = CommonUtils.calculateRate2(CommonUtils.setBigDecimalDefaultValue(vo.getPlanMoney()), CommonUtils.setBigDecimalDefaultValue(vo.getRealityMoney()));
                planDataList.add(planRatio1);
                BigDecimal predictRatio1 = CommonUtils.calculateRate2(CommonUtils.setBigDecimalDefaultValue(vo.getPredictMoney()), CommonUtils.setBigDecimalDefaultValue(vo.getOneselfContract()));
                predictDataList.add(predictRatio1);
                continue;
            }
            planDataList.add(new BigDecimal(0));
            predictDataList.add(new BigDecimal(0));
        }
        json.put("legendData", orgName);
        json.put("planDataList", planDataList);
        json.put("predictDataList", predictDataList);
        json.put("targetValue", predictDataList.get(0));
        json.put("achieveValue", planDataList.get(0));
        return json;
    }

    @Override
    public JSONObject getOutputValueConfirmationRate() {
        JSONObject json = new JSONObject();
        String reportingMonth = this.getReportingMonth("cumulative", "");
        LinkedHashMap<String, String> orgMap = this.getOrg();
        LinkedList<String> orgId = new LinkedList<String>();
        LinkedList<String> orgName = new LinkedList<String>();
        for (String key : orgMap.keySet()) {
            orgId.add(key);
            orgName.add(orgMap.get(key));
        }
        LinkedList<BigDecimal> ownerAffirmProductionDataList = new LinkedList<BigDecimal>();
        LinkedList<BigDecimal> actualFinishProductionDataList = new LinkedList<BigDecimal>();
        LinkedList<BigDecimal> confirmationRateDataList = new LinkedList<BigDecimal>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("reportingMonth", reportingMonth);
        param.put("orgIds", orgId);
        param.put("projectStatus", "2");
        param.put("tenantId", InvocationInfoProxy.getTenantid());
        param.put("type", "outputValueConfirmationRate");
        List<ProjectPaymentVO> orgData = this.portalMapper.getOutputValueConfirmationRate(param);
        HashMap<String, ProjectPaymentVO> dataList = new HashMap<String, ProjectPaymentVO>();
        for (ProjectPaymentVO vo : orgData) {
            dataList.put(vo.getTwoOrgId().toString(), vo);
        }
        param.put("range", "all");
        param.remove("orgIds");
        List<ProjectPaymentVO> allData = this.portalMapper.getOutputValueConfirmationRate(param);
        if (allData != null && allData.size() > 0 && allData.get(0) != null) {
            ownerAffirmProductionDataList.add(CommonUtils.parseYuanToYi(allData.get(0).getOwnerAffirmProduction()));
            actualFinishProductionDataList.add(CommonUtils.parseYuanToYi(allData.get(0).getActualFinishProduction()));
            BigDecimal confirmationRate = CommonUtils.calculateRate2(CommonUtils.setBigDecimalDefaultValue(allData.get(0).getOwnerAffirmProduction()), CommonUtils.setBigDecimalDefaultValue(allData.get(0).getActualFinishProduction()));
            confirmationRateDataList.add(confirmationRate);
        } else {
            ownerAffirmProductionDataList.add(new BigDecimal(0));
            actualFinishProductionDataList.add(new BigDecimal(0));
            confirmationRateDataList.add(new BigDecimal(0));
        }
        for (int i = 1; i < orgId.size(); ++i) {
            String id = (String)orgId.get(i);
            ProjectPaymentVO vo = (ProjectPaymentVO)((Object)dataList.get(id));
            if (vo != null) {
                ownerAffirmProductionDataList.add(CommonUtils.parseYuanToYi(vo.getOwnerAffirmProduction()));
                actualFinishProductionDataList.add(CommonUtils.parseYuanToYi(vo.getActualFinishProduction()));
                BigDecimal confirmationRate1 = CommonUtils.calculateRate2(CommonUtils.setBigDecimalDefaultValue(vo.getOwnerAffirmProduction()), CommonUtils.setBigDecimalDefaultValue(vo.getActualFinishProduction()));
                confirmationRateDataList.add(confirmationRate1);
                continue;
            }
            ownerAffirmProductionDataList.add(new BigDecimal(0));
            actualFinishProductionDataList.add(new BigDecimal(0));
            confirmationRateDataList.add(new BigDecimal(0));
        }
        json.put("legendData", orgName);
        json.put("ownerAffirmProductionDataList", ownerAffirmProductionDataList);
        json.put("actualFinishProductionDataList", actualFinishProductionDataList);
        json.put("confirmationRateDataList", confirmationRateDataList);
        return json;
    }

    @Override
    public JSONObject getCostRate(String projectStatus) {
        JSONObject json = new JSONObject();
        String reportingMonth = this.getReportingMonth("cumulative", "");
        LinkedHashMap<String, String> orgMap = this.getOrg();
        LinkedList<String> orgId = new LinkedList<String>();
        LinkedList<String> orgName = new LinkedList<String>();
        for (String key : orgMap.keySet()) {
            orgId.add(key);
            orgName.add(orgMap.get(key));
        }
        LinkedList<BigDecimal> costRateDataList = new LinkedList<BigDecimal>();
        LinkedList<BigDecimal> costToRateDataList = new LinkedList<BigDecimal>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("reportingMonth", reportingMonth);
        param.put("orgIds", orgId);
        param.put("projectStatus", projectStatus);
        param.put("tenantId", InvocationInfoProxy.getTenantid());
        param.put("type", "costRate");
        List<ProjectPaymentVO> orgData = this.portalMapper.getOutputValueConfirmationRate(param);
        HashMap<String, ProjectPaymentVO> dataList = new HashMap<String, ProjectPaymentVO>();
        for (ProjectPaymentVO vo : orgData) {
            dataList.put(vo.getTwoOrgId().toString(), vo);
        }
        param.put("range", "all");
        param.remove("orgIds");
        List<ProjectPaymentVO> allData = this.portalMapper.getOutputValueConfirmationRate(param);
        if (allData != null && allData.size() > 0 && allData.get(0) != null) {
            BigDecimal gatheringProject = ComputeUtil.safeSub((BigDecimal)allData.get(0).getProjectFunds(), (BigDecimal)allData.get(0).getAdvance());
            BigDecimal costRate = CommonUtils.calculateRate2(CommonUtils.setBigDecimalDefaultValue(gatheringProject), CommonUtils.setBigDecimalDefaultValue(allData.get(0).getActualCost()));
            costRateDataList.add(costRate);
            BigDecimal costToRate = CommonUtils.calculateRate2(CommonUtils.setBigDecimalDefaultValue(allData.get(0).getAmountPaid()), CommonUtils.setBigDecimalDefaultValue(allData.get(0).getActualCost()));
            costToRateDataList.add(costToRate);
        } else {
            costRateDataList.add(new BigDecimal(0));
            costToRateDataList.add(new BigDecimal(0));
        }
        for (int i = 1; i < orgId.size(); ++i) {
            String id = (String)orgId.get(i);
            ProjectPaymentVO vo = (ProjectPaymentVO)((Object)dataList.get(id));
            if (vo != null) {
                BigDecimal gatheringProject1 = ComputeUtil.safeSub((BigDecimal)vo.getProjectFunds(), (BigDecimal)vo.getAdvance());
                BigDecimal costRate1 = CommonUtils.calculateRate2(CommonUtils.setBigDecimalDefaultValue(gatheringProject1), CommonUtils.setBigDecimalDefaultValue(vo.getActualCost()));
                costRateDataList.add(costRate1);
                BigDecimal costToRate1 = CommonUtils.calculateRate2(CommonUtils.setBigDecimalDefaultValue(vo.getAmountPaid()), CommonUtils.setBigDecimalDefaultValue(vo.getActualCost()));
                costToRateDataList.add(costToRate1);
                continue;
            }
            costRateDataList.add(new BigDecimal(0));
            costToRateDataList.add(new BigDecimal(0));
        }
        json.put("legendData", orgName);
        json.put("costRateDataList", costRateDataList);
        json.put("costToRateDataList", costToRateDataList);
        return json;
    }

    @Override
    public JSONObject getScheduleDelay(String projectStatus) {
        JSONObject json = new JSONObject();
        String reportingMonth = this.getReportingMonth("cumulative", "");
        LinkedHashMap<String, String> orgMap = this.getOrg();
        LinkedList<String> orgId = new LinkedList<String>();
        LinkedList<String> orgName = new LinkedList<String>();
        for (String key : orgMap.keySet()) {
            orgId.add(key);
            orgName.add(orgMap.get(key));
        }
        LinkedList<BigDecimal> delayDaysTotalDataList = new LinkedList<BigDecimal>();
        LinkedList<BigDecimal> delayCostTotalDataList = new LinkedList<BigDecimal>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("reportingMonth", reportingMonth);
        param.put("projectStatus", projectStatus);
        param.put("orgIds", orgId);
        param.put("tenantId", InvocationInfoProxy.getTenantid());
        List<ProDurationDelayVO> orgData = this.portalMapper.getScheduleDelay(param);
        HashMap<String, ProDurationDelayVO> dataList = new HashMap<String, ProDurationDelayVO>();
        for (ProDurationDelayVO vo : orgData) {
            dataList.put(vo.getTwoOrgId().toString(), vo);
        }
        param.put("range", "all");
        param.remove("orgIds");
        List<ProDurationDelayVO> allData = this.portalMapper.getScheduleDelay(param);
        if (allData != null && allData.size() > 0 && allData.get(0) != null) {
            delayDaysTotalDataList.add(allData.get(0).getDelayDaysTotal());
            delayCostTotalDataList.add(CommonUtils.parseYuanToWan2(allData.get(0).getDelayCostTotal()));
        } else {
            delayDaysTotalDataList.add(new BigDecimal(0));
            delayCostTotalDataList.add(new BigDecimal(0));
        }
        for (int i = 1; i < orgId.size(); ++i) {
            String id = (String)orgId.get(i);
            ProDurationDelayVO vo = (ProDurationDelayVO)dataList.get(id);
            if (vo != null) {
                delayDaysTotalDataList.add(vo.getDelayDaysTotal());
                delayCostTotalDataList.add(CommonUtils.parseYuanToWan2(vo.getDelayCostTotal()));
                continue;
            }
            delayDaysTotalDataList.add(new BigDecimal(0));
            delayCostTotalDataList.add(new BigDecimal(0));
        }
        json.put("legendData", orgName);
        json.put("delayDaysTotalDataList", delayDaysTotalDataList);
        json.put("delayCostTotalDataList", delayCostTotalDataList);
        return json;
    }

    private String getReportingMonth(String section, String year) {
        String reportingMonth = null;
        if ("yearCumulative".equals(section)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy");
            String nowYear = format.format(new Date());
            if (year.equals(nowYear)) {
                LocalDateTime currentTime = LocalDateTime.now();
                LocalDateTime lastMonth = currentTime.minusMonths(1L);
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
                reportingMonth = lastMonth.format(formatter);
            } else {
                reportingMonth = year + "-12";
            }
        } else {
            LocalDateTime currentTime = LocalDateTime.now();
            LocalDateTime lastMonth = currentTime.minusMonths(1L);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
            reportingMonth = lastMonth.format(formatter);
        }
        return reportingMonth;
    }

    private LinkedHashMap<String, String> getOrg() {
        LinkedHashMap<String, String> orgMap = new LinkedHashMap<String, String>();
        CommonResponse defdocResponse = this.defdocApi.getDefDocByDefCode("zjkj_cost_portal_org");
        if (defdocResponse.isSuccess() && defdocResponse.getData() != null) {
            for (DefdocDetailVO vo : (List)defdocResponse.getData()) {
                orgMap.put(vo.getCode(), vo.getName());
                this.logger.info("code:{},name:{}", (Object)vo.getCode(), (Object)vo.getName());
            }
        } else {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u7ec4\u7ec7\u4fe1\u606f");
        }
        return orgMap;
    }

    public static void main(String[] args) {
        LocalDateTime currentTime = LocalDateTime.now();
        LocalDateTime lastMonth = currentTime.minusMonths(1L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM");
        String lastMonthDate = lastMonth.format(formatter);
        System.out.println("\u4e0a\u4e00\u4e2a\u6708\u7684\u65e5\u671f\u4e3a\uff1a" + lastMonthDate);
        ArrayList<Object> delayDaysTotalDataList = new ArrayList<Object>();
        delayDaysTotalDataList.add(null);
        System.out.println(delayDaysTotalDataList);
    }
}

