package com.ejianc.foundation.analyticdatas.consumer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.ejianc.foundation.analyticdatas.service.IBehaviorDataAnalyticService;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.mq.consumer.BaseConsumer;

@Component
public class AnalyticDatasCommonListener extends BaseConsumer {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IBehaviorDataAnalyticService behaviorDataAnalyticService;

    @Override
    protected void doConsumeMsg(MqMessage mqMessage) {
        try {
        	behaviorDataAnalyticService.handleBehaviorDatas(JSON.toJSONString(mqMessage.getBody()));
        } catch (Exception e) {
            logger.error("数据分析消费异常: ", e);
        }
    }

    @Override
    protected String[] getQueueNames() {
        return new String[]{BehaviorDataAnalyticParam.ANALYTICDATAS_COMMON_QUEUE};
    }
}
