package com.ejianc.foundation.analyticdatas.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.analyticdatas.bean.BehaviorDataAnalyticEntity;
import com.ejianc.foundation.analyticdatas.consumer.BehaviorDataAnalyticParam;
import com.ejianc.foundation.analyticdatas.mapper.BehaviorDataAnalyticMapper;
import com.ejianc.foundation.analyticdatas.service.IBehaviorDataAnalyticService;
import com.ejianc.foundation.analyticdatas.vo.BehaviorDataAnalyticVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;

@Service
public class BehaviorDataAnalyticServiceImpl extends BaseServiceImpl<BehaviorDataAnalyticMapper, BehaviorDataAnalyticEntity> implements IBehaviorDataAnalyticService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private final static String GET_ADDR_BY_IP = "http://opendata.baidu.com/api.php?query=IPADDR&resource_id=6006&t=IDWORKER&ie=utf8&format=json";
	
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private BehaviorDataAnalyticMapper behaviorDataAnalyticMapper;
    
	@Override
	public void registerData(BehaviorDataAnalyticVO behaviorData) {
		MqMessage mqMessage = new MqMessage();
        mqMessage.setBody(behaviorData);
        rabbitTemplate.convertAndSend(BehaviorDataAnalyticParam.ANALYTICDATAS_COMMON_QUEUE, mqMessage);
	}

	@Override
	@Transactional
	public void handleBehaviorDatas(String behaviorData) {
		logger.info("待处理的用户行为数据：【{}】", behaviorData);
		BehaviorDataAnalyticVO behaviorDataAnalyticVo = JSONObject.parseObject(behaviorData, BehaviorDataAnalyticVO.class);
		if(StringUtils.isNotBlank(behaviorDataAnalyticVo.getIpAddr())) {
			String ipAddr = behaviorDataAnalyticVo.getIpAddr();
			String getAddrUrl = GET_ADDR_BY_IP.replace("IPADDR", ipAddr).replace("IDWORKER", IdWorker.getId()+"");
			try {
				Map<String, String> params = new HashMap<>();
				Map<String, String> headers = new HashMap<>();
				String addrData = HttpTookit.get(getAddrUrl,"gb2312", params, headers);
				logger.info("addrData======="+addrData);
				JSONObject addrJson = JSON.parseObject(addrData);
				JSONArray addrDataList = addrJson.getJSONArray("data");
				JSONObject addrDataObj = addrDataList.getJSONObject(0);
				String location = addrDataObj.getString("location");
				if(StringUtils.isNotBlank(location)) {
					String[] locationArr = location.split(" ");
					if(locationArr.length > 1) {
						String address = locationArr[0];
						String[] addressArr = address.split("省");
						if(addressArr.length >= 1){
							behaviorDataAnalyticVo.setProvince(addressArr[0]+"省");
							if(addressArr.length > 1) {
								behaviorDataAnalyticVo.setCity(addressArr[1]);
							}
						}else{
							addressArr = address.split("自治区");
							if(addressArr.length > 1) {
								behaviorDataAnalyticVo.setProvince(addressArr[0]+"自治区");
								if(addressArr.length > 1) {
									behaviorDataAnalyticVo.setCity(addressArr[1]);
								}
							}else{
								addressArr = address.split("市");
								behaviorDataAnalyticVo.setProvince(addressArr[0]+"市");
								behaviorDataAnalyticVo.setCity(addressArr[0]+"市");
							}
						}
						behaviorDataAnalyticVo.setOperators(locationArr[1]);
					}
				}
			} catch (Exception e) { } 
			
			BehaviorDataAnalyticEntity behaviorDataAnalyticEntity = BeanMapper.map(behaviorDataAnalyticVo, BehaviorDataAnalyticEntity.class);
			behaviorDataAnalyticMapper.insert(behaviorDataAnalyticEntity);
		}
	}
	
	@Override
	public List<BehaviorDataAnalyticVO> queryProvinceMapData() {
        return behaviorDataAnalyticMapper.queryProvinceMapData();
	}

	@Override
	public List<BehaviorDataAnalyticVO> queryCityMapData(String provinceName) {
		 return behaviorDataAnalyticMapper.queryCityMapData(provinceName);
	}

	@Override
	public IPage<BehaviorDataAnalyticVO> queryCountRankPage(Map<String, Object> param) {
        List<BehaviorDataAnalyticVO> voList = new ArrayList<>();
        IPage<BehaviorDataAnalyticVO> page = new Page<>();
        page.setCurrent(Integer.valueOf(param.get("pageIndex").toString()));
        page.setSize(Integer.valueOf(param.get("pageSize").toString()));
        long total = behaviorDataAnalyticMapper.countCountRankPage(param);
        page.setTotal(total);
        if(total == 0) {
            page.setRecords(voList);
            return page;
        }
        long startLine = (page.getCurrent() < 1 ? 0 : page.getCurrent() -  1) * page.getSize();
        param.put("startLine", startLine);
        param.put("pageSize", page.getSize());
        voList = behaviorDataAnalyticMapper.queryCountRankPage(param);
        if("enterpriseUseAppData".equals(param.get("type"))){
        	if(ListUtil.isNotEmpty(voList)){
				for (BehaviorDataAnalyticVO analyticVO : voList) {
					List<String> comNames = behaviorDataAnalyticMapper.queryComNameByAppName(analyticVO.getAppName());
					analyticVO.setComNames(comNames);
					analyticVO.setComNums(ListUtil.isNotEmpty(comNames)?comNames.size():0L);
				}
			}
		}
        page.setRecords(voList);
        return page;
	}

}
