package com.ejianc.foundation.analyticdatas.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.analyticdatas.bean.BusinessDataAnalyticEntity;
import com.ejianc.foundation.analyticdatas.service.IBusinessDataAnalyticService;
import com.ejianc.foundation.analyticdatas.vo.BusinessDataAnalyticVO;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;

@SuppressWarnings("unchecked")
@Controller
@RequestMapping("businessdata/analytic")
public class BusinessDataAnalyticController implements Serializable {

	private static final long serialVersionUID = 1L;
	
	@Value("${common.env.base-host}")
	private String baseHost;
	
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IBusinessDataAnalyticService businessDataAnalyticService;
	
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<BusinessDataAnalyticVO> saveOrUpdate(@RequestBody BusinessDataAnalyticVO businessDataAnalyticVo) {
		CommonResponse<BillTypeVO> billTypeResponse = billTypeApi.getById(businessDataAnalyticVo.getBillTypeId());
		if(billTypeResponse.isSuccess()) {
			CommonResponse<MdReferVO> mdReferResponse = billTypeApi.queryMetadataByBillType(billTypeResponse.getData().getBillCode());
			if(mdReferResponse.isSuccess()) {
				MdReferVO referVo = mdReferResponse.getData();
				Map<String, String> paramterMap = new HashMap<>();
				paramterMap.put("tableName", referVo.getTableName());
				if(businessDataAnalyticVo.getTenantId() != null) {
					paramterMap.put("tenantId", businessDataAnalyticVo.getTenantId()+"");
				}

				String url = baseHost + referVo.getProjectName() + "/commonstate/queryBillCount";
				try {
					String result = ReferHttpClientUtils.postByJson(url, JSON.toJSONString(paramterMap));
					CommonResponse<String> countResponse = JSONObject.parseObject(result, CommonResponse.class);
					if(countResponse.isSuccess()) {
						Long dataCount = countResponse.getData()!=null?Long.parseLong(countResponse.getData()):0;
						businessDataAnalyticVo.setDataCount(dataCount);
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		businessDataAnalyticVo.setLastUpdateTime(new Date());
		
		BusinessDataAnalyticEntity entity = BeanMapper.map(businessDataAnalyticVo, BusinessDataAnalyticEntity.class);
		businessDataAnalyticService.saveOrUpdate(entity);
		
		return CommonResponse.success();
	}
	
	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<BusinessDataAnalyticVO>> pageList(@RequestBody QueryParam queryParam) {
		Map<String, String> order = queryParam.getOrderMap();
		order.put("sequence", "asc");
		IPage<BusinessDataAnalyticEntity> pageData = businessDataAnalyticService.queryPage(queryParam, false);
		IPage<BusinessDataAnalyticVO> page = new Page<BusinessDataAnalyticVO>(pageData.getCurrent(),pageData.getSize(),pageData.getTotal());
		List<BusinessDataAnalyticVO> list = new ArrayList<>();
		if(pageData.getRecords()!=null&&pageData.getRecords().size()>0){
			list = BeanMapper.mapList(pageData.getRecords(), BusinessDataAnalyticVO.class);
		}
		page.setRecords(list);
		return CommonResponse.success(page);
	}
	
	@RequestMapping(value = "/delete", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> delete(@RequestParam Long id) {
		businessDataAnalyticService.removeById(id);
		return CommonResponse.success();
	}

}
