package com.ejianc.foundation.analyticdatas.controller;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.analyticdatas.bean.LoginlogsEntity;
import com.ejianc.foundation.analyticdatas.bean.StatisticBillDataEntity;
import com.ejianc.foundation.analyticdatas.service.IStatisticBillDataService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.analyticdatas.bean.TenantDataEntity;
import com.ejianc.foundation.analyticdatas.service.ITenantDataService;
import com.ejianc.foundation.analyticdatas.service.ILoginlogsService;
import com.ejianc.foundation.tenant.api.IEnterpriseApi;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 租户获取服务
 * 
 * @author guoming
 *
 */
@Controller
@RequestMapping("tenantdata")
public class TenantDataController implements Serializable {

	private static final long serialVersionUID = 1L;
	
	@Autowired
	private IEnterpriseApi enterpriseApi;
	@Autowired
	private ITenantDataService tenantDataService;
	@Autowired
	private ILoginlogsService iLoginlogsService;
	@Autowired
	private IStatisticBillDataService statisticBillDataService;

	@RequestMapping(value = "/sync", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> syncTenantList() {
		CommonResponse<List<EnterpriseVO>> enterpriseResponse = enterpriseApi.getAllEnterpriseList();
		if(enterpriseResponse.isSuccess()) {
			List<EnterpriseVO> enterpriseList = enterpriseResponse.getData();
			if(enterpriseList != null && enterpriseList.size() > 0) {
				List<TenantDataEntity> tenantDataList = new ArrayList<TenantDataEntity>();
				for(EnterpriseVO enterpriseVo:enterpriseList) {
					QueryWrapper<TenantDataEntity> queryWrapper = new QueryWrapper<>();
					queryWrapper.eq("tenant_id", enterpriseVo.getTenantId());
					TenantDataEntity tenantDataEntity = tenantDataService.getOne(queryWrapper);
					if(tenantDataEntity != null) {
						tenantDataEntity.setTenantName(enterpriseVo.getName());
						tenantDataEntity.setBusinessType(enterpriseVo.getBusinessType());
						tenantDataEntity.setSocialCreditCode(enterpriseVo.getSocialCreditCode());
						tenantDataEntity.setCreateTime(enterpriseVo.getCreateTime());
						tenantDataEntity.setUpdateTime(enterpriseVo.getUpdateTime());

						tenantDataList.add(tenantDataEntity);
					}else{
						tenantDataEntity = new TenantDataEntity();
						tenantDataEntity.setTenantId(enterpriseVo.getTenantId());
						tenantDataEntity.setTenantName(enterpriseVo.getName());
						tenantDataEntity.setBusinessType(enterpriseVo.getBusinessType());
						tenantDataEntity.setSuperAdminId(enterpriseVo.getUserId());
						tenantDataEntity.setSuperAdminUserCode(enterpriseVo.getUserCode());
						tenantDataEntity.setSocialCreditCode(enterpriseVo.getSocialCreditCode());
						tenantDataEntity.setCreateTime(enterpriseVo.getCreateTime());
						tenantDataEntity.setUpdateTime(enterpriseVo.getUpdateTime());

						tenantDataList.add(tenantDataEntity);
					}
				}
				tenantDataService.saveOrUpdateBatch(tenantDataList);
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 获取 企业租户数，本年新增租户数
	 *
	 * @return
	 */
	@RequestMapping(value = "/queryTenantData", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<JSONObject> queryTenantData() {
		JSONObject res = new JSONObject();

		QueryParam param = new QueryParam();
		List<TenantDataEntity> dataEntityList = tenantDataService.queryList(param,false);
		res.put("totalEnterpriseNum",dataEntityList.size());
		param.getParams().put("createTime",new Parameter(QueryParam.GE, LocalDate.now().getYear()+"-01-01 00:00:00"));
		dataEntityList = tenantDataService.queryList(param,false);
		res.put("totalNewEnterpriseNumThisYear",dataEntityList.size());
		List<JSONObject> objectList = tenantDataService.businessTake();
		List<JSONObject> list = ListUtil.newArrayList();
		if(ListUtil.isNotEmpty(objectList)){
			int total = 0;
			for (JSONObject object : objectList) {
				if(Objects.equals(object.getString("bt"),"1")){
					object.put("name","建筑施工单位");
					list.add(object);
					total+=object.getInteger("value");
				}else if(Objects.equals(object.getString("bt"),"2")){
					object.put("name","供应商");
					res.put("supplierNum",object.getInteger("value"));
					list.add(object);
					total+=object.getInteger("value");
				}
			}
			JSONObject object = new JSONObject();
			object.put("name","其他");
			object.put("value",res.getInteger("totalEnterpriseNum")-total);
			list.add(object);
		}
		res.put("businessTake",list);
		CommonResponse<JSONObject> userTotal =  enterpriseApi.getAllUserStatistics();
		if(userTotal.isSuccess()){
			res.put("userTotal",userTotal.getData());
		}else {
			JSONObject total = new JSONObject();
			total.put("total",0);
			total.put("thisYear",0);
			res.put("userTotal",total);
		}
		param.getParams().put("businessType",new Parameter(QueryParam.EQ, 2));
		dataEntityList = tenantDataService.queryList(param,false);
		res.put("supplierNumThisYear",dataEntityList.size());
		/** 登录用户数 */
		param = new QueryParam();
		List<LoginlogsEntity> loginlogsEntities = iLoginlogsService.queryList(param,false);
		res.put("loginTotal",loginlogsEntities.size());
		param.getParams().put("loginTime",new Parameter(QueryParam.GE, LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))+" 00:00:00"));
		loginlogsEntities = iLoginlogsService.queryList(param,false);
		res.put("loginTotalToday",loginlogsEntities.size());

		return CommonResponse.success(res);
	}

	/**
	 * 获取 企业租户列表
	 *
	 * @return
	 */
	@RequestMapping(value = "/queryTenantList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<JSONObject>> queryTenantList(@RequestBody QueryParam param) {

		IPage<TenantDataEntity> dataEntityList = tenantDataService.queryPage(param,false);
		IPage<JSONObject> page = new Page<>();
		page.setSize(dataEntityList.getSize());
		page.setCurrent(dataEntityList.getCurrent());
		page.setTotal(dataEntityList.getTotal());
		page.setPages(dataEntityList.getPages());
		Calendar calendar = Calendar.getInstance();
		// 将日期减一天
		calendar.add(Calendar.DATE, -1);
		String today = DateFormatUtil.formatDate("yyyy-MM-dd",calendar.getTime());

		if(ListUtil.isNotEmpty(dataEntityList.getRecords())){
			List<JSONObject> records = new ArrayList<>();
			for (TenantDataEntity entity : dataEntityList.getRecords()) {
				CommonResponse<JSONObject> comboInfo = enterpriseApi.getEnterpriseComboInfo(entity.getTenantId());
				JSONObject data = new JSONObject();
				if(comboInfo.isSuccess()){
					data = comboInfo.getData();
				}else {
					data.put("id",entity.getTenantId());
					data.put("name",entity.getTenantName());
					data.put("appNum",0);
				}
				param = new QueryParam();
				param.getParams().put("statistic_tenant_id",new Parameter(QueryParam.EQ,entity.getTenantId()));
				param.getParams().put("statisticTime",new Parameter(QueryParam.EQ,today));
				List<StatisticBillDataEntity> billInfo = statisticBillDataService.queryList(param);
				long billCountToday = 0;
				long billCountTotal = 0;
				if(ListUtil.isNotEmpty(billInfo)){
					for (StatisticBillDataEntity billDataEntity : billInfo) {
						billCountToday+=billDataEntity.getBillCount();
						billCountTotal+=billDataEntity.getBillSumCount();
					}
				}
				data.put("billCountToday",billCountToday);
				data.put("billCountTotal",billCountTotal);
				records.add(data);
			}
			page.setRecords(records);
		}

		return CommonResponse.success(page);
	}


}
