package com.ejianc.foundation.analyticdatas.service.impl;

import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.foundation.analyticdatas.bean.StatisticBillDataEntity;
import com.ejianc.foundation.analyticdatas.mapper.StatisticBillDataMapper;
import com.ejianc.foundation.analyticdatas.service.IStatisticBillDataService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;

@Service
public class StatisticBillDataServiceImpl extends BaseServiceImpl<StatisticBillDataMapper, StatisticBillDataEntity> implements IStatisticBillDataService {

    @Autowired
    StatisticBillDataMapper statisticBillDataMapper;
    @Override
    public long queryStatisticBillTenantRankCount(String date) {
        return statisticBillDataMapper.queryStatisticBillTenantRankCount(date);
    }

    @Override
    public List<JSONObject> queryStatisticBillTenantRankPage(String date, int startLine, int pageSize) {
        return statisticBillDataMapper.queryStatisticBillTenantRankPage(date,startLine,pageSize);
    }

    @Override
    public long queryStatisticBillTenantRankThisMonthCount(String thisMonth) {
        return statisticBillDataMapper.queryStatisticBillTenantRankThisMonthCount(thisMonth);
    }

    @Override
    public List<JSONObject> queryStatisticBillTenantRankThisMonthPage(String thisMonth, int startLine, int pageSize) {
        return statisticBillDataMapper.queryStatisticBillTenantRankThisMonthPage(thisMonth,startLine,pageSize);
    }
}
