package com.ejianc.foundation.analyticdatas.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.foundation.analyticdatas.bean.TenantDataEntity;
import com.ejianc.foundation.analyticdatas.mapper.TenantDataMapper;
import com.ejianc.foundation.analyticdatas.service.ITenantDataService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;

@Service
public class TenantDataServiceImpl extends BaseServiceImpl<TenantDataMapper, TenantDataEntity> implements ITenantDataService {

    @Autowired
    private TenantDataMapper tenantDataMapper;
    @Override
    public List<JSONObject> businessTake() {
        return tenantDataMapper.businessTake();
    }

    @Override
    public TenantDataEntity selectByTenantId(Long tenantId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,tenantId));
        List<TenantDataEntity> entities = queryList(param);
        return ListUtil.isNotEmpty(entities)?entities.get(0):null;
    }
}
