/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.analyticdatas.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.analyticdatas.bean.StatisticBillDataEntity;
import com.ejianc.foundation.analyticdatas.bean.TenantDataEntity;
import com.ejianc.foundation.analyticdatas.service.IBehaviorDataAnalyticService;
import com.ejianc.foundation.analyticdatas.service.IStatisticBillDataService;
import com.ejianc.foundation.analyticdatas.service.ITenantDataService;
import com.ejianc.foundation.analyticdatas.vo.BehaviorDataAnalyticVO;
import com.ejianc.foundation.tenant.api.IEnterpriseApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"behaviordata/analytic"})
public class BehaviorDataAnalyticController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBehaviorDataAnalyticService behaviorDataAnalyticService;
    @Autowired
    private IEnterpriseApi enterpriseApi;
    @Autowired
    private IStatisticBillDataService statisticBillDataService;
    @Autowired
    private ITenantDataService tenantDataService;

    @RequestMapping(value={"/register"})
    @ResponseBody
    public CommonResponse<String> registData(HttpServletRequest request) {
        String appId = request.getParameter("appId");
        String appName = request.getParameter("appName");
        String eventCode = request.getParameter("eventCode");
        String reqFrom = request.getParameter("reqFrom");
        if (StringUtils.isBlank((CharSequence)appId) || StringUtils.isBlank((CharSequence)appName)) {
            return CommonResponse.error((String)"\u6570\u636e\u4e0d\u5408\u6cd5:appId\u548cappName\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BehaviorDataAnalyticVO behaviorData = new BehaviorDataAnalyticVO();
        String userAgent = request.getHeader("user-agent");
        behaviorData.setDeviceId(userAgent);
        String ipAddr = this.getIPAddress(request);
        UserContext userContext = this.sessionManager.getUserContext();
        if (StringUtils.isNotBlank((CharSequence)ipAddr)) {
            behaviorData.setIpAddr(ipAddr);
        }
        behaviorData.setUserId(InvocationInfoProxy.getUserid() + "");
        behaviorData.setCompanyName(userContext.getEnterpriseName());
        behaviorData.setUserName(userContext.getEmployeeName());
        behaviorData.setUserMobile(userContext.getUserMobile());
        behaviorData.setOperateTime(new Date());
        behaviorData.setAppId(appId);
        behaviorData.setAppName(appName);
        behaviorData.setEventCode(eventCode);
        behaviorData.setReqFrom(reqFrom);
        QueryParam param = new QueryParam();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List list = this.tenantDataService.queryList(param);
        if (ListUtil.isNotEmpty((List)list)) {
            TenantDataEntity tenantDataEntity = (TenantDataEntity)((Object)list.get(0));
            behaviorData.setCompanyType(tenantDataEntity.getBusinessType());
        }
        this.behaviorDataAnalyticService.registerData(behaviorData);
        return CommonResponse.success();
    }

    @RequestMapping(value={"/loginRegister"})
    @ResponseBody
    public CommonResponse<String> loginRegister(HttpServletRequest request) {
        String tenantId = request.getParameter("tenantId");
        String userCode = request.getParameter("userCode");
        String deviceId = request.getParameter("deviceId");
        String ipAddr = request.getParameter("ipAddr");
        String reqFrom = request.getParameter("reqFrom");
        BehaviorDataAnalyticVO behaviorData = new BehaviorDataAnalyticVO();
        behaviorData.setDeviceId(deviceId);
        behaviorData.setUserCode(userCode);
        behaviorData.setReqFrom(reqFrom);
        behaviorData.setTenantId(Long.valueOf(Long.parseLong(tenantId)));
        if (StringUtils.isNotBlank((CharSequence)ipAddr)) {
            behaviorData.setIpAddr(ipAddr);
        }
        behaviorData.setOperateTime(new Date());
        behaviorData.setEventCode("login");
        this.behaviorDataAnalyticService.registerData(behaviorData);
        return CommonResponse.success();
    }

    private String getIPAddress(HttpServletRequest request) {
        String ip = null;
        String ipAddresses = request.getHeader("X-Forwarded-For");
        if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            ipAddresses = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            ipAddresses = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            ipAddresses = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            ipAddresses = request.getHeader("X-Real-IP");
        }
        if (ipAddresses != null && ipAddresses.length() != 0) {
            ip = ipAddresses.split(",")[0];
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    @RequestMapping(value={"/getMapData"})
    @ResponseBody
    public CommonResponse<JSONObject> getMapData(@RequestParam String range, @RequestParam String type) {
        JSONObject back = new JSONObject();
        back.put("range", (Object)range);
        if ("china".equals(type)) {
            JSONArray proList = new JSONArray();
            List<BehaviorDataAnalyticVO> list = this.behaviorDataAnalyticService.queryProvinceMapData();
            if (list != null && list.size() > 0) {
                for (BehaviorDataAnalyticVO vo : list) {
                    JSONObject province = new JSONObject();
                    province.put("name", (Object)vo.getProvince());
                    province.put("value", (Object)vo.getStatistics());
                    proList.add((Object)province);
                }
            }
            back.put("data", (Object)proList);
        } else {
            JSONArray cityList = new JSONArray();
            List<BehaviorDataAnalyticVO> list = this.behaviorDataAnalyticService.queryCityMapData(range);
            if (list != null && list.size() > 0) {
                if ("\u5317\u4eac\u5e02".equals(range) || "\u5317\u4eac\u5e02".equals(range) || "\u4e0a\u6d77\u5e02".equals(range) || "\u53f0\u6e7e\u7701".equals(range) || "\u5929\u6d25\u5e02".equals(range) || "\u9999\u6e2f".equals(range) || "\u6fb3\u95e8".equals(range)) {
                    Integer value = 0;
                    for (BehaviorDataAnalyticVO vo : list) {
                        value = value + Integer.valueOf(vo.getStatistics());
                    }
                    JSONObject city = new JSONObject();
                    city.put("name", (Object)range);
                    city.put("value", (Object)value);
                    cityList.add((Object)city);
                } else {
                    for (BehaviorDataAnalyticVO vo : list) {
                        JSONObject city = new JSONObject();
                        city.put("name", (Object)vo.getCity());
                        city.put("value", (Object)vo.getStatistics());
                        cityList.add((Object)city);
                    }
                }
            }
            back.put("data", (Object)cityList);
        }
        return CommonResponse.success((Object)back);
    }

    @RequestMapping(value={"/queryCountRankPage"})
    @ResponseBody
    public CommonResponse<IPage<BehaviorDataAnalyticVO>> queryCountRankPage(@RequestBody Map<String, Object> param) {
        IPage<BehaviorDataAnalyticVO> page = this.behaviorDataAnalyticService.queryCountRankPage(param);
        return CommonResponse.success(page);
    }

    @RequestMapping(value={"/getEnterpriseComEndTimeInComingSeveralMonth"})
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> getEnterpriseComEndTimeInComingSeveralMonth(@RequestBody Map<String, Object> param) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 3);
        System.out.println("\u589e\u52a0\u4e09\u4e2a\u6708\u540e\u7684\u65e5\u671f\uff1a" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)calendar.getTime()));
        CommonResponse response = this.enterpriseApi.getEnterpriseComEndTimeInComingSeveralMonth(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)calendar.getTime()));
        Page page = new Page();
        int pageIndex = Integer.parseInt(param.get("pageIndex").toString());
        int pageSize = Integer.parseInt(param.get("pageSize").toString());
        page.setCurrent((long)pageIndex);
        page.setSize((long)pageSize);
        if (response.isSuccess()) {
            page.setTotal((long)((List)response.getData()).size());
            List datas = (List)response.getData();
            ArrayList<JSONObject> record = new ArrayList<JSONObject>();
            QueryParam queryParam = new QueryParam();
            for (int i = pageIndex * pageSize; i < (pageIndex + 1) * pageSize; ++i) {
                if ((long)i >= page.getTotal()) continue;
                JSONObject object = (JSONObject)datas.get(i);
                queryParam.getParams().put("statistic_tenant_id", new Parameter("eq", (Object)object.getString("id")));
                queryParam.getOrderMap().put("statisticTime", "desc");
                List billDataEntities = this.statisticBillDataService.queryList(queryParam, false);
                if (ListUtil.isNotEmpty((List)billDataEntities)) {
                    object.put("billCount", (Object)((StatisticBillDataEntity)((Object)billDataEntities.get(0))).getBillSumCount());
                } else {
                    object.put("billCount", (Object)0);
                }
                record.add(object);
            }
            page.setRecords(record);
        }
        return CommonResponse.success((Object)page);
    }
}

