/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.analyticdatas.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.analyticdatas.bean.BusinessDataAnalyticEntity;
import com.ejianc.foundation.analyticdatas.service.IBusinessDataAnalyticService;
import com.ejianc.foundation.analyticdatas.vo.BusinessDataAnalyticVO;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"businessdata/analytic"})
public class BusinessDataAnalyticController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBusinessDataAnalyticService businessDataAnalyticService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BusinessDataAnalyticVO> saveOrUpdate(@RequestBody BusinessDataAnalyticVO businessDataAnalyticVo) {
        CommonResponse mdReferResponse;
        CommonResponse billTypeResponse = this.billTypeApi.getById(businessDataAnalyticVo.getBillTypeId());
        if (billTypeResponse.isSuccess() && (mdReferResponse = this.billTypeApi.queryMetadataByBillType(((BillTypeVO)billTypeResponse.getData()).getBillCode())).isSuccess()) {
            MdReferVO referVo = (MdReferVO)mdReferResponse.getData();
            HashMap<String, String> paramterMap = new HashMap<String, String>();
            paramterMap.put("tableName", referVo.getTableName());
            if (businessDataAnalyticVo.getTenantId() != null) {
                paramterMap.put("tenantId", businessDataAnalyticVo.getTenantId() + "");
            }
            String url = this.baseHost + referVo.getProjectName() + "/commonstate/queryBillCount";
            try {
                String result = ReferHttpClientUtils.postByJson((String)url, (String)JSON.toJSONString(paramterMap));
                CommonResponse countResponse = (CommonResponse)JSONObject.parseObject((String)result, CommonResponse.class);
                if (countResponse.isSuccess()) {
                    Long dataCount = countResponse.getData() != null ? Long.parseLong((String)countResponse.getData()) : 0L;
                    businessDataAnalyticVo.setDataCount(dataCount);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        businessDataAnalyticVo.setLastUpdateTime(new Date());
        BusinessDataAnalyticEntity entity = (BusinessDataAnalyticEntity)((Object)BeanMapper.map((Object)businessDataAnalyticVo, BusinessDataAnalyticEntity.class));
        this.businessDataAnalyticService.saveOrUpdate((Object)entity);
        return CommonResponse.success();
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BusinessDataAnalyticVO>> pageList(@RequestBody QueryParam queryParam) {
        LinkedHashMap order = queryParam.getOrderMap();
        order.put("sequence", "asc");
        IPage pageData = this.businessDataAnalyticService.queryPage(queryParam, false);
        Page page = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        List list = new ArrayList();
        if (pageData.getRecords() != null && pageData.getRecords().size() > 0) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), BusinessDataAnalyticVO.class);
        }
        page.setRecords(list);
        return CommonResponse.success((Object)page);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam Long id) {
        this.businessDataAnalyticService.removeById(id);
        return CommonResponse.success();
    }
}

