/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.analyticdatas.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.analyticdatas.bean.StatisticBillDataEntity;
import com.ejianc.foundation.analyticdatas.bean.StatisticBillEntity;
import com.ejianc.foundation.analyticdatas.bean.TenantDataEntity;
import com.ejianc.foundation.analyticdatas.service.IStatisticBillDataService;
import com.ejianc.foundation.analyticdatas.service.IStatisticBillService;
import com.ejianc.foundation.analyticdatas.service.ITenantDataService;
import com.ejianc.foundation.analyticdatas.vo.StatisticBillVO;
import com.ejianc.foundation.metadata.api.IMdClassApi;
import com.ejianc.foundation.metadata.api.IMdProjectApi;
import com.ejianc.foundation.metadata.vo.MdClassVO;
import com.ejianc.foundation.metadata.vo.MdProjectVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"statbill"})
public class StatisticBillController
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long serialVersionUID = 1L;
    @Autowired
    private IStatisticBillService statisticBillService;
    @Autowired
    private IStatisticBillDataService statisticBillDataService;
    @Autowired
    private IMdClassApi mdClassApi;
    @Autowired
    private IMdProjectApi mdProjectApi;
    @Autowired
    private EnvironmentTools environmentTools;
    @Autowired
    private ITenantDataService tenantDataService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<StatisticBillVO> saveOrUpdate(@RequestBody StatisticBillVO saveOrUpdateVO) {
        if (saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0L) {
            StatisticBillEntity uniqueBean = (StatisticBillEntity)((Object)this.statisticBillService.getById(saveOrUpdateVO.getId()));
            uniqueBean.setRemark(saveOrUpdateVO.getRemark());
            uniqueBean.setSequence(saveOrUpdateVO.getSequence());
            this.statisticBillService.updateById((Object)uniqueBean);
        } else {
            StatisticBillEntity statisticBillEntity = (StatisticBillEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, StatisticBillEntity.class));
            QueryParam param = new QueryParam();
            param.getParams().put("billtype_id", new Parameter("eq", (Object)statisticBillEntity.getBilltypeId()));
            if (ListUtil.isNotEmpty((List)this.statisticBillService.queryList(param))) {
                return CommonResponse.error((String)"\u8be5\u5355\u636e\u5df2\u5b58\u5728\uff01");
            }
            CommonResponse classResponse = this.mdClassApi.queryDetail(saveOrUpdateVO.getMdEntityId());
            if (classResponse.isSuccess()) {
                MdClassVO mdClassVo = (MdClassVO)classResponse.getData();
                CommonResponse projectResponse = this.mdProjectApi.queryDetail(mdClassVo.getProjectId());
                if (projectResponse.isSuccess()) {
                    MdProjectVO projectVo = (MdProjectVO)projectResponse.getData();
                    statisticBillEntity.setMdProjectName(projectVo.getProjectName());
                    statisticBillEntity.setTableName(mdClassVo.getTableName());
                }
                this.statisticBillService.save((Object)statisticBillEntity);
            }
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<StatisticBillVO>> pageList(@RequestBody QueryParam queryParam) {
        LinkedHashMap order = queryParam.getOrderMap();
        order.put("sequence", "asc");
        IPage pageData = this.statisticBillService.queryPage(queryParam, false);
        Page page = new Page();
        page.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), StatisticBillVO.class));
        page.setPages(pageData.getPages());
        page.setTotal(pageData.getTotal());
        page.setCurrent(pageData.getCurrent());
        page.setSize(pageData.getSize());
        return CommonResponse.success((Object)page);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<StatisticBillVO> queryDetail(@RequestParam Long id) {
        StatisticBillEntity statisticBillEntity = (StatisticBillEntity)((Object)this.statisticBillService.getById(id));
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)statisticBillEntity), StatisticBillVO.class));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        this.statisticBillService.removeByIds(ids);
        return CommonResponse.success();
    }

    @RequestMapping(value={"sync"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> sync(HttpServletRequest request) {
        this.logger.info("\u540c\u6b65\u5355\u636e\u6570\u636e\u5f00\u59cb---------");
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("authority", request.getHeader("authority"));
        QueryParam param = new QueryParam();
        List billEntities = this.statisticBillService.queryList(param);
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        String today = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)calendar.getTime());
        if (ListUtil.isNotEmpty((List)billEntities)) {
            for (StatisticBillEntity billEntity : billEntities) {
                String baseHost = this.environmentTools.getBaseHost(InvocationInfoProxy.getTenantid());
                HashMap<String, String> mapParam = new HashMap<String, String>();
                mapParam.put("tableName", billEntity.getTableName());
                try {
                    String billTenantInfoResp = ReferHttpClientUtils.get((String)(baseHost + billEntity.getMdProjectName() + "/common/billTenant/queryTenantTotalBill"), mapParam, header);
                    this.logger.info(billTenantInfoResp);
                    CommonResponse response = (CommonResponse)JSONObject.parseObject((String)billTenantInfoResp, CommonResponse.class);
                    if (response != null && response.isSuccess() && response.getData() != null && ((JSONArray)response.getData()).size() > 0) {
                        JSONArray array = (JSONArray)response.getData();
                        for (Object o : array) {
                            StatisticBillDataEntity billDataEntity = (StatisticBillDataEntity)((Object)JSONObject.parseObject((String)JSONObject.toJSONString(o), StatisticBillDataEntity.class));
                            billDataEntity.setStatisticTime(today);
                            billDataEntity.setStatisticName(billEntity.getBillName());
                            billDataEntity.setStatisticId(billEntity.getId());
                            TenantDataEntity tenantDataEntity = this.tenantDataService.selectByTenantId(billDataEntity.getStatisticTenantId());
                            if (tenantDataEntity != null) {
                                billDataEntity.setStatisticTenantName(tenantDataEntity.getTenantName());
                            }
                            if (Objects.equals(billDataEntity.getStatisticTenantId(), 999999L)) {
                                billDataEntity.setStatisticTenantName("\u5317\u4eac\u76ca\u4f01\u8054\u79d1\u6280\u6709\u9650\u516c\u53f8");
                            }
                            if (billDataEntity.getStatisticTenantId() == null) continue;
                            this.statisticBillDataService.saveOrUpdateNoES((Object)billDataEntity);
                        }
                        continue;
                    }
                    this.logger.error("\u8bf7\u6c42\u51fa\u9519\uff0c\u8be5\u5de5\u7a0b\u540e\u7aef\u5e94\u8be5\u672a\u6784\u5efa\u53d1\u5e03\uff01" + billTenantInfoResp);
                }
                catch (IOException | GeneralSecurityException e) {
                    e.printStackTrace();
                    this.logger.error("\u540c\u6b65\u51fa\u9519----" + e.getMessage());
                }
            }
        }
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f");
    }
}

