/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.analyticdatas.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.analyticdatas.bean.StatisticBillDataEntity;
import com.ejianc.foundation.analyticdatas.bean.TenantDataEntity;
import com.ejianc.foundation.analyticdatas.service.ILoginlogsService;
import com.ejianc.foundation.analyticdatas.service.IStatisticBillDataService;
import com.ejianc.foundation.analyticdatas.service.ITenantDataService;
import com.ejianc.foundation.tenant.api.IEnterpriseApi;
import com.ejianc.foundation.tenant.vo.EnterpriseVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"tenantdata"})
public class TenantDataController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IEnterpriseApi enterpriseApi;
    @Autowired
    private ITenantDataService tenantDataService;
    @Autowired
    private ILoginlogsService iLoginlogsService;
    @Autowired
    private IStatisticBillDataService statisticBillDataService;

    @RequestMapping(value={"/sync"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> syncTenantList() {
        List enterpriseList;
        CommonResponse enterpriseResponse = this.enterpriseApi.getAllEnterpriseList();
        if (enterpriseResponse.isSuccess() && (enterpriseList = (List)enterpriseResponse.getData()) != null && enterpriseList.size() > 0) {
            ArrayList<TenantDataEntity> tenantDataList = new ArrayList<TenantDataEntity>();
            for (EnterpriseVO enterpriseVo : enterpriseList) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"tenant_id", (Object)enterpriseVo.getTenantId());
                TenantDataEntity tenantDataEntity = (TenantDataEntity)((Object)this.tenantDataService.getOne((Wrapper)queryWrapper));
                if (tenantDataEntity != null) {
                    tenantDataEntity.setTenantName(enterpriseVo.getName());
                    tenantDataEntity.setBusinessType(enterpriseVo.getBusinessType());
                    tenantDataEntity.setSocialCreditCode(enterpriseVo.getSocialCreditCode());
                    tenantDataEntity.setCreateTime(enterpriseVo.getCreateTime());
                    tenantDataEntity.setUpdateTime(enterpriseVo.getUpdateTime());
                    tenantDataList.add(tenantDataEntity);
                    continue;
                }
                tenantDataEntity = new TenantDataEntity();
                tenantDataEntity.setTenantId(enterpriseVo.getTenantId());
                tenantDataEntity.setTenantName(enterpriseVo.getName());
                tenantDataEntity.setBusinessType(enterpriseVo.getBusinessType());
                tenantDataEntity.setSuperAdminId(enterpriseVo.getUserId());
                tenantDataEntity.setSuperAdminUserCode(enterpriseVo.getUserCode());
                tenantDataEntity.setSocialCreditCode(enterpriseVo.getSocialCreditCode());
                tenantDataEntity.setCreateTime(enterpriseVo.getCreateTime());
                tenantDataEntity.setUpdateTime(enterpriseVo.getUpdateTime());
                tenantDataList.add(tenantDataEntity);
            }
            this.tenantDataService.saveOrUpdateBatch(tenantDataList);
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/queryTenantData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryTenantData() {
        JSONObject res = new JSONObject();
        QueryParam param = new QueryParam();
        List dataEntityList = this.tenantDataService.queryList(param, false);
        res.put("totalEnterpriseNum", (Object)dataEntityList.size());
        param.getParams().put("createTime", new Parameter("ge", (Object)(LocalDate.now().getYear() + "-01-01 00:00:00")));
        dataEntityList = this.tenantDataService.queryList(param, false);
        res.put("totalNewEnterpriseNumThisYear", (Object)dataEntityList.size());
        List<JSONObject> objectList = this.tenantDataService.businessTake();
        ArrayList list = ListUtil.newArrayList();
        if (ListUtil.isNotEmpty(objectList)) {
            int total = 0;
            for (JSONObject object : objectList) {
                if (Objects.equals(object.getString("bt"), "1")) {
                    object.put("name", (Object)"\u5efa\u7b51\u65bd\u5de5\u5355\u4f4d");
                    list.add(object);
                    total += object.getInteger("value").intValue();
                    continue;
                }
                if (!Objects.equals(object.getString("bt"), "2")) continue;
                object.put("name", (Object)"\u4f9b\u5e94\u5546");
                res.put("supplierNum", (Object)object.getInteger("value"));
                list.add(object);
                total += object.getInteger("value").intValue();
            }
            JSONObject object = new JSONObject();
            object.put("name", (Object)"\u5176\u4ed6");
            object.put("value", (Object)(res.getInteger("totalEnterpriseNum") - total));
            list.add(object);
        }
        res.put("businessTake", (Object)list);
        CommonResponse userTotal = this.enterpriseApi.getAllUserStatistics();
        if (userTotal.isSuccess()) {
            res.put("userTotal", userTotal.getData());
        } else {
            JSONObject total = new JSONObject();
            total.put("total", (Object)0);
            total.put("thisYear", (Object)0);
            res.put("userTotal", (Object)total);
        }
        param.getParams().put("businessType", new Parameter("eq", (Object)2));
        dataEntityList = this.tenantDataService.queryList(param, false);
        res.put("supplierNumThisYear", (Object)dataEntityList.size());
        param = new QueryParam();
        List loginlogsEntities = this.iLoginlogsService.queryList(param, false);
        res.put("loginTotal", (Object)loginlogsEntities.size());
        param.getParams().put("loginTime", new Parameter("ge", (Object)(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + " 00:00:00")));
        loginlogsEntities = this.iLoginlogsService.queryList(param, false);
        res.put("loginTotalToday", (Object)loginlogsEntities.size());
        return CommonResponse.success((Object)res);
    }

    @RequestMapping(value={"/queryTenantList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryTenantList(@RequestBody QueryParam param) {
        IPage dataEntityList = this.tenantDataService.queryPage(param, false);
        Page page = new Page();
        page.setSize(dataEntityList.getSize());
        page.setCurrent(dataEntityList.getCurrent());
        page.setTotal(dataEntityList.getTotal());
        page.setPages(dataEntityList.getPages());
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        String today = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)calendar.getTime());
        if (ListUtil.isNotEmpty((List)dataEntityList.getRecords())) {
            ArrayList<JSONObject> records = new ArrayList<JSONObject>();
            for (TenantDataEntity entity : dataEntityList.getRecords()) {
                CommonResponse comboInfo = this.enterpriseApi.getEnterpriseComboInfo(entity.getTenantId());
                JSONObject data = new JSONObject();
                if (comboInfo.isSuccess()) {
                    data = (JSONObject)comboInfo.getData();
                } else {
                    data.put("id", (Object)entity.getTenantId());
                    data.put("name", (Object)entity.getTenantName());
                    data.put("appNum", (Object)0);
                }
                param = new QueryParam();
                param.getParams().put("statistic_tenant_id", new Parameter("eq", (Object)entity.getTenantId()));
                param.getParams().put("statisticTime", new Parameter("eq", (Object)today));
                List billInfo = this.statisticBillDataService.queryList(param);
                long billCountToday = 0L;
                long billCountTotal = 0L;
                if (ListUtil.isNotEmpty((List)billInfo)) {
                    for (StatisticBillDataEntity billDataEntity : billInfo) {
                        billCountToday += billDataEntity.getBillCount().longValue();
                        billCountTotal += billDataEntity.getBillSumCount().longValue();
                    }
                }
                data.put("billCountToday", (Object)billCountToday);
                data.put("billCountTotal", (Object)billCountTotal);
                records.add(data);
            }
            page.setRecords(records);
        }
        return CommonResponse.success((Object)page);
    }
}

