package com.ejianc.foundation.analyticdatas.controller;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.analyticdatas.bean.BehaviorDataAnalyticEntity;
import com.ejianc.foundation.analyticdatas.bean.StatisticBillDataEntity;
import com.ejianc.foundation.analyticdatas.bean.TenantDataEntity;
import com.ejianc.foundation.analyticdatas.service.IStatisticBillDataService;
import com.ejianc.foundation.analyticdatas.service.ITenantDataService;
import com.ejianc.foundation.deskTop.vo.StatisticUserVO;
import com.ejianc.foundation.deskTop.vo.TimeAnalysisVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.tenant.api.IEnterpriseApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.analyticdatas.service.IBehaviorDataAnalyticService;
import com.ejianc.foundation.analyticdatas.vo.BehaviorDataAnalyticVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;

@Controller
@RequestMapping("behaviordata/analytic")
public class BehaviorDataAnalyticController implements Serializable {

	private static final long serialVersionUID = 1L;
	
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IBehaviorDataAnalyticService behaviorDataAnalyticService;
	@Autowired
	private IEnterpriseApi enterpriseApi;
	@Autowired
	private IStatisticBillDataService statisticBillDataService;
	@Autowired
	private ITenantDataService tenantDataService;
	@Autowired
	private IOrgApi iOrgApi;

	@RequestMapping(value = "/register")
	@ResponseBody
	public CommonResponse<String> registData(HttpServletRequest request) {
		String appId = request.getParameter("appId");
		String appName = request.getParameter("appName");
		String eventCode = request.getParameter("eventCode");
		String reqFrom = request.getParameter("reqFrom");
		if(StringUtils.isBlank(appId) || StringUtils.isBlank(appName)) {
			return CommonResponse.error("数据不合法:appId和appName都不能为空");
		}
		
		if(appName.indexOf(".") != -1) {
			return CommonResponse.error("appName不合法");
		}
		
		BehaviorDataAnalyticVO behaviorData = new BehaviorDataAnalyticVO();
		String userAgent = request.getHeader("user-agent");
		behaviorData.setDeviceId(userAgent);
		
		String ipAddr = getIPAddress(request);
		UserContext userContext = sessionManager.getUserContext();
		if(StringUtils.isNotBlank(ipAddr)) {
			behaviorData.setIpAddr(ipAddr);
		}
		behaviorData.setUserId(InvocationInfoProxy.getUserid()+"");
		behaviorData.setCompanyName(userContext.getEnterpriseName());
		behaviorData.setUserName(userContext.getEmployeeName());
		behaviorData.setUserMobile(userContext.getUserMobile());
		behaviorData.setOperateTime(new Date());
		behaviorData.setAppId(appId);
		behaviorData.setAppName(appName);
		behaviorData.setEventCode(eventCode);
		behaviorData.setReqFrom(reqFrom);
		behaviorData.setTenantId(999999L);

		//记录操作时的所属组织
		behaviorData.setOperateOrgId(userContext.getOrgId());
		behaviorData.setOperateOrgName(userContext.getOrgName());
		behaviorData.setOperateOrgCode(userContext.getOrgCode());
		behaviorData.setDepartmentId(userContext.getDeptId());
		behaviorData.setDepartmentName(userContext.getDeptName());
		behaviorData.setOperateOrgType(userContext.getOrgType());
		behaviorData.setEmployeeId(userContext.getEmployeeId());
		behaviorData.setEmployeeName(userContext.getEmployeeName());


		QueryParam param = new QueryParam();
		param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
		List<TenantDataEntity> list =  tenantDataService.queryList(param);
		if(ListUtil.isNotEmpty(list)){
			TenantDataEntity tenantDataEntity = list.get(0);
			behaviorData.setCompanyType(tenantDataEntity.getBusinessType());
		}
		behaviorDataAnalyticService.registerData(behaviorData);
		return CommonResponse.success();
	}

	/** 登录注册 */
	@RequestMapping(value = "/loginRegister")
	@ResponseBody
	public CommonResponse<String> loginRegister(HttpServletRequest request) {

		String tenantId = request.getParameter("tenantId");
		String userCode = request.getParameter("userCode");
		String deviceId = request.getParameter("deviceId");
		String ipAddr = request.getParameter("ipAddr");
		String reqFrom = request.getParameter("reqFrom");

		BehaviorDataAnalyticVO behaviorData = new BehaviorDataAnalyticVO();
		behaviorData.setDeviceId(deviceId);
		behaviorData.setUserCode(userCode);
		behaviorData.setReqFrom(reqFrom);
		behaviorData.setTenantId(Long.parseLong(tenantId));

		if(StringUtils.isNotBlank(ipAddr)) {
			behaviorData.setIpAddr(ipAddr);
		}

		behaviorData.setOperateTime(new Date());
		behaviorData.setEventCode("login");
		behaviorDataAnalyticService.registerData(behaviorData);
		return CommonResponse.success();
	}

	private String getIPAddress(HttpServletRequest request) {
	    String ip = null;
	    //X-Forwarded-For：Squid 服务代理
	    String ipAddresses = request.getHeader("X-Forwarded-For");
	    if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
	        //Proxy-Client-IP：apache 服务代理
	        ipAddresses = request.getHeader("Proxy-Client-IP");
	    }
	    if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
	        //WL-Proxy-Client-IP：weblogic 服务代理
	        ipAddresses = request.getHeader("WL-Proxy-Client-IP");
	    }
	    if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
	        //HTTP_CLIENT_IP：有些代理服务器
	        ipAddresses = request.getHeader("HTTP_CLIENT_IP");
	    }
	    if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
	        //X-Real-IP：nginx服务代理
	        ipAddresses = request.getHeader("X-Real-IP");
	    }
	    //有些网络通过多层代理，那么获取到的ip就会有多个，一般都是通过逗号（,）分割开来，并且第一个ip为客户端的真实IP
	    if (ipAddresses != null && ipAddresses.length() != 0) {
	        ip = ipAddresses.split(",")[0];
	    }
	    //还是不能获取到，最后再通过request.getRemoteAddr();获取
	    if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
	        ip = request.getRemoteAddr();
	    }
	    return ip;
	}

	@RequestMapping(value = "/getMapData")
	@ResponseBody
	public CommonResponse<JSONObject> getMapData(@RequestParam String range,@RequestParam String type) {
		JSONObject back = new JSONObject();
		back.put("range", range);
		if("china".equals(type)){
			//全国地图
			JSONArray proList = new JSONArray();
			List<BehaviorDataAnalyticVO> list = behaviorDataAnalyticService.queryProvinceMapData();
			if(list!=null&&list.size()>0){
				for(BehaviorDataAnalyticVO vo : list){
					JSONObject province = new JSONObject();
					province.put("name", vo.getProvince());
					province.put("value", vo.getStatistics());
					proList.add(province);
				}
			}
			back.put("data", proList);
		}else{
			JSONArray cityList = new JSONArray();
			List<BehaviorDataAnalyticVO> list = behaviorDataAnalyticService.queryCityMapData(range);
			if(list!=null&&list.size()>0){
				if("北京市".equals(range)||"北京市".equals(range)||"上海市".equals(range)||"台湾省".equals(range)
						||"天津市".equals(range)||"香港".equals(range)||"澳门".equals(range)){
					Integer value = 0;
					for(BehaviorDataAnalyticVO vo : list){
						value += (Integer.valueOf(vo.getStatistics()));
					}
					JSONObject city = new JSONObject();
					city.put("name", range);
					city.put("value", value);
					cityList.add(city);
				}else{
					for(BehaviorDataAnalyticVO vo : list){
						JSONObject city = new JSONObject();
						city.put("name", vo.getCity());
						city.put("value", vo.getStatistics());
						cityList.add(city);
					}
				}
			}
			back.put("data", cityList);
		}
		return CommonResponse.success(back);
	}

	//热点排名
	@RequestMapping(value = "/queryCountRankPage")
	@ResponseBody
	public CommonResponse<IPage<BehaviorDataAnalyticVO>> queryCountRankPage(@RequestBody Map<String,Object> param) {
		IPage<BehaviorDataAnalyticVO> page = behaviorDataAnalyticService.queryCountRankPage(param);
		return CommonResponse.success(page);
	}


	/**
	* 客户到期续费预警 近三月
	* */
	@RequestMapping(value = "/getEnterpriseComEndTimeInComingSeveralMonth")
	@ResponseBody
	public CommonResponse<IPage<JSONObject>> getEnterpriseComEndTimeInComingSeveralMonth(@RequestBody Map<String,Object> param) {
		Calendar calendar = Calendar.getInstance();
		// 将日期增加三个月
		calendar.add(Calendar.MONTH, 3);
		System.out.println("增加三个月后的日期：" + DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss",calendar.getTime()));
		CommonResponse<List<JSONObject>>  response = enterpriseApi.getEnterpriseComEndTimeInComingSeveralMonth(DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss",calendar.getTime()));
		IPage<JSONObject> page = new Page<>();
		int pageIndex = Integer.parseInt(param.get("pageIndex").toString());
		int pageSize = Integer.parseInt(param.get("pageSize").toString());
		page.setCurrent(pageIndex);
		page.setSize(pageSize);
		if(response.isSuccess()){
			page.setTotal(response.getData().size());
			List<JSONObject> datas = response.getData();
			List<JSONObject> record = new ArrayList<>();
			QueryParam queryParam = new QueryParam();
			for (int i = pageIndex*pageSize; i < (pageIndex+1)*pageSize; i++) {
				if(i<page.getTotal()){
					JSONObject object = datas.get(i);
					queryParam.getParams().put("statistic_tenant_id",new Parameter(QueryParam.EQ,object.getString("id")));
					queryParam.getOrderMap().put("statisticTime",QueryParam.DESC);
					List<StatisticBillDataEntity> billDataEntities = statisticBillDataService.queryList(queryParam,false);
					if(ListUtil.isNotEmpty(billDataEntities)){
						object.put("billCount",billDataEntities.get(0).getBillSumCount());
					}else {
						object.put("billCount",0);
					}
					record.add(object);
				}
			}
			page.setRecords(record);
		}
		return CommonResponse.success(page);
	}


	/**
	 * @param param
	 * @Description queryList 查询列表
	 * @Return
	 */
	@RequestMapping(value = "/queryList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<BehaviorDataAnalyticVO>> queryList(@RequestBody QueryParam param) {

		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();

		fuzzyFields.add("appName");
		fuzzyFields.add("operateOrgName");
		fuzzyFields.add("userName");

		/** 租户隔离 */
		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

		/** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
		UserContext userContextCache = sessionManager.getUserContext();
		//当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
		String authOrgIds = userContextCache.getAuthOrgIds();
		List<OrgVO> orgVOList = null;
		if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
		} else {//pc端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
		}
		//普通组织 id
		List<Long> commonOrgIds = new ArrayList<>();
		orgVOList.stream().forEach(org -> {
			//普通组织
			commonOrgIds.add(org.getId());

		});
		if(param.getParams().get("projectId") == null){
			if (CollectionUtils.isNotEmpty(commonOrgIds)) {
				/** 要求主表有orgId字段，保存单据所属组织 */
				param.getParams().put("operateOrgId", new Parameter(QueryParam.IN, commonOrgIds));
			}
		}
		/** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */


//		IPage<BehaviorDataAnalyticEntity> page = behaviorDataAnalyticService.queryPage(param,false);
//		IPage<BehaviorDataAnalyticVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BehaviorDataAnalyticVO.class));

        /**
         *实现分页
         */
        Page<BehaviorDataAnalyticVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


        List<BehaviorDataAnalyticVO> vos = behaviorDataAnalyticService.queryList(page, wrapper);
        page.setRecords(vos);
		return CommonResponse.success("查询列表数据成功！", page);
	}

	/**
	 * 获取RPC数据
	 * resp 返回值
	 * isMustSuc 是否必须成功
	 * errMsg 失败提示
	 */
	private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
		if(isMustSuc && !resp.isSuccess()) {
			throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
		}
		return resp.getData();
	}

	/**
	 * @param param
	 * @Description queryList 查询列表
	 * @Return
	 */
	@RequestMapping(value = "/queryUserBusinessCount", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<StatisticUserVO>> queryUserBusinessCount(@RequestBody QueryParam param) {

		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("user_name");
		fuzzyFields.add("app_name");

		/**
		 * 组织隔离
		 */
		//普通组织 id
		List<OrgVO> orgVOList = new ArrayList<>();
		List<String> orgCodes = new ArrayList<>();
		if(!param.getParams().containsKey("orgId")) {
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
		} else {
			Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
		}
		orgVOList.stream().forEach(org -> {
			//普通组织
			orgCodes.add(org.getCode());
		});
		if (CollectionUtils.isNotEmpty(orgCodes)) {
			/** 要求主表有orgId字段，保存单据所属组织 */
			param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
			param.getParams().remove("operateOrgId");
		}
		/** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

		/**
		 *实现分页
		 */
		Page<StatisticUserVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
		QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


		List<StatisticUserVO> vos = behaviorDataAnalyticService.queryUserBusinessCount(page, wrapper);
		page.setRecords(vos);
		return CommonResponse.success("查询列表数据成功！", page);
	}

	/**
	 * @param param
	 * @Description queryUserCount 查询列表
	 * @Return
	 */
	@RequestMapping(value = "/queryUserCount", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<StatisticUserVO>> queryUserCount(@RequestBody QueryParam param) {

		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("user_name");

		/**
		 * 组织隔离
		 */
		//普通组织 id
		List<OrgVO> orgVOList = new ArrayList<>();
		List<String> orgCodes = new ArrayList<>();
		if(!param.getParams().containsKey("orgId")) {
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
		} else {
			Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
		}
		orgVOList.stream().forEach(org -> {
			//普通组织
			orgCodes.add(org.getCode());
		});
		if (CollectionUtils.isNotEmpty(orgCodes)) {
			/** 要求主表有orgId字段，保存单据所属组织 */
			param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
			param.getParams().remove("operateOrgId");
		}
		/** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

		/**
		 *实现分页
		 */
		Page<StatisticUserVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
		QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


		List<StatisticUserVO> vos = behaviorDataAnalyticService.queryUserCount(page, wrapper);
		page.setRecords(vos);
		return CommonResponse.success("查询列表数据成功！", page);
	}

	/**
	 * @param param
	 * @Description queryUserCount 查询列表
	 * @Return
	 */
	@RequestMapping(value = "/queryTimeAnalysis", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<List<TimeAnalysisVO>> queryTimeAnalysis(@RequestBody QueryParam param) {

		Date date = new Date();
		if(param.getParams().get("operateTime") == null){
			String startTime = DateUtil.beginOfMonth(date).toTimeStr();
			String endTime = DateUtil.endOfMonth(date).toTimeStr();
			param.getParams().put("operateTime",new Parameter(QueryParam.BETWEEN,startTime+","+endTime));
		}
		QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
		List<TimeAnalysisVO> vos = behaviorDataAnalyticService.queryTimeAnalysis(wrapper);
		return CommonResponse.success("查询列表数据成功！", vos);
	}

	/**
	 * @param param
	 * @Description queryUserCount 查询列表
	 * @Return
	 */
	@RequestMapping(value = "/queryOrgCount", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<StatisticUserVO>> queryOrgCount(@RequestBody QueryParam param) {

		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("operate_org_name");

		/**
		 * 组织隔离
		 */
		//普通组织 id
		List<OrgVO> orgVOList = new ArrayList<>();
		List<String> orgCodes = new ArrayList<>();
		if(!param.getParams().containsKey("orgId")) {
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
		} else {
			Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
		}
		orgVOList.stream().forEach(org -> {
			//普通组织
			orgCodes.add(org.getCode());
		});
		if (CollectionUtils.isNotEmpty(orgCodes)) {
			/** 要求主表有orgId字段，保存单据所属组织 */
			param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
			param.getParams().remove("operateOrgId");
		}
		/** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

		/**
		 *实现分页
		 */
		Page<StatisticUserVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
		QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


		List<StatisticUserVO> vos = behaviorDataAnalyticService.queryOrgCount(page, wrapper);
		page.setRecords(vos);
		return CommonResponse.success("查询列表数据成功！", page);
	}


	/**
	 * @param param
	 * @Description queryUserCount 查询列表
	 * @Return
	 */
	@RequestMapping(value = "/queryDepartmentCount", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<StatisticUserVO>> queryDepartmentCount(@RequestBody QueryParam param) {

		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("department_name");

		/**
		 * 组织隔离
		 */
		//普通组织 id
		List<OrgVO> orgVOList = new ArrayList<>();
		List<String> orgCodes = new ArrayList<>();
		if(!param.getParams().containsKey("orgId")) {
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
		} else {
			Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
		}
		orgVOList.stream().forEach(org -> {
			//普通组织
			orgCodes.add(org.getCode());
		});
		if (CollectionUtils.isNotEmpty(orgCodes)) {
			/** 要求主表有orgId字段，保存单据所属组织 */
			param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
			param.getParams().remove("operateOrgId");
		}
		/** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

		/**
		 *实现分页
		 */
		Page<StatisticUserVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
		QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


		List<StatisticUserVO> vos = behaviorDataAnalyticService.queryDepartmentCount(page, wrapper);
		page.setRecords(vos);
		return CommonResponse.success("查询列表数据成功！", page);
	}

	/**
	 * @param param
	 * @Description queryBusinessCount 查询列表
	 * @Return
	 */
	@RequestMapping(value = "/queryBusinessCount", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<StatisticUserVO>> queryBusinessCount(@RequestBody QueryParam param) {

		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("app_name");

		/**
		 * 组织隔离
		 */
		//普通组织 id
		List<OrgVO> orgVOList = new ArrayList<>();
		List<String> orgCodes = new ArrayList<>();
		if(!param.getParams().containsKey("orgId")) {
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
		} else {
			Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
		}
		orgVOList.stream().forEach(org -> {
			//普通组织
			orgCodes.add(org.getCode());
		});
		if (CollectionUtils.isNotEmpty(orgCodes)) {
			/** 要求主表有orgId字段，保存单据所属组织 */
			param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
			param.getParams().remove("operateOrgId");
		}
		/** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

		/**
		 *实现分页
		 */
		Page<StatisticUserVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
		QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);


		List<StatisticUserVO> vos = behaviorDataAnalyticService.queryBusinessCount(page, wrapper);
		page.setRecords(vos);
		return CommonResponse.success("查询列表数据成功！", page);
	}
}
