package com.ejianc.foundation.analyticdatas.controller;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.analyticdatas.service.IStatisticBillDataService;
import com.ejianc.framework.core.response.CommonResponse;

@SuppressWarnings("unchecked")
@Controller
@RequestMapping("statbilldata")
public class StatisticBillDataController implements Serializable {

	private static final long serialVersionUID = 1L;
	
	@Value("${common.env.base-host}")
	private String baseHost;
	
	@Autowired
	private IStatisticBillDataService statisticBillDataService;

	/**
	 * 获取 企业总制单数量排名
	 *
	 * @return
	 */
	@RequestMapping(value = "/queryTenantDataList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<JSONObject>> queryTenantDataList(@RequestBody QueryParam param) {
		Calendar calendar = Calendar.getInstance();
		// 将日期减一天
		calendar.add(Calendar.DATE, -1);
		String today = DateFormatUtil.formatDate("yyyy-MM-dd",calendar.getTime());

		IPage<JSONObject> page = new Page<>();
		page.setSize(param.getPageSize());
		page.setCurrent(param.getPageIndex());
		int startLine = (param.getPageIndex() < 1 ? 0 : param.getPageIndex() -  1) * param.getPageSize();
		Long total = statisticBillDataService.queryStatisticBillTenantRankCount(today);
		if(total>0){
			List<JSONObject> record = statisticBillDataService.queryStatisticBillTenantRankPage(today,startLine,param.getPageSize());
			page.setRecords(record);
		}
		page.setTotal(total);
		return CommonResponse.success(page);
	}

	/**
	 * 获取 企业  当月制单数量排名
	 *
	 * @return
	 */
	@RequestMapping(value = "/queryTenantDataThisMonth", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<JSONObject>> queryTenantDataThisMonth(@RequestBody QueryParam param) {
		String thisMonth = DateFormatUtil.formatDate("yyyy-MM",new Date());

		IPage<JSONObject> page = new Page<>();
		page.setSize(param.getPageSize());
		page.setCurrent(param.getPageIndex());
		int startLine = (param.getPageIndex() < 1 ? 0 : param.getPageIndex() -  1) * param.getPageSize();
		Long total = statisticBillDataService.queryStatisticBillTenantRankThisMonthCount(thisMonth);
		if(total>0){
			List<JSONObject> record = statisticBillDataService.queryStatisticBillTenantRankThisMonthPage(thisMonth,startLine,param.getPageSize());
			page.setRecords(record);
		}
		page.setTotal(total);
		return CommonResponse.success(page);
	}

}
