/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.analyticdatas.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.analyticdatas.bean.BehaviorDataAnalyticEntity;
import com.ejianc.foundation.analyticdatas.bean.LoginlogsEntity;
import com.ejianc.foundation.analyticdatas.mapper.BehaviorDataAnalyticMapper;
import com.ejianc.foundation.analyticdatas.service.IBehaviorDataAnalyticService;
import com.ejianc.foundation.analyticdatas.service.ILoginlogsService;
import com.ejianc.foundation.analyticdatas.vo.BehaviorDataAnalyticVO;
import com.ejianc.foundation.deskTop.vo.StatisticUserVO;
import com.ejianc.foundation.deskTop.vo.TimeAnalysisVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BehaviorDataAnalyticServiceImpl
extends BaseServiceImpl<BehaviorDataAnalyticMapper, BehaviorDataAnalyticEntity>
implements IBehaviorDataAnalyticService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String GET_ADDR_BY_IP = "http://opendata.baidu.com/api.php?query=IPADDR&resource_id=6006&t=IDWORKER&ie=utf8&format=json";
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private BehaviorDataAnalyticMapper behaviorDataAnalyticMapper;
    @Autowired
    private ILoginlogsService iLoginlogsService;

    @Override
    public void registerData(BehaviorDataAnalyticVO behaviorData) {
        MqMessage mqMessage = new MqMessage();
        mqMessage.setBody((Object)behaviorData);
        this.rabbitTemplate.convertAndSend("analyticdatas-common-queue", (Object)mqMessage);
    }

    @Override
    @Transactional
    public void handleBehaviorDatas(String behaviorData) {
        this.logger.info("\u5f85\u5904\u7406\u7684\u7528\u6237\u884c\u4e3a\u6570\u636e\uff1a\u3010{}\u3011", (Object)behaviorData);
        BehaviorDataAnalyticVO behaviorDataAnalyticVo = (BehaviorDataAnalyticVO)JSONObject.parseObject((String)behaviorData, BehaviorDataAnalyticVO.class);
        if (StringUtils.isNotBlank((CharSequence)behaviorDataAnalyticVo.getIpAddr())) {
            String ipAddr = behaviorDataAnalyticVo.getIpAddr();
            String getAddrUrl = GET_ADDR_BY_IP.replace("IPADDR", ipAddr).replace("IDWORKER", IdWorker.getId() + "");
            try {
                String[] locationArr;
                HashMap params = new HashMap();
                HashMap headers = new HashMap();
                String addrData = HttpTookit.get((String)getAddrUrl, (String)"gb2312", params, headers);
                this.logger.info("addrData=======" + addrData);
                JSONObject addrJson = JSON.parseObject((String)addrData);
                JSONArray addrDataList = addrJson.getJSONArray("data");
                JSONObject addrDataObj = addrDataList.getJSONObject(0);
                String location = addrDataObj.getString("location");
                if (StringUtils.isNotBlank((CharSequence)location) && (locationArr = location.split(" ")).length > 1) {
                    String address = locationArr[0];
                    String[] addressArr = address.split("\u7701");
                    if (addressArr.length > 1) {
                        behaviorDataAnalyticVo.setProvince(addressArr[0] + "\u7701");
                        behaviorDataAnalyticVo.setCity(addressArr[1]);
                    } else {
                        addressArr = address.split("\u81ea\u6cbb\u533a");
                        if (addressArr.length > 1) {
                            behaviorDataAnalyticVo.setProvince(addressArr[0] + "\u81ea\u6cbb\u533a");
                            behaviorDataAnalyticVo.setCity(addressArr[1]);
                        } else {
                            addressArr = address.split("\u5e02");
                            behaviorDataAnalyticVo.setProvince(addressArr[0] + "\u5e02");
                            behaviorDataAnalyticVo.setCity(addressArr[1]);
                        }
                    }
                    this.logger.info("\u7701\uff1a{}\uff0c\u5e02\uff1a{}", (Object)behaviorDataAnalyticVo.getProvince(), (Object)behaviorDataAnalyticVo.getCity());
                    behaviorDataAnalyticVo.setOperators(locationArr[1]);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
            if ("login".equals(behaviorDataAnalyticVo.getEventCode())) {
                LoginlogsEntity loginlogsEntity = new LoginlogsEntity();
                loginlogsEntity.setCity(behaviorDataAnalyticVo.getCity());
                loginlogsEntity.setDeviceId(behaviorDataAnalyticVo.getDeviceId());
                loginlogsEntity.setIpAddr(behaviorDataAnalyticVo.getIpAddr());
                loginlogsEntity.setLoginTime(behaviorDataAnalyticVo.getOperateTime());
                loginlogsEntity.setOperators(behaviorDataAnalyticVo.getOperators());
                loginlogsEntity.setUserCode(behaviorDataAnalyticVo.getUserCode());
                loginlogsEntity.setProvince(behaviorDataAnalyticVo.getProvince());
                loginlogsEntity.setReqFrom(behaviorDataAnalyticVo.getReqFrom());
                loginlogsEntity.setTenantId(behaviorDataAnalyticVo.getTenantId());
                this.iLoginlogsService.saveOrUpdate((Object)loginlogsEntity, false);
                return;
            }
            this.logger.info("save BehaviorDataAnalyticEntity = {}", (Object)JSONObject.toJSONString((Object)behaviorDataAnalyticVo));
            BehaviorDataAnalyticEntity behaviorDataAnalyticEntity = (BehaviorDataAnalyticEntity)((Object)BeanMapper.map((Object)behaviorDataAnalyticVo, BehaviorDataAnalyticEntity.class));
            this.behaviorDataAnalyticMapper.insert((Object)behaviorDataAnalyticEntity);
        }
    }

    @Override
    public List<BehaviorDataAnalyticVO> queryProvinceMapData() {
        return this.behaviorDataAnalyticMapper.queryProvinceMapData();
    }

    @Override
    public List<BehaviorDataAnalyticVO> queryCityMapData(String provinceName) {
        return this.behaviorDataAnalyticMapper.queryCityMapData(provinceName);
    }

    @Override
    public IPage<BehaviorDataAnalyticVO> queryCountRankPage(Map<String, Object> param) {
        List<Object> voList = new ArrayList();
        Page page = new Page();
        page.setCurrent((long)Integer.valueOf(param.get("pageIndex").toString()).intValue());
        page.setSize((long)Integer.valueOf(param.get("pageSize").toString()).intValue());
        long total = this.behaviorDataAnalyticMapper.countCountRankPage(param);
        page.setTotal(total);
        if (total == 0L) {
            page.setRecords(voList);
            return page;
        }
        long startLine = (page.getCurrent() < 1L ? 0L : page.getCurrent() - 1L) * page.getSize();
        param.put("startLine", startLine);
        param.put("pageSize", page.getSize());
        voList = this.behaviorDataAnalyticMapper.queryCountRankPage(param);
        if ("enterpriseUseAppData".equals(param.get("type")) && ListUtil.isNotEmpty(voList)) {
            for (BehaviorDataAnalyticVO behaviorDataAnalyticVO : voList) {
                List<String> comNames = this.behaviorDataAnalyticMapper.queryComNameByAppName(behaviorDataAnalyticVO.getAppName());
                behaviorDataAnalyticVO.setComNames(comNames);
                behaviorDataAnalyticVO.setComNums(Long.valueOf(ListUtil.isNotEmpty(comNames) ? (long)comNames.size() : 0L));
            }
        }
        page.setRecords(voList);
        return page;
    }

    @Override
    public List<BehaviorDataAnalyticVO> queryList(Page<BehaviorDataAnalyticVO> page, QueryWrapper wrapper) {
        return this.behaviorDataAnalyticMapper.queryList(page, wrapper);
    }

    @Override
    public List<StatisticUserVO> queryUserBusinessCount(Page<StatisticUserVO> page, QueryWrapper wrapper) {
        return this.behaviorDataAnalyticMapper.queryUserBusinessCount(page, wrapper);
    }

    @Override
    public List<StatisticUserVO> queryUserCount(Page<StatisticUserVO> page, QueryWrapper wrapper) {
        return this.behaviorDataAnalyticMapper.queryUserCount(page, wrapper);
    }

    @Override
    public List<TimeAnalysisVO> queryTimeAnalysis(QueryWrapper wrapper) {
        return this.behaviorDataAnalyticMapper.queryTimeAnalysis(wrapper);
    }

    @Override
    public List<StatisticUserVO> queryOrgCount(Page<StatisticUserVO> page, QueryWrapper wrapper, String order) {
        return this.behaviorDataAnalyticMapper.queryOrgCount(page, wrapper, order);
    }

    @Override
    public List<StatisticUserVO> queryDepartmentCount(Page<StatisticUserVO> page, QueryWrapper wrapper) {
        return this.behaviorDataAnalyticMapper.queryDepartmentCount(page, wrapper);
    }

    @Override
    public List<StatisticUserVO> queryBusinessCount(Page<StatisticUserVO> page, QueryWrapper wrapper) {
        return this.behaviorDataAnalyticMapper.queryBusinessCount(page, wrapper);
    }
}

