/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.analyticdatas.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.analyticdatas.bean.StatisticBillDataEntity;
import com.ejianc.foundation.analyticdatas.bean.TenantDataEntity;
import com.ejianc.foundation.analyticdatas.service.IBehaviorDataAnalyticService;
import com.ejianc.foundation.analyticdatas.service.IStatisticBillDataService;
import com.ejianc.foundation.analyticdatas.service.ITenantDataService;
import com.ejianc.foundation.analyticdatas.vo.BehaviorDataAnalyticVO;
import com.ejianc.foundation.deskTop.vo.StatisticUserVO;
import com.ejianc.foundation.deskTop.vo.TimeAnalysisVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.tenant.api.IEnterpriseApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"behaviordata/analytic"})
public class BehaviorDataAnalyticController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBehaviorDataAnalyticService behaviorDataAnalyticService;
    @Autowired
    private IEnterpriseApi enterpriseApi;
    @Autowired
    private IStatisticBillDataService statisticBillDataService;
    @Autowired
    private ITenantDataService tenantDataService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IEmployeeApi employeeApi;

    @RequestMapping(value={"/register"})
    @ResponseBody
    public CommonResponse<String> registData(HttpServletRequest request) {
        String appId = request.getParameter("appId");
        String appName = request.getParameter("appName");
        String eventCode = request.getParameter("eventCode");
        String reqFrom = request.getParameter("reqFrom");
        if (StringUtils.isBlank((CharSequence)appId) || StringUtils.isBlank((CharSequence)appName)) {
            return CommonResponse.error((String)"\u6570\u636e\u4e0d\u5408\u6cd5:appId\u548cappName\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (appName.indexOf(".") != -1) {
            return CommonResponse.error((String)"appName\u4e0d\u5408\u6cd5");
        }
        BehaviorDataAnalyticVO behaviorData = new BehaviorDataAnalyticVO();
        String userAgent = request.getHeader("user-agent");
        behaviorData.setDeviceId(userAgent);
        String ipAddr = this.getIPAddress(request);
        UserContext userContext = this.sessionManager.getUserContext();
        if (StringUtils.isNotBlank((CharSequence)ipAddr)) {
            behaviorData.setIpAddr(ipAddr);
        }
        behaviorData.setUserId(InvocationInfoProxy.getUserid() + "");
        behaviorData.setCompanyName(userContext.getEnterpriseName());
        behaviorData.setUserName(userContext.getEmployeeName());
        behaviorData.setUserMobile(userContext.getUserMobile());
        behaviorData.setOperateTime(new Date());
        behaviorData.setAppId(appId);
        behaviorData.setAppName(appName);
        behaviorData.setEventCode(eventCode);
        behaviorData.setReqFrom(reqFrom);
        behaviorData.setTenantId(Long.valueOf(999999L));
        behaviorData.setOperateOrgId(userContext.getOrgId());
        behaviorData.setOperateOrgName(userContext.getOrgName());
        behaviorData.setOperateOrgCode(userContext.getOrgCode());
        behaviorData.setDepartmentId(userContext.getDeptId());
        behaviorData.setDepartmentName(userContext.getDeptName());
        behaviorData.setOperateOrgType(userContext.getOrgType());
        behaviorData.setEmployeeId(userContext.getEmployeeId());
        behaviorData.setEmployeeName(userContext.getEmployeeName());
        CommonResponse employeeVOCommonResponse = this.employeeApi.queryEmployeByUserId(userContext.getUserId());
        if (employeeVOCommonResponse.isSuccess()) {
            EmployeeVO employeeVO = (EmployeeVO)employeeVOCommonResponse.getData();
            behaviorData.setEmployeeId(employeeVO.getId());
            behaviorData.setOrgId(employeeVO.getOrgId());
            behaviorData.setOrgName(employeeVO.getOrgName());
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List list = this.tenantDataService.queryList(param);
        if (ListUtil.isNotEmpty((List)list)) {
            TenantDataEntity tenantDataEntity = (TenantDataEntity)((Object)list.get(0));
            behaviorData.setCompanyType(tenantDataEntity.getBusinessType());
        }
        this.behaviorDataAnalyticService.registerData(behaviorData);
        return CommonResponse.success();
    }

    @RequestMapping(value={"/loginRegister"})
    @ResponseBody
    public CommonResponse<String> loginRegister(HttpServletRequest request) {
        String tenantId = request.getParameter("tenantId");
        String userCode = request.getParameter("userCode");
        String deviceId = request.getParameter("deviceId");
        String ipAddr = request.getParameter("ipAddr");
        String reqFrom = request.getParameter("reqFrom");
        BehaviorDataAnalyticVO behaviorData = new BehaviorDataAnalyticVO();
        behaviorData.setDeviceId(deviceId);
        behaviorData.setUserCode(userCode);
        behaviorData.setReqFrom(reqFrom);
        behaviorData.setTenantId(Long.valueOf(Long.parseLong(tenantId)));
        if (StringUtils.isNotBlank((CharSequence)ipAddr)) {
            behaviorData.setIpAddr(ipAddr);
        }
        behaviorData.setOperateTime(new Date());
        behaviorData.setEventCode("login");
        this.behaviorDataAnalyticService.registerData(behaviorData);
        return CommonResponse.success();
    }

    private String getIPAddress(HttpServletRequest request) {
        String ip = null;
        String ipAddresses = request.getHeader("X-Forwarded-For");
        if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            ipAddresses = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            ipAddresses = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            ipAddresses = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            ipAddresses = request.getHeader("X-Real-IP");
        }
        if (ipAddresses != null && ipAddresses.length() != 0) {
            ip = ipAddresses.split(",")[0];
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    @RequestMapping(value={"/getMapData"})
    @ResponseBody
    public CommonResponse<JSONObject> getMapData(@RequestParam String range, @RequestParam String type) {
        JSONObject back = new JSONObject();
        back.put("range", (Object)range);
        if ("china".equals(type)) {
            JSONArray proList = new JSONArray();
            List<BehaviorDataAnalyticVO> list = this.behaviorDataAnalyticService.queryProvinceMapData();
            if (list != null && list.size() > 0) {
                for (BehaviorDataAnalyticVO vo : list) {
                    JSONObject province = new JSONObject();
                    province.put("name", (Object)vo.getProvince());
                    province.put("value", (Object)vo.getStatistics());
                    proList.add((Object)province);
                }
            }
            back.put("data", (Object)proList);
        } else {
            JSONArray cityList = new JSONArray();
            List<BehaviorDataAnalyticVO> list = this.behaviorDataAnalyticService.queryCityMapData(range);
            if (list != null && list.size() > 0) {
                if ("\u5317\u4eac\u5e02".equals(range) || "\u5317\u4eac\u5e02".equals(range) || "\u4e0a\u6d77\u5e02".equals(range) || "\u53f0\u6e7e\u7701".equals(range) || "\u5929\u6d25\u5e02".equals(range) || "\u9999\u6e2f".equals(range) || "\u6fb3\u95e8".equals(range)) {
                    Integer value = 0;
                    for (BehaviorDataAnalyticVO vo : list) {
                        value = value + Integer.valueOf(vo.getStatistics());
                    }
                    JSONObject city = new JSONObject();
                    city.put("name", (Object)range);
                    city.put("value", (Object)value);
                    cityList.add((Object)city);
                } else {
                    for (BehaviorDataAnalyticVO vo : list) {
                        JSONObject city = new JSONObject();
                        city.put("name", (Object)vo.getCity());
                        city.put("value", (Object)vo.getStatistics());
                        cityList.add((Object)city);
                    }
                }
            }
            back.put("data", (Object)cityList);
        }
        return CommonResponse.success((Object)back);
    }

    @RequestMapping(value={"/queryCountRankPage"})
    @ResponseBody
    public CommonResponse<IPage<BehaviorDataAnalyticVO>> queryCountRankPage(@RequestBody Map<String, Object> param) {
        IPage<BehaviorDataAnalyticVO> page = this.behaviorDataAnalyticService.queryCountRankPage(param);
        return CommonResponse.success(page);
    }

    @RequestMapping(value={"/getEnterpriseComEndTimeInComingSeveralMonth"})
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> getEnterpriseComEndTimeInComingSeveralMonth(@RequestBody Map<String, Object> param) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 3);
        System.out.println("\u589e\u52a0\u4e09\u4e2a\u6708\u540e\u7684\u65e5\u671f\uff1a" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)calendar.getTime()));
        CommonResponse response = this.enterpriseApi.getEnterpriseComEndTimeInComingSeveralMonth(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)calendar.getTime()));
        Page page = new Page();
        int pageIndex = Integer.parseInt(param.get("pageIndex").toString());
        int pageSize = Integer.parseInt(param.get("pageSize").toString());
        page.setCurrent((long)pageIndex);
        page.setSize((long)pageSize);
        if (response.isSuccess()) {
            page.setTotal((long)((List)response.getData()).size());
            List datas = (List)response.getData();
            ArrayList<JSONObject> record = new ArrayList<JSONObject>();
            QueryParam queryParam = new QueryParam();
            for (int i = pageIndex * pageSize; i < (pageIndex + 1) * pageSize; ++i) {
                if ((long)i >= page.getTotal()) continue;
                JSONObject object = (JSONObject)datas.get(i);
                queryParam.getParams().put("statistic_tenant_id", new Parameter("eq", (Object)object.getString("id")));
                queryParam.getOrderMap().put("statisticTime", "desc");
                List billDataEntities = this.statisticBillDataService.queryList(queryParam, false);
                if (ListUtil.isNotEmpty((List)billDataEntities)) {
                    object.put("billCount", (Object)((StatisticBillDataEntity)((Object)billDataEntities.get(0))).getBillSumCount());
                } else {
                    object.put("billCount", (Object)0);
                }
                record.add(object);
            }
            page.setRecords(record);
        }
        return CommonResponse.success((Object)page);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BehaviorDataAnalyticVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("appName");
        fuzzyFields.add("operateOrgName");
        fuzzyFields.add("userName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List orgVOList = new ArrayList();
        ArrayList orgIds = new ArrayList();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        orgVOList.stream().forEach(org -> orgIds.add(org.getId()));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<BehaviorDataAnalyticVO> vos = this.behaviorDataAnalyticService.queryList((Page<BehaviorDataAnalyticVO>)page, wrapper);
        page.setRecords(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/queryUserBusinessCount"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<StatisticUserVO>> queryUserBusinessCount(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("user_name");
        fuzzyFields.add("app_name");
        List orgVOList = new ArrayList();
        ArrayList orgIds = new ArrayList();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        orgVOList.stream().forEach(org -> orgIds.add(org.getId()));
        String order = "";
        if (param.getOrderMap().get("countNum") != null) {
            if (!"asc".equals(param.getOrderMap().get("countNum")) && !"desc".equals(param.getOrderMap().get("countNum"))) {
                throw new BusinessException("\u975e\u6cd5\u53c2\u6570\uff0c\u6392\u5e8f\u53c2\u6570\u5f02\u5e38!");
            }
            order = "count_num " + (String)param.getOrderMap().get("countNum");
            param.getOrderMap().remove("countNum");
        }
        if (param.getOrderMap().get("totalNum") != null) {
            if (!"asc".equals(param.getOrderMap().get("totalNum")) && !"desc".equals(param.getOrderMap().get("totalNum"))) {
                throw new BusinessException("\u975e\u6cd5\u53c2\u6570\uff0c\u6392\u5e8f\u53c2\u6570\u5f02\u5e38!");
            }
            order = "total_num " + (String)param.getOrderMap().get("totalNum");
            param.getOrderMap().remove("totalNum");
        }
        this.logger.info("[\u6392\u5e8f\u4f9d\u636e\u4e3a]" + order);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<StatisticUserVO> vos = this.behaviorDataAnalyticService.queryUserBusinessCount((Page<StatisticUserVO>)page, wrapper, order);
        page.setRecords(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryUserCount"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<StatisticUserVO>> queryUserCount(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("user_name");
        List orgVOList = new ArrayList();
        ArrayList orgIds = new ArrayList();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        orgVOList.stream().forEach(org -> orgIds.add(org.getId()));
        String order = "";
        if (param.getOrderMap().get("countNum") != null) {
            if (!"asc".equals(param.getOrderMap().get("countNum")) && !"desc".equals(param.getOrderMap().get("countNum"))) {
                throw new BusinessException("\u975e\u6cd5\u53c2\u6570\uff0c\u6392\u5e8f\u53c2\u6570\u5f02\u5e38!");
            }
            order = "count_num " + (String)param.getOrderMap().get("countNum");
            param.getOrderMap().remove("countNum");
        }
        if (param.getOrderMap().get("totalNum") != null) {
            if (!"asc".equals(param.getOrderMap().get("totalNum")) && !"desc".equals(param.getOrderMap().get("totalNum"))) {
                throw new BusinessException("\u975e\u6cd5\u53c2\u6570\uff0c\u6392\u5e8f\u53c2\u6570\u5f02\u5e38!");
            }
            order = "total_num " + (String)param.getOrderMap().get("totalNum");
            param.getOrderMap().remove("totalNum");
        }
        this.logger.info("[\u6392\u5e8f\u4f9d\u636e\u4e3a]" + order);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<StatisticUserVO> vos = this.behaviorDataAnalyticService.queryUserCount((Page<StatisticUserVO>)page, wrapper, order);
        page.setRecords(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryTimeAnalysis"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<TimeAnalysisVO>> queryTimeAnalysis(@RequestBody QueryParam param) {
        Date date = new Date();
        if (param.getParams().get("operateTime") == null) {
            String startTime = DateUtil.beginOfMonth((Date)date).toTimeStr();
            String endTime = DateUtil.endOfMonth((Date)date).toTimeStr();
            param.getParams().put("operateTime", new Parameter("between", (Object)(startTime + "," + endTime)));
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<TimeAnalysisVO> vos = this.behaviorDataAnalyticService.queryTimeAnalysis(wrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", vos);
    }

    @RequestMapping(value={"/queryOrgCount"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<StatisticUserVO>> queryOrgCount(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("org_name");
        List orgVOList = new ArrayList();
        ArrayList orgIds = new ArrayList();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        orgVOList.stream().forEach(org -> orgIds.add(org.getId()));
        String order = "";
        if (param.getOrderMap().get("countNum") != null) {
            if (!"asc".equals(param.getOrderMap().get("countNum")) && !"desc".equals(param.getOrderMap().get("countNum"))) {
                throw new BusinessException("\u975e\u6cd5\u53c2\u6570\uff0c\u6392\u5e8f\u53c2\u6570\u5f02\u5e38!");
            }
            order = "count_num " + (String)param.getOrderMap().get("countNum");
            param.getOrderMap().remove("countNum");
        }
        if (param.getOrderMap().get("totalNum") != null) {
            if (!"asc".equals(param.getOrderMap().get("totalNum")) && !"desc".equals(param.getOrderMap().get("totalNum"))) {
                throw new BusinessException("\u975e\u6cd5\u53c2\u6570\uff0c\u6392\u5e8f\u53c2\u6570\u5f02\u5e38!");
            }
            order = "total_num " + (String)param.getOrderMap().get("totalNum");
            param.getOrderMap().remove("totalNum");
        }
        this.logger.info("[\u6392\u5e8f\u4f9d\u636e\u4e3a]" + order);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<StatisticUserVO> vos = this.behaviorDataAnalyticService.queryOrgCount((Page<StatisticUserVO>)page, wrapper, order);
        page.setRecords(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryDepartmentCount"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<StatisticUserVO>> queryDepartmentCount(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("department_name");
        List orgVOList = new ArrayList();
        ArrayList orgIds = new ArrayList();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        orgVOList.stream().forEach(org -> orgIds.add(org.getId()));
        String order = "";
        if (param.getOrderMap().get("countNum") != null) {
            if (!"asc".equals(param.getOrderMap().get("countNum")) && !"desc".equals(param.getOrderMap().get("countNum"))) {
                throw new BusinessException("\u975e\u6cd5\u53c2\u6570\uff0c\u6392\u5e8f\u53c2\u6570\u5f02\u5e38!");
            }
            order = "count_num " + (String)param.getOrderMap().get("countNum");
            param.getOrderMap().remove("countNum");
        }
        if (param.getOrderMap().get("totalNum") != null) {
            if (!"asc".equals(param.getOrderMap().get("totalNum")) && !"desc".equals(param.getOrderMap().get("totalNum"))) {
                throw new BusinessException("\u975e\u6cd5\u53c2\u6570\uff0c\u6392\u5e8f\u53c2\u6570\u5f02\u5e38!");
            }
            order = "total_num " + (String)param.getOrderMap().get("totalNum");
            param.getOrderMap().remove("totalNum");
        }
        this.logger.info("[\u6392\u5e8f\u4f9d\u636e\u4e3a]" + order);
        param.getParams().put("orgId", new Parameter("eq", (Object)1502571152642412546L));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<StatisticUserVO> vos = this.behaviorDataAnalyticService.queryDepartmentCount((Page<StatisticUserVO>)page, wrapper, order);
        page.setRecords(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryBusinessCount"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<StatisticUserVO>> queryBusinessCount(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("app_name");
        List orgVOList = new ArrayList();
        ArrayList orgIds = new ArrayList();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        } else {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        }
        orgVOList.stream().forEach(org -> orgIds.add(org.getId()));
        String order = "";
        if (param.getOrderMap().get("totalNum") != null) {
            if (!"asc".equals(param.getOrderMap().get("totalNum")) && !"desc".equals(param.getOrderMap().get("totalNum"))) {
                throw new BusinessException("\u975e\u6cd5\u53c2\u6570\uff0c\u6392\u5e8f\u53c2\u6570\u5f02\u5e38!");
            }
            order = "total_num " + (String)param.getOrderMap().get("totalNum");
            param.getOrderMap().remove("totalNum");
        }
        this.logger.info("[\u6392\u5e8f\u4f9d\u636e\u4e3a]" + order);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<StatisticUserVO> vos = this.behaviorDataAnalyticService.queryBusinessCount((Page<StatisticUserVO>)page, wrapper, order);
        page.setRecords(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }
}

