package com.ejianc.foundation.analyticdatas.controller;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.analyticdatas.bean.LoginlogsEntity;
import com.ejianc.foundation.analyticdatas.service.ILoginlogsService;
import com.ejianc.foundation.analyticdatas.vo.BehaviorDataAnalyticVO;
import com.ejianc.foundation.deskTop.vo.TimeAnalysisVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author: jiang
 * @Date: 2024/5/29
 **/
@Controller
@RequestMapping("loginlogs")
public class LoginlogsController implements Serializable {

    @Autowired
    private ILoginlogsService loginlogsService;

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LoginlogsEntity>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();

        fuzzyFields.add("userCode");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));



		IPage<LoginlogsEntity> page = loginlogsService.queryPage(param,false);
		IPage<LoginlogsEntity> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(page.getRecords());

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @param param
     * @Description queryLoginTimeAnalysis 查询列表
     * @Return
     */
    @RequestMapping(value = "/queryLoginTimeAnalysis", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<TimeAnalysisVO>> queryLoginTimeAnalysis(@RequestBody QueryParam param) {

        Date date = new Date();
        if(param.getParams().get("loginTime") == null){
            String startTime = DateUtil.beginOfMonth(date).toTimeStr();
            String endTime = DateUtil.endOfMonth(date).toTimeStr();
            param.getParams().put("loginTime",new Parameter(QueryParam.BETWEEN,startTime+","+endTime));
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<TimeAnalysisVO> vos = loginlogsService.queryLoginTimeAnalysis(wrapper);
        return CommonResponse.success("查询列表数据成功！", vos);
    }

}
