package com.ejianc.foundation.analyticdatas.mapper;

import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.deskTop.vo.StatisticUserVO;
import com.ejianc.foundation.deskTop.vo.TimeAnalysisVO;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.foundation.analyticdatas.bean.BehaviorDataAnalyticEntity;
import com.ejianc.foundation.analyticdatas.vo.BehaviorDataAnalyticVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

@Mapper
public interface BehaviorDataAnalyticMapper extends BaseCrudMapper<BehaviorDataAnalyticEntity> {

    public List<BehaviorDataAnalyticVO> queryProvinceMapData();
    
    public List<BehaviorDataAnalyticVO> queryCityMapData(String provinceName);

	public long countCountRankPage(Map<String, Object> param);

	public List<BehaviorDataAnalyticVO> queryCountRankPage(Map<String, Object> param);

	@Select(" SELECT DISTINCT b.company_name  FROM `ejc_analyticdatas_behaviordata` b WHERE b.app_name = #{appName} ")
	List<String> queryComNameByAppName(@Param("appName") String appName);

	@Select(" SELECT d.app_name appName, COUNT(d.app_name) c FROM ejc_analyticdatas_behaviordata d WHERE " +
			" d.company_name = #{comName} GROUP BY d.app_name ORDER BY c DESC LIMIT 3 ")
	List<JSONObject> queryAppNameByComName(@Param("comName") String comName);

	List<BehaviorDataAnalyticVO> queryList(Page<BehaviorDataAnalyticVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper);


	/**
	 * 查询用户应用访问次数
	 * @param page
	 * @param wrapper
	 * @return
	 */
	List<StatisticUserVO> queryUserBusinessCount(Page<StatisticUserVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper,@Param("order") String order);

	/**
	 * 查询用户访问总次数、访问种类数
	 * @param page
	 * @param wrapper
	 * @return
	 */
	List<StatisticUserVO> queryUserCount(Page<StatisticUserVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper,@Param("order") String order);

	/**
	 * 查询访问组织总次数、访问人数
	 * @param wrapper
	 * @return
	 */
	List<StatisticUserVO> queryOrgCount(@Param(Constants.WRAPPER) QueryWrapper wrapper,@Param("order") String order);

	/**
	 * 查询部门总次数、访问人数
	 * @param page
	 * @param wrapper
	 * @return
	 */
	List<StatisticUserVO> queryDepartmentCount(Page<StatisticUserVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper,@Param("order") String order);


	/**
	 * 查询应用访问总次数
	 * @param page
	 * @param wrapper
	 * @return
	 */
	List<StatisticUserVO> queryBusinessCount(Page<StatisticUserVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper,@Param("order") String order);

	/**
	 * 根据时间范围按每小时统计浏览次数
	 * @param wrapper
	 * @return
	 */
	List<TimeAnalysisVO> queryTimeAnalysis(@Param(Constants.WRAPPER) QueryWrapper wrapper);


	/**
	 * 查询人员信息
	 */
	List<EmployeeVO> queryIdmEmployee(@Param(Constants.WRAPPER) QueryWrapper wrapper);
}
