package com.ejianc.foundation.analyticdatas.mapper;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.analyticdatas.vo.BehaviorDataAnalyticVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.foundation.analyticdatas.bean.StatisticBillDataEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

@Mapper
public interface StatisticBillDataMapper extends BaseCrudMapper<StatisticBillDataEntity> {

    @Select("SELECT COUNT(a.id) FROM ( SELECT b.statistic_tenant_id id  " +
            "FROM ejc_analyticdatas_statistic_billdata b , ejc_analyticdatas_tenantdata t " +
            "WHERE t.state = 1 AND b.statistic_tenant_id = t.tenant_id AND b.statistic_time = #{date}  AND  b.statistic_tenant_name IS NOT NULL " +
            " GROUP BY b.statistic_tenant_id ) a ")
    long queryStatisticBillTenantRankCount(@Param("date") String date);

    @Select("SELECT b.statistic_tenant_id id, b.statistic_tenant_name companyName,SUM(b.bill_sum_count) billCount " +
            "FROM ejc_analyticdatas_statistic_billdata b , ejc_analyticdatas_tenantdata t " +
            "WHERE t.state = 1 AND b.statistic_tenant_id = t.tenant_id AND b.statistic_time = #{date}  AND  b.statistic_tenant_name IS NOT NULL " +
            " GROUP BY b.statistic_tenant_id " +
            "ORDER BY billCount DESC " +
            "LIMIT #{startLine}, #{pageSize} ")
    List<JSONObject> queryStatisticBillTenantRankPage(@Param("date") String date , @Param("startLine") int startLine,@Param("pageSize") int pageSize);

    @Select("SELECT COUNT(a.id) FROM ( SELECT b.statistic_tenant_id id  " +
            "FROM ejc_analyticdatas_statistic_billdata b , ejc_analyticdatas_tenantdata t " +
            "WHERE t.state = 1 AND b.statistic_tenant_id = t.tenant_id AND  LEFT(b.statistic_time,7) = #{thisMonth}  AND  b.statistic_tenant_name IS NOT NULL " +
            " GROUP BY b.statistic_tenant_id ) a ")
    long queryStatisticBillTenantRankThisMonthCount(@Param("thisMonth") String thisMonth);

    @Select("SELECT b.statistic_tenant_id id, b.statistic_tenant_name companyName,SUM(b.bill_count) billCount " +
            "FROM ejc_analyticdatas_statistic_billdata b , ejc_analyticdatas_tenantdata t " +
            "WHERE t.state = 1 AND b.statistic_tenant_id = t.tenant_id AND  LEFT(b.statistic_time,7) = #{thisMonth}  AND  b.statistic_tenant_name IS NOT NULL " +
            " GROUP BY b.statistic_tenant_id " +
            "ORDER BY billCount DESC " +
            "LIMIT #{startLine}, #{pageSize} ")
    List<JSONObject> queryStatisticBillTenantRankThisMonthPage(@Param("thisMonth") String thisMonth , @Param("startLine") int startLine,@Param("pageSize") int pageSize);
}
