package com.ejianc.foundation.analyticdatas.service;

import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.analyticdatas.bean.BehaviorDataAnalyticEntity;
import com.ejianc.foundation.analyticdatas.vo.BehaviorDataAnalyticVO;
import com.ejianc.foundation.deskTop.vo.StatisticUserVO;
import com.ejianc.foundation.deskTop.vo.TimeAnalysisVO;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.apache.ibatis.annotations.Param;

public interface IBehaviorDataAnalyticService extends IBaseService<BehaviorDataAnalyticEntity> {

	void registerData(BehaviorDataAnalyticVO behaviorData);

	void handleBehaviorDatas(String behaviorData);

	List<BehaviorDataAnalyticVO> queryProvinceMapData();

	List<BehaviorDataAnalyticVO> queryCityMapData(String provinceName);

	IPage<BehaviorDataAnalyticVO> queryCountRankPage(Map<String, Object> param);

	List<BehaviorDataAnalyticVO> queryList(Page<BehaviorDataAnalyticVO> page, QueryWrapper wrapper);

	/**
	 * 查询用户应用访问次数
	 * @param page
	 * @param wrapper
	 * @return
	 */
	List<StatisticUserVO> queryUserBusinessCount(Page<StatisticUserVO> page,  QueryWrapper wrapper, String order);

	/**
	 * 查询用户访问总次数、访问种类数
	 * @param page
	 * @param wrapper
	 * @return
	 */
	List<StatisticUserVO> queryUserCount(Page<StatisticUserVO> page,  QueryWrapper wrapper, String order);

    /**
     * 查询访问组织总次数、访问人数
     * @param wrapper
     * @return
     */
    List<StatisticUserVO> queryOrgCount(QueryWrapper wrapper, String order);

    /**
     * 查询部门总次数、访问人数
     * @param page
     * @param wrapper
     * @return
     */
    List<StatisticUserVO> queryDepartmentCount(Page<StatisticUserVO> page, QueryWrapper wrapper, String order);


    /**
     * 查询应用访问总次数
     * @param page
     * @param wrapper
     * @return
     */
    List<StatisticUserVO> queryBusinessCount(Page<StatisticUserVO> page, QueryWrapper wrapper, String order);

	/**
	 * 根据时间范围按每小时统计浏览次数
	 * @param wrapper
	 * @return
	 */
	List<TimeAnalysisVO> queryTimeAnalysis(QueryWrapper wrapper);


	/**
	 * 查询人员信息
	 */
	List<EmployeeVO>  queryIdmEmployee(QueryWrapper wrapper);
}
